<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

SpAddonsConfig::addonConfig([
	'type'       => 'repeatable',
	'addon_name' => 'gallery',
	'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY'),
	'desc'       => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_DESC'),
	'category'   => 'Media',
	'settings' => [
		'content' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT'),
			'fields' => [
				'sp_gallery_item' => [
					'type'	=> 'repeatable',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_ITEMS'),
					'std'   => [
							[
                                'thumb' => ['src' => 'https://source.unsplash.com/B5drkS_Z5RM/220x150'],
								'full' => ['src' => 'https://source.unsplash.com/B5drkS_Z5RM/900x500'],
								'title' => 'Gallery Item 1',
                            ],
							[
                                'thumb' => ['src' => 'https://source.unsplash.com/t3dlLOhdEzs/220x150'],
								'full' => ['src' => 'https://source.unsplash.com/t3dlLOhdEzs/900x500'],
								'title' => 'Gallery Item 2',
                            ],
													[
                            	'thumb' => ['src' => 'https://source.unsplash.com/RySPDa0FdcQ/220x150'],
								'full' => ['src' => 'https://source.unsplash.com/RySPDa0FdcQ/900x500'],
								'title' => 'Gallery Item 3',
                            ],
                        ],

					'attr'  => [
						'title' => [
							'type'  => 'text',
							'title' => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_ITEM_TITLE'),
							'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_ITEM_TITLE_DESC'),
							'std'   => 'Gallery Item 1'
						],

						'thumb' => [
							'type'  => 'media',
							'title' => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_THUMB'),
							'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_THUMB_DESC'),
							'std'   => [
								'src'    => 'https://source.unsplash.com/gvptKmonylk/220x180',
								'height' => '',
								'width'  => '',
							],
						],

						'full' => [
							'type'  => 'media',
							'title' => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_FULL'),
							'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_FULL_DESC'),
							'std'   => [
								'src'    => 'https://source.unsplash.com/gvptKmonylk/900x480',
								'height' => '',
								'width'  => '',
							],
						],
					],
				],

				'item_alignment' => [
					'type' => 'alignment',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_ALIGNMENT'),
					'responsive' => true,
					'available_options' => ['left', 'center', 'right'],
					'std' => [
						'xl' => 'center',
						'lg' => '',
						'md' => '',
						'sm' => '',
						'xs' => '',
					],
				],
			],
		],

		'options' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_OPTIONS'),
			'fields' => [
				'width' => [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_WIDTH'),
					'responsive' => true,
					'std'        => ['xl' => 220],
					'max'        => 1000,
				],

				/*
				'height' => [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_HEIGHT'),
					'responsive' => true,
					'std'        => ['xl' => 180],
					'max'        => 1000,
				],
				*/

				'item_gap' => [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_GAP'),
					'responsive' => true,
					'std'        => ['xl' => 5],
					'max'        => 80,
				],
			]
		],

		'title' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TITLE'),
			'fields' => [
				'title' => [
					'type'  => 'text',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_DESC'),
				],

				'heading_selector' => [
					'type'   => 'headings',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_DESC'),
					'std'   => 'h3',
				],

				'title_typography' => [
					'type'     => 'typography',
					'title'  	=> Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
					'fallbacks'   => [
						'font' => 'title_font_family',
						'size' => 'title_fontsize',
						'line_height' => 'title_lineheight',
						'letter_spacing' => 'title_letterspace',
						'uppercase' => 'title_font_style.uppercase',
						'italic' => 'title_font_style.italic',
						'underline' => 'title_font_style.underline',
						'weight' => 'title_font_style.weight',
					],
				],

				'title_text_color' => [
					'type'   => 'color',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
				],

				'title_margin_separator' => [
					'type' => 'separator',
				],

				'title_margin_top' => [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_TOP'),
					'max'        => 400,
					'responsive' => true,
				],

				'title_margin_bottom' => [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_BOTTOM'),
					'max'        => 400,
					'responsive' => true,
				],
			],
		],
	],
]);
