<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Version;

class SppagebuilderAddonGmap extends SppagebuilderAddons
{

	public function render() {
	
		$settings = $this->addon->settings;
		$app = Factory::getApplication();
		$doc = Factory::getDocument();
		$tmpl_url = Uri::base(true) . '/templates/' . $app->getTemplate() . '/images/';

		$class = (isset($settings->class) && $settings->class) ? $settings->class : '';
		$title = (isset($settings->title) && $settings->title) ? $settings->title : '';
		$heading_selector = (isset($settings->heading_selector) && $settings->heading_selector) ? $settings->heading_selector : 'h3';

		//Options
		$map = (isset($settings->map) && $settings->map) ? $settings->map : '';
		$api_key = (isset($settings->api_key) && $settings->api_key) ? $settings->api_key : '';
		$gmap_api = (isset($settings->gmap_api) && $settings->gmap_api) ? $settings->gmap_api : '';
		
		$infowindow = (isset($settings->infowindow) && $settings->infowindow) ? $settings->infowindow : '';
		
		$type = (isset($settings->type) && $settings->type) ? $settings->type : '';
		$zoom = (isset($settings->zoom) && $settings->zoom) ? $settings->zoom : '';
		$mousescroll = (isset($settings->mousescroll) && $settings->mousescroll) ? $settings->mousescroll : '';
		
		$fullscreen_control = (isset($settings->fullscreen_control) && $settings->fullscreen_control) ? $settings->fullscreen_control : '';
		$street_view_control = (isset($settings->street_view_control) && $settings->street_view_control) ? $settings->street_view_control : '';
		$map_type_control = (isset($settings->map_type_control) && $settings->map_type_control) ? $settings->map_type_control : '';
		
		$show_transit = (isset($settings->show_transit) && $settings->show_transit) ? $settings->show_transit : '';
		$show_poi = (isset($settings->show_poi) && $settings->show_poi) ? $settings->show_poi : '';
		
		$fullscreen_control != 'true' ? $data_fullscreen_control = ' data-fullscreen_control="' . $fullscreen_control . '"' : $data_fullscreen_control = '';
		$street_view_control != 'true' ? $data_street_view_control = ' data-street_view_control="' . $street_view_control . '"' : $data_street_view_control = '';
		$map_type_control != 'true' ? $data_map_type_control = ' data-map_type_control="' . $map_type_control . '"' : $data_map_type_control = '';
		
		//$show_transit != 'on' ? $data_show_transit = ' data-show_transit="off"' : $data_show_transit = ' data-show_transit="on"';
		//$show_poi != 'on' ? $data_show_poi = ' data-show_poi="off"' : $data_show_poi = ' data-show_poi="on"';
		
		$show_transit == 1 ? $data_show_transit = ' data-show_transit="on"' : $data_show_transit = ' data-show_transit="off"';
		$show_poi == 1 ? $data_show_poi = ' data-show_poi="on"' : $data_show_poi = ' data-show_poi="off"';
		
		$water_color = (isset($settings->water_color) && $settings->water_color) ? $settings->water_color : '';
		$highway_stroke_color = (isset($settings->highway_stroke_color) && $settings->highway_stroke_color) ? $settings->highway_stroke_color : '';
		$highway_fill_color = (isset($settings->highway_fill_color) && $settings->highway_fill_color) ? $settings->highway_fill_color : '';
		$local_stroke_color = (isset($settings->local_stroke_color) && $settings->local_stroke_color) ? $settings->local_stroke_color : '';
		$local_fill_color = (isset($settings->local_fill_color) && $settings->local_fill_color) ? $settings->local_fill_color : '';
		$poi_fill_color = (isset($settings->poi_fill_color) && $settings->poi_fill_color) ? $settings->poi_fill_color : '';
		$administrative_color = (isset($settings->administrative_color) && $settings->administrative_color) ? $settings->administrative_color : '';
		$landscape_color = (isset($settings->landscape_color) && $settings->landscape_color) ? $settings->landscape_color : '';
		$road_text_color = (isset($settings->road_text_color) && $settings->road_text_color) ? $settings->road_text_color : '';
		$road_arterial_fill_color = (isset($settings->road_arterial_fill_color) && $settings->road_arterial_fill_color) ? $settings->road_arterial_fill_color : '';
		$road_arterial_stroke_color = (isset($settings->road_arterial_stroke_color) && $settings->road_arterial_stroke_color) ? $settings->road_arterial_stroke_color : '';
		
		//$map_type_control != 'true' ? $data_map_type_control = ' data-map_type_control="' . $map_type_control . '"' : $data_map_type_control = '';
		//$street_view_control != 'true' ? $data_street_view_control = ' data-street_view_control="' . $street_view_control . '"' : $data_street_view_control = '';
		$water_color != '' ? $data_water_color = ' data-water_color="' . $water_color . '"' : $data_water_color = '';
		$highway_stroke_color != '' ? $data_highway_stroke_color = ' data-highway_stroke_color="' . $highway_stroke_color . '"' : $data_highway_stroke_color = '';
		$highway_fill_color != '' ? $data_highway_fill_color = ' data-highway_fill_color="' . $highway_fill_color . '"' : $data_highway_fill_color = '';
		$local_stroke_color != '' ? $data_local_stroke_color = ' data-local_stroke_color="' . $local_stroke_color . '"' : $data_local_stroke_color = '';
		$local_fill_color != '' ? $data_local_fill_color = ' data-local_fill_color="' . $local_fill_color . '"' : $data_local_fill_color = '';
		$poi_fill_color != '' ? $data_poi_fill_color = ' data-poi_fill_color="' . $poi_fill_color . '"' : $data_poi_fill_color = '';
		$administrative_color != '' ? $data_administrative_color = ' data-administrative_color="' . $administrative_color . '"' : $data_administrative_color = '';
		$landscape_color != '' ? $data_landscape_color = ' data-landscape_color="' . $landscape_color . '"' : $data_landscape_color = '';
		$road_text_color != '' ? $data_road_text_color = ' data-road_text_color="' . $road_text_color . '"' : $data_road_text_color = '';
		$road_arterial_fill_color != '' ? $data_road_arterial_fill_color = ' data-road_arterial_fill_color="' . $road_arterial_fill_color . '"' : $data_road_arterial_fill_color = '';
		$road_arterial_stroke_color != '' ? $data_road_arterial_stroke_color = ' data-road_arterial_stroke_color="' . $road_arterial_stroke_color . '"' : $data_road_arterial_stroke_color = '';
	
		if($map) {
			$map = explode(',', $map);
			$output  = '<div id="sppb-addon-map-'. $this->addon->id .'" class="sppb-addon sppb-addon-gmap ' . $class . '">';
			$output .= ($title) ? '<'.$heading_selector.' class="sppb-addon-title">' . $title . '</'.$heading_selector.'>' : '';
			$output .= '<div class="sppb-addon-content">';
			$output .= '<div id="sppb-addon-gmap-'. $this->addon->id .'" class="sppb-addon-gmap-canvas" data-lat="' . trim($map[0]) . '" data-lng="' . trim($map[1]) . '" data-tmpl_url="' . $tmpl_url . '" data-maptype="' . $type . '" data-mapzoom="' . $zoom . '"'. $data_map_type_control . $data_street_view_control . $data_fullscreen_control .' data-infowindow="' . base64_encode($infowindow) . '" data-mousescroll="' . $mousescroll . '"'. $data_water_color . $data_highway_stroke_color . $data_highway_fill_color . $data_local_stroke_color . $data_local_fill_color . $data_poi_fill_color . $data_administrative_color . $data_landscape_color . $data_road_text_color . $data_road_arterial_fill_color . $data_road_arterial_stroke_color . $data_show_transit . $data_show_poi;
			$output .= '></div>';
			$output .= '</div>';
			$output .= '</div>';
			return $output;
		}

		return;
	}

	public function scripts()
	{
		$app = Factory::getApplication();
		$doc = Factory::getDocument();
		
		$tmpl_url = Uri::base(true) . '/templates/' . $app->getTemplate() . '/images/';
		
		$params = ComponentHelper::getParams('com_sppagebuilder');
		$gmap_api = $params->get('gmap_api', '');

		$version = new Version();
		$JoomlaVersion = (float) $version->getShortVersion();

		if ($JoomlaVersion > 4)
		{
			Factory::getDocument()->getWebAssetManager()->registerAndUseScript('gmap-api', "https://maps.googleapis.com/maps/api/js?key=" . $gmap_api, [], []);
		}
		else
		{
			HTMLHelper::_('script', "https://maps.googleapis.com/maps/api/js?key=" . $gmap_api, [], []);
		}
	
		return [
			Uri::base(true) . "/templates/" . $app->getTemplate() . "/js/gmap.js"
		];
	}

	public function css()
	{
		$addon_id = '#sppb-addon-' . $this->addon->id;
		$cssHelper = new CSSHelper($addon_id);
		$settings = $this->addon->settings;
		$css = '';

		$height = $cssHelper->generateStyle('.sppb-addon-gmap-canvas', $settings, ['height' => 'height']);
		$css .= $height;

		$css .= $cssHelper->generateStyle('a>div>img', $settings, [], '', [], null, false, 'top:-15px!important;');

		return $css;
	}

	public static function getTemplate()
	{

		$lodash = new Lodash('#sppb-addon-{{ data.id }}');
		$output = '
		<#
			var map = data.map.split(",");
			var transitShow = (data.show_transit == 1) ? "on" : "off";
			var poiShow = (data.show_transit == 1) ? "on" : "off";

			var ConvertToBaseSixFour = {
				_keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
				encode: function(e) {
					var t = "";
					var n, r, i, s, o, u, a;
					var f = 0;
					e = ConvertToBaseSixFour._utf8_encode(e);
					while (f < e.length) {
						n = e.charCodeAt(f++);
						r = e.charCodeAt(f++);
						i = e.charCodeAt(f++);
						s = n >> 2;
						o = (n & 3) << 4 | r >> 4;
						u = (r & 15) << 2 | i >> 6;
						a = i & 63;
						if (isNaN(r)) {
							u = a = 64
						} else if (isNaN(i)) {
							a = 64
						}
						t = t + this._keyStr.charAt(s) + this._keyStr.charAt(o) + this._keyStr.charAt(u) + this._keyStr.charAt(a)
					}
					return t
				},
				_utf8_encode: function(e) {
					e = e.replace(/rn/g, "n");
					var t = "";
					for (var n = 0; n < e.length; n++) {
						var r = e.charCodeAt(n);
						if (r < 128) {
							t += String.fromCharCode(r)
						} else if (r > 127 && r < 2048) {
							t += String.fromCharCode(r >> 6 | 192);
							t += String.fromCharCode(r & 63 | 128)
						} else {
							t += String.fromCharCode(r >> 12 | 224);
							t += String.fromCharCode(r >> 6 & 63 | 128);
							t += String.fromCharCode(r & 63 | 128)
						}
					}
					return t
				}
			};
			var infoText = (!_.isEmpty(data.infowindow)) ? ConvertToBaseSixFour.encode(data.infowindow) : "";

			let location_addr = {
				address: data.infowindow,
				latitude: map[0],
				longitude: map[1]
			};
			if(_.isObject(data.multi_location_items) && data.multi_location !== 0){
				_.each(data.multi_location_items, function(item){
					let latLong = _.split(item.location_item, ",");
					let mainObj = {
						address: item.location_popup_text,
						latitude: latLong[0],
						longitude: latLong[1]
					}
					location_addr = _.concat(location_addr, mainObj);
				})
			}
			let latiLongi = _.split(location_addr.location_item, ",");

			let location_json = JSON.stringify(location_addr);
			
		#>
		<style type="text/css">';
		$titleTypographyFallbacks = [
			'font'           => 'data.title_font_family',
			'size'           => 'data.title_fontsize',
			'line_height'    => 'data.title_lineheight',
			'letter_spacing' => 'data.title_letterspace',
			'uppercase'      => 'data.title_font_style?.uppercase',
			'italic'         => 'data.title_font_style?.italic',
			'underline'      => 'data.title_font_style?.underline',
			'weight'         => 'data.title_font_style?.weight'
		];
		$output .= $lodash->unit('margin-bottom', '.sppb-addon-title', 'data.title_margin_bottom');
		$output .= $lodash->unit('margin-top', '.sppb-addon-title', 'data.title_margin_top');
		$output .= $lodash->color('color', '.sppb-addon-title', 'data.title_text_color');
		$output .= $lodash->typography('.sppb-addon-title', 'data.title_typography', $titleTypographyFallbacks);

		$output .= $lodash->unit('height', '.sppb-addon-gmap-canvas', 'data.height', 'px');
		$output .= '
		#sppb-addon-map-{{ data.id }} a>div>img{top:-15px!important;}
		</style>
		<div id="sppb-addon-map-{{ data.id }}" class="sppb-addon sppb-addon-gmap {{ data.class }}">
			<# if( !_.isEmpty( data.title ) ){ #><{{ data.heading_selector }} class="sppb-addon-title sp-inline-editable-element" data-id={{data.id}} data-fieldName="title" contenteditable="true">{{ data.title }}</{{ data.heading_selector }}><# } #>
			<div class="sppb-addon-content">
				<div id="sppb-addon-gmap-{{ data.id }}" class="sppb-addon-gmap-canvas" data-lat="{{ map[0] }}" data-lng="{{ map[1] }}" data-maptype="{{ data.type }}" data-mapzoom="{{ data.zoom }}" data-mousescroll="{{ data.mousescroll }}" data-water_color="{{ data.water_color }}" data-highway_stroke_color="{{ data.highway_stroke_color }}" data-highway_fill_color="{{ data.highway_fill_color }}" data-local_stroke_color="{{ data.local_stroke_color }}" data-local_fill_color="{{ data.local_fill_color }}" data-poi_fill_color="{{ data.poi_fill_color }}" data-administrative_color="{{ data.administrative_color }}" data-landscape_color="{{ data.landscape_color }}" data-road_text_color="{{ data.road_text_color }}" data-road_arterial_fill_color="{{ data.road_arterial_fill_color }}" data-road_arterial_stroke_color="{{ data.road_arterial_stroke_color }}" data-show_transit="{{ transitShow }}" data-show_poi="{{ poiShow }}" data-infowindow="{{ infoText }}" data-show-controll="{{data.show_controllers}}"></div>
			</div>	
		</div>';

		return $output;
	}
}
