<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

//Include Pixeden Icons
require_once dirname(dirname( __DIR__ )) . '/fields/pixeden-icons.php';

SpAddonsConfig::addonConfig([
	'type'       => 'content',
	'addon_name' => 'icon',
	'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_ICON'),
	'desc'       => Text::_('COM_SPPAGEBUILDER_ADDON_ICON_DESC'),
	'category'   => 'Media',
	'settings' => [
		'content' => [
			'title' => Text::_('COM_SPPAGEBUILDER_ADDON_ICON'),
			'fields' => [
				'title'=> [
					'type'      => 'text',
					'title'     => Text::_('COM_SPPAGEBUILDER_GLOBAL_ICON_TITLE'),
					'std'       => '',
				],
				
				// Pixeden Icons
				'peicon_name'=> [
					'type'      => 'select',
					'title' 	=> Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_PE_ICON_NAME'),
					'desc' 		=> Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_PE_ICON_NAME_DESC'),
					'values'	=> $peicon_list,
					'std'       => 'pe pe-7s-download',
				],
				
				'icon_name'=> [
					'type'      => 'icon',
					'title'     => Text::_('COM_SPPAGEBUILDER_GLOBAL_ICON_NAME'),
					'clearable' => true,
					'std'       => 'fas fa-cogs',
				],

				'size'=> [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_ICON_SIZE'),
					'std'        => ['xl' => 36],
					'max'        => 400,
					'responsive' => true
				],

				'title_link'=> [
					'type'   => 'link',
					'format' => 'attachment',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_LINK'),
					'std'    => '',
				],
				
				'margin'=> [
					'type'        => 'margin',
					'title'       => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN'),
					'desc'        => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_DESC'),
					'responsive'  => true
				],
				
				'padding'=> [
					'type'        => 'slider',
					'title' 	  => Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_PADDING'),
					'desc'		  => Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_PADDING_DESC'),
					'placeholder' => 20,
					'max'         => 100,
					//'responsive'  => true
				],

				'hover_effect'=> [
					'type'   => 'select',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_ICON_HOVER_EFFECT'),
					'values' => [
						''         => Text::_('COM_SPPAGEBUILDER_ADDON_ICON_HOVER_EFFECT_NONE'),
						'zoom-in'  => Text::_('COM_SPPAGEBUILDER_ADDON_ICON_HOVER_EFFECT_ZOOM_IN'),
						'zoom-out' => Text::_('COM_SPPAGEBUILDER_ADDON_ICON_HOVER_EFFECT_ZOOM_OUT'),
						'rotate'   => Text::_('COM_SPPAGEBUILDER_ADDON_ICON_HOVER_EFFECT_ROTATE'),
					],
					'std' => 'zoom-in',
					'inline' => true,
				],

				'alignment' => [
					'type'              => 'alignment',
					'title'       		=> Text::_('COM_SPPAGEBUILDER_GLOBAL_ALIGNMENT'),
					'responsive'        => true,
					'available_options' => ['left', 'center', 'right'],
				]
			],
		],

		'size' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_SIZE'),
			'fields' => [
				'width'=> [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_WIDTH'),
					'max'        => 500,
					'responsive' => true
				],

				'height'=> [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_HEIGHT'),
					'max'        => 500,
					'responsive' => true
				],

				'border_radius'=> [
					'type'        => 'slider',
					'title'       => Text::_('COM_SPPAGEBUILDER_GLOBAL_RADIUS'),
					'max'         => 500,
					'responsive'  => true
				],
			]
		],

		'color' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
			'fields' => [
				'use_hover_state' => [
					'type'   => 'radio',
					'values' => [
						'normal' => Text::_('COM_SPPAGEBUILDER_GLOBAL_NORMAL'),
						'hover' => Text::_('COM_SPPAGEBUILDER_GLOBAL_HOVER'),
					],
					'std' => 'normal',
					'depends' => [['hover_effect', '!=', '']]
				],

				'color' => [
					'type'   => 'color',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
					'depends' => [['use_hover_state', '!=', 'hover']]
				],

				'background' => [
					'type' => 'color',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND'),
					'depends' => [['use_hover_state', '!=', 'hover']]
				],

				'border_width' => [
					'type'        => 'slider',
					'title'       => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_WIDTH'),
					'responsive'  => true,
					'depends' => [['use_hover_state', '!=', 'hover']]
				],

				'border_color' => [
					'type'   => 'color',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_COLOR'),
					'depends' => [['use_hover_state', '!=', 'hover']]
				],

				// Hover
				'hover_color'=> [
					'type'    => 'color',
					'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
					'depends' => [
						['hover_effect', '!=', ''],
						['use_hover_state', '=', 'hover']
					],
				],

				'hover_background'=> [
					'type'    => 'color',
					'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND'),
					'depends' => [
						['hover_effect', '!=', ''],
						['use_hover_state', '=', 'hover']
					],
				],

				'hover_border_width'=> [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_WIDTH'),
					'responsive' => true,
					'depends' => [
						['hover_effect', '!=', ''],
						['use_hover_state', '=', 'hover']
					],
				],

				'hover_border_color'=> [
					'type'    => 'color',
					'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_COLOR'),
					'depends' => [
						['hover_effect', '!=', ''],
						['use_hover_state', '=', 'hover']
					],
				],

				'hover_border_radius'=> [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_RADIUS'),
					'max'        => 500,
					'responsive' => true,
					'depends' => [
						['hover_effect', '!=', ''],
						['use_hover_state', '=', 'hover']
					],
				],
			],
		],
	],
]);
