<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

//Include Pixeden Icons
require_once dirname(dirname( __DIR__ )) . '/fields/pixeden-icons.php';
SpAddonsConfig::addonConfig(
	array(
		'type'=>'repeatable',
		'addon_name'=>'sp_icons',
		'title'=>Text::_('FLEX_ADDON_ICONS'),
		'desc'=>Text::_('FLEX_ADDON_ICONS_DESC'),
		'category'=>'Flex',
		'attr'=>array(
			'general' => array(

				'admin_label'=>array(
					'type'=>'text',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL_DESC'),
					'std'=> ''
				),

			'title'=>array(
				'type'=>'text', 
				'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_TITLE'),
				'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_DESC'),
				'std'=>  ''
				),

			'heading_selector'=>array(
				'type'=>'select', 
				'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS'),
				'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_DESC'),
				'values'=>array(
					'h1'=>Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H1'),
					'h2'=>Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H2'),
					'h3'=>Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H3'),
					'h4'=>Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H4'),
					'h5'=>Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H5'),
					'h6'=>Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_H6'),
					),
				'std'=>'h3',
				'depends'=>array(array('title', '!=', '')),
			),

			'title_fontsize'=>array(
				'type'=>'number', 
				'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_FONT_SIZE'),
				'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_FONT_SIZE_DESC'),
				'std'=>'',
				'depends'=>array(array('title', '!=', '')),
				),

			'title_fontweight'=>array(
				'type'=>'text', 
				'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_FONT_WEIGHT'),
				'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_FONT_WEIGHT_DESC'),
				'placeholder'=>300,
				'std'=>'',
				'depends'=>array(array('title', '!=', '')),
				),

			'title_text_color'=>array(
				'type'=>'color',
				'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_TEXT_COLOR'),
				'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_TEXT_COLOR_DESC'),
				'depends'=>array(array('title', '!=', '')),
				),	

			'title_margin_top'=>array(
				'type'=>'slider',
				'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_MARGIN_TOP'),
				'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_MARGIN_TOP_DESC'),
				'placeholder'=>10,
				'info' => 'px',
				'depends'=>array(array('title', '!=', '')),
				),

			'title_margin_bottom'=>array(
				'type'=>'slider',
				'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_MARGIN_BOTTOM'),
				'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_MARGIN_BOTTOM_DESC'),
				'placeholder'=>10,
				'info' => 'px',
				'depends'=>array(array('title', '!=', '')),
				),
				
				
			'separator_margin'=>array(
				'type'=>'separator',
				'title'=>Text::_(''),
				),
			'margin_gap'=>array(
				'type'=>'slider', 
				'title'=>Text::_('FLEX_ADDON_ICONS_GAP'),
				'desc'=>Text::_('FLEX_ADDON_ICONS_GAP_DESC'),
				//'placeholder'=>10,
				'info' => 'px',
				'std'=>8,
				),

			'alignment' => [
				'type'   => 'buttons',
				'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_CONTENT_ALIGNMENT'),
				'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_CONTENT_ALIGNMENT_DESC'),
				'values' => [
					['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_LEFT'), 'value' => 'sppb-text-left'],
					['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CENTER'), 'value' => 'sppb-text-center'],
					['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_RIGHT'), 'value' => 'sppb-text-right'],
				],
				'std'    => 'button',
				'tabs'    => true,
			],
			
			'title_tooltip'=>array(
				'type'=>'checkbox', 
				'title'=>Text::_('FLEX_ADDON_TITLE_TOOLTIP'),
				'desc'=>Text::_('FLEX_ADDON_TITLE_TOOLTIP_DESC'),
				'values'=> array(
					1=>Text::_('JYES'),
					0=>Text::_('JNO'),
				),
				'std'=>1,
			    ),	

			'class'=>array(
				'type'=>'text', 
				'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
				'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
				'std'=> ''
				),
						
			// Repeatable Items
			'separator_items'=>array(
				'type'=>'separator',
				'title'=>Text::_(''),
				),
				
			'sp_icons_item'=>array(
				'title'=> 'Icons', 
				'type'	=> 'repeatable',

				'std'=> array(
					
					array(
						'icon_name' => 'fab fa-youtube',
						'title' => 'YouTube',
						'size' => 23,
						'padding' => 8,
						'color' => '#FFFFFF',
						'background' => '#FF0000',
						//'border_color' => '#F77737',
						//'border_width'=> 2,
						'border_radius'=> 8,
					),
					array(
						'icon_name' => 'fab fa-facebook',
						'title' => 'Facebook',
						'size' => 23,
						'padding' => 8,
						'color' => '#FFFFFF',
						'background' => '#4267B2',
						'border_radius'=> 8,
					),
					array(
						'icon_name' => 'fab fa-instagram',
						'title' => 'Instagram',
						'size' => 25,
						'padding' => 7,
						'color' => '#FFFFFF',
						'background' => '#C13584',
						'border_radius'=> 8,
					),
					array(
						'icon_name' => 'far fa-image',
						'title' => 'Image icon example',
						'color' => '#3EAFDF',
						'size' => 34,
						'padding' => 10,
					),
					array(
						'icon_name' => 'pe pe-7s-download',
						'title' => 'Download',
						'size' => 36,
						'padding' => 8,
						'font_weight' => 700,
					),

					array(
						'icon_name' => 'fab fa-apple-pay',
						'title' => 'Apple Pay',
						'size' => 44,
						'padding' => 5,
						'color' => '#222',
					),
					array(
						'icon_name' => 'pe pe-7s-rocket',
						'title' => 'Rocket',
						'size' => 58,
						'padding' => 5,
						'color' => '#8FA12B',
					),
					array(
						'icon_name' => 'pe pe-7s-paint-bucket',
						'title' => 'Paint Bucket',
						'size' => 38,
						'color' => '#8C32A6',
						'padding' => 5,
						'font_weight' => 500,
					),
					array(
						'icon_name' => 'pe pe-7s-cloud-upload',
						'title' => 'Cloud Upload',
						'size' => 40,
						'padding' => 8,
						'font_weight' => 700,
					),
					array(
						'icon_name' => 'fas fa-download',
						'title' => 'Font Awesome download icon',
						'color' => '#3191CB',
						'size' => 24,
						'padding' => 10,
						'border_color' => '#98C7E3',
						'border_width'=> 2,
						'border_radius'=> 48,
					)
				),
				'attr'=>array(
				
					'title'=>array(
						'type'=>'text', 
						'title'=>Text::_('FLEX_ADDON_ICONS_TITLE'),
						'desc'=>Text::_('FLEX_ADDON_ICONS_TITLE_DESC'),
						'std'=>Text::_('FLEX_ADDON_ICONS_TITLE_STD')
						),

					'peicon_name'=>array( // Pixeden Icons
							'type'=>'select', 
							'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_PE_ICON_NAME'),
							'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_PE_ICON_NAME_DESC'),
							'clearable' => true,
							'values'=> $peicon_list,
							'std' => 'pe pe-7s-rocket',
						),		
		
					'icon_name'=>array(
							'type'=>'icon', 
							'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_FONTAWESOME_ICON_NAME'),
							'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_FONTAWESOME_ICON_NAME_DESC'),
							'clearable' => true,
							'std' => 'fa-cogs',
						),
	
					'size'=>array(
						'type'=>'slider',
						'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_ICON_SIZE'),
						'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_ICON_SIZE_DESC'),
						'std'=>44,
						'info' => 'px',
						),
					
					'font_weight'=>array(
						'type'=>'text',
						'title'=>Text::_('FLEX_ADDON_GLOBAL_ICON_FONT_WEIGHT'),
						'desc'=>Text::_('FLEX_ADDON_GLOBAL_ICON_FONT_WEIGHT_DESC'),
						'placeholder'=>300,
						//'std'=>300,
						),
					'color'=>array(
						'type'=>'color',
						'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_COLOR'),
						'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_COLOR_DESC'),
						),
		
					'background'=>array(
						'type'=>'color',
						'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_BACKGROUND'),
						'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_BACKGROUND_DESC'),
						),
		
					'border_color'=>array(
						'type'=>'color',
						'title'=>Text::_('FLEX_GLOBAL_BORDER_COLOR'),
						'desc'=>Text::_('FLEX_GLOBAL_BORDER_COLOR_DESC'),
						),
		
					'border_width'=>array(
						'type'=>'slider',
						'title'=>Text::_('FLEX_GLOBAL_BORDER_WIDTH_SIZE'),
						'desc'=>Text::_('FLEX_GLOBAL_BORDER_WIDTH_SIZE_DESC'),
						'info' => 'px',
						),
					
					'border_radius'=>array(
						'type'=>'slider',
						'title'=>Text::_('FLEX_GLOBAL_BORDER_RADIUS'),
						'desc'=>Text::_('FLEX_GLOBAL_BORDER_RADIUS_DESC'),
						'std' => 0,
						'max' => 100,
						'info' => 'px',
						),

					'icon_margin'=>array(
						'type'=>'slider',
						'title'=>Text::_('FLEX_ADDON_GLOBAL_MARGIN'),
						'desc'=>Text::_('FLEX_ADDON_GLOBAL_MARGIN_DESC'),
						'info'=>'px',
						'std'=>'',
						),	

					'padding'=>array(
						'type'=>'slider',
						'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_PADDING'),
						'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_PADDING_DESC'),
						'info'=>'px',
						'std'=>10,
						),

					'url'=>array(
						'type'=>'link',
						'title'=>Text::_('FLEX_ADDON_ICONS_URL'),
						'desc'=>Text::_('FLEX_ADDON_ICONS_URL_DESC'),
						'placeholder'=>'http://',
						//'std'=>'',
						),
					),
				),
			),
		),
	)
);
