<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

SpAddonsConfig::addonConfig([
    'type' => 'content',
    'addon_name' => 'image',
    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE'),
    'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_DESC'),
    'category' => 'Media',
    'settings' => [
        'content' => [
            'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT'),
            'fields' => [
                'image' => [
                    'type' => 'media',
                    'std' => [
                        'src' => 'https://source.unsplash.com/gvptKmonylk/900x480',
                        'height' => '',
                        'width' => '',
                    ],
                ],

                'image_2x' => [
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_IMAGE_2X_TEXT'),
                    'desc' => Text::_('COM_SPPAGEBUILDER_GLOBAL_IMAGE_2X_TEXT_DESC'),
                    'type' => 'media',
                    'hide_preview' => true,
                    'std' => [
                        'src' => '',
                        'height' => '',
                        'width' => '',
                    ],
                ],

                'alt_text' => [
                    'type' => 'text',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_ALT_TEXT'),
                    'desc' => Text::_('COM_SPPAGEBUILDER_GLOBAL_ALT_TEXT_DESC'),
                    'std' => 'Image',
                    'inline' => true,
                ],

                'position' => [
                    'type' => 'alignment',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_ALIGNMENT'),
                    'responsive' => true,
                    'available_options' => ['left', 'center', 'right'],
                ],
            ],
        ],

        'options' => [
            'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_OPTIONS'),
            'fields' => [
                'image_width' => [
                    'type' => 'slider',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_WIDTH'),
                    'max' => 2000,
                    'min' => 0,
                    'responsive' => true,
                ],

                'image_height' => [
                    'type' => 'slider',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_HEIGHT'),
                    'max' => 2000,
                    'min' => 0,
                    'responsive' => true,
                ],

                'border_radius' => [
                    'type' => 'advancedslider',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_RADIUS'),
                    'std' => 0,
                    'max' => 1200,
                ],

                'open_lightbox' => [
                    'type' => 'checkbox',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_OPEN_LIGHTBOX'),
                    'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_OPEN_LIGHTBOX_DESC'),
                    'std' => 0,
                ],

                'overlay_color' => [
                    'type' => 'color',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_OVERLAY'),
                    'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_OVERLAY_DESC'),
                    'std' => 'rgba(52, 52, 52, .35)',
                    'depends' => [['open_lightbox', '!=', 0]],
                ],

                'link' => [
                    'type' => 'link',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_LINK'),
                    'desc' => Text::_('COM_SPPAGEBUILDER_GLOBAL_LINK_DESC'),
                    'std' => '',
                    'depends' => [['open_lightbox', '!=', 1]],
                ],
				
				'link_overlay_icon' => [
                    'type' => 'radio',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_LINK_OVERLAY'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_LINK_OVERLAY_DESC'),
					'values' => [
						1=>Text::_('JYES'),
						0=>Text::_('JNO'),
					],
                    'std'=>1,
                    'depends' => [['open_lightbox', '!=', 1]],
                ],
            ],
        ],

        'title' => [
            'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TITLE'),
            'fields' => [
                'title' => [
                    'type' => 'text',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE'),
                    'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_DESC'),
                ],

                'heading_selector' => [
                    'type' => 'headings',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS'),
                    'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_DESC'),
                    'std' => 'h3',
                ],

                'title_typography' => [
                    'type' => 'typography',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
                    'fallbacks' => [
                        'font' => 'title_font_family',
                        'size' => 'title_fontsize',
                        'line_height' => 'title_lineheight',
                        'letter_spacing' => 'title_letterspace',
                        'uppercase' => 'title_font_style.uppercase',
                        'italic' => 'title_font_style.italic',
                        'underline' => 'title_font_style.underline',
                        'weight' => 'title_font_style.weight',
                    ],
                ],

                'title_text_color' => [
                    'type' => 'color',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
                ],

				'title_position' => [
                    'type' => 'radio',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_POSITION'),
                    'values' => [
                        'top' => 'Top',
                        'bottom' => 'Bottom',
                    ],
                    'std' => 'top',
                ],
				
				/*
				'title_position' => [
					'type'   => 'buttons',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_POSITION'),
					'values' => [
						['label' => Text::_('Top'), 'value' => 'top'],
						['label' => Text::_('Bottom'), 'value' => 'bottom'],
					],
					'std'    => 'top',
					'tabs'    => true,
				],
				*/

                'title_margin_top' => [
                    'type' => 'slider',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_TOP'),
                    'max' => 400,
                    'responsive' => true,
                ],

                'title_margin_bottom' => [
                    'type' => 'slider',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_BOTTOM'),
                    'max' => 400,
                    'responsive' => true,
                ],
            ],
        ],
    ],
]);