<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Access\Access;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\Helpers\StringHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Version;
use Joomla\CMS\Component\ComponentHelper;

class SppagebuilderAddonLatest_posts extends SppagebuilderAddons
{

	public function render()
	{
		$app = Factory::getApplication();
		$doc = Factory::getDocument();

		$version = new Version();
		$JoomlaVersion = $version->getShortVersion();

		if ($app->isClient('administrator')) {
			return ''; // prevent from loading in the admin view
		}

		$settings = $this->addon->settings;

		$class = (isset($settings->class) && $settings->class) ? $settings->class : '';
		$title = (isset($settings->title) && $settings->title) ? $settings->title : '';
		$heading_selector = (isset($settings->heading_selector) && $settings->heading_selector) ? $settings->heading_selector : 'h3';

		$item_limit = (isset($settings->item_limit) && $settings->item_limit) ? (int) $settings->item_limit : 6;
		$column_no = (isset($settings->column_no) && $settings->column_no) ? (int) $settings->column_no : 3;
		$category = (isset($settings->category) && $settings->category) ? $settings->category : [];
		$include_subcat = (isset($settings->include_subcat)) ? (int) $settings->include_subcat : 1;
		$ordering = (isset($settings->ordering) && $settings->ordering) ? $settings->ordering : 'latest';
		
		$style = (isset($settings->style) && $settings->style) ? $settings->style : 'flex';
		$enable_masonry = (isset($settings->enable_masonry)) ? (int) $settings->enable_masonry : 0;

		$show_image = (isset($settings->show_image)) ? (int) $settings->show_image : 1;
		$image_alignment = (isset($settings->image_alignment) && $settings->image_alignment) ? $settings->image_alignment : '';
		
		$show_intro_text = (isset($settings->show_intro_text)) ? (int) $settings->show_intro_text : 1;
		$intro_text_limit = (isset($settings->intro_text_limit) && $settings->intro_text_limit) ? (int) $settings->intro_text_limit : 200;
		$show_date = (isset($settings->show_date)) ? (int) $settings->show_date : 1;
		$date_format = (isset($settings->date_format) && $settings->date_format) ? $settings->date_format : 'DATE_FORMAT_LC1';	
		$show_category = (isset($settings->show_category)) ? (int) $settings->show_category : 1;
		$show_author = (isset($settings->show_author)) ? (int) $settings->show_author : 1;

		// Readmore button
		$show_readmore = (isset($settings->show_readmore)) ? (int) $settings->show_readmore : 0;
		$readmore_btn_txt = str_replace(array(' &', 'hellip;', '  ', '...'), '', Text::_('JGLOBAL_READ_MORE'));
		$readmore_button = (isset($settings->readmore_button) && $settings->readmore_button) ? $settings->readmore_button : $readmore_btn_txt;
		$readmore_button_position = (!empty($settings->readmore_button_position) && $settings->readmore_button_position) ? ' sppb-btn-' . $settings->readmore_button_position : 'left';
		$button_classes = '';
		$button_classes = (!empty($settings->button_type) && $settings->button_type) ? ' sppb-btn-' . $settings->button_type : ' sppb-btn-default';
		$button_classes .= (!empty($settings->button_appearance) && $settings->button_appearance) ? ' sppb-btn-' . $settings->button_appearance : '';
		$button_classes .= (!empty($settings->button_size) && $settings->button_size) ? ' sppb-btn-' . $settings->button_size : '';
		$button_classes .= (!empty($settings->button_shape) && $settings->button_shape) ? ' sppb-btn-' . $settings->button_shape : ' sppb-btn-rounded';
		$button_classes .= (!empty($settings->button_block) && $settings->button_block) ? ' ' . $settings->button_block : '';
		
		$article_modified_date = ComponentHelper::getParams('com_content')->get('show_modify_date');
		$article_created_date = ComponentHelper::getParams('com_content')->get('show_publish_date');
		
		$output = '';
		
		$article_helper = JPATH_ROOT . '/components/com_sppagebuilder/helpers/articles.php';

		// Addon ID (unique ID)
		$addon_id = $this->addon->id;

		// Render Joomla Articles
		require_once $article_helper;
		$items = SppagebuilderHelperArticles::getArticles($item_limit, $ordering, $category, $include_subcat);
		
		$match_height = '';
		$masonry = '';

		if ($enable_masonry == 1 && $column_no > 1) {
			$masonry = ' masonry_latest_post';
		}

		$style == 'flex' ? $flex_style = ' flex' : $flex_style = '';
		$style == 'blog' ? $blog_style = ' blog' : $blog_style = '';
		$readmore_button != '' ? $button_text = $readmore_button : $button_text = Text::_('READ_MORE_TITLE');
		$readmore_button_position == 'left' ? $readmore_button_position = ' pull-left float-start float-left' : $readmore_button_position = ' pull-right float-end float-right';

		// HTML starts
		
		$columns_number = '';
		
		if ($column_no == 5) {
			$columns_number = ' columns-'. $column_no;
		}

		if (!count($items)) {
			$output .= '<p class="alert alert-warning p-4 centered">' . Text::_('COM_SPPAGEBUILDER_ADDON_ARTICLE_NO_ITEMS_FOUND') . '</p>';
			return $output;
		}
		
		$output .= '<div class="sppb-addon sppb-addon-latest-posts'. $flex_style . $blog_style .' row ' . $class . '">';
		
				if ($title)
				{
					$output .= '<div class="sppb-section-title">';
					$output .= '<' . $heading_selector . ' class="sppb-addon-title">' . $title . '</' . $heading_selector . '>';
					$output .= '</div>'; // END :: title
				}

				$output .= '<div class="sppb-addon-content">';
				$output .= '<div id="lp-'.$addon_id.'" class="latest-posts">';
			

		if (count((array) $items)) {
				// Important to have "row" for grid here:
				$output .= '<div class="row">';

			foreach ($items as $key => $item) {
					
					$tplParams = Factory::getApplication()->getTemplate(true)->params;

					//$params  		= $item->params;
					$attribs 		= json_decode($item->attribs);
					$images 		= json_decode($item->images);
					$imgsize 		= $tplParams->get('blog_list_image', 'default');
					$intro_image 	= '';
					
					

					if(isset($attribs->spfeatured_image) && $attribs->spfeatured_image != '') {

						if($imgsize == 'default') {
							$intro_image = $attribs->spfeatured_image;
						} else {
							$intro_image = $attribs->spfeatured_image;
							$basename = basename($intro_image);
							$list_image = JPATH_ROOT . '/' . dirname($intro_image) . '/' . File::stripExt($basename) . '_'. $imgsize .'.' . File::getExt($basename);
							if(file_exists($list_image)) {
								$intro_image = Uri::root(true) . '/' . dirname($intro_image) . '/' . File::stripExt($basename) . '_'. $imgsize .'.' . File::getExt($basename);
							}
						}
					} elseif(isset($images->image_intro) && !empty($images->image_intro)) {
						$intro_image = $images->image_intro;
					}



					if($column_no == 1) {
						
						
						if ($show_image) {
							$image_alignment == 'right' ? $content_column = 'col-sm-8 column-1 float-start float-left match-height' : $content_column = 'col-sm-8 column-1 float-end float-right match-height';
						} else {		
							$image_alignment == 'right' ? $content_column = 'col-sm-12 column-1' : $content_column = 'col-sm-12 column-1';
						}
						if ($show_image) {
							$image_alignment == 'left' ? $img_column = 'col-sm-4 column-1 float-start float-left match-height' : $img_column = 'col-sm-4 column-1 float-end float-right match-height';
						}
						
						//$output .= '<div class="row">'.$image_alignment.'</div>';
						
					
							$h2style = ' style="font-size:180%;line-height:1.4;"';
							$img_wrapper_margin = ' style="margin:0;"';
						

						if ($image_alignment == 'left') {
							$inner_padding = ' style="padding:0 0 0 30px;"';
						} else {
							$inner_padding = ' style="padding:0 30px 0 0;"';
						}
					} else {
						$h2style = '';
						$img_wrapper_margin = '';
					}
				
				

				if ($enable_masonry == 0) {
					// match-height
					$column_no > 1 ? $match_height = ' match-height' : $match_height = ' match-height';
				} else {
					$column_no == 1 ? $match_height = ' match-height' : $match_height = '';
				}
				
				//'. ( ($column_no != 5) ? 'col-md-' . round(12 / $column_no) .' : '' ) .'
				//($column_no != 5)
				

				// Flex Style
				if($style == 'flex') {
					$output .= '<div class="latest-post'. $masonry . $columns_number . ( ( $column_no != 5 ) ? ' col-lg-' . round(12 / $column_no) : '' ) .'">';
					
					
					$output .= '<div class="latest-post-item'. $match_height .'">';

					// Only one column
					if($column_no == 1) {
						$output .= '<div class="clearfix">';// Important for floating left or right
					}

							if(!empty($intro_image) || (isset($images->image_intro) && !empty($images->image_intro))) {
								if ($show_image) {

									if($column_no == 1) {
										$output .= '<div style="padding:0" class="'.$img_column.'">';
									}
									$output .= '<div class="img-wrapper">';
									$output .= '<a href="' . $item->link . '"><img class="post-img" src="' . $intro_image . '" alt="' . $item->title . '" /><div class="caption-content">' . $item->title;
									if ($show_category) {
										$output .= '<em class="caption-category"><span class="posted-in">'. Text::_('COM_SPPAGEBUILDER_ADDON_POSTED_IN') .'</span>'. $item->category . '</em>';
									}
									$output .= '</div></a>';
									$output .= '</div>';

									if($column_no == 1) {
										$output .= '</div>';
									}
								}
							}

						// Only one column
						if($column_no == 1) {
							$output .= '<div class="'.$content_column.'">';
						}
					
					
							$output .= '<div class="latest-post-inner">';

									if (($show_date || $show_intro_text || $show_author) != 1)  {
									   $output .= '<h2 style="margin:0" class="entry-title"><a href="' . $item->link . '">' . $item->title . '</a></h2>';
									} else {
									   $output .= '<h2'.$h2style.' class="entry-title"><a href="' . $item->link . '">' . $item->title . '</a></h2>';
									}
									if ($show_date) {
										$output .= '<div class="entry-meta"><span class="entry-date">' . HTMLHelper::_('date', $item->created, $date_format) . '</span></div>';

									}
									if ($show_intro_text) {
										if ($intro_text_limit != '') {
											$output .= '<p class="intro-text" >' . StringHelper::truncate($item->introtext, $intro_text_limit, true, false) . '</p>';
										} else {
											$output .= '<p class="intro-text" >' . StringHelper::truncate($item->introtext, $intro_text_limit, true, false) . '</p>';
										}

									
									}
					
									// Show Author (Article author)
									$show_author || $show_category ? $output .= '<hr />' : $output .= '';
									if (!empty($item->username) && $show_author) {	
										$output .= '<span class="post-author"><span class="entry-author">' . Text::_('COM_SPPAGEBUILDER_ADDON_POSTED_BY'). '</span> ' . $item->username . '</span>';
									}
					
				
									if ($show_category) {

										$item->catUrl = Route::_(version_compare($JoomlaVersion, '4.0.0', '>=') ? Joomla\Component\Content\Site\Helper\RouteHelper::getCategoryRoute($item->catslug) : ContentHelperRoute::getCategoryRoute($item->catslug));

										$show_author ? $posted_in_category = ' cat-inline' : $posted_in_category = '';

										$output .= '<span class="category'.$posted_in_category.'"><span class="posted-in">'. Text::_('COM_SPPAGEBUILDER_ADDON_CATEGORY') .'</span><a href="' . $item->catUrl . '">'. $item->category . '</a></span>';

									}
					
						// Only one column
						if($column_no == 1) {
							$output .= '</div>';
							$output .= '</div>';
						}
					
								//Readmore button
								if ($show_readmore == '1') {	
									$output .= '<div class="clearfix" style="margin-top:25px;"><a class="sppb-btn' . $button_classes . ''.$readmore_button_position.'" href="' . $item->link . '">'. $button_text. '</a></div>';

								}

							$output .= '</div>'; // <div class="latest-post-inner">

							$output .= '</div>';
							$output .= '</div>'; 
				// ENDS FLex style
				
				// Default & Blog styles	
					} else {
						//$output .= '<div class="latest-post'. $masonry .' col-md-' . round(12/$column_no) . ' '. $columns_number .'">';
						//$output .= '<div'. ( ( $column_no == 5 ) ? ' style="@media screen and (min-width: 992px){width:20%}"' : '' ) .' class="latest-post'. $masonry .' '. $columns_number . ( ( $column_no != 5 ) ? ' col-md-' . round(12 / $column_no) : '' ) .'">';
					
						//$output .= '<div class="latest-post'. $masonry . $columns_number . ( ( $column_no != 5 ) ? ' col-md-' . round(12 / $column_no) : '' ) .'">';
					
					
					
					$output .= '<div class="latest-post'. $masonry . $columns_number . ( ( $column_no != 5 ) ? ' col-lg-' . round(12 / $column_no) : '' ) .'">';
					
						$output .= '<div class="latest-post-item">';
					
						$output .= '<div class="latest-post-inner'. $match_height .'">';

					if($column_no == 1) {
						//$output .= '<div class="row-fluid">';
						$output .= '<div class="clearfix">';
					}
							if ($show_image) {
								if($column_no == 1) {
									$output .= '<div class="'.$img_column.'">';
								}
								$output .= '<div'.$img_wrapper_margin.' class="img-wrapper">';
								$output .= '<a href="' . $item->link . '"><img class="post-img" src="' . $intro_image . '" alt="' . $item->title . '" /></a>';
								$output .= '</div>';

								if($column_no == 1) {
									$output .= '</div>';
								}
							}

						if($column_no == 1) {
							$output .= '<div'.$inner_padding.' class="'. $content_column .'">';
						}
							if ($show_date) {
								$output .= '<div class="entry-meta"><span class="entry-date"> ' . HTMLHelper::_('date', $item->created, $date_format) . '</span></div>';
							}
							$output .= '<h2'.$h2style.' class="entry-title"><a href="' . $item->link . '">' . $item->title . '</a></h2>';
							if ($show_intro_text) {
								if ($intro_text_limit != '') {
									$output .= '<p class="intro-text" >' . HTMLHelper::_('string.truncate', strip_tags($item->introtext), $intro_text_limit) . '</p>';
								} else {
									$output .= '<p class="intro-text" >' . HTMLHelper::_('string.truncate', $item->introtext, $intro_text_limit) . '</p>';
								}
							}
					
							// Show Author (Article author)
							$show_author || $show_category ? $output .= '<hr />' : $output .= '';
							if (!empty($item->username) && $show_author) {	
								$output .= '<span class="post-author"><span class="entry-author">' . Text::_('COM_SPPAGEBUILDER_ADDON_POSTED_BY'). '</span> ' . $item->username . '</span>';
							}
					
							if ($show_category) {
								
								$item->catUrl = Route::_(version_compare($JoomlaVersion, '4.0.0', '>=') ? Joomla\Component\Content\Site\Helper\RouteHelper::getCategoryRoute($item->catslug) : ContentHelperRoute::getCategoryRoute($item->catslug));
								
								$show_author ? $posted_in_category = ' cat-inline' : $posted_in_category = '';
								$output .= '<span class="category'.$posted_in_category.'"><span class="posted-in">'. Text::_('COM_SPPAGEBUILDER_ADDON_CATEGORY') .'</span><a href="' . $item->catUrl . '">'. $item->category . '</a></span>';
							}
					
						if($column_no == 1) {
							$output .= '</div>';
							$output .= '</div>';
						}

							//Readmore button
							if ($show_readmore == '1') {	
								$output .= '<div class="clearfix" style="margin-top:25px;"><a class="sppb-btn' . $button_classes . ''.$readmore_button_position.'" href="' . $item->link . '">'. $button_text. '</a></div>';
							}

						//latest-post-inner
						$output .= '</div>';	
						
						$output .= '</div>';
						$output .= '</div>';
					
					
					}
			
			}
			
				$output .= '</div>'; // Row
				
				$output .= '</div>';	
				$output .= '</div>';
				$output .= '</div>';

		} // End Foreach
	
	return $output;
	}
	
	public function css() {
		
		$addon_id = '#sppb-addon-' . $this->addon->id;
		$settings = $this->addon->settings;
		
		$column_no = (isset($settings->column_no) && $settings->column_no) ? (int) $settings->column_no : 3;
		$style = (isset($settings->style) && $settings->style) ? $settings->style : '';
		
		$css = '';
		
		$column_no == 1 ? $column_no_1 = $addon_id .' .col-lg-12 {margin:10px auto;padding:0!important;}' : $column_no_1 = '';
		
		// Add styles @media rule post-img
		if($style == 'flex') {
			$css .= '@media screen and (max-width: 767.98px){ '. $column_no_1 . $addon_id .' .img-wrapper a {font-size:150%;line-height:1.5;} }';
		}
		
		if ($column_no == 1) {
			$css .= $addon_id .' .column-1 {display:block;padding:0;}';
			$css .= $addon_id .' .img-wrapper {display:block;padding:0;}';
		}
		
		if ($column_no == 3) {
			
			$css .= 
			'@media screen and (min-width: 767.99px) and (max-width: 991.98px){'.$addon_id.' .latest-post {width:50%}}'
			. '@media screen and ( min-width: 575.99px ) and ( max-width: 767.98px ){'.$addon_id.' .latest-post {width:50%}}'
			. '@media screen and (max-width: 575.98px){'.$addon_id.' .latest-post {width:100%}}'
			;
		}

		if ($column_no == 4) {
			
			$css .= 
			'@media screen and (min-width: 767.99px) and (max-width: 991.98px){'.$addon_id.' .latest-post {width:33.3333%}}'
			. '@media screen and ( min-width: 575.99px ) and ( max-width: 767.98px ){'.$addon_id.' .latest-post {width:50%}}'
			. '@media screen and (max-width: 575.98px){'.$addon_id.' .latest-post {width:100%}}'
			;
		}
		
		if($column_no == 5) {
			$css .= 
			'@media screen and (min-width: 991.99px){'.$addon_id.' .columns-5 {width:20%}}'
			. '@media screen and (min-width: 767.99px) and (max-width: 991.98px){'.$addon_id.' .columns-5 {width:33.3333%}}'
			. '@media screen and ( min-width: 575.99px ) and ( max-width: 767.98px ){'.$addon_id.' .columns-5 {width:50%}}'
			. '@media screen and (max-width: 575.98px){'.$addon_id.' .columns-5 {width:100%} }'
			;
		}
		
		if ($column_no == 6) {
			
			$css .= 
			'@media screen and (min-width: 767.99px) and (max-width: 991.98px){'.$addon_id.' .latest-post {width:25%}}'
			. '@media screen and ( min-width: 575.99px ) and ( max-width: 767.98px ){'.$addon_id.' .latest-post {width:50%}}'
			. '@media screen and (max-width: 575.98px){'.$addon_id.' .latest-post {width:100%} }'
			;
		}

		return $css;
	}

	
	
	public function js()
	{
		$settings = $this->addon->settings;
		$addon_id = $this->addon->id;
		$enable_masonry = (isset($settings->enable_masonry)) ? (int) $settings->enable_masonry : 0;
		$column_no = (isset($settings->column_no) && $settings->column_no) ? (int) $settings->column_no : 3;

		if ($enable_masonry == 1 && $column_no > 1) {
			return '
				jQuery(function(){
					"use strict";
					jQuery("#lp-' . $addon_id . '").imagesLoaded(function(){
						jQuery("#lp-'.$addon_id.'").masonry({
							itemSelector:\'.masonry_latest_post\'
						});
					});
				});
			';
		}
	}
	
	static function isComponentInstalled($component_name)
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('a.enabled');
		$query->from($db->quoteName('#__extensions', 'a'));
		$query->where($db->quoteName('a.name') . " = " . $db->quote($component_name));
		$db->setQuery($query);
		$is_enabled = $db->loadResult();
		return $is_enabled;
	}
}
