<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

SpAddonsConfig::addonConfig([
	'type'       => 'content',
	'addon_name' => 'person',
	'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON'),
	'desc'       => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_DESC'),
	'category'   => 'Content',
	'settings' => [
		'layout' => [
			'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_STYLE'),
			'fields' => [
				
				'type' => [
					'type' => 'thumbnail',
					'title'=>Text::_('Main Styles'),
					'columns' => 3,
					'values' => [
						'default' => ['svg' => '<svg fill="none" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 86 88"><path d="M0,0h86v88H0V0z" fill-opacity=".1"/><path d="M13 9h60c2.2 0 4 1.8 4 4v45c0 2.2-1.8 4-4 4H13c-2.2 0-4-1.8-4-4V13c0-2.2 1.8-4 4-4z" opacity=".1" fill="currentColor"/><path d="M47 31.4h-8c-3.6 0-6.5 2.5-6.5 5.5v11.2c0 .6.6 1.1 1.3 1.1H52c.7 0 1.3-.5 1.3-1.1V36.9c.1-3-2.8-5.5-6.3-5.5h0z" opacity=".33" fill="currentColor"/><path d="M43 16.8c-3.7 0-6.8 3-6.8 6.6 0 2.5 1.4 4.6 3.5 5.8 1 .5 2.1.8 3.3.8s2.3-.3 3.3-.8a6.54 6.54 0 0 0 3.5-5.8c0-3.6-3.1-6.6-6.8-6.6z" opacity=".5" fill="currentColor"/><path d="M29 69h28c1.1 0 2 .9 2 2h0c0 1.1-.9 2-2 2H29c-1.1 0-2-.9-2-2h0c0-1.1.9-2 2-2z" opacity=".4" fill="currentColor"/><path d="M18.5 77.4h49a1.54 1.54 0 0 1 1.5 1.5h0a1.54 1.54 0 0 1-1.5 1.5h-49a1.54 1.54 0 0 1-1.5-1.5h0a1.54 1.54 0 0 1 1.5-1.5z" opacity=".3" fill="currentColor"/></svg><h6 style="text-align:center;font-size:14px;padding:6px 0 0 0;">Default</h6>'],
						'flex' => ['svg' => '<svg fill="none" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 86 88"><path fill="currentColor" fill-opacity=".1" d="M0 0h86v88H0z"/><path d="M0,0h86v88H0V0z" fill-opacity=".1"/><path d="M13 9h60c2.2 0 4 1.8 4 4v45c0 2.2-1.8 4-4 4H13c-2.2 0-4-1.8-4-4V13c0-2.2 1.8-4 4-4z" opacity=".1" fill="currentColor" /><path d="M43 15.9c-3.3 0-5.9 2.6-5.9 5.8 0 2.2 1.2 4 3 5 .9.5 1.8.7 2.9.7s2-.3 2.9-.7c1.8-1 3-2.9 3-5 0-3.2-2.6-5.8-5.9-5.8z" fill="currentColor" opacity=".7"/><path d="M29 69h28c1.1 0 2 .9 2 2h0c0 1.1-.9 2-2 2H29c-1.1 0-2-.9-2-2h0c0-1.1.9-2 2-2z" opacity=".5" fill="currentColor"/><path d="M18.5 76.4h49a1.54 1.54 0 0 1 1.5 1.5h0a1.54 1.54 0 0 1-1.5 1.5h-49a1.54 1.54 0 0 1-1.5-1.5h0a1.54 1.54 0 0 1 1.5-1.5z" opacity=".5" fill="currentColor"/><path d="M71.5 40.9c9.9 3.8 9.4 10.2-4.3 13.8-2.8.8-5.6 1.5-9 1.9V61c3.9-.5 7.2-1.5 10.4-2.3 20-5.2 17.7-14.9 3.3-19.5-8.7-2.8-19.5-4-28.5-4-8.5 0-18 .8-26.3 3.1C-21.6 49 25.7 63.5 45 62.7v5l6.7-7.3v-1.5L45 51.7V57c-9.8.1-57-6.4-27.4-16.7 6.8-2.4 18.9-3.1 26.1-3.1 7.9-.1 20.2.8 27.8 3.7h0z" fill="currentColor" fill-rule="evenodd"/><path d="M46.4 28.6h-6.9c-3.1 0-5.6 2.2-5.6 4.8v9.7c0 .5.5 1 1.1 1h15.9c.6 0 1.1-.4 1.1-1v-9.7c.1-2.6-2.5-4.8-5.6-4.8h0z" opacity=".3" fill="currentColor"/></svg><h6 style="text-align:center;font-size:14px;padding:6px 0 0 0;">Flex</h6>'],
						'flip' => ['svg' => '<svg fill="none" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 86 88"><path fill="currentColor" fill-opacity="0.1" d="M0 0h86v88H0z"/><path d="M0,0h86v88H0V0z" fill-opacity=".1"/><path d="M13 9h60c2.2 0 4 1.8 4 4v45c0 2.2-1.8 4-4 4H13c-2.2 0-4-1.8-4-4V13c0-2.2 1.8-4 4-4z" opacity=".1" fill="currentColor" /><path d="M43 15.9c-3.3 0-5.9 2.6-5.9 5.8 0 2.2 1.2 4 3 5 .9.5 1.8.7 2.9.7s2-.3 2.9-.7c1.8-1 3-2.9 3-5 0-3.2-2.6-5.8-5.9-5.8z" fill="currentColor" opacity=".6"/><path d="M29 69h28c1.1 0 2 .9 2 2h0c0 1.1-.9 2-2 2H29c-1.1 0-2-.9-2-2h0c0-1.1.9-2 2-2z" opacity=".5" fill="currentColor"/><path d="M18.5 76.4h49a1.54 1.54 0 0 1 1.5 1.5h0a1.54 1.54 0 0 1-1.5 1.5h-49a1.54 1.54 0 0 1-1.5-1.5h0a1.54 1.54 0 0 1 1.5-1.5z" opacity=".4" fill="currentColor"/><path d="M15 40.4c1.1-.5 1.6-1.7 1.1-2.7s-1.8-1.5-3-1h0c-1.5.6-2.9 1.4-3.9 2.3s-1.8 2.1-1.8 3.6c0 2.2 1.8 3.8 3.7 4.8 2 1.1 4.6 2.1 7.8 2.8 6.3 1.5 14.8 2.4 24.2 2.4h1.3l-5.1 4.6a1.89 1.89 0 0 0 0 2.9c.9.8 2.3.8 3.2 0l8.9-8.1c.9-.8.9-2.1 0-2.8l-8.9-8.1c-.9-.8-2.3-.8-3.2 0a1.89 1.89 0 0 0 0 2.9l5.1 4.6h-1.3c-9.1 0-17.2-.9-23-2.3-2.9-.7-5.1-1.5-6.5-2.3-1.5-.9-1.6-1.4-1.6-1.4s0-.2.5-.7c.3-.4 1.2-.9 2.5-1.5h0zm57.8-3.6c-1.1-.5-2.4 0-3 1s0 2.2 1.1 2.7c1.3.5 2.2 1.1 2.7 1.5s.5.7.5.7 0 .3-.6.8-1.6 1-3 1.6c-2.9 1.1-7.1 2.1-12.3 2.8-1.2.2-2 1.2-1.8 2.3s1.3 1.8 2.5 1.7c5.4-.7 10.1-1.7 13.5-3.1 1.7-.7 3.2-1.4 4.3-2.4 1.1-.9 2-2.2 2-3.7s-.8-2.7-1.8-3.6-2.5-1.7-4.1-2.3z" fill="currentColor" fill-rule="evenodd"/><path d="M46.4 28.6h-6.9c-3.1 0-5.6 2.2-5.6 4.8v9.7c0 .5.5 1 1.1 1h15.9c.6 0 1.1-.4 1.1-1v-9.7c.1-2.6-2.5-4.8-5.6-4.8h0z" opacity=".3" fill="currentColor"/></svg><h6 style="text-align:center;font-size:14px;padding:6px 0 0 0;">Flip</h6>'],
					],
					'std' => 'default',
				],
				
				'style_separator1' => [
					'type' => 'separator',
					'depends' => [['type', '=', 'default']]
				],
				
				'person_style_separator' => [
					'type' => 'separator',
					'title'=> 'Additional styles for "DEFAULT" Main style',
					'depends' => [['type', '=', 'default']]
				],
				
				'style_separator2' => [
					'type' => 'separator',
					'title'=> Text::_(''),
					//'title'=> Text::_('Additional styles for "DEFAULT" Styles (not "Flex" or "Flip")'),
					'depends' => [['type', '=', 'default']]
				],

				
				'person_style_preset' => [
					'type' => 'thumbnail',
					'title' => '',
					'columns'   => 3,
					'values'    => [
						'default' => ['svg' => '<svg fill="none" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 86 88"><path opacity="0.2" fill="currentColor" fill-opacity="0.3" d="M0 0h86v88H0z"/><rect opacity="0.1" x="9" y="9" width="68" height="43" rx="4" fill="currentColor"/><path opacity="0.5" d="M45.99 28.805h-5.98c-2.694 0-4.885 1.87-4.885 4.169v8.442c0 .46.437.834.977.834h13.796c.54 0 .977-.374.977-.834v-8.442c0-2.299-2.191-4.17-4.884-4.17z" fill="currentColor"/><path d="M43 17.75c-2.827 0-5.127 2.25-5.127 5.014 0 1.876 1.058 3.513 2.621 4.373.742.408 1.596.641 2.506.641.91 0 1.764-.233 2.505-.64 1.563-.86 2.622-2.498 2.622-4.374 0-2.765-2.3-5.014-5.127-5.014z" fill="currentColor"/><rect opacity="0.6" x="9" y="60" width="32" height="4" rx="2" fill="currentColor"/><rect opacity="0.3" x="9" y="67" width="49" height="3" rx="1.5" fill="currentColor"/><g opacity="0.5" fill="currentColor"><circle cx="11" cy="78" r="2"/><circle cx="18" cy="78" r="2"/><circle cx="25" cy="78" r="2"/></g></svg>'],
						'layout1' => ['svg' => '<svg fill="none" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 86 88"><path fill="currentColor" fill-opacity="0.1" d="M0 0h86v88H0z"/><rect opacity="0.1" x="9" y="9" width="68" height="53" rx="4" fill="currentColor"/><g opacity="0.5" fill="currentColor"><circle cx="18" cy="53" r="2"/><circle cx="25" cy="53" r="2"/><circle cx="32" cy="53" r="2"/></g><path opacity="0.5" d="M45.99 28.805h-5.98c-2.694 0-4.885 1.87-4.885 4.169v8.442c0 .46.437.834.977.834h13.796c.54 0 .977-.374.977-.834v-8.442c0-2.299-2.191-4.17-4.884-4.17z" fill="currentColor"/><path d="M43 17.75c-2.827 0-5.127 2.25-5.127 5.014 0 1.876 1.058 3.513 2.621 4.373.742.408 1.596.641 2.506.641.91 0 1.764-.233 2.505-.64 1.563-.86 2.622-2.498 2.622-4.374 0-2.765-2.3-5.014-5.127-5.014z" fill="currentColor"/><rect opacity="0.6" x="16" y="68" width="32" height="4" rx="2" fill="currentColor"/><rect opacity="0.3" x="16" y="75" width="52" height="3" rx="1.5" fill="currentColor"/></svg>'],
						'layout2' => ['svg' => '<svg fill="none" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 86 88"><path opacity="0.2" fill="currentColor" fill-opacity="0.3" d="M0 0h86v88H0z"/><rect opacity="0.1" x="9" y="9" width="68" height="70" rx="4" fill="currentColor"/><g opacity="0.5" fill="currentColor"><circle cx="18" cy="70" r="2"/><circle cx="25" cy="70" r="2"/><circle cx="32" cy="70" r="2"/></g><path opacity="0.5" d="M45.99 28.805h-5.98c-2.694 0-4.885 1.87-4.885 4.169v8.442c0 .46.437.834.977.834h13.796c.54 0 .977-.374.977-.834v-8.442c0-2.299-2.191-4.17-4.884-4.17z" fill="currentColor"/><path d="M43 17.75c-2.827 0-5.127 2.25-5.127 5.014 0 1.876 1.058 3.513 2.621 4.373.742.408 1.596.641 2.506.641.91 0 1.764-.233 2.505-.64 1.563-.86 2.622-2.498 2.622-4.374 0-2.765-2.3-5.014-5.127-5.014z" fill="currentColor"/><rect opacity="0.6" x="16" y="54" width="32" height="4" rx="2" fill="currentColor"/><rect opacity="0.3" x="16" y="61" width="52" height="3" rx="1.5" fill="currentColor"/></svg>'],
						'layout3' => ['svg' => '<svg fill="none" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 86 88"><path opacity="0.2" fill="currentColor" fill-opacity="0.3" d="M0 0h86v88H0z"/><rect opacity="0.1" x="9" y="9" width="68" height="70" rx="4" fill="currentColor"/><rect opacity="0.6" x="27" y="38" width="32" height="4" rx="2" fill="currentColor"/><rect opacity="0.3" x="19" y="45" width="49" height="3" rx="1.5" fill="currentColor"/><g opacity="0.5" fill="currentColor"><circle cx="36" cy="56" r="2"/><circle cx="43" cy="56" r="2"/><circle cx="50" cy="56" r="2"/></g></svg>'],
						'layout4' => ['svg' => '<svg fill="none" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 86 88"><path opacity="0.2" fill="currentColor" fill-opacity="0.3" d="M0 0h86v88H0z"/><rect opacity="0.1" x="9" y="9" width="68" height="70" rx="4" fill="currentColor"/><g opacity="0.5" fill="currentColor"><circle cx="42" cy="50" r="2"/><circle cx="49" cy="50" r="2"/><circle cx="56" cy="50" r="2"/></g><path opacity="0.5" d="M28.866 40.055h-5.982c-2.693 0-4.884 1.87-4.884 4.169v8.442c0 .46.437.834.977.834h13.796c.54 0 .977-.374.977-.834v-8.442c0-2.299-2.191-4.17-4.884-4.17z" fill="currentColor"/><path d="M25.875 29c-2.827 0-5.127 2.25-5.127 5.014 0 1.875 1.058 3.513 2.621 4.373.742.408 1.596.641 2.506.641.91 0 1.764-.233 2.505-.64 1.563-.86 2.622-2.498 2.622-4.374 0-2.765-2.3-5.014-5.127-5.014z" fill="currentColor"/><rect opacity="0.6" x="40" y="34" width="22" height="4" rx="2" fill="currentColor"/><rect opacity="0.3" x="40" y="41" width="29" height="3" rx="1.5" fill="currentColor"/></svg>'],
					],
					'std' => 'default',
					'depends' => [['type', '=', 'default']],
				],
				
				'wrap_background' => [
					'type' => 'color',
					'title'=>Text::_('FLEX_ADDON_PERSON_BACKGROUND'),
					'desc'=>Text::_('FLEX_ADDON_PERSON_BACKGROUND_DESC'),
					'std' => '',
					'depends' => [['type', '!=', 'default']]
				],
				
			],
		],

		'person' => [
			'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON'),
			'fields' => [
				'name' => [
					'type'        => 'text',
					'title'       => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_NAME'),
					'placeholder' => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_NAME'),
					'placeholder' => 'John Doe (example)',
					'std'         => 'Janette L’Aughter',
				],

				'title_link' => [
					'type'  => 'link',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_LINK'),
					'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_HEADING_USE_LINK_DESC'),
				],

				'name_typography' => [
					'type'     => 'typography',
					'title'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
					'fallbacks'   => [
						'font' => 'name_font_family',
						'size' => 'name_fontsize',
						'line_height' => 'name_lineheight',
						'letter_spacing' => 'name_letterspace',
						'uppercase' => 'name_font_style.uppercase',
						'italic' => 'name_font_style.italic',
						'underline' => 'name_font_style.underline',
						'weight' => 'name_font_style.weight',
					],
				],

				'name_color' => [
					'type'      => 'color',
					'title'    	=> Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
				],

				'designation_separator' => [
					'type'        => 'separator'
				],

				'designation' => [
					'type'        => 'text',
					'title'       => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_DESIGNATION'),
					'placeholder' => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_DESIGNATION'),
					'std'         => '/ Laughing Executive & Co-Founder /',
				],

				'designation_typography' => [
					'type'     => 'typography',
					'title'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
					'fallbacks'   => [
						'font' => 'designation_font_family',
						'size' => 'designation_fontsize',
						'line_height' => 'designation_lineheight',
						'letter_spacing' => 'designation_letterspace',
						'uppercase' => 'designation_font_style.uppercase',
						'italic' => 'designation_font_style.italic',
						'underline' => 'designation_font_style.underline',
						'weight' => 'designation_font_style.weight',
					],
				],

				'designation_color' => [
					'type'      => 'color',
					'title'    	=> Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
				],

				'designation_margin' => [
					'type'       => 'margin',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN'),
					'responsive' => true,
				],

				'email' => [
					'type'        => 'text',
					'title'       => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_EMAIL'),
					'placeholder' => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_EMAIL'),
				],

				'intro_separator' => [
					'type'        => 'separator'
				],

				'introtext' => [
					'type'    => 'textarea',
					'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_INTROTEXT'),
					'desc'    => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_INTROTEXT_DESC'),
					'depends' => [['person_style_preset', '!=', 'layout3']],
					'std'     => 'Laugh with her grace valley likeness life midst good. Fruit air every there two. Seed it moved their midst lights green lighthouse. Male stars without you earth that waters the make bearing. Smile under seasons for over he forth upon multiply. Days you subdue under said divided isn’t may days fish fly was firmament imagine the fruit.',
				],

				'intro_typography' => [
					'type'     => 'typography',
					'title'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
					'fallbacks'   => [
						'font' => 'introtext_font_family',
						'size' => 'introtext_fontsize',
						'line_height' => 'introtext_lineheight',
						'letter_spacing' => 'introtext_letterspace',
						'uppercase' => 'introtext_font_style.uppercase',
						'italic' => 'introtext_font_style.italic',
						'underline' => 'introtext_font_style.underline',
						'weight' => 'introtext_font_style.weight',
					],
				],

				'introtext_color' => [
					'type' => 'color',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR')
				],

				'alignment_separator' => [
					'type' => 'separator',
				],

				'alignment' => [
					'type' => 'alignment',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_ALIGNMENT'),
					'responsive' => true,
					'available_options' => ['left', 'center', 'right'],
					'std' => 'center',
				],
			],
		],

		'image' => [
			'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_IMAGE'),
			'fields' => [
				'image' => [
					'type'      => 'media',
					'title'     => Text::_('COM_SPPAGEBUILDER_GLOBAL_IMAGE'),
					'hideTitle' => true,
					'format'    => 'image',
					'std'       => ['src' => 'https://source.unsplash.com/IF9TK5Uy-KI/350x460']
				],

				'image_border_radius' => [
					'type'  => 'slider',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_RADIUS'),
					'std'   => 0,
					'max'   => 400
				],
			]
		],

		'background' => [
			'title'	=> Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_CONTENT_BACKGROUND'),
			'depends'    => [
				['person_style_preset', '!=', 'default'],
				['person_style_preset', '!=', 'layout2'],
				['person_style_preset', '!=', 'layout3'],
			],
			'fields' => [
				'name_desig_padding' => [
					'type'    => 'padding',
					'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_PADDING'),
					'std'     => ['xl' => '15px 0px 15px 15px', 'lg' => '', 'md' => '', 'sm' => '', 'xs' => ''],
					'depends' => [['person_style_preset', '=', 'layout1']],
					'responsive' => true,
				],

				'name_desig_bg' => [
					'type'    => 'color',
					'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND_COLOR'),
					'std'     => '#FFFFFF',
					'depends' => [['person_style_preset', '=', 'layout1']]
				],

				'person_content_bg' => [
					'type'    => 'color',
					'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND_COLOR'),
					'std'     => '#FFFFFF',
					'depends' => [['person_style_preset', '=', 'layout4']]
				],

				'person_content_padding' => [
					'type'       => 'padding',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_PADDING'),
					'std'        => ['xl' => '15px 15px 15px 15px', 'lg' => '15px 15px 15px 15px', 'md' => '15px 15px 15px 15px', 'sm' => '15px 15px 15px 15px', 'xs' => '15px 15px 15px 15px'],
					'responsive' => true,
					'depends'    => [['person_style_preset', '=', 'layout4']],
				],
			],
		],

		'overlay' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_OVERLAY'),
			'depends' => [['person_style_preset', '!=', 'layout4']],
			'fields' => [
				'content_overlay_type' => [
					'type'    => 'radio',
					'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_OVERLAY'),
					'values'  => [
						'color' => 'Color',
						'gradient' => 'Gradient',
					],
					'std' => 'gradient',
					'is_header' => 1,
					'depends' => [['type', '=', 'default']],
				],

				'content_overlay_color' => [
					'type'    => 'color',
					'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
					'depends' => [
						['content_overlay_type', '!=', 'gradient'],
						['type', '=', 'default']
					],
				],

				'content_overlay_backdrop_filter' => [
					'type' => 'select',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_LAYOUTS_WRAPPER_BACKDROP_FILTER'),
					'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_LAYOUTS_WRAPPER_BACKDROP_FILTER_DESC'),
					'values' => [
						'blur' => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_LAYOUTS_WRAPPER_BACKDROP_FILTER_BLUR'),
						'brightness' => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_LAYOUTS_WRAPPER_BACKDROP_FILTER_BRIGHTNESS'),
						'contrast' => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_LAYOUTS_WRAPPER_BACKDROP_FILTER_CONTRAST'),
						'grayscale' => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_LAYOUTS_WRAPPER_BACKDROP_FILTER_GRAYSCALE'),
						'invert' => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_LAYOUTS_WRAPPER_BACKDROP_FILTER_INVERT'),
						'opacity' => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_LAYOUTS_WRAPPER_BACKDROP_FILTER_OPACITY'),
						'sepia' => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_LAYOUTS_WRAPPER_BACKDROP_FILTER_SEPIA'),
						'saturate' => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_LAYOUTS_WRAPPER_BACKDROP_FILTER_SATURATE'),
					],
					'std' => '',
					'depends' => [
						['type', '=', 'default'],
						['person_style_preset', '!=', 'layout1'],
						['person_style_preset', '!=', 'default'],
						['content_overlay_type', '!=', 'gradient']
					],
				],

				'content_overlay_backdrop_filter_value' => [
					'type'  => 'slider',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_LAYOUTS_WRAPPER_BACKDROP_FILTER_VALUE'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_LAYOUTS_WRAPPER_BACKDROP_FILTER_VALUE_DESC'),
					'max'   => 100,
					'depends' => [
						['type', '=', 'default'],
						['person_style_preset', '!=', 'layout1'],
						['person_style_preset', '!=', 'default'],
						['content_overlay_backdrop_filter', '!=', '']
					]
				],

				'content_overlay_gradient' => [
					'type'  => 'gradient',
					'std'   => [
						"color"  => "rgba(207, 140, 145, 0.6)",
						"color2" => "rgba(227, 150, 155, 0.4)",
						"deg"    => "45",
						"type"   => "linear"
					],
					'depends' => [
						['type', '=', 'default'],
						['content_overlay_type', '=', 'gradient']
					],
				],
			],
		],

		'social' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_SOCIAL'),
			'fields' => [
				'facebook' => [
					'type'        => 'text',
					'title'       => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_FACEBOOK'),
					'desc'        => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_FACEBOOK_DESC'),
					'placeholder' => 'https://www.facebook.com/username',
					'std'         => '#',
				],

				'twitter' => [
					'type'        => 'text',
					'title'       => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_TWITTER'),
					'desc'        => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_TWITTER_DESC'),
					'placeholder' => 'https://twitter.com/username',
					'std'         => '#',
				],

				'youtube' => [
					'type'  => 'text',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_YOUTUBE'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_YOUTUBE_DESC'),
				],

				'linkedin' => [
					'type'  => 'text',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_LINKEDIN'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_LINKEDIN_DESC'),
				],

				'pinterest' => [
					'type'  => 'text',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_PINTEREST'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_PINTEREST_DESC'),
				],

				'flickr' => [
					'type'  => 'text',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_FLICKR'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_FLICKR_DESC'),
				],

				'dribbble' => [
					'type'  => 'text',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_DRIBBBLE'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_DRIBBBLE_DESC'),
				],

				'behance' => [
					'type'  => 'text',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_BEHANCE'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_BEHANCE_DESC'),
				],

				'instagram' => [
					'type'  => 'text',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_INSTAGRAM'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_INSTAGRAM_DESC'),
				],

				'social_icon_color_separator' => [
					'type' => 'separator',
				],

				'social_icon_color' => [
					'type'  => 'color',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
				],

				'social_icon_hover_color' => [
					'type'  => 'color',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR_HOVER'),
				],

				'social_icon_fontsize_separator' => [
					'type' => 'separator',
				],

				'social_icon_fontsize' => [
					'type'  => 'slider',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_FONT_SIZE'),
					'max'   => 200,
				],

				'social_icon_margin' => [
					'type'       => 'margin',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN'),
					'responsive' => true,
				],

				'social_position' => [
					'type'   => 'select',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_POSITION'),
					'values' => [
						'before' => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_BEFORE_INTROTEXT'),
						'after'  => Text::_('COM_SPPAGEBUILDER_ADDON_PERSON_AFTER_INTROTEXT'),
					],
					'std'     => 'after',
					'depends' => [['person_style_preset', '!=', 'layout3']],
				],
			],
		],
	],
]);
