<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

//Include Pixeden Icons (in Flex)
require_once dirname(dirname( __DIR__ )) . '/fields/pixeden-icons.php';

SpAddonsConfig::addonConfig([
    'type'       => 'content',
    'addon_name' => 'pie_progress',
    'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS'),
    'desc'       => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_DESC'),
    'category'   => 'Content',
    'settings' => [
        'progress' => [
            'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS'),
            'fields' => [
                'percentage' => [
                    'type'  => 'slider',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_PERCENTAGE'),
                    'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_PERCENTAGE_DESC'),
                    'min'   => 1,
                    'max'   => 100,
                    'std'   => 75,
                    'info'  => '%',
                ],

                'percentage_font_size' => [
                    'type'       => 'slider',
                    'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_FONT_SIZE'),
                    'std'        => ['xl' => 24],
                    'responsive' => true,
                    'max'        => 400,
                    'info'       => 'px',
                ],

                'size' => [
                    'type'  => 'slider',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_SIZE'),
                    'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_SIZE_DESC'),
                    'min'   => 50,
                    'max'   => 1000,
                    'std'   => 110,
                    'info'  => 'px',
                ],

                'animation_duration' => [
                    'type' => 'slider',
                    'title' => Text::_('COM_SPPAGEBUILDER_ANIMATION_DURATION'),
                    'desc' => Text::_('COM_SPPAGEBUILDER_ANIMATION_DURATION_DESC'),
					'std'  => 1500,
                    'info' => 'ms',
                ],

                'border_width' => [
                    'type'  => 'slider',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_BORDER_WIDTH'),
                    'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_BAR_WIDTH_DESC'),
                    'min'   => 1,
                    'max'   => 40,
                    'std'   => 5,
                    'info'  => 'px',
                ],

                'border_color' => [
                    'type'   => 'color',
                    'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_BAR'),
                    'std'    => 'rgba(217, 211, 128, 0.4)',
                ],

                'border_active_color' => [
                    'type'   => 'color',
                    'std'    => '#D1BC1F',
                    'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_PROGRESS'),
                ],

                'percentage_color' => [
                    'type'   => 'color',
                    'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_PERCENTAGE'),
                    'std'    => '#574E18',
                ],
            ],
        ],

        'icon' => [
            'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_ICON'),
            'fields' => [
				
				 'peicon_name' => [
                    'type' =>'select',
    				'title' => Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_PE_ICON_NAME'),
					'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_PE_ICON_NAME_DESC'),
					'values' => $peicon_list,
					'std' => 'pe-7s-download',
                ],	
				
                'icon_name' => [
                    'type'  => 'icon',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_ICON'),
                ],
				
				'icon_size' => [
                    'type'=>'slider',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_ICON_SIZE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_ICON_SIZE_DESC'),
					'min'=>16,
					'max'=>500,
					'std'=>55,
					'info' => 'px',
                ],
				
				'icon_color' => [
                    'type'=>'color',
					'title'=>Text::_('FLEX_ADDON_ICON_TXT_COLOR'),
					'desc'=>Text::_('FLEX_ADDON_ICON_TXT_COLOR_DESC'),
                    'std'=>'#60591B',
                ],
            ]
        ],

        'content' => [
            'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT'),
            'fields' => [
                'text' => [
                    'type' => 'editor',
                    'std'  => 'Pie Progress is a type of circular progress view similar to the one that you can find in iOS devices while updating applications. Simple library where the progress gets updated by passing values to a single method.'
                ],

                'content_typography' => [
                    'type' => 'typography',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
                ],
            ],
        ],

        'title' => [
            'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TITLE'),
            'fields' => [
                'title' => [
                    'type'  => 'text',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE'),
                    'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_DESC'),
					'std'   => 'Pie Progress',
                ],

                'heading_selector' => [
                    'type'   => 'headings',
                    'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS'),
                    'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_DESC'),
                    'std'   => 'h4',
                ],

                'title_typography' => [
                    'type'     => 'typography',
                    'title'       => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
                    'fallbacks'   => [
                        'font' => 'title_font_family',
                        'size' => 'title_fontsize',
                        'line_height' => 'title_lineheight',
                        'letter_spacing' => 'title_letterspace',
                        'uppercase' => 'title_font_style.uppercase',
                        'italic' => 'title_font_style.italic',
                        'underline' => 'title_font_style.underline',
                        'weight' => 'title_font_style.weight',
                    ],
                ],

                'title_text_color' => [
                    'type'   => 'color',
                    'title'       => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
                ],

                'title_margin_top' => [
                    'type'        => 'slider',
                    'title'       => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_TOP'),
                    'max'         => 400,
					'std'		  => 15,
                    'responsive'  => true
                ],

                'title_margin_bottom' => [
                    'type'        => 'slider',
                    'title'       => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_BOTTOM'),
                    'max'         => 400,
					'std'		  => 20,
                    'responsive'  => true
                ],
            ],
        ],
    ],
]);
