<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

SpAddonsConfig::addonConfig([
	'type' => 'content',
	'addon_name' => 'sp_plyr',
	'title' => Text::_('FLEX_ADDON_PLYR'),
	'desc' => Text::_('FLEX_ADDON_PLYR_DESC'),
	'category' => 'Flex',
	'settings' => [
        'content' => [
            'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT'),
            'fields' => [
				
				'media' => [
					'type' => 'thumbnail',
					'title' => Text::_('FLEX_ADDON_PLYR_MEDIA'),
					'desc' => Text::_('FLEX_ADDON_PLYR_MEDIA_DESC'),
					'columns' => 3,
					'values' => [
						'1' => ['svg' => '<svg xmlns="http://www.w3.org/2000/svg" width="38" height="38" fill="currentColor" class="d-table w-100 my-2 mx-auto centered" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M0 5a2 2 0 0 1 2-2h7.5a2 2 0 0 1 1.983 1.738l3.11-1.382A1 1 0 0 1 16 4.269v7.462a1 1 0 0 1-1.406.913l-3.111-1.382A2 2 0 0 1 9.5 13H2a2 2 0 0 1-2-2zm11.5 5.175 3.5 1.556V4.269l-3.5 1.556zM2 4a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h7.5a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1z"/></svg><h6 style="text-align:center;font-size:14px;padding:7px 0 2px 0;">'. Text::_('FLEX_VIDEO') .'</h6>'],
						
						'2' => ['svg' => '<svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" fill="currentColor" class="d-table w-100 my-2 mx-auto centered" viewBox="0 0 16 16"><path d="M6 13c0 1.105-1.12 2-2.5 2S1 14.105 1 13s1.12-2 2.5-2 2.5.896 2.5 2m9-2c0 1.105-1.12 2-2.5 2s-2.5-.895-2.5-2 1.12-2 2.5-2 2.5.895 2.5 2"/><path fill-rule="evenodd" d="M14 11V2h1v9zM6 3v10H5V3z"/><path d="M5 2.905a1 1 0 0 1 .9-.995l8-.8a1 1 0 0 1 1.1.995V3L5 4z"/></svg><h6 style="text-align:center;font-size:14px;padding:10px 0 2px 0;">'. Text::_('FLEX_AUDIO') .'</h6>'],
						
						'3' => ['svg' => '
						<svg xmlns="http://www.w3.org/2000/svg" width="37" height="37" fill="currentColor" class="d-table mt-2 mx-auto centered" viewBox="0 0 16 16"><path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"/></svg><h6 style="text-align:center;font-size:11px;padding:8px 0 0 0;">'. Text::_('FLEX_YOUTUBE_VIMEO') .'</h6>'],
					],
					'std' => '1',
					//'depends' => [['type', '=', 'default']],
				],
				
				'separator_media' => [
					'type'=>'separator', 
					'title'=>Text::_(''),
					//'depends' => [['media', '=', 1]],
				],

				
				// VIDEO
				'video' => [
                    'type'         => 'media',
                    'format'       => 'video',
					'title'=>Text::_('FLEX_ADDON_PLYR_VIDEO_URL'),
					'desc'=>Text::_('FLEX_ADDON_PLYR_VIDEO_URL_DESC'),
                    'std'          => ['src' => 'https://cdn.plyr.io/static/demo/View_From_A_Blue_Moon_Trailer-720p.mp4'],
                    'hide_preview' => true,
                    'depends'      => [['media', '=', '1']],
                ],

				'divider_mp4' => [
					'action' => 'separator',
				],
				
				'video_poster' => [
					'type'  => 'media',
					'title' => Text::_('FLEX_ADDON_PLYR_VIDEO_POSTER'),
					'desc' => Text::_('FLEX_ADDON_PLYR_VIDEO_POSTER_DESC'),
					'std'=>'https://cdn.plyr.io/static/demo/View_From_A_Blue_Moon_Trailer-HD.jpg',
					//'depends' => [['media', '=', 1]],
					'depends' => [['media', '=', '1']],
				],
				
				'captions' => [
					'type'=>'text', 
					'title'=>Text::_('FLEX_ADDON_PLYR_CAPTIONS'),
					'desc'=>Text::_('FLEX_ADDON_PLYR_CAPTIONS_DESC'),
					'placeholder'=>Text::_('FLEX_ADDON_PLYR_CAPTIONS_PLACEHOLDER'),
					'std'=>'https://cdn.plyr.io/static/demo/View_From_A_Blue_Moon_Trailer-HD.en.vtt',
					//'depends' => [['media', '=', 1]],
					'depends' => [['media', '=', '1']],
				],
				
				'captions_lang_label' => [
					'type'=>'text', 
					'title'=>Text::_('Language Label for Captions'),
					'desc'=>Text::_('Specifies the title of the text track. Here you can insert your desired language for captions. For example: “English” or “English captions”.'),
					'placeholder'=>Text::_('English'),
					'std'=>'',
					//'depends' => [['media', '=', 1]],
					'depends' => [['media', '=', '1']],
				],
				
				'captions_srclang' => [
					'type'=>'text', 
					'title'=>Text::_('Language for captions'),
					'desc'=>Text::_('Specifies the language of the track text data. For example “en” for English language.'),
					'placeholder'=>Text::_('en'),
					'std'=>'',
					//'depends' => [['media', '=', 1]],
					'depends' => [['media', '=', '1']],
				],
				
				
				// AUDIO
				'audio' => [
					'type' => 'media',
					'format' => 'audio',
					'title' => Text::_('FLEX_ADDON_PLYR_AUDIO_URL'),
					'desc' => Text::_('FLEX_ADDON_PLYR_AUDIO_URL_DESC'),
					//'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_MP3'),
					'hide_preview' => true,
					//'depends'=>array('media'=>'2'),
					'std' => 'https://cdn.plyr.io/static/demo/Kishi_Bashi_-_It_All_Began_With_a_Burst.mp3',
					'depends' => [['media', '=', '2']],
				],		
				
				// YouTube or Vimeo
                'youtube_vimeo_url' => [
                    'type'    => 'text',
                    'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_VIDEO_URL'),
                    'desc'    => Text::_('COM_SPPAGEBUILDER_ADDON_VIDEO_URL_DESC'),
					'placeholder'=>Text::_('FLEX_ADDON_PLYR_YOUTUBE_VIMEO_URL_PLACEHOLDER'),
                    //'std'=>'',
					'std' => 'https://www.youtube.com/watch?v=bTqVqk7FSmY',
                    //'depends' => [['media', '=', 3]],
					'depends' => [['media', '=', '3']],
                ],
            ],
        ],

        'player' => [
            'title' => Text::_('Settings'),
            'fields' => [

				'autoplay' => [
                    'type'    => 'checkbox',
 					'title'=>Text::_('FLEX_ADDON_PLYR_AUTOPLAY'),
					'desc'=>Text::_('FLEX_ADDON_PLYR_AUTOPLAY_DESC'),
					'values' => [
						1=>Text::_('JYES'),
						0=>Text::_('JNO'),
					],
                    'std' => 0,
                    //'depends' => [['media', '!=', '3']],
                ],
				
				'captions_toggle' => [
                    'type'   => 'checkbox',
					'title'=>Text::_('FLEX_ADDON_PLYR_TOGGLE_CAPTIONS'),
					'desc'=>Text::_('FLEX_ADDON_PLYR_TOGGLE_CAPTIONS_DESC'),
                    'values' => [
						1 => Text::_('JYES'),
						0 => Text::_('JNO'),
                    ],
                    'std' => 1,
					'depends' => [['media', '=', '1']],
                ],	
				
				'tooltips' => [
                    'type'   => 'checkbox',
					'title'=>Text::_('FLEX_ADDON_PLYR_TOOLTIPS'),
					'desc'=>Text::_('FLEX_ADDON_PLYR_TOOLTIPS_DESC'),
                    'values' => [
						1 => Text::_('JYES'),
						0 => Text::_('JNO'),
                    ],
                    'std' => 0,
                ],	
            ],
        ],

        'title' => [
            'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TITLE'),
            'fields' => [
                'title' => [
                    'type'  => 'text',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE'),
                    'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_DESC'),
                ],

                'heading_selector' => [
                    'type'   => 'headings',
                    'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS'),
                    'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_DESC'),
                    'std'   => 'h3',
                ],

                'title_typography' => [
                    'type'   => 'typography',
                    'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
                    'fallbacks'   => [
                        'font' => 'title_font_family',
                        'size' => 'title_fontsize',
                        'line_height' => 'title_lineheight',
                        'letter_spacing' => 'title_letterspace',
                        'uppercase' => 'title_font_style.uppercase',
                        'italic' => 'title_font_style.italic',
                        'underline' => 'title_font_style.underline',
                        'weight' => 'title_font_style.weight',
                    ],
                ],

                'title_text_color' => [
                    'type'   => 'color',
                    'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
                ],

                'title_margin_top' => [
                    'type'       => 'slider',
                    'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_TOP'),
                    'max'        => 400,
                    'responsive' => true,
                ],

                'title_margin_bottom' => [
                    'type'       => 'slider',
                    'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_BOTTOM'),
                    'max'        => 400,
                    'responsive' => true,
                ],
            ],
        ],
    ],
]);
