<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Layout\FileLayout;

class SppagebuilderAddonPricing extends SppagebuilderAddons {

	public function render() {
		
		$settings = $this->addon->settings;

		$class = (isset($settings->class) && $settings->class) ? $settings->class : '';
		$title = (isset($settings->title) && $settings->title) ? $settings->title : '';
		$heading_selector = (isset($settings->heading_selector) && $settings->heading_selector) ? $settings->heading_selector : 'h3';

		//Options
		$price = (isset($settings->price) && $settings->price) ? $settings->price : '';
		$currency = (isset($settings->currency) && $settings->currency) ? $settings->currency : '';
		$duration = (isset($settings->duration) && $settings->duration) ? $settings->duration : '';
		$pricing_content = (isset($settings->pricing_content) && $settings->pricing_content) ? $settings->pricing_content : '';
		$button_text = (isset($settings->button_text) && $settings->button_text) ? $settings->button_text : '';
		
		$button_classes = (isset($settings->button_size) && $settings->button_size) ? ' sppb-btn-' . $settings->button_size : '';
		$button_classes .= (isset($settings->button_type) && $settings->button_type) ? ' sppb-btn-' . $settings->button_type : '';
		$button_classes .= (isset($settings->button_shape) && $settings->button_shape) ? ' sppb-btn-' . $settings->button_shape: ' sppb-btn-rounded';
		$button_classes .= (isset($settings->button_appearance) && $settings->button_appearance) ? ' sppb-btn-' . $settings->button_appearance : '';
		$button_classes .= (isset($settings->button_block) && $settings->button_block) ? ' ' . $settings->button_block : '';
		$button_block = (isset($settings->button_block ) && $settings->button_block ) ? $settings->button_block  : '';
		// Pixeden icons
		$peicon_name = (isset($settings->peicon_name) && $settings->peicon_name) ? $settings->peicon_name : '';
		$button_icon = (isset($settings->button_icon) && $settings->button_icon) ? $settings->button_icon : '';
		$button_icon_position = (isset($settings->button_icon_position) && $settings->button_icon_position) ? $settings->button_icon_position: 'left';
		$button_position = (isset($settings->button_position) && $settings->button_position) ? $settings->button_position : '';
		
		$alignment = (isset($settings->alignment) && $settings->alignment) ? $settings->alignment : '';
		$border_radius = (isset($settings->border_radius) && $settings->border_radius) ? $settings->border_radius : '';
		//$background = (isset($settings->background) && $settings->background) ? $settings->background : '';
		$color = (isset($settings->color) && $settings->color) ? $settings->color : '';
		$header_color = (isset($settings->header_color) && $settings->header_color) ? $settings->header_color : '';
		$features_color = (isset($settings->features_color) && $settings->features_color) ? $settings->features_color : '';
		
		$featured = (isset($settings->featured) && $settings->featured) ? $settings->featured : '';
		
		// Button link
		list($button_url, $button_target) = AddonHelper::parseLink($settings, 'button_url', ['url' => 'button_url', 'new_tab' => 'button_target']);
		$button_attribs = (isset($button_target) && $button_target) ? ' rel="noopener noreferrer" ' . $button_target : '';
		$button_attribs .= (isset($button_url) && $button_url) ? ' href="' . $button_url . '"' : '';
		
		$style = '';
		$table_border_radius = '';
		$header_border_radius = '';
		$duration_span = '';
		$header_style = '';
		$content_color = '';
		$currency_span = '';
		
		if($header_color) $header_style .= 'color:' . $header_color . ';';
		if($color) $content_color .= ' style="color:' . $color . ';"';
		if($border_radius != '') {
			$table_border_radius = 'border-radius:'. $border_radius .'px;overflow:hidden;';
			$header_border_radius = 'border-radius:'. $border_radius .'px '.$border_radius .'px 0 0;';
			if($class == 'flex') {
				$button_block != '' ? $button_block_radius = ' style="border-radius:0 0 '.$border_radius.'px '.$border_radius.'px;"' : '';
			}
		}
		
		if($class == 'flex') {
			$button_block != '' ? $button_block_padding = ' style="padding:0;"' : $button_block_padding = '';
		}
		
		if($button_icon_position == 'left') {
			if ($peicon_name != '') {
				$button_text = ($peicon_name) ? '<i style="margin:-4px 5px 0 -3px;" class="pe ' . $peicon_name . ' pe-va"></i> ' . $button_text : $button_text;
			}else{
				$button_text = ($button_icon) ? '<i style="margin:-3px 5px 0 -3px;" class="fa ' . $button_icon . ' pe-va"></i> ' . $button_text : $button_text;
			}
		} else {
			if ($peicon_name != '') {
				$button_text = ($peicon_name) ? $button_text . ' <i style="margin:-4px -4px 0 5px;" class="pe ' . $peicon_name . '"></i>' : $button_text;
			}else{
				$button_text = ($button_icon) ? $button_text . ' <i style="margin:-3px -3px 0 5px;" class="fa ' . $button_icon . '"></i>' : $button_text;
			}
		}

		$button_output = ($button_text) ? '<a' . $button_attribs . ' id="btn-'. $this->addon->id .'" class="sppb-btn' . $button_classes . '">' . $button_text . '</a>' : '';

		//Output
		$output  = '<div class="sppb-addon sppb-addon-pricing-table '. $alignment .' '. $class .'">';
		
		$output .= '<div style="'. $table_border_radius .'" class="sppb-pricing-box '. $featured .'">';
		$output .= '<div style="'. $header_border_radius . $header_style .'" class="sppb-pricing-header">';
	
		if($title) $output .= '<h1 class="sppb-pricing-title responsive">' . $title . '</h1>';
		
		if($currency) $currency_span = '<span class="sppb-pricing-currency">' . $currency . '</span>';
		if($duration) $duration_span = '<span class="sppb-pricing-duration">' . $duration . '</span>';
		if($price) $output .= '<h2 class="sppb-pricing-price">' . $currency_span . $price . $duration_span . '</h2>';
	
		$output .= '</div>';

		if($pricing_content) {
			$output .= '<div class="sppb-pricing-features">';
			$output .= '<ul'.$content_color.'>';

			$features = explode("\n", $pricing_content);

			foreach ($features as $feature) {
				$output .= '<li>' . $feature . '</li>';
			}

			$output .= '</ul>';
			$output .= '</div>';
		}

		$output .= '<div class="sppb-pricing-footer">';
		$output .= $button_output;
		$output .= '</div>';
		$output .= '</div>';
		$output .= '</div>';

		return $output;
	}

	public function css() {
		$settings = $this->addon->settings;
		$addon_id = '#sppb-addon-' . $this->addon->id;
		$cssHelper = new CSSHelper($addon_id);
		
		$css = '';

		$backgroundStyle = $cssHelper->generateStyle('.sppb-pricing-box', $settings, ['background' => ['background-color', 'border-color']], '', false);
		
		$priceTypographyStyle = $cssHelper->typography('.sppb-pricing-title', $settings, 'title_typography', ['font' => 'title_font_family', 'size' => 'title_fontsize', 'line_height' => 'title_lineheight', 'letter_spacing' => 'title_letterspace', 'uppercase' => 'title_font_style.uppercase', 'italic' => 'title_font_style.italic', 'underline' => 'title_font_style.underline', 'weight' => 'title_font_style.weight']);
		
		$priceFontStyle = $cssHelper->typography('.sppb-pricing-price', $settings, 'price_typography', ['font' => 'price_font_family', 'size' => 'price_font_size', 'weight' => 'price_font_weight']);
		
		$contentFontStyle = $cssHelper->typography('.sppb-pricing-features', $settings, 'pricing_content_typography', ['font' => 'pricing_content_font_family', 'size' => 'pricing_content_font_size', 'weight' => 'pricing_content_font_weight']);
		
		// Button css
		$layoutPath = JPATH_ROOT . '/components/com_sppagebuilder/layouts';
		$buttonLayout = new FileLayout('addon.css.button', $layoutPath);
		$css .= $buttonLayout->render(array('addon_id' => $addon_id, 'options' => $settings, 'id' => 'btn-' . $this->addon->id));
		
		$css .= $priceTypographyStyle;
		$css .= $priceFontStyle;
		$css .= $contentFontStyle;
		$css .= $backgroundStyle;

		return $css;
	}
}
