<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;
use Joomla\CMS\Language\Text;

SpAddonsConfig::addonConfig(
	array(
		'type'=>'repeatable',
		'addon_name'=>'sp_slick_carousel',
		'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL'),
		'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_DESC'),
		'category'=>'Flex',
		'attr'=>array(
			'general' => array(

				'admin_label'=>array(
					'type'=>'text',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL_DESC'),
					'std'=> ''
				),

			'separator1'=>array(
				'type'=>'separator', 
				'title'=>Text::_('FLEX_ADDON_SETTINGS')
				),
			'infiniteloop'=>array(
				'type'=>'checkbox', 
				'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_LOOP'),
				'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_LOOP_DESC'),
				'values'=>array(
					1 => Text::_('JYES'),
					0 => Text::_('JNO'),
				),
				'std'=>1,
			    ),
			'lazyloading'=>array(
				'type'=>'checkbox', 
				'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_LAZYLOAD'),
				'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_LAZYLOAD_DESC'),
				'values'=>array(
					1 => Text::_('JYES'),
					0 => Text::_('JNO'),
				),
				'std'=>1,
			    ),

			'slidestoshow' => [
				'type' => 'slider',
				'title' => Text::_('FLEX_ADDON_SLICK_CAROUSEL_SLIDES_TO_SHOW'),
				'desc' => Text::_('FLEX_ADDON_SLICK_CAROUSEL_SLIDES_TO_SHOW_DESC'),
				'min' => 1,
				'max' => 12,
				'std' => 1,
			],
			
			'slidestoscroll' => [
				'type' => 'slider',
				'title' => Text::_('FLEX_ADDON_SLICK_CAROUSEL_SLIDES_TO_SCROLL'),
				'desc' => Text::_('FLEX_ADDON_SLICK_CAROUSEL_SLIDES_TO_SCROLL_DESC'),
				'min' => 1,
				'max' => 12,
				'std' => 1,
			],
				
			'spacing' => [
				'type' => 'slider',
				'title' => Text::_('FLEX_ADDON_SLICK_CAROUSEL_SPACE_BETWEEN_IMG'),
				'desc' => Text::_('FLEX_ADDON_SLICK_CAROUSEL_SPACE_BETWEEN_IMG_DESC'),
				'max' => 50,
				'std' => 0,
				//'responsive'  => true,
			],

			'fade_effect'=>array(
				'type'=>'checkbox', 
				'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_FADE_EFFECT'),
				'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_FADE_EFFECT_DESC'),
				'values'=>array(
					1 => Text::_('JYES'),
					0 => Text::_('JNO'),
				),
				'std'=>0,
				'depends'=>array(array('slidestoshow', '=', '1')),
			 ),
			'autoplay'=>array(
				'type'=>'checkbox', 
				'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_AUTOPLAY'),
				'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_AUTOPLAY_DESC'),
				'values'=>array(
					1 => Text::_('JYES'),
					0 => Text::_('JNO'),
				),
				'std'=>1,
			),
			'autoplay_pause_onhover'=>array(
				'type'=>'checkbox', 
				'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_AUTOPLAY_STOP_ON_HOVER'),
				'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_AUTOPLAY_STOP_ON_HOVER_DESC'),
				'values'=>array(
					1 => Text::_('JYES'),
					0 => Text::_('JNO'),
				),
				'std'=>1,
			),
			'autoplay_pause_onfocus'=>array(
				'type'=>'checkbox', 
				'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_AUTOPLAY_STOP_ON_FOCUS'),
				'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_AUTOPLAY_STOP_ON_FOCUS_DESC'),
				'values'=>array(
					1 => Text::_('JYES'),
					0 => Text::_('JNO'),
				),
				'std'=>1,
			),
			'autoplay_interval'=>array(
				'type'=>'slider', 
				'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_AUTOPLAY_INTERVAL'),
				'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_AUTOPLAY_INTERVAL_DESC'),
				//'placeholder'=>5000,
				'min' => 200,
				'max' => 10000,
				'std' => 5000,
				'step' => 200,
				'depends'=>array(array('autoplay', '=', '1')),
				),	
			
			'speed'=>array(
				'type'=>'slider', 
				'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_AUTOPLAY_SPEED'),
				'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_AUTOPLAY_SPEED_DESC'),
				'min' => 100,
				'max' => 3000,
				'std' => 500,
				'step' => 100,
				),

			'arrows'=>array(
				'type'=>'checkbox', 
				'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_ARROWS'),
				'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_ARROWS_DESC'),
				'values'=>array(
					1=>Text::_('JYES'),
					0=>Text::_('JNO'),
				),
				'std'=>1,
			    ),
				
				
			'arrows_size'=>array(
				'type' => 'slider', 
				'title' => Text::_('FLEX_ADDON_SLICK_CAROUSEL_ARROWS_SIZE'),
				'desc' => Text::_('FLEX_ADDON_SLICK_CAROUSEL_ARROWS_SIZE_DESC'),
				'max' => 100,
				'std' => 44,
				'depends'=>array(array('arrows', '=', '1')),
				),
			'arrows_color'=>array(
				'type'=>'color',
				'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_ARROWS_COLOR'),
				'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_ARROWS_COLOR_DESC'),
				'depends'=>array(array('arrows', '=', '1')),
				),
			'arrows_background_color'=>array(
				'type'=>'color',
				'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_ARROWS_BACKGROUND_COLOR'),
				'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_ARROWS_BACKGROUND_COLOR_DESC'),
				'depends'=>array(array('arrows', '=', '1')),
				),
			'arrows_class'=>array(
				'type'=>'text', 
				'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_ARROWS_CLASS'),
				'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_ARROWS_CLASS_DESC'),
				'std'=>'',
				'depends'=>array(array('arrows', '=', '1')),
				),		
			'counter'=>array(
				'type'=>'checkbox', 
				'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_COUNTER'),
				'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_COUNTER_DESC'),
				'values'=>array(
					1=>Text::_('JYES'),
					0=>Text::_('JNO'),
				),
				'std'=>0,
				'depends'=>array(array('arrows', '=', '1')),
				),
			'counter_color'=>array(
				'type'=>'color',
				'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_COUNTER_COLOR'),
				'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_COUNTER_COLOR_DESC'),
				'depends'=>array(
						array('arrows', '=', '1'),
						array('counter', '=', '1')
					),
				),
			'dots'=>array(
				'type'=>'checkbox', 
				'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_DOTS'),
				'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_DOTS_DESC'),
				'values'=>array(
					1=>Text::_('JYES'),
					0=>Text::_('JNO'),
				),
				'std'=>1,
			    ),
			'dots_color'=>array(
				'type'=>'color',
				'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_DOTS_COLOR'),
				'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_DOTS_COLOR_DESC'),
				'depends'=>array(array('dots', '=', '1')),
				),
			'autoheight'=>array(
				'type'=>'checkbox', 
				'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_AUTOHEIGHT'),
				'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_AUTOHEIGHT_DESC'),
				'values'=>array(
					1=>Text::_('JYES'),
					0=>Text::_('JNO'),
				),
				'std'=>1,
			    ),
				
			'separatorRTL'=>array(
				'type'=>'separator', 
				'title'=>Text::_('FLEX_ADDON_RTL_DIR_SEPARATOR')
				),
			'rtl_support'=>array(
				'type'=>'checkbox', 
				'title'=>Text::_('FLEX_ADDON_RTL_DIR'),
				'desc'=>Text::_('FLEX_ADDON_RTL_DIR_DESC'),
				'values'=>array(
					1=>Text::_('JYES'),
					0=>Text::_('JNO'),
				),
				'std'=>0,
			 ),
					
			'separator2'=>array(
				'type'=>'separator', 
				'title'=>Text::_('FLEX_ADDON_BREAKPOINTS')
				),	
	
			'breakpoint1' => [
				'type' => 'slider',
				'title'=>Text::_('FLEX_ADDON_BREAKPOINTS_MEDIUM_DEVICES'),
				'desc'=>Text::_('FLEX_ADDON_BREAKPOINTS_MEDIUM_DEVICES_DESC'),
				'max' => 992,
				'std' => 992,
				'info' => 'px',
			],
	
			'slidestoshow_break1' => [
				'type' => 'slider',
				'title' => Text::_('FLEX_ADDON_SLICK_CAROUSEL_SLIDES_TO_SHOW'),
				'desc' => Text::_('FLEX_ADDON_BREAKPOINTS_MEDIUM_DEVICES_SLIDES_TO_SHOW'),
				'min' => 1,
				'max' => 12,
				'std' => 3,
			],
		
			'breakpoint2' => [
				'type' => 'slider',
				'title' => Text::_('FLEX_ADDON_BREAKPOINTS_SMALL_DEVICES'),
				'desc' => Text::_('FLEX_ADDON_BREAKPOINTS_SMALL_DEVICES_DESC'),
				'max' => 768,
				'std' => 768,
				'info' => 'px',
			],

			'slidestoshow_break2' => [
				'type' => 'slider',
				'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_SLIDES_TO_SHOW'),
				'desc'=>Text::_('FLEX_ADDON_BREAKPOINTS_SMALL_DEVICES_SLIDES_TO_SHOW'),
				'min' => 1,
				'max' => 12,
				'std' => 2,
			],
	
			'breakpoint3' => [
				'type' => 'slider',
				'title'=>Text::_('FLEX_ADDON_BREAKPOINTS_EXTRASMALL_DEVICES'),
				'desc'=>Text::_('FLEX_ADDON_BREAKPOINTS_EXTRASMALL_DEVICES_DESC'),
				'max' => 480,
				'std' => 480,
				'info' => 'px',
			],
		
			'slidestoshow_break3' => [
				'type' => 'slider',
				'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_SLIDES_TO_SHOW'),
				'desc'=>Text::_('FLEX_ADDON_BREAKPOINTS_EXTRASMALL_DEVICES_SLIDES_TO_SHOW'),
				'min' => 1,
				'max' => 12,
				'std' => 1,
			],
				
			'separator3'=>array(
				'type'=>'separator', 
				'title'=>Text::_('FLEX_ADDON_TITLE')
				),
				
				
			'title' => [
				'type'  => 'text',
				'title' => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE'),
				'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_DESC'),
			],

			'heading_selector' => [
				'type'   => 'headings',
				'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS'),
				'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_DESC'),
				'std'   => 'h3',
			],

			'title_typography' => [
				'type'     => 'typography',
				'title'  	=> Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
				'fallbacks'   => [
					'font' => 'title_font_family',
					'size' => 'title_fontsize',
					'line_height' => 'title_lineheight',
					'letter_spacing' => 'title_letterspace',
					'uppercase' => 'title_font_style.uppercase',
					'italic' => 'title_font_style.italic',
					'underline' => 'title_font_style.underline',
					'weight' => 'title_font_style.weight',
				],
			],

			'title_text_color' => [
				'type'   => 'color',
				'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
			],

			'title_margin_separator' => [
				'type' => 'separator',
			],

			'title_margin_top' => [
				'type'       => 'slider',
				'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_TOP'),
				'max'        => 400,
				'responsive' => true,
			],

			'title_margin_bottom' => [
				'type'       => 'slider',
				'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_BOTTOM'),
				'max'        => 400,
				'responsive' => true,
			],
				
			'class_separator' => [
				'type' => 'separator',
				'title' => Text::_(''),
			],
			
			'class'=>array(
				'type'=>'text', 
				'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
				'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
				'std'=>''
				),
			'separator4'=>array(
				'type'=>'separator', 
				'title'=>Text::_('FLEX_ADDON_IMAGES')
				),

				// Repeatable Items
				'sp_slick_carousel_item'=>array(
					'type'	=> 'repeatable',
					'title'=> Text::_('COM_SPPAGEBUILDER_ADDON_CAROUSEL_ITEMS'),
					//'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_ITEMS'),
					'std'=> array(
						array(
							'thumb' => 'https://source.unsplash.com/aAd6zv2rdBI/900x420',
							'title' => 'Slide #1',
						),
						array(
							'thumb' => 'https://source.unsplash.com/XJJIJ_DJWdE/900x420',
							'title' => 'Slide #2',
						),
						array(
							'thumb' => 'https://source.unsplash.com/B5drkS_Z5RM/900x420',
							'title' => 'Slide #3',
						)
					),
					'attr'=>  array(
						'title'=>array(
							'type'=>'text',
							'title'=>Text::_('COM_SPPAGEBUILDER_ADMIN_LABEL'),
							'desc'=>Text::_('COM_SPPAGEBUILDER_ADMIN_LABEL_DESC'),
							'std'=>'Slider Item Title',
						),
						
						'thumb'=>array(
							'type'=>'media',
							'title'=>Text::_('FLEX_ADDON_IMAGE'),
							'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_IMAGE'),
							'format' => 'image',
							'std'=> array(
								'src' => 'https://source.unsplash.com/aAd6zv2rdBI/900x420',
							),
						),
						
						'thumb_separator'=>array(
							'type' => 'separator',
						),
						
						'thumb_url'=>array(
							'type'=>'link',
							'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_THUMB_URL'),
							'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_THUMB_URL_DESC'),
						),
						
						'alt_text_separator'=>array(
							'type' => 'separator',
						),

						'alt_text'=>array(
							'type'=>'text',
							'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_ALT_TEXT'),
							'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_ALT_TEXT_DESC'),
							'std'=>'Image',
							'depends'=>array(
								array('thumb', '!=', ''),
							),
						),
						
						'slider_content_separator'=>array(
							'type' => 'separator',
							'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT'),
						),
						
						'item_title'=>array(
							'type'=>'text', 
							'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_ITEM_TITLE'),
							'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_ITEM_TITLE_DESC'),
							'std'=>''
						),
						'description'=>array(
							'type'=>'editor', 
							'title'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_ITEM_DESCRIPTION'),
							'desc'=>Text::_('FLEX_ADDON_SLICK_CAROUSEL_ITEM_DESCRIPTION_DESC'),
							'std'=> ''
						),
					),
				),
			),
		),
	)
);
