<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

SpAddonsConfig::addonConfig([
	'type'       => 'repeatable',
	'addon_name'=>'sp_testimonialflex',
	'title'=>Text::_('Testimonials Flex'),
	'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_DESC'),
	'category'   => 'Flex',
	'settings' => [
		'content' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT'),
			'fields' => [
				
				// Repeatable Items
				'sp_testimonialflex_item' => [
					'type' => 'repeatable',
					'title'=> Text::_('Testimonials'),
					'std'=> array(
						array(
							'avatar' => 'https://source.unsplash.com/IF9TK5Uy-KI/280x400',
							'title' => 'Rose Poppins',
							'message' => 'Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor.',
							'avatar_style'=>'sppb-img-circle',
							'avatar_position' => 'left',
						),
						array(
							'avatar' => 'https://source.unsplash.com/eXYuC9k6P_c/280x380',
							'title' => 'Johanna Smile',
							'message' => 'Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor.',
							'avatar_position' => 'right',
						),
						array(
							'avatar' => 'https://source.unsplash.com/XDYlOQUrfD8/280x380',
							'title' => 'Marry Christmas',
							'message' => 'Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor.',
							'avatar_style'=>'sppb-img-rounded',
							'avatar_position' => 'left',
						)
					),
					
					'attr' => [
						'title' => [
							'type' => 'text',
							'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_NAME'),
							'std' => 'John Doe',
						],
						
						'avatar' => [
							'type' => 'media',
							'title' => Text::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_CLIENT_IMAGE'),
							'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_CLIENT_IMAGE_DESC'),
							'std' => array(
								'src'=>'https://source.unsplash.com/IF9TK5Uy-KI/280x400',
							),
						],

						'avatar_style' => [
							'type'=>'select', 
							'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_AVATAR_STYLE'),
							'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_AVATAR_STYLE_DESC'),
							'values' => [
								''=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_STANDARD'),
								'sppb-img-rounded'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_ROUNDED'),
								'sppb-img-circle'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_CIRCLE'),
							],
							'std'=>'sppb-img-rounded',
						],
						
						
						'avatar_position' => [
							'type'=>'radio', 
							'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_CLIENT_AVATAR_POSITION'),
							'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_CLIENT_AVATAR_POSITION_DESC'),
							'values' =>array(
								'left'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_LEFT'),
								'center'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_CENTER'),
								'right'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_RIGHT'),
								),
							'std' => 'left'
						],
						
						'url'=> [
							'type'   => 'link',
							'format' => 'attachment',
							'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_LINK'),
							//'std'    => '',
						],
						
						'short_text_link' => [
							'type' => 'text',
							'title' => Text::_('Custom text for Link (URL)'),
							'desc' => Text::_('If the URL is long, then you can override it with custom (short) text to display for link (URL)'),
							'placeholder' => 'Short link (text) to display for link (URL)',
							'depends' => [['url', '!=', '']],
						],

						'message' => [
							'type' => 'editor',
							'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_MESSAGE'),
							'std' => 'Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.'
						],
					],
				],
			],
		],

		'avatar' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_AVATAR'),
			'fields' => [
				'avatar_width' => [
					'type'       => 'slider',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_CLIENT_AVATAR_WIDTH'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_CLIENT_AVATAR_WIDTH_DESC'),
					'std'        => 120,
					'min'        => 32,
					'max'        => 320,
					'responsive' => true,
				],
			
				'class' => [
					'type' => 'text',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
					'std' => 'flex'
				],
			],
		],

		'carousel_options' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_OPTIONS'),
			'fields' => [
				'autoplay' => [
					'type'   => 'checkbox',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_AUTOPLAY'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_AUTOPLAY_DESC'),
					'values' => [
						1 => Text::_('JYES'),
						0 => Text::_('JNO'),
					],
					'std' => 1,
				],

				'autoplay_interval' => [
					'type' => 'slider',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_AUTOPLAY_INTERVAL'),
					'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_AUTOPLAY_INTERVAL_DESC'),
					'placeholder' => 5000,
					'max' => 15000,
					'step' => 500,
					'std' => 5000,
					'depends' => [['autoplay', '=', 1]]
				],

				'arrow_controls_separator' => [
					'type' => 'separator',
				],

				'arrows' => [
					'type'  => 'checkbox',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_SHOW_ARROWS'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_SHOW_ARROWS_DESC'),
					'std'   => 0,
				],
			],
		],
	],
]);
