<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

class SppagebuilderAddonTestimonialflex extends SppagebuilderAddons {

	public function render() {
		
		$settings = $this->addon->settings;
		
		// Include template's params
		$tpl_params 	= Factory::getApplication()->getTemplate(true)->params;
		$has_lazyload = $tpl_params->get('lazyload', 1);

		$class = (isset($settings->class) && $settings->class) ? $settings->class : '';
		$style = (isset($settings->style) && $settings->style) ? $settings->style : '';

		// Options
		$autoplay = (isset($settings->autoplay) && $settings->autoplay) ? 1 : 0;
		$autoplay_interval = (isset($settings->autoplay_interval) && $settings->autoplay_interval) ? ((int) $settings->autoplay_interval ) : 5000;
		$carousel_autoplay = ($autoplay != 0) ? ' data-sppb-ride="sppb-carousel"' : '';

		if ($autoplay == 0)
		{
			$autoplay_interval = 'false';
		}
	
		$arrows = (isset($settings->arrows) && $settings->arrows) ? $settings->arrows : '';
		$avatar_size = (isset($settings->avatar_width) && $settings->avatar_width) ? $settings->avatar_width : '120';
		$carousel_autoplay_interval = ($autoplay != 0) ? ' data-interval="'. $autoplay_interval .'"' : ' data-interval="0"';
		
		// Carousel starts
		$output  = '<div id="sppb-carousel-' . $this->addon->id . '" class="sppb-carousel sppb-testimonial-flex sppb-slide ' . $class . ' sppb-text-center" ' . $carousel_autoplay . $carousel_autoplay_interval .'">';
		
		$output .= '<div class="sppb-carousel-inner">';
		
		if (isset($settings->sp_testimonialflex_item) && is_array($settings->sp_testimonialflex_item))
		{
			foreach ($settings->sp_testimonialflex_item as $key => $value) {

				$avatar = (isset($value->avatar) && $value->avatar) ? $value->avatar : '';
				$avatar_src = isset($avatar->src) ? $avatar->src : $avatar;

				$message = (isset($value->message) && $value->message) ? $value->message : '';
				$avatar_position = (isset($value->avatar_position) && $value->avatar_position) ? $value->avatar_position : 'left';
				$avatar_style = (isset($value->avatar_style) && $value->avatar_style) ? $value->avatar_style : '';
				$title = (isset($value->title) && $value->title) ? $value->title : '';
				
				// Short (custom) text to display for URL (link)
				$short_text_link = (isset($value->short_text_link) && $value->short_text_link) ? $value->short_text_link : '';
	
				$personLink = '';

				if (isset($value->url))
				{
					$personLink = EditorUtils::stringifyLinkItem($value->url);
				}
				
				// Active 
				$output   .= '<div class="sppb-item ' . (($key == 0) ? ' active' : '') .'">';

				$name = (isset($value->title) && $value->title) ? '<h4 class="pro-client-name my-3">'. $value->title .'</h4>' : '';
				
				// Link
				if (!empty($personLink->url))
				{
					if ($short_text_link != '') {
						$name .= '<a href="'. $personLink->url .'" '. $personLink->attributes .'><em class="pro-client-url my-2">' . $short_text_link . '</em></a>';
					} else {
						$name .= '<a href="'. $personLink->url .'" '. $personLink->attributes .'><em class="pro-client-url my-2">' . $personLink->url . '</em></a>';
					}
				}
				
				$output .= '<div class="sppb-media flex">';
				$output .= '<div class="pull-'. $avatar_position .'">';

				if($avatar_src) {
					//Lazyload image
					if(strpos($avatar_src, "http://") !== false || strpos($avatar_src, "https://") !== false){
						$avatar_src = $avatar_src;
					} else {
						$avatar_src = Uri::base(true) . '/' . $avatar_src;
					}

					if ($avatar_style == 'sppb-img-circle') {
						$avatar_style_css = ' style="width:' . $avatar_size . 'px;height:'. $avatar_size .'px;"';
					} else {
						$avatar_style_css = ' style="width:' . $avatar_size . 'px;height:auto;"';
					}

					if($has_lazyload) {
						$output .= '<img'. $avatar_style_css .' class="lazyload sppb-img-responsive sppb-avatar '. $avatar_style .'" src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==" data-src="'. $avatar_src .'" alt="'. $title .'">';
					} else {
						$output .= '<img src="'.$avatar_src.'" class="sppb-img-responsive sppb-avatar '. $avatar_style .'" alt="'.$title.'">';	
					}
				}
				$output .= '</div>';

					$output .= '<div style="text-align:'.$avatar_position.'" class="sppb-media-body">';
					if($class == 'flex') $output .= '<i class="fas fa-solid fa-quote-left"></i>';
					$output .= $message;
					if($class == 'flex') $output .= '<i class="fas fa-solid fa-quote-right"></i>';
					if($title) $output .= '<div class="sppb-testimonial-client">' . $name . '</div>';
					$output .= '</div>';

				$output .= '</div>';
				$output  .= '</div>';
			}
		}
		
		$output	.= '</div>';
		
		if($arrows) {
			$output	.= '<a href="#sppb-carousel-' . $this->addon->id . '" class="left sppb-carousel-control" role="button" data-slide="prev"><i class="fa-solid fa-angle-left pt-1"></i></a>';
			$output	.= '<a href="#sppb-carousel-' . $this->addon->id . '" class="right sppb-carousel-control" role="button" data-slide="next"><i class="fa-solid fa-angle-right pt-1"></i></a>';
		}

		$output .= '</div>';

		return $output;

	}

	public function css() {
		$settings = $this->addon->settings;
		$avatar_size = (isset($settings->avatar_width) && $settings->avatar_width) ? $settings->avatar_width : '120';
		$addon_id = '#sppb-addon-' . $this->addon->id;
		$css = '';
		
		foreach ($settings->sp_testimonialflex_item as $key => $value) {
			
			$avatar = (isset($value->avatar) && $value->avatar) ? $value->avatar : '';
			$avatar_style = (isset($value->avatar_style) && $value->avatar_style) ? $value->avatar_style : '';
			
			// Image circle
			if (($avatar_style) == 'sppb-img-circle') {
				$css .= $addon_id.' .sppb-carousel-inner .sppb-media img.sppb-img-circle {width:'. $avatar_size .'px;height:'. $avatar_size .'px;object-fit:cover;}';
			} else {
				$css .= $addon_id.' .sppb-carousel-inner .sppb-media img.sppb-img-circle {width:'. $avatar_size .'px;height:'. $avatar_size .'px;object-fit:cover;}';
			}
		}
		return $css;
	}


	public static function getTemplate(){
		
		$lodash = new Lodash('#sppb-addon-{{ data.id }}');
		/*
			let autoplay_interval = data.autoplay_interval ? data.autoplay_interval : 5000;
			if (data.autoplay==0)
			{
				autoplay_interval = "false";
			}
			let autoplay = data.autoplay ? \'data-sppb-ride="sppb-carousel"\' : "";
			var avatar_size = (data.avatar_width) ? data.avatar_width : 120;
		*/
		$output = '
			<#
			let autoplay_interval = (data.autoplay_interval) ? (data.autoplay_interval) : 5000;
			let autoplay = (data.autoplay != 0) ? \' data-sppb-ride="sppb-carousel"\' : "";
			let avatar_size = data.avatar_width || 120;
			#>
			<style type="text/css">';
		
		// Image
        $output .= $lodash->unit('width', '.sppb-avatar', 'data.avatar_width', 'px');
		// Image "circle":
		$output .= $lodash->unit('width', '.sppb-img-circle', 'data.avatar_width', 'px');
		$output .= $lodash->unit('height', '.sppb-img-circle', 'data.avatar_width', 'px');

		$output .= '</style>';
		
		$output .= '<div id="sppb-carousel-{{ data.id }}" class="sppb-carousel sppb-testimonial-flex sppb-slide {{ data.class }} sppb-text-center" data-interval="{{ autoplay_interval }}" {{{ autoplay }}}>
			<div class="sppb-carousel-inner">
			
				<# if(_.isArray(data.sp_testimonialflex_item)){ _.each(data.sp_testimonialflex_item, function(testimonial_item, key){
				
					const profileLink = testimonial_item.url;
					const isUrlObject = _.isObject(profileLink) && ( !!profileLink?.url || !!profileLink?.page || !!profileLink?.menu);
					const isUrlString = _.isString(profileLink) && profileLink !== "";

					let target;
					let profileHref;
					let rel;

					if(isUrlObject || isUrlString){
						const urlObj = profileLink?.url ? profileLink : window.getSiteUrl(profileLink);
						const {url, new_tab, nofollow, noopener, noreferrer, type} = urlObj;

						const profileUrl = (type === "url" && url) || (type === "menu" && urlObj.menu) || ( (type === "page" && !!urlObj.page)  && "index.php/component/sppagebuilder/index.php?option=com_sppagebuilder&view=page&id=" + urlObj.page) || "";
						target = new_tab ? `target="_blank"` : "";

						let relData="";
						relData += nofollow ? "nofollow" : "";
						relData += noopener ? " noopener" : "";
						relData += noreferrer ? " noreferrer" : "";

						rel = `rel="${relData}"`;

						profileHref = profileUrl ? `${profileUrl}`: "";
					}
			
					let content = "";
					
					if(!!profileHref){
						content += `<a ${profileHref} ${target} ${rel} >`;
					}
					content += `${profileHref}`;
					if(!!profileHref){
						content += `</a>`;
					}
				
					var avatarSrc = {}
						if (typeof testimonial_item.avatar !== "undefined" && typeof testimonial_item.avatar.src !== "undefined") {
							avatarSrc = testimonial_item.avatar
						} else {
							avatarSrc = {src: testimonial_item.avatar}
						}

						let activeClass = ""
						if (key == 0) {
							activeClass = " active"
						} else {
							activeClass = ""
						}
					#>
						<div class="sppb-item {{ activeClass }}">
							<div class="sppb-media flex">
								<div class="pull-{{ testimonial_item.avatar_position }}">
									<# if(avatarSrc.src && avatarSrc.src.indexOf("https://") == -1 && avatarSrc.src.indexOf("http://") == -1){ #>
										<img<# if(testimonial_item.avatar_style == "sppb-img-circle") { #> style="width:{{ avatar_size }}px;height:{{ avatar_size }}px;object-fit:cover;border-radius:{{ avatar_size }}px;"<# } else { #> style="width:{{ avatar_size }}px;height:auto;"<# } #> class="sppb-img-responsive sppb-avatar {{ testimonial_item.avatar_style }}" src=\'{{ pagebuilder_base + avatarSrc.src }}\' alt="{{ testimonial_item.title }}">
									<# } else if(avatarSrc.src){ #>
										<img<# if(testimonial_item.avatar_style == "sppb-img-circle") { #> style="width:{{ avatar_size }}px;height:{{ avatar_size }}px;object-fit:cover;border-radius:{{ avatar_size }}px;"<# } else { #> style="width:{{ avatar_size }}px;height:auto;"<# } #> class="sppb-img-responsive sppb-avatar {{ testimonial_item.avatar_style }}" src=\'{{ avatarSrc.src }}\' alt="{{ testimonial_item.title }}">
									<# } #>	
								</div>
								<div style="text-align:{{ testimonial_item.avatar_position }}" class="sppb-media-body">
									<# if(data.class == "flex") { #>
										<i class="fas fa-solid fa-quote-left"></i>
									<# } #>
									{{ testimonial_item.message }}
									<# if(data.class == "flex") { #>
										<i class="fas fa-solid fa-quote-right"></i>
									<# } #>
									<div class="sppb-testimonial-client">
										<h4 class="pro-client-name my-3">{{ testimonial_item.title }}</h4>
										<# if(profileHref){ #>
											<# if(testimonial_item.short_text_link != ""){ #>
												<a href={{profileHref}} {{target}} {{rel}} ><em class="pro-client-url my-2">{{testimonial_item.short_text_link}}</em></a>
											<# } else { #>
												<a href={{profileHref}} {{target}} {{rel}} ><em class="pro-client-url my-2">{{profileHref}}</em></a>
											<# } #>
										<# } #>
									</div>
								</div>	
							</div>
						</div>
					<# })
                } #>
				</div>
				<# if(data.arrows) { #>
					<a href="#sppb-carousel-{{ data.id }}" class="left sppb-carousel-control" role="button" data-slide="prev"><i class="fas fa-angle-left"></i></a>
					<a href="#sppb-carousel-{{ data.id }}" class="right sppb-carousel-control" role="button" data-slide="next"><i class="fas fa-angle-right"></i></a>
				<# } #>
			</div>
			';
		return $output;
	}

}
