<?php
/**
 * Flex @package Helix Framework
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2023 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

defined('_JEXEC') or die;

use Joomla\CMS\Form\FormField;
use Joomla\CMS\HTML\HTMLHelper;

class JFormFieldIcon extends FormField
{

	protected $type = 'Icon';

	public function getInput() {

		$icons = $this->getIconsList();
		
		$arr = array();
		$arr[] = HTMLHelper::_('select.option', '', '' );

		foreach ($icons as $value) {
			//$arr[] = HTMLHelper::_('select.option', $value, preg_replace('@^fa[sbr]\s+fa-@', '', $value));
			//$arr[] = HTMLHelper::_('select.option', $value, str_replace('fa-', '', $value) );
			//$fastyle = str_replace(array("fa-solid", "fa-brands", "fa-regular"), 'GAGA', $value);
			$fastyle = array("fa-solid", "fa-brands", "fa-regular", "fa-");
			$arr[] = HTMLHelper::_('select.option', $value, str_replace($fastyle, '', $value) );
		}				 
		return HTMLHelper::_('select.genericlist', $arr, $this->name, 'class="form-select"', 'value', 'text', $this->value);

	}

	/*Icons List (Font Awesome 6.5.1*/
	private static function getIconsList()
	{
		return array(

			'fa-solid fa-0 (solid)',
			'fa-solid fa-1 (solid)',
			'fa-solid fa-2 (solid)',
			'fa-solid fa-3 (solid)',
			'fa-solid fa-4 (solid)',
			'fa-solid fa-5 (solid)',
			'fa-solid fa-6 (solid)',
			'fa-solid fa-7 (solid)',
			'fa-solid fa-8 (solid)',
			'fa-solid fa-9 (solid)',
			'fa-brands fa-42-group (brands)',
			'fa-brands fa-500px (brands)',
			'fa-solid fa-a (solid)',
			'fa-brands fa-accessible-icon (brands)',
			'fa-brands fa-accusoft (brands)',
			'fa-solid fa-address-book (solid)',
			'fa-regular fa-address-book (regular)',
			'fa-solid fa-address-card (solid)',
			'fa-regular fa-address-card (regular)',
			'fa-brands fa-adn (brands)',
			'fa-brands fa-adversal (brands)',
			'fa-brands fa-affiliatetheme (brands)',
			'fa-brands fa-airbnb (brands)',
			'fa-brands fa-algolia (brands)',
			'fa-solid fa-align-center (solid)',
			'fa-solid fa-align-justify (solid)',
			'fa-solid fa-align-left (solid)',
			'fa-solid fa-align-right (solid)',
			'fa-brands fa-alipay (brands)',
			'fa-brands fa-amazon (brands)',
			'fa-brands fa-amazon-pay (brands)',
			'fa-brands fa-amilia (brands)',
			'fa-solid fa-anchor (solid)',
			'fa-solid fa-anchor-circle-check (solid)',
			'fa-solid fa-anchor-circle-exclamation (solid)',
			'fa-solid fa-anchor-circle-xmark (solid)',
			'fa-solid fa-anchor-lock (solid)',
			'fa-brands fa-android (brands)',
			'fa-brands fa-angellist (brands)',
			'fa-solid fa-angle-down (solid)',
			'fa-solid fa-angle-left (solid)',
			'fa-solid fa-angle-right (solid)',
			'fa-solid fa-angle-up (solid)',
			'fa-solid fa-angles-down (solid)',
			'fa-solid fa-angles-left (solid)',
			'fa-solid fa-angles-right (solid)',
			'fa-solid fa-angles-up (solid)',
			'fa-brands fa-angrycreative (brands)',
			'fa-brands fa-angular (brands)',
			'fa-solid fa-ankh (solid)',
			'fa-brands fa-app-store (brands)',
			'fa-brands fa-app-store-ios (brands)',
			'fa-brands fa-apper (brands)',
			'fa-brands fa-apple (brands)',
			'fa-brands fa-apple-pay (brands)',
			'fa-solid fa-apple-whole (solid)',
			'fa-solid fa-archway (solid)',
			'fa-solid fa-arrow-down (solid)',
			'fa-solid fa-arrow-down-1-9 (solid)',
			'fa-solid fa-arrow-down-9-1 (solid)',
			'fa-solid fa-arrow-down-a-z (solid)',
			'fa-solid fa-arrow-down-long (solid)',
			'fa-solid fa-arrow-down-short-wide (solid)',
			'fa-solid fa-arrow-down-up-across-line (solid)',
			'fa-solid fa-arrow-down-up-lock (solid)',
			'fa-solid fa-arrow-down-wide-short (solid)',
			'fa-solid fa-arrow-down-z-a (solid)',
			'fa-solid fa-arrow-left (solid)',
			'fa-solid fa-arrow-left-long (solid)',
			'fa-solid fa-arrow-pointer (solid)',
			'fa-solid fa-arrow-right (solid)',
			'fa-solid fa-arrow-right-arrow-left (solid)',
			'fa-solid fa-arrow-right-from-bracket (solid)',
			'fa-solid fa-arrow-right-long (solid)',
			'fa-solid fa-arrow-right-to-bracket (solid)',
			'fa-solid fa-arrow-right-to-city (solid)',
			'fa-solid fa-arrow-rotate-left (solid)',
			'fa-solid fa-arrow-rotate-right (solid)',
			'fa-solid fa-arrow-trend-down (solid)',
			'fa-solid fa-arrow-trend-up (solid)',
			'fa-solid fa-arrow-turn-down (solid)',
			'fa-solid fa-arrow-turn-up (solid)',
			'fa-solid fa-arrow-up (solid)',
			'fa-solid fa-arrow-up-1-9 (solid)',
			'fa-solid fa-arrow-up-9-1 (solid)',
			'fa-solid fa-arrow-up-a-z (solid)',
			'fa-solid fa-arrow-up-from-bracket (solid)',
			'fa-solid fa-arrow-up-from-ground-water (solid)',
			'fa-solid fa-arrow-up-from-water-pump (solid)',
			'fa-solid fa-arrow-up-long (solid)',
			'fa-solid fa-arrow-up-right-dots (solid)',
			'fa-solid fa-arrow-up-right-from-square (solid)',
			'fa-solid fa-arrow-up-short-wide (solid)',
			'fa-solid fa-arrow-up-wide-short (solid)',
			'fa-solid fa-arrow-up-z-a (solid)',
			'fa-solid fa-arrows-down-to-line (solid)',
			'fa-solid fa-arrows-down-to-people (solid)',
			'fa-solid fa-arrows-left-right (solid)',
			'fa-solid fa-arrows-left-right-to-line (solid)',
			'fa-solid fa-arrows-rotate (solid)',
			'fa-solid fa-arrows-spin (solid)',
			'fa-solid fa-arrows-split-up-and-left (solid)',
			'fa-solid fa-arrows-to-circle (solid)',
			'fa-solid fa-arrows-to-dot (solid)',
			'fa-solid fa-arrows-to-eye (solid)',
			'fa-solid fa-arrows-turn-right (solid)',
			'fa-solid fa-arrows-turn-to-dots (solid)',
			'fa-solid fa-arrows-up-down (solid)',
			'fa-solid fa-arrows-up-down-left-right (solid)',
			'fa-solid fa-arrows-up-to-line (solid)',
			'fa-brands fa-artstation (brands)',
			'fa-solid fa-asterisk (solid)',
			'fa-brands fa-asymmetrik (brands)',
			'fa-solid fa-at (solid)',
			'fa-brands fa-atlassian (brands)',
			'fa-solid fa-atom (solid)',
			'fa-brands fa-audible (brands)',
			'fa-solid fa-audio-description (solid)',
			'fa-solid fa-austral-sign (solid)',
			'fa-brands fa-autoprefixer (brands)',
			'fa-brands fa-avianex (brands)',
			'fa-brands fa-aviato (brands)',
			'fa-solid fa-award (solid)',
			'fa-brands fa-aws (brands)',
			'fa-solid fa-b (solid)',
			'fa-solid fa-baby (solid)',
			'fa-solid fa-baby-carriage (solid)',
			'fa-solid fa-backward (solid)',
			'fa-solid fa-backward-fast (solid)',
			'fa-solid fa-backward-step (solid)',
			'fa-solid fa-bacon (solid)',
			'fa-solid fa-bacteria (solid)',
			'fa-solid fa-bacterium (solid)',
			'fa-solid fa-bag-shopping (solid)',
			'fa-solid fa-bahai (solid)',
			'fa-solid fa-baht-sign (solid)',
			'fa-solid fa-ban (solid)',
			'fa-solid fa-ban-smoking (solid)',
			'fa-solid fa-bandage (solid)',
			'fa-brands fa-bandcamp (brands)',
			'fa-solid fa-bangladeshi-taka-sign (solid)',
			'fa-solid fa-barcode (solid)',
			'fa-solid fa-bars (solid)',
			'fa-solid fa-bars-progress (solid)',
			'fa-solid fa-bars-staggered (solid)',
			'fa-solid fa-baseball (solid)',
			'fa-solid fa-baseball-bat-ball (solid)',
			'fa-solid fa-basket-shopping (solid)',
			'fa-solid fa-basketball (solid)',
			'fa-solid fa-bath (solid)',
			'fa-solid fa-battery-empty (solid)',
			'fa-solid fa-battery-full (solid)',
			'fa-solid fa-battery-half (solid)',
			'fa-solid fa-battery-quarter (solid)',
			'fa-solid fa-battery-three-quarters (solid)',
			'fa-brands fa-battle-net (brands)',
			'fa-solid fa-bed (solid)',
			'fa-solid fa-bed-pulse (solid)',
			'fa-solid fa-beer-mug-empty (solid)',
			'fa-brands fa-behance (brands)',
			'fa-solid fa-bell (solid)',
			'fa-regular fa-bell (regular)',
			'fa-solid fa-bell-concierge (solid)',
			'fa-solid fa-bell-slash (solid)',
			'fa-regular fa-bell-slash (regular)',
			'fa-solid fa-bezier-curve (solid)',
			'fa-solid fa-bicycle (solid)',
			'fa-brands fa-bilibili (brands)',
			'fa-brands fa-bimobject (brands)',
			'fa-solid fa-binoculars (solid)',
			'fa-solid fa-biohazard (solid)',
			'fa-brands fa-bitbucket (brands)',
			'fa-brands fa-bitcoin (brands)',
			'fa-solid fa-bitcoin-sign (solid)',
			'fa-brands fa-bity (brands)',
			'fa-brands fa-black-tie (brands)',
			'fa-brands fa-blackberry (brands)',
			'fa-solid fa-blender (solid)',
			'fa-solid fa-blender-phone (solid)',
			'fa-solid fa-blog (solid)',
			'fa-brands fa-blogger (brands)',
			'fa-brands fa-blogger-b (brands)',
			'fa-brands fa-bluetooth (brands)',
			'fa-brands fa-bluetooth-b (brands)',
			'fa-solid fa-bold (solid)',
			'fa-solid fa-bolt (solid)',
			'fa-solid fa-bolt-lightning (solid)',
			'fa-solid fa-bomb (solid)',
			'fa-solid fa-bone (solid)',
			'fa-solid fa-bong (solid)',
			'fa-solid fa-book (solid)',
			'fa-solid fa-book-atlas (solid)',
			'fa-solid fa-book-bible (solid)',
			'fa-solid fa-book-bookmark (solid)',
			'fa-solid fa-book-journal-whills (solid)',
			'fa-solid fa-book-medical (solid)',
			'fa-solid fa-book-open (solid)',
			'fa-solid fa-book-open-reader (solid)',
			'fa-solid fa-book-quran (solid)',
			'fa-solid fa-book-skull (solid)',
			'fa-solid fa-book-tanakh (solid)',
			'fa-solid fa-bookmark (solid)',
			'fa-regular fa-bookmark (regular)',
			'fa-brands fa-bootstrap (brands)',
			'fa-solid fa-border-all (solid)',
			'fa-solid fa-border-none (solid)',
			'fa-solid fa-border-top-left (solid)',
			'fa-solid fa-bore-hole (solid)',
			'fa-brands fa-bots (brands)',
			'fa-solid fa-bottle-droplet (solid)',
			'fa-solid fa-bottle-water (solid)',
			'fa-solid fa-bowl-food (solid)',
			'fa-solid fa-bowl-rice (solid)',
			'fa-solid fa-bowling-ball (solid)',
			'fa-solid fa-box (solid)',
			'fa-solid fa-box-archive (solid)',
			'fa-solid fa-box-open (solid)',
			'fa-solid fa-box-tissue (solid)',
			'fa-solid fa-boxes-packing (solid)',
			'fa-solid fa-boxes-stacked (solid)',
			'fa-solid fa-braille (solid)',
			'fa-solid fa-brain (solid)',
			'fa-brands fa-brave (brands)',
			'fa-brands fa-brave-reverse (brands)',
			'fa-solid fa-brazilian-real-sign (solid)',
			'fa-solid fa-bread-slice (solid)',
			'fa-solid fa-bridge (solid)',
			'fa-solid fa-bridge-circle-check (solid)',
			'fa-solid fa-bridge-circle-exclamation (solid)',
			'fa-solid fa-bridge-circle-xmark (solid)',
			'fa-solid fa-bridge-lock (solid)',
			'fa-solid fa-bridge-water (solid)',
			'fa-solid fa-briefcase (solid)',
			'fa-solid fa-briefcase-medical (solid)',
			'fa-solid fa-broom (solid)',
			'fa-solid fa-broom-ball (solid)',
			'fa-solid fa-brush (solid)',
			'fa-brands fa-btc (brands)',
			'fa-solid fa-bucket (solid)',
			'fa-brands fa-buffer (brands)',
			'fa-solid fa-bug (solid)',
			'fa-solid fa-bug-slash (solid)',
			'fa-solid fa-bugs (solid)',
			'fa-solid fa-building (solid)',
			'fa-regular fa-building (regular)',
			'fa-solid fa-building-circle-arrow-right (solid)',
			'fa-solid fa-building-circle-check (solid)',
			'fa-solid fa-building-circle-exclamation (solid)',
			'fa-solid fa-building-circle-xmark (solid)',
			'fa-solid fa-building-columns (solid)',
			'fa-solid fa-building-flag (solid)',
			'fa-solid fa-building-lock (solid)',
			'fa-solid fa-building-ngo (solid)',
			'fa-solid fa-building-shield (solid)',
			'fa-solid fa-building-un (solid)',
			'fa-solid fa-building-user (solid)',
			'fa-solid fa-building-wheat (solid)',
			'fa-solid fa-bullhorn (solid)',
			'fa-solid fa-bullseye (solid)',
			'fa-solid fa-burger (solid)',
			'fa-brands fa-buromobelexperte (brands)',
			'fa-solid fa-burst (solid)',
			'fa-solid fa-bus (solid)',
			'fa-solid fa-bus-simple (solid)',
			'fa-solid fa-business-time (solid)',
			'fa-brands fa-buy-n-large (brands)',
			'fa-brands fa-buysellads (brands)',
			'fa-solid fa-c (solid)',
			'fa-solid fa-cable-car (solid)',
			'fa-solid fa-cake-candles (solid)',
			'fa-solid fa-calculator (solid)',
			'fa-solid fa-calendar (solid)',
			'fa-regular fa-calendar (regular)',
			'fa-solid fa-calendar-check (solid)',
			'fa-regular fa-calendar-check (regular)',
			'fa-solid fa-calendar-day (solid)',
			'fa-solid fa-calendar-days (solid)',
			'fa-regular fa-calendar-days (regular)',
			'fa-solid fa-calendar-minus (solid)',
			'fa-regular fa-calendar-minus (regular)',
			'fa-solid fa-calendar-plus (solid)',
			'fa-regular fa-calendar-plus (regular)',
			'fa-solid fa-calendar-week (solid)',
			'fa-solid fa-calendar-xmark (solid)',
			'fa-regular fa-calendar-xmark (regular)',
			'fa-solid fa-camera (solid)',
			'fa-solid fa-camera-retro (solid)',
			'fa-solid fa-camera-rotate (solid)',
			'fa-solid fa-campground (solid)',
			'fa-brands fa-canadian-maple-leaf (brands)',
			'fa-solid fa-candy-cane (solid)',
			'fa-solid fa-cannabis (solid)',
			'fa-solid fa-capsules (solid)',
			'fa-solid fa-car (solid)',
			'fa-solid fa-car-battery (solid)',
			'fa-solid fa-car-burst (solid)',
			'fa-solid fa-car-on (solid)',
			'fa-solid fa-car-rear (solid)',
			'fa-solid fa-car-side (solid)',
			'fa-solid fa-car-tunnel (solid)',
			'fa-solid fa-caravan (solid)',
			'fa-solid fa-caret-down (solid)',
			'fa-solid fa-caret-left (solid)',
			'fa-solid fa-caret-right (solid)',
			'fa-solid fa-caret-up (solid)',
			'fa-solid fa-carrot (solid)',
			'fa-solid fa-cart-arrow-down (solid)',
			'fa-solid fa-cart-flatbed (solid)',
			'fa-solid fa-cart-flatbed-suitcase (solid)',
			'fa-solid fa-cart-plus (solid)',
			'fa-solid fa-cart-shopping (solid)',
			'fa-solid fa-cash-register (solid)',
			'fa-solid fa-cat (solid)',
			'fa-brands fa-cc-amazon-pay (brands)',
			'fa-brands fa-cc-amex (brands)',
			'fa-brands fa-cc-apple-pay (brands)',
			'fa-brands fa-cc-diners-club (brands)',
			'fa-brands fa-cc-discover (brands)',
			'fa-brands fa-cc-jcb (brands)',
			'fa-brands fa-cc-mastercard (brands)',
			'fa-brands fa-cc-paypal (brands)',
			'fa-brands fa-cc-stripe (brands)',
			'fa-brands fa-cc-visa (brands)',
			'fa-solid fa-cedi-sign (solid)',
			'fa-solid fa-cent-sign (solid)',
			'fa-brands fa-centercode (brands)',
			'fa-brands fa-centos (brands)',
			'fa-solid fa-certificate (solid)',
			'fa-solid fa-chair (solid)',
			'fa-solid fa-chalkboard (solid)',
			'fa-solid fa-chalkboard-user (solid)',
			'fa-solid fa-champagne-glasses (solid)',
			'fa-solid fa-charging-station (solid)',
			'fa-solid fa-chart-area (solid)',
			'fa-solid fa-chart-bar (solid)',
			'fa-regular fa-chart-bar (regular)',
			'fa-solid fa-chart-column (solid)',
			'fa-solid fa-chart-gantt (solid)',
			'fa-solid fa-chart-line (solid)',
			'fa-solid fa-chart-pie (solid)',
			'fa-solid fa-chart-simple (solid)',
			'fa-solid fa-check (solid)',
			'fa-solid fa-check-double (solid)',
			'fa-solid fa-check-to-slot (solid)',
			'fa-solid fa-cheese (solid)',
			'fa-solid fa-chess (solid)',
			'fa-solid fa-chess-bishop (solid)',
			'fa-regular fa-chess-bishop (regular)',
			'fa-solid fa-chess-board (solid)',
			'fa-solid fa-chess-king (solid)',
			'fa-regular fa-chess-king (regular)',
			'fa-solid fa-chess-knight (solid)',
			'fa-regular fa-chess-knight (regular)',
			'fa-solid fa-chess-pawn (solid)',
			'fa-regular fa-chess-pawn (regular)',
			'fa-solid fa-chess-queen (solid)',
			'fa-regular fa-chess-queen (regular)',
			'fa-solid fa-chess-rook (solid)',
			'fa-regular fa-chess-rook (regular)',
			'fa-solid fa-chevron-down (solid)',
			'fa-solid fa-chevron-left (solid)',
			'fa-solid fa-chevron-right (solid)',
			'fa-solid fa-chevron-up (solid)',
			'fa-solid fa-child (solid)',
			'fa-solid fa-child-combatant (solid)',
			'fa-solid fa-child-dress (solid)',
			'fa-solid fa-child-reaching (solid)',
			'fa-solid fa-children (solid)',
			'fa-brands fa-chrome (brands)',
			'fa-brands fa-chromecast (brands)',
			'fa-solid fa-church (solid)',
			'fa-solid fa-circle (solid)',
			'fa-regular fa-circle (regular)',
			'fa-solid fa-circle-arrow-down (solid)',
			'fa-solid fa-circle-arrow-left (solid)',
			'fa-solid fa-circle-arrow-right (solid)',
			'fa-solid fa-circle-arrow-up (solid)',
			'fa-solid fa-circle-check (solid)',
			'fa-regular fa-circle-check (regular)',
			'fa-solid fa-circle-chevron-down (solid)',
			'fa-solid fa-circle-chevron-left (solid)',
			'fa-solid fa-circle-chevron-right (solid)',
			'fa-solid fa-circle-chevron-up (solid)',
			'fa-solid fa-circle-dollar-to-slot (solid)',
			'fa-solid fa-circle-dot (solid)',
			'fa-regular fa-circle-dot (regular)',
			'fa-solid fa-circle-down (solid)',
			'fa-regular fa-circle-down (regular)',
			'fa-solid fa-circle-exclamation (solid)',
			'fa-solid fa-circle-h (solid)',
			'fa-solid fa-circle-half-stroke (solid)',
			'fa-solid fa-circle-info (solid)',
			'fa-solid fa-circle-left (solid)',
			'fa-regular fa-circle-left (regular)',
			'fa-solid fa-circle-minus (solid)',
			'fa-solid fa-circle-nodes (solid)',
			'fa-solid fa-circle-notch (solid)',
			'fa-solid fa-circle-pause (solid)',
			'fa-regular fa-circle-pause (regular)',
			'fa-solid fa-circle-play (solid)',
			'fa-regular fa-circle-play (regular)',
			'fa-solid fa-circle-plus (solid)',
			'fa-solid fa-circle-question (solid)',
			'fa-regular fa-circle-question (regular)',
			'fa-solid fa-circle-radiation (solid)',
			'fa-solid fa-circle-right (solid)',
			'fa-regular fa-circle-right (regular)',
			'fa-solid fa-circle-stop (solid)',
			'fa-regular fa-circle-stop (regular)',
			'fa-solid fa-circle-up (solid)',
			'fa-regular fa-circle-up (regular)',
			'fa-solid fa-circle-user (solid)',
			'fa-regular fa-circle-user (regular)',
			'fa-solid fa-circle-xmark (solid)',
			'fa-regular fa-circle-xmark (regular)',
			'fa-solid fa-city (solid)',
			'fa-solid fa-clapperboard (solid)',
			'fa-solid fa-clipboard (solid)',
			'fa-regular fa-clipboard (regular)',
			'fa-solid fa-clipboard-check (solid)',
			'fa-solid fa-clipboard-list (solid)',
			'fa-solid fa-clipboard-question (solid)',
			'fa-solid fa-clipboard-user (solid)',
			'fa-solid fa-clock (solid)',
			'fa-regular fa-clock (regular)',
			'fa-solid fa-clock-rotate-left (solid)',
			'fa-solid fa-clone (solid)',
			'fa-regular fa-clone (regular)',
			'fa-solid fa-closed-captioning (solid)',
			'fa-regular fa-closed-captioning (regular)',
			'fa-solid fa-cloud (solid)',
			'fa-solid fa-cloud-arrow-down (solid)',
			'fa-solid fa-cloud-arrow-up (solid)',
			'fa-solid fa-cloud-bolt (solid)',
			'fa-solid fa-cloud-meatball (solid)',
			'fa-solid fa-cloud-moon (solid)',
			'fa-solid fa-cloud-moon-rain (solid)',
			'fa-solid fa-cloud-rain (solid)',
			'fa-solid fa-cloud-showers-heavy (solid)',
			'fa-solid fa-cloud-showers-water (solid)',
			'fa-solid fa-cloud-sun (solid)',
			'fa-solid fa-cloud-sun-rain (solid)',
			'fa-brands fa-cloudflare (brands)',
			'fa-brands fa-cloudscale (brands)',
			'fa-brands fa-cloudsmith (brands)',
			'fa-brands fa-cloudversify (brands)',
			'fa-solid fa-clover (solid)',
			'fa-brands fa-cmplid (brands)',
			'fa-solid fa-code (solid)',
			'fa-solid fa-code-branch (solid)',
			'fa-solid fa-code-commit (solid)',
			'fa-solid fa-code-compare (solid)',
			'fa-solid fa-code-fork (solid)',
			'fa-solid fa-code-merge (solid)',
			'fa-solid fa-code-pull-request (solid)',
			'fa-brands fa-codepen (brands)',
			'fa-brands fa-codiepie (brands)',
			'fa-solid fa-coins (solid)',
			'fa-solid fa-colon-sign (solid)',
			'fa-solid fa-comment (solid)',
			'fa-regular fa-comment (regular)',
			'fa-solid fa-comment-dollar (solid)',
			'fa-solid fa-comment-dots (solid)',
			'fa-regular fa-comment-dots (regular)',
			'fa-solid fa-comment-medical (solid)',
			'fa-solid fa-comment-slash (solid)',
			'fa-solid fa-comment-sms (solid)',
			'fa-solid fa-comments (solid)',
			'fa-regular fa-comments (regular)',
			'fa-solid fa-comments-dollar (solid)',
			'fa-solid fa-compact-disc (solid)',
			'fa-solid fa-compass (solid)',
			'fa-regular fa-compass (regular)',
			'fa-solid fa-compass-drafting (solid)',
			'fa-solid fa-compress (solid)',
			'fa-solid fa-computer (solid)',
			'fa-solid fa-computer-mouse (solid)',
			'fa-brands fa-confluence (brands)',
			'fa-brands fa-connectdevelop (brands)',
			'fa-brands fa-contao (brands)',
			'fa-solid fa-cookie (solid)',
			'fa-solid fa-cookie-bite (solid)',
			'fa-solid fa-copy (solid)',
			'fa-regular fa-copy (regular)',
			'fa-solid fa-copyright (solid)',
			'fa-regular fa-copyright (regular)',
			'fa-brands fa-cotton-bureau (brands)',
			'fa-solid fa-couch (solid)',
			'fa-solid fa-cow (solid)',
			'fa-brands fa-cpanel (brands)',
			'fa-brands fa-creative-commons (brands)',
			'fa-brands fa-creative-commons-by (brands)',
			'fa-brands fa-creative-commons-nc (brands)',
			'fa-brands fa-creative-commons-nc-eu (brands)',
			'fa-brands fa-creative-commons-nc-jp (brands)',
			'fa-brands fa-creative-commons-nd (brands)',
			'fa-brands fa-creative-commons-pd (brands)',
			'fa-brands fa-creative-commons-pd-alt (brands)',
			'fa-brands fa-creative-commons-remix (brands)',
			'fa-brands fa-creative-commons-sa (brands)',
			'fa-brands fa-creative-commons-sampling (brands)',
			'fa-brands fa-creative-commons-sampling-plus (brands)',
			'fa-brands fa-creative-commons-share (brands)',
			'fa-brands fa-creative-commons-zero (brands)',
			'fa-solid fa-credit-card (solid)',
			'fa-regular fa-credit-card (regular)',
			'fa-brands fa-critical-role (brands)',
			'fa-solid fa-crop (solid)',
			'fa-solid fa-crop-simple (solid)',
			'fa-solid fa-cross (solid)',
			'fa-solid fa-crosshairs (solid)',
			'fa-solid fa-crow (solid)',
			'fa-solid fa-crown (solid)',
			'fa-solid fa-crutch (solid)',
			'fa-solid fa-cruzeiro-sign (solid)',
			'fa-brands fa-css3 (brands)',
			'fa-brands fa-css3-alt (brands)',
			'fa-solid fa-cube (solid)',
			'fa-solid fa-cubes (solid)',
			'fa-solid fa-cubes-stacked (solid)',
			'fa-brands fa-cuttlefish (brands)',
			'fa-solid fa-d (solid)',
			'fa-brands fa-d-and-d (brands)',
			'fa-brands fa-d-and-d-beyond (brands)',
			'fa-brands fa-dailymotion (brands)',
			'fa-brands fa-dashcube (brands)',
			'fa-solid fa-database (solid)',
			'fa-brands fa-debian (brands)',
			'fa-brands fa-deezer (brands)',
			'fa-solid fa-delete-left (solid)',
			'fa-brands fa-delicious (brands)',
			'fa-solid fa-democrat (solid)',
			'fa-brands fa-deploydog (brands)',
			'fa-brands fa-deskpro (brands)',
			'fa-solid fa-desktop (solid)',
			'fa-brands fa-dev (brands)',
			'fa-brands fa-deviantart (brands)',
			'fa-solid fa-dharmachakra (solid)',
			'fa-brands fa-dhl (brands)',
			'fa-solid fa-diagram-next (solid)',
			'fa-solid fa-diagram-predecessor (solid)',
			'fa-solid fa-diagram-project (solid)',
			'fa-solid fa-diagram-successor (solid)',
			'fa-solid fa-diamond (solid)',
			'fa-solid fa-diamond-turn-right (solid)',
			'fa-brands fa-diaspora (brands)',
			'fa-solid fa-dice (solid)',
			'fa-solid fa-dice-d20 (solid)',
			'fa-solid fa-dice-d6 (solid)',
			'fa-solid fa-dice-five (solid)',
			'fa-solid fa-dice-four (solid)',
			'fa-solid fa-dice-one (solid)',
			'fa-solid fa-dice-six (solid)',
			'fa-solid fa-dice-three (solid)',
			'fa-solid fa-dice-two (solid)',
			'fa-brands fa-digg (brands)',
			'fa-brands fa-digital-ocean (brands)',
			'fa-brands fa-discord (brands)',
			'fa-brands fa-discourse (brands)',
			'fa-solid fa-disease (solid)',
			'fa-solid fa-display (solid)',
			'fa-solid fa-divide (solid)',
			'fa-solid fa-dna (solid)',
			'fa-brands fa-dochub (brands)',
			'fa-brands fa-docker (brands)',
			'fa-solid fa-dog (solid)',
			'fa-solid fa-dollar-sign (solid)',
			'fa-solid fa-dolly (solid)',
			'fa-solid fa-dong-sign (solid)',
			'fa-solid fa-door-closed (solid)',
			'fa-solid fa-door-open (solid)',
			'fa-solid fa-dove (solid)',
			'fa-solid fa-down-left-and-up-right-to-center (solid)',
			'fa-solid fa-down-long (solid)',
			'fa-solid fa-download (solid)',
			'fa-brands fa-draft2digital (brands)',
			'fa-solid fa-dragon (solid)',
			'fa-solid fa-draw-polygon (solid)',
			'fa-brands fa-dribbble (brands)',
			'fa-brands fa-dropbox (brands)',
			'fa-solid fa-droplet (solid)',
			'fa-solid fa-droplet-slash (solid)',
			'fa-solid fa-drum (solid)',
			'fa-solid fa-drum-steelpan (solid)',
			'fa-solid fa-drumstick-bite (solid)',
			'fa-brands fa-drupal (brands)',
			'fa-solid fa-dumbbell (solid)',
			'fa-solid fa-dumpster (solid)',
			'fa-solid fa-dumpster-fire (solid)',
			'fa-solid fa-dungeon (solid)',
			'fa-brands fa-dyalog (brands)',
			'fa-solid fa-e (solid)',
			'fa-solid fa-ear-deaf (solid)',
			'fa-solid fa-ear-listen (solid)',
			'fa-brands fa-earlybirds (brands)',
			'fa-solid fa-earth-africa (solid)',
			'fa-solid fa-earth-americas (solid)',
			'fa-solid fa-earth-asia (solid)',
			'fa-solid fa-earth-europe (solid)',
			'fa-solid fa-earth-oceania (solid)',
			'fa-brands fa-ebay (brands)',
			'fa-brands fa-edge (brands)',
			'fa-brands fa-edge-legacy (brands)',
			'fa-solid fa-egg (solid)',
			'fa-solid fa-eject (solid)',
			'fa-brands fa-elementor (brands)',
			'fa-solid fa-elevator (solid)',
			'fa-solid fa-ellipsis (solid)',
			'fa-solid fa-ellipsis-vertical (solid)',
			'fa-brands fa-ello (brands)',
			'fa-brands fa-ember (brands)',
			'fa-brands fa-empire (brands)',
			'fa-solid fa-envelope (solid)',
			'fa-regular fa-envelope (regular)',
			'fa-solid fa-envelope-circle-check (solid)',
			'fa-solid fa-envelope-open (solid)',
			'fa-regular fa-envelope-open (regular)',
			'fa-solid fa-envelope-open-text (solid)',
			'fa-solid fa-envelopes-bulk (solid)',
			'fa-brands fa-envira (brands)',
			'fa-solid fa-equals (solid)',
			'fa-solid fa-eraser (solid)',
			'fa-brands fa-erlang (brands)',
			'fa-brands fa-ethereum (brands)',
			'fa-solid fa-ethernet (solid)',
			'fa-brands fa-etsy (brands)',
			'fa-solid fa-euro-sign (solid)',
			'fa-brands fa-evernote (brands)',
			'fa-solid fa-exclamation (solid)',
			'fa-solid fa-expand (solid)',
			'fa-brands fa-expeditedssl (brands)',
			'fa-solid fa-explosion (solid)',
			'fa-solid fa-eye (solid)',
			'fa-regular fa-eye (regular)',
			'fa-solid fa-eye-dropper (solid)',
			'fa-solid fa-eye-low-vision (solid)',
			'fa-solid fa-eye-slash (solid)',
			'fa-regular fa-eye-slash (regular)',
			'fa-solid fa-f (solid)',
			'fa-solid fa-face-angry (solid)',
			'fa-regular fa-face-angry (regular)',
			'fa-solid fa-face-dizzy (solid)',
			'fa-regular fa-face-dizzy (regular)',
			'fa-solid fa-face-flushed (solid)',
			'fa-regular fa-face-flushed (regular)',
			'fa-solid fa-face-frown (solid)',
			'fa-regular fa-face-frown (regular)',
			'fa-solid fa-face-frown-open (solid)',
			'fa-regular fa-face-frown-open (regular)',
			'fa-solid fa-face-grimace (solid)',
			'fa-regular fa-face-grimace (regular)',
			'fa-solid fa-face-grin (solid)',
			'fa-regular fa-face-grin (regular)',
			'fa-solid fa-face-grin-beam (solid)',
			'fa-regular fa-face-grin-beam (regular)',
			'fa-solid fa-face-grin-beam-sweat (solid)',
			'fa-regular fa-face-grin-beam-sweat (regular)',
			'fa-solid fa-face-grin-hearts (solid)',
			'fa-regular fa-face-grin-hearts (regular)',
			'fa-solid fa-face-grin-squint (solid)',
			'fa-regular fa-face-grin-squint (regular)',
			'fa-solid fa-face-grin-squint-tears (solid)',
			'fa-regular fa-face-grin-squint-tears (regular)',
			'fa-solid fa-face-grin-stars (solid)',
			'fa-regular fa-face-grin-stars (regular)',
			'fa-solid fa-face-grin-tears (solid)',
			'fa-regular fa-face-grin-tears (regular)',
			'fa-solid fa-face-grin-tongue (solid)',
			'fa-regular fa-face-grin-tongue (regular)',
			'fa-solid fa-face-grin-tongue-squint (solid)',
			'fa-regular fa-face-grin-tongue-squint (regular)',
			'fa-solid fa-face-grin-tongue-wink (solid)',
			'fa-regular fa-face-grin-tongue-wink (regular)',
			'fa-solid fa-face-grin-wide (solid)',
			'fa-regular fa-face-grin-wide (regular)',
			'fa-solid fa-face-grin-wink (solid)',
			'fa-regular fa-face-grin-wink (regular)',
			'fa-solid fa-face-kiss (solid)',
			'fa-regular fa-face-kiss (regular)',
			'fa-solid fa-face-kiss-beam (solid)',
			'fa-regular fa-face-kiss-beam (regular)',
			'fa-solid fa-face-kiss-wink-heart (solid)',
			'fa-regular fa-face-kiss-wink-heart (regular)',
			'fa-solid fa-face-laugh (solid)',
			'fa-regular fa-face-laugh (regular)',
			'fa-solid fa-face-laugh-beam (solid)',
			'fa-regular fa-face-laugh-beam (regular)',
			'fa-solid fa-face-laugh-squint (solid)',
			'fa-regular fa-face-laugh-squint (regular)',
			'fa-solid fa-face-laugh-wink (solid)',
			'fa-regular fa-face-laugh-wink (regular)',
			'fa-solid fa-face-meh (solid)',
			'fa-regular fa-face-meh (regular)',
			'fa-solid fa-face-meh-blank (solid)',
			'fa-regular fa-face-meh-blank (regular)',
			'fa-solid fa-face-rolling-eyes (solid)',
			'fa-regular fa-face-rolling-eyes (regular)',
			'fa-solid fa-face-sad-cry (solid)',
			'fa-regular fa-face-sad-cry (regular)',
			'fa-solid fa-face-sad-tear (solid)',
			'fa-regular fa-face-sad-tear (regular)',
			'fa-solid fa-face-smile (solid)',
			'fa-regular fa-face-smile (regular)',
			'fa-solid fa-face-smile-beam (solid)',
			'fa-regular fa-face-smile-beam (regular)',
			'fa-solid fa-face-smile-wink (solid)',
			'fa-regular fa-face-smile-wink (regular)',
			'fa-solid fa-face-surprise (solid)',
			'fa-regular fa-face-surprise (regular)',
			'fa-solid fa-face-tired (solid)',
			'fa-regular fa-face-tired (regular)',
			'fa-brands fa-facebook (brands)',
			'fa-brands fa-facebook-f (brands)',
			'fa-brands fa-facebook-messenger (brands)',
			'fa-solid fa-fan (solid)',
			'fa-brands fa-fantasy-flight-games (brands)',
			'fa-solid fa-faucet (solid)',
			'fa-solid fa-faucet-drip (solid)',
			'fa-solid fa-fax (solid)',
			'fa-solid fa-feather (solid)',
			'fa-solid fa-feather-pointed (solid)',
			'fa-brands fa-fedex (brands)',
			'fa-brands fa-fedora (brands)',
			'fa-solid fa-ferry (solid)',
			'fa-brands fa-figma (brands)',
			'fa-solid fa-file (solid)',
			'fa-regular fa-file (regular)',
			'fa-solid fa-file-arrow-down (solid)',
			'fa-solid fa-file-arrow-up (solid)',
			'fa-solid fa-file-audio (solid)',
			'fa-regular fa-file-audio (regular)',
			'fa-solid fa-file-circle-check (solid)',
			'fa-solid fa-file-circle-exclamation (solid)',
			'fa-solid fa-file-circle-minus (solid)',
			'fa-solid fa-file-circle-plus (solid)',
			'fa-solid fa-file-circle-question (solid)',
			'fa-solid fa-file-circle-xmark (solid)',
			'fa-solid fa-file-code (solid)',
			'fa-regular fa-file-code (regular)',
			'fa-solid fa-file-contract (solid)',
			'fa-solid fa-file-csv (solid)',
			'fa-solid fa-file-excel (solid)',
			'fa-regular fa-file-excel (regular)',
			'fa-solid fa-file-export (solid)',
			'fa-solid fa-file-image (solid)',
			'fa-regular fa-file-image (regular)',
			'fa-solid fa-file-import (solid)',
			'fa-solid fa-file-invoice (solid)',
			'fa-solid fa-file-invoice-dollar (solid)',
			'fa-solid fa-file-lines (solid)',
			'fa-regular fa-file-lines (regular)',
			'fa-solid fa-file-medical (solid)',
			'fa-solid fa-file-pdf (solid)',
			'fa-regular fa-file-pdf (regular)',
			'fa-solid fa-file-pen (solid)',
			'fa-solid fa-file-powerpoint (solid)',
			'fa-regular fa-file-powerpoint (regular)',
			'fa-solid fa-file-prescription (solid)',
			'fa-solid fa-file-shield (solid)',
			'fa-solid fa-file-signature (solid)',
			'fa-solid fa-file-video (solid)',
			'fa-regular fa-file-video (regular)',
			'fa-solid fa-file-waveform (solid)',
			'fa-solid fa-file-word (solid)',
			'fa-regular fa-file-word (regular)',
			'fa-solid fa-file-zipper (solid)',
			'fa-regular fa-file-zipper (regular)',
			'fa-solid fa-fill (solid)',
			'fa-solid fa-fill-drip (solid)',
			'fa-solid fa-film (solid)',
			'fa-solid fa-filter (solid)',
			'fa-solid fa-filter-circle-dollar (solid)',
			'fa-solid fa-filter-circle-xmark (solid)',
			'fa-solid fa-fingerprint (solid)',
			'fa-solid fa-fire (solid)',
			'fa-solid fa-fire-burner (solid)',
			'fa-solid fa-fire-extinguisher (solid)',
			'fa-solid fa-fire-flame-curved (solid)',
			'fa-solid fa-fire-flame-simple (solid)',
			'fa-brands fa-firefox (brands)',
			'fa-brands fa-firefox-browser (brands)',
			'fa-brands fa-first-order (brands)',
			'fa-brands fa-first-order-alt (brands)',
			'fa-brands fa-firstdraft (brands)',
			'fa-solid fa-fish (solid)',
			'fa-solid fa-fish-fins (solid)',
			'fa-solid fa-flag (solid)',
			'fa-regular fa-flag (regular)',
			'fa-solid fa-flag-checkered (solid)',
			'fa-solid fa-flag-usa (solid)',
			'fa-solid fa-flask (solid)',
			'fa-solid fa-flask-vial (solid)',
			'fa-brands fa-flickr (brands)',
			'fa-brands fa-flipboard (brands)',
			'fa-solid fa-floppy-disk (solid)',
			'fa-regular fa-floppy-disk (regular)',
			'fa-solid fa-florin-sign (solid)',
			'fa-brands fa-fly (brands)',
			'fa-solid fa-folder (solid)',
			'fa-regular fa-folder (regular)',
			'fa-solid fa-folder-closed (solid)',
			'fa-regular fa-folder-closed (regular)',
			'fa-solid fa-folder-minus (solid)',
			'fa-solid fa-folder-open (solid)',
			'fa-regular fa-folder-open (regular)',
			'fa-solid fa-folder-plus (solid)',
			'fa-solid fa-folder-tree (solid)',
			'fa-solid fa-font (solid)',
			'fa-solid fa-font-awesome (solid)',
			'fa-regular fa-font-awesome (regular)',
			'fa-brands fa-font-awesome (brands)',
			'fa-brands fa-fonticons (brands)',
			'fa-brands fa-fonticons-fi (brands)',
			'fa-solid fa-football (solid)',
			'fa-brands fa-fort-awesome (brands)',
			'fa-brands fa-fort-awesome-alt (brands)',
			'fa-brands fa-forumbee (brands)',
			'fa-solid fa-forward (solid)',
			'fa-solid fa-forward-fast (solid)',
			'fa-solid fa-forward-step (solid)',
			'fa-brands fa-foursquare (brands)',
			'fa-solid fa-franc-sign (solid)',
			'fa-brands fa-free-code-camp (brands)',
			'fa-brands fa-freebsd (brands)',
			'fa-solid fa-frog (solid)',
			'fa-brands fa-fulcrum (brands)',
			'fa-solid fa-futbol (solid)',
			'fa-regular fa-futbol (regular)',
			'fa-solid fa-g (solid)',
			'fa-brands fa-galactic-republic (brands)',
			'fa-brands fa-galactic-senate (brands)',
			'fa-solid fa-gamepad (solid)',
			'fa-solid fa-gas-pump (solid)',
			'fa-solid fa-gauge (solid)',
			'fa-solid fa-gauge-high (solid)',
			'fa-solid fa-gauge-simple (solid)',
			'fa-solid fa-gauge-simple-high (solid)',
			'fa-solid fa-gavel (solid)',
			'fa-solid fa-gear (solid)',
			'fa-solid fa-gears (solid)',
			'fa-solid fa-gem (solid)',
			'fa-regular fa-gem (regular)',
			'fa-solid fa-genderless (solid)',
			'fa-brands fa-get-pocket (brands)',
			'fa-brands fa-gg (brands)',
			'fa-brands fa-gg-circle (brands)',
			'fa-solid fa-ghost (solid)',
			'fa-solid fa-gift (solid)',
			'fa-solid fa-gifts (solid)',
			'fa-brands fa-git (brands)',
			'fa-brands fa-git-alt (brands)',
			'fa-brands fa-github (brands)',
			'fa-brands fa-github-alt (brands)',
			'fa-brands fa-gitkraken (brands)',
			'fa-brands fa-gitlab (brands)',
			'fa-brands fa-gitter (brands)',
			'fa-solid fa-glass-water (solid)',
			'fa-solid fa-glass-water-droplet (solid)',
			'fa-solid fa-glasses (solid)',
			'fa-brands fa-glide (brands)',
			'fa-brands fa-glide-g (brands)',
			'fa-solid fa-globe (solid)',
			'fa-brands fa-gofore (brands)',
			'fa-brands fa-golang (brands)',
			'fa-solid fa-golf-ball-tee (solid)',
			'fa-brands fa-goodreads (brands)',
			'fa-brands fa-goodreads-g (brands)',
			'fa-brands fa-google (brands)',
			'fa-brands fa-google-drive (brands)',
			'fa-brands fa-google-pay (brands)',
			'fa-brands fa-google-play (brands)',
			'fa-brands fa-google-plus (brands)',
			'fa-brands fa-google-plus-g (brands)',
			'fa-brands fa-google-scholar (brands)',
			'fa-brands fa-google-wallet (brands)',
			'fa-solid fa-gopuram (solid)',
			'fa-solid fa-graduation-cap (solid)',
			'fa-brands fa-gratipay (brands)',
			'fa-brands fa-grav (brands)',
			'fa-solid fa-greater-than (solid)',
			'fa-solid fa-greater-than-equal (solid)',
			'fa-solid fa-grip (solid)',
			'fa-solid fa-grip-lines (solid)',
			'fa-solid fa-grip-lines-vertical (solid)',
			'fa-solid fa-grip-vertical (solid)',
			'fa-brands fa-gripfire (brands)',
			'fa-solid fa-group-arrows-rotate (solid)',
			'fa-brands fa-grunt (brands)',
			'fa-solid fa-guarani-sign (solid)',
			'fa-brands fa-guilded (brands)',
			'fa-solid fa-guitar (solid)',
			'fa-brands fa-gulp (brands)',
			'fa-solid fa-gun (solid)',
			'fa-solid fa-h (solid)',
			'fa-brands fa-hacker-news (brands)',
			'fa-brands fa-hackerrank (brands)',
			'fa-solid fa-hammer (solid)',
			'fa-solid fa-hamsa (solid)',
			'fa-solid fa-hand (solid)',
			'fa-regular fa-hand (regular)',
			'fa-solid fa-hand-back-fist (solid)',
			'fa-regular fa-hand-back-fist (regular)',
			'fa-solid fa-hand-dots (solid)',
			'fa-solid fa-hand-fist (solid)',
			'fa-solid fa-hand-holding (solid)',
			'fa-solid fa-hand-holding-dollar (solid)',
			'fa-solid fa-hand-holding-droplet (solid)',
			'fa-solid fa-hand-holding-hand (solid)',
			'fa-solid fa-hand-holding-heart (solid)',
			'fa-solid fa-hand-holding-medical (solid)',
			'fa-solid fa-hand-lizard (solid)',
			'fa-regular fa-hand-lizard (regular)',
			'fa-solid fa-hand-middle-finger (solid)',
			'fa-solid fa-hand-peace (solid)',
			'fa-regular fa-hand-peace (regular)',
			'fa-solid fa-hand-point-down (solid)',
			'fa-regular fa-hand-point-down (regular)',
			'fa-solid fa-hand-point-left (solid)',
			'fa-regular fa-hand-point-left (regular)',
			'fa-solid fa-hand-point-right (solid)',
			'fa-regular fa-hand-point-right (regular)',
			'fa-solid fa-hand-point-up (solid)',
			'fa-regular fa-hand-point-up (regular)',
			'fa-solid fa-hand-pointer (solid)',
			'fa-regular fa-hand-pointer (regular)',
			'fa-solid fa-hand-scissors (solid)',
			'fa-regular fa-hand-scissors (regular)',
			'fa-solid fa-hand-sparkles (solid)',
			'fa-solid fa-hand-spock (solid)',
			'fa-regular fa-hand-spock (regular)',
			'fa-solid fa-handcuffs (solid)',
			'fa-solid fa-hands (solid)',
			'fa-solid fa-hands-asl-interpreting (solid)',
			'fa-solid fa-hands-bound (solid)',
			'fa-solid fa-hands-bubbles (solid)',
			'fa-solid fa-hands-clapping (solid)',
			'fa-solid fa-hands-holding (solid)',
			'fa-solid fa-hands-holding-child (solid)',
			'fa-solid fa-hands-holding-circle (solid)',
			'fa-solid fa-hands-praying (solid)',
			'fa-solid fa-handshake (solid)',
			'fa-regular fa-handshake (regular)',
			'fa-solid fa-handshake-angle (solid)',
			'fa-solid fa-handshake-simple (solid)',
			'fa-solid fa-handshake-simple-slash (solid)',
			'fa-solid fa-handshake-slash (solid)',
			'fa-solid fa-hanukiah (solid)',
			'fa-solid fa-hard-drive (solid)',
			'fa-regular fa-hard-drive (regular)',
			'fa-brands fa-hashnode (brands)',
			'fa-solid fa-hashtag (solid)',
			'fa-solid fa-hat-cowboy (solid)',
			'fa-solid fa-hat-cowboy-side (solid)',
			'fa-solid fa-hat-wizard (solid)',
			'fa-solid fa-head-side-cough (solid)',
			'fa-solid fa-head-side-cough-slash (solid)',
			'fa-solid fa-head-side-mask (solid)',
			'fa-solid fa-head-side-virus (solid)',
			'fa-solid fa-heading (solid)',
			'fa-solid fa-headphones (solid)',
			'fa-solid fa-headphones-simple (solid)',
			'fa-solid fa-headset (solid)',
			'fa-solid fa-heart (solid)',
			'fa-regular fa-heart (regular)',
			'fa-solid fa-heart-circle-bolt (solid)',
			'fa-solid fa-heart-circle-check (solid)',
			'fa-solid fa-heart-circle-exclamation (solid)',
			'fa-solid fa-heart-circle-minus (solid)',
			'fa-solid fa-heart-circle-plus (solid)',
			'fa-solid fa-heart-circle-xmark (solid)',
			'fa-solid fa-heart-crack (solid)',
			'fa-solid fa-heart-pulse (solid)',
			'fa-solid fa-helicopter (solid)',
			'fa-solid fa-helicopter-symbol (solid)',
			'fa-solid fa-helmet-safety (solid)',
			'fa-solid fa-helmet-un (solid)',
			'fa-solid fa-highlighter (solid)',
			'fa-solid fa-hill-avalanche (solid)',
			'fa-solid fa-hill-rockslide (solid)',
			'fa-solid fa-hippo (solid)',
			'fa-brands fa-hips (brands)',
			'fa-brands fa-hire-a-helper (brands)',
			'fa-brands fa-hive (brands)',
			'fa-solid fa-hockey-puck (solid)',
			'fa-solid fa-holly-berry (solid)',
			'fa-brands fa-hooli (brands)',
			'fa-brands fa-hornbill (brands)',
			'fa-solid fa-horse (solid)',
			'fa-solid fa-horse-head (solid)',
			'fa-solid fa-hospital (solid)',
			'fa-regular fa-hospital (regular)',
			'fa-solid fa-hospital-user (solid)',
			'fa-solid fa-hot-tub-person (solid)',
			'fa-solid fa-hotdog (solid)',
			'fa-solid fa-hotel (solid)',
			'fa-brands fa-hotjar (brands)',
			'fa-solid fa-hourglass (solid)',
			'fa-regular fa-hourglass (regular)',
			'fa-solid fa-hourglass-end (solid)',
			'fa-solid fa-hourglass-half (solid)',
			'fa-regular fa-hourglass-half (regular)',
			'fa-solid fa-hourglass-start (solid)',
			'fa-solid fa-house (solid)',
			'fa-solid fa-house-chimney (solid)',
			'fa-solid fa-house-chimney-crack (solid)',
			'fa-solid fa-house-chimney-medical (solid)',
			'fa-solid fa-house-chimney-user (solid)',
			'fa-solid fa-house-chimney-window (solid)',
			'fa-solid fa-house-circle-check (solid)',
			'fa-solid fa-house-circle-exclamation (solid)',
			'fa-solid fa-house-circle-xmark (solid)',
			'fa-solid fa-house-crack (solid)',
			'fa-solid fa-house-fire (solid)',
			'fa-solid fa-house-flag (solid)',
			'fa-solid fa-house-flood-water (solid)',
			'fa-solid fa-house-flood-water-circle-arrow-right (solid)',
			'fa-solid fa-house-laptop (solid)',
			'fa-solid fa-house-lock (solid)',
			'fa-solid fa-house-medical (solid)',
			'fa-solid fa-house-medical-circle-check (solid)',
			'fa-solid fa-house-medical-circle-exclamation (solid)',
			'fa-solid fa-house-medical-circle-xmark (solid)',
			'fa-solid fa-house-medical-flag (solid)',
			'fa-solid fa-house-signal (solid)',
			'fa-solid fa-house-tsunami (solid)',
			'fa-solid fa-house-user (solid)',
			'fa-brands fa-houzz (brands)',
			'fa-solid fa-hryvnia-sign (solid)',
			'fa-brands fa-html5 (brands)',
			'fa-brands fa-hubspot (brands)',
			'fa-solid fa-hurricane (solid)',
			'fa-solid fa-i (solid)',
			'fa-solid fa-i-cursor (solid)',
			'fa-solid fa-ice-cream (solid)',
			'fa-solid fa-icicles (solid)',
			'fa-solid fa-icons (solid)',
			'fa-solid fa-id-badge (solid)',
			'fa-regular fa-id-badge (regular)',
			'fa-solid fa-id-card (solid)',
			'fa-regular fa-id-card (regular)',
			'fa-solid fa-id-card-clip (solid)',
			'fa-brands fa-ideal (brands)',
			'fa-solid fa-igloo (solid)',
			'fa-solid fa-image (solid)',
			'fa-regular fa-image (regular)',
			'fa-solid fa-image-portrait (solid)',
			'fa-solid fa-images (solid)',
			'fa-regular fa-images (regular)',
			'fa-brands fa-imdb (brands)',
			'fa-solid fa-inbox (solid)',
			'fa-solid fa-indent (solid)',
			'fa-solid fa-indian-rupee-sign (solid)',
			'fa-solid fa-industry (solid)',
			'fa-solid fa-infinity (solid)',
			'fa-solid fa-info (solid)',
			'fa-brands fa-instagram (brands)',
			'fa-brands fa-instalod (brands)',
			'fa-brands fa-intercom (brands)',
			'fa-brands fa-internet-explorer (brands)',
			'fa-brands fa-invision (brands)',
			'fa-brands fa-ioxhost (brands)',
			'fa-solid fa-italic (solid)',
			'fa-brands fa-itch-io (brands)',
			'fa-brands fa-itunes (brands)',
			'fa-brands fa-itunes-note (brands)',
			'fa-solid fa-j (solid)',
			'fa-solid fa-jar (solid)',
			'fa-solid fa-jar-wheat (solid)',
			'fa-brands fa-java (brands)',
			'fa-solid fa-jedi (solid)',
			'fa-brands fa-jedi-order (brands)',
			'fa-brands fa-jenkins (brands)',
			'fa-solid fa-jet-fighter (solid)',
			'fa-solid fa-jet-fighter-up (solid)',
			'fa-brands fa-jira (brands)',
			'fa-brands fa-joget (brands)',
			'fa-solid fa-joint (solid)',
			'fa-brands fa-joomla (brands)',
			'fa-brands fa-js (brands)',
			'fa-brands fa-jsfiddle (brands)',
			'fa-solid fa-jug-detergent (solid)',
			'fa-solid fa-k (solid)',
			'fa-solid fa-kaaba (solid)',
			'fa-brands fa-kaggle (brands)',
			'fa-solid fa-key (solid)',
			'fa-brands fa-keybase (brands)',
			'fa-solid fa-keyboard (solid)',
			'fa-regular fa-keyboard (regular)',
			'fa-brands fa-keycdn (brands)',
			'fa-solid fa-khanda (solid)',
			'fa-brands fa-kickstarter (brands)',
			'fa-brands fa-kickstarter-k (brands)',
			'fa-solid fa-kip-sign (solid)',
			'fa-solid fa-kit-medical (solid)',
			'fa-solid fa-kitchen-set (solid)',
			'fa-solid fa-kiwi-bird (solid)',
			'fa-brands fa-korvue (brands)',
			'fa-solid fa-l (solid)',
			'fa-solid fa-land-mine-on (solid)',
			'fa-solid fa-landmark (solid)',
			'fa-solid fa-landmark-dome (solid)',
			'fa-solid fa-landmark-flag (solid)',
			'fa-solid fa-language (solid)',
			'fa-solid fa-laptop (solid)',
			'fa-solid fa-laptop-code (solid)',
			'fa-solid fa-laptop-file (solid)',
			'fa-solid fa-laptop-medical (solid)',
			'fa-brands fa-laravel (brands)',
			'fa-solid fa-lari-sign (solid)',
			'fa-brands fa-lastfm (brands)',
			'fa-solid fa-layer-group (solid)',
			'fa-solid fa-leaf (solid)',
			'fa-brands fa-leanpub (brands)',
			'fa-solid fa-left-long (solid)',
			'fa-solid fa-left-right (solid)',
			'fa-solid fa-lemon (solid)',
			'fa-regular fa-lemon (regular)',
			'fa-brands fa-less (brands)',
			'fa-solid fa-less-than (solid)',
			'fa-solid fa-less-than-equal (solid)',
			'fa-brands fa-letterboxd (brands)',
			'fa-solid fa-life-ring (solid)',
			'fa-regular fa-life-ring (regular)',
			'fa-solid fa-lightbulb (solid)',
			'fa-regular fa-lightbulb (regular)',
			'fa-brands fa-line (brands)',
			'fa-solid fa-lines-leaning (solid)',
			'fa-solid fa-link (solid)',
			'fa-solid fa-link-slash (solid)',
			'fa-brands fa-linkedin (brands)',
			'fa-brands fa-linkedin-in (brands)',
			'fa-brands fa-linode (brands)',
			'fa-brands fa-linux (brands)',
			'fa-solid fa-lira-sign (solid)',
			'fa-solid fa-list (solid)',
			'fa-solid fa-list-check (solid)',
			'fa-solid fa-list-ol (solid)',
			'fa-solid fa-list-ul (solid)',
			'fa-solid fa-litecoin-sign (solid)',
			'fa-solid fa-location-arrow (solid)',
			'fa-solid fa-location-crosshairs (solid)',
			'fa-solid fa-location-dot (solid)',
			'fa-solid fa-location-pin (solid)',
			'fa-solid fa-location-pin-lock (solid)',
			'fa-solid fa-lock (solid)',
			'fa-solid fa-lock-open (solid)',
			'fa-solid fa-locust (solid)',
			'fa-solid fa-lungs (solid)',
			'fa-solid fa-lungs-virus (solid)',
			'fa-brands fa-lyft (brands)',
			'fa-solid fa-m (solid)',
			'fa-brands fa-magento (brands)',
			'fa-solid fa-magnet (solid)',
			'fa-solid fa-magnifying-glass (solid)',
			'fa-solid fa-magnifying-glass-arrow-right (solid)',
			'fa-solid fa-magnifying-glass-chart (solid)',
			'fa-solid fa-magnifying-glass-dollar (solid)',
			'fa-solid fa-magnifying-glass-location (solid)',
			'fa-solid fa-magnifying-glass-minus (solid)',
			'fa-solid fa-magnifying-glass-plus (solid)',
			'fa-brands fa-mailchimp (brands)',
			'fa-solid fa-manat-sign (solid)',
			'fa-brands fa-mandalorian (brands)',
			'fa-solid fa-map (solid)',
			'fa-regular fa-map (regular)',
			'fa-solid fa-map-location (solid)',
			'fa-solid fa-map-location-dot (solid)',
			'fa-solid fa-map-pin (solid)',
			'fa-brands fa-markdown (brands)',
			'fa-solid fa-marker (solid)',
			'fa-solid fa-mars (solid)',
			'fa-solid fa-mars-and-venus (solid)',
			'fa-solid fa-mars-and-venus-burst (solid)',
			'fa-solid fa-mars-double (solid)',
			'fa-solid fa-mars-stroke (solid)',
			'fa-solid fa-mars-stroke-right (solid)',
			'fa-solid fa-mars-stroke-up (solid)',
			'fa-solid fa-martini-glass (solid)',
			'fa-solid fa-martini-glass-citrus (solid)',
			'fa-solid fa-martini-glass-empty (solid)',
			'fa-solid fa-mask (solid)',
			'fa-solid fa-mask-face (solid)',
			'fa-solid fa-mask-ventilator (solid)',
			'fa-solid fa-masks-theater (solid)',
			'fa-brands fa-mastodon (brands)',
			'fa-solid fa-mattress-pillow (solid)',
			'fa-brands fa-maxcdn (brands)',
			'fa-solid fa-maximize (solid)',
			'fa-brands fa-mdb (brands)',
			'fa-solid fa-medal (solid)',
			'fa-brands fa-medapps (brands)',
			'fa-brands fa-medium (brands)',
			'fa-brands fa-medrt (brands)',
			'fa-brands fa-meetup (brands)',
			'fa-brands fa-megaport (brands)',
			'fa-solid fa-memory (solid)',
			'fa-brands fa-mendeley (brands)',
			'fa-solid fa-menorah (solid)',
			'fa-solid fa-mercury (solid)',
			'fa-solid fa-message (solid)',
			'fa-regular fa-message (regular)',
			'fa-brands fa-meta (brands)',
			'fa-solid fa-meteor (solid)',
			'fa-brands fa-microblog (brands)',
			'fa-solid fa-microchip (solid)',
			'fa-solid fa-microphone (solid)',
			'fa-solid fa-microphone-lines (solid)',
			'fa-solid fa-microphone-lines-slash (solid)',
			'fa-solid fa-microphone-slash (solid)',
			'fa-solid fa-microscope (solid)',
			'fa-brands fa-microsoft (brands)',
			'fa-solid fa-mill-sign (solid)',
			'fa-solid fa-minimize (solid)',
			'fa-brands fa-mintbit (brands)',
			'fa-solid fa-minus (solid)',
			'fa-solid fa-mitten (solid)',
			'fa-brands fa-mix (brands)',
			'fa-brands fa-mixcloud (brands)',
			'fa-brands fa-mixer (brands)',
			'fa-brands fa-mizuni (brands)',
			'fa-solid fa-mobile (solid)',
			'fa-solid fa-mobile-button (solid)',
			'fa-solid fa-mobile-retro (solid)',
			'fa-solid fa-mobile-screen (solid)',
			'fa-solid fa-mobile-screen-button (solid)',
			'fa-brands fa-modx (brands)',
			'fa-brands fa-monero (brands)',
			'fa-solid fa-money-bill (solid)',
			'fa-solid fa-money-bill-1 (solid)',
			'fa-regular fa-money-bill-1 (regular)',
			'fa-solid fa-money-bill-1-wave (solid)',
			'fa-solid fa-money-bill-transfer (solid)',
			'fa-solid fa-money-bill-trend-up (solid)',
			'fa-solid fa-money-bill-wave (solid)',
			'fa-solid fa-money-bill-wheat (solid)',
			'fa-solid fa-money-bills (solid)',
			'fa-solid fa-money-check (solid)',
			'fa-solid fa-money-check-dollar (solid)',
			'fa-solid fa-monument (solid)',
			'fa-solid fa-moon (solid)',
			'fa-regular fa-moon (regular)',
			'fa-solid fa-mortar-pestle (solid)',
			'fa-solid fa-mosque (solid)',
			'fa-solid fa-mosquito (solid)',
			'fa-solid fa-mosquito-net (solid)',
			'fa-solid fa-motorcycle (solid)',
			'fa-solid fa-mound (solid)',
			'fa-solid fa-mountain (solid)',
			'fa-solid fa-mountain-city (solid)',
			'fa-solid fa-mountain-sun (solid)',
			'fa-solid fa-mug-hot (solid)',
			'fa-solid fa-mug-saucer (solid)',
			'fa-solid fa-music (solid)',
			'fa-solid fa-n (solid)',
			'fa-solid fa-naira-sign (solid)',
			'fa-brands fa-napster (brands)',
			'fa-brands fa-neos (brands)',
			'fa-solid fa-network-wired (solid)',
			'fa-solid fa-neuter (solid)',
			'fa-solid fa-newspaper (solid)',
			'fa-regular fa-newspaper (regular)',
			'fa-brands fa-nfc-directional (brands)',
			'fa-brands fa-nfc-symbol (brands)',
			'fa-brands fa-nimblr (brands)',
			'fa-brands fa-node (brands)',
			'fa-brands fa-node-js (brands)',
			'fa-solid fa-not-equal (solid)',
			'fa-solid fa-notdef (solid)',
			'fa-solid fa-note-sticky (solid)',
			'fa-regular fa-note-sticky (regular)',
			'fa-solid fa-notes-medical (solid)',
			'fa-brands fa-npm (brands)',
			'fa-brands fa-ns8 (brands)',
			'fa-brands fa-nutritionix (brands)',
			'fa-solid fa-o (solid)',
			'fa-solid fa-object-group (solid)',
			'fa-regular fa-object-group (regular)',
			'fa-solid fa-object-ungroup (solid)',
			'fa-regular fa-object-ungroup (regular)',
			'fa-brands fa-octopus-deploy (brands)',
			'fa-brands fa-odnoklassniki (brands)',
			'fa-brands fa-odysee (brands)',
			'fa-solid fa-oil-can (solid)',
			'fa-solid fa-oil-well (solid)',
			'fa-brands fa-old-republic (brands)',
			'fa-solid fa-om (solid)',
			'fa-brands fa-opencart (brands)',
			'fa-brands fa-openid (brands)',
			'fa-brands fa-opensuse (brands)',
			'fa-brands fa-opera (brands)',
			'fa-brands fa-optin-monster (brands)',
			'fa-brands fa-orcid (brands)',
			'fa-brands fa-osi (brands)',
			'fa-solid fa-otter (solid)',
			'fa-solid fa-outdent (solid)',
			'fa-solid fa-p (solid)',
			'fa-brands fa-padlet (brands)',
			'fa-brands fa-page4 (brands)',
			'fa-brands fa-pagelines (brands)',
			'fa-solid fa-pager (solid)',
			'fa-solid fa-paint-roller (solid)',
			'fa-solid fa-paintbrush (solid)',
			'fa-solid fa-palette (solid)',
			'fa-brands fa-palfed (brands)',
			'fa-solid fa-pallet (solid)',
			'fa-solid fa-panorama (solid)',
			'fa-solid fa-paper-plane (solid)',
			'fa-regular fa-paper-plane (regular)',
			'fa-solid fa-paperclip (solid)',
			'fa-solid fa-parachute-box (solid)',
			'fa-solid fa-paragraph (solid)',
			'fa-solid fa-passport (solid)',
			'fa-solid fa-paste (solid)',
			'fa-regular fa-paste (regular)',
			'fa-brands fa-patreon (brands)',
			'fa-solid fa-pause (solid)',
			'fa-solid fa-paw (solid)',
			'fa-brands fa-paypal (brands)',
			'fa-solid fa-peace (solid)',
			'fa-solid fa-pen (solid)',
			'fa-solid fa-pen-clip (solid)',
			'fa-solid fa-pen-fancy (solid)',
			'fa-solid fa-pen-nib (solid)',
			'fa-solid fa-pen-ruler (solid)',
			'fa-solid fa-pen-to-square (solid)',
			'fa-regular fa-pen-to-square (regular)',
			'fa-solid fa-pencil (solid)',
			'fa-solid fa-people-arrows (solid)',
			'fa-solid fa-people-carry-box (solid)',
			'fa-solid fa-people-group (solid)',
			'fa-solid fa-people-line (solid)',
			'fa-solid fa-people-pulling (solid)',
			'fa-solid fa-people-robbery (solid)',
			'fa-solid fa-people-roof (solid)',
			'fa-solid fa-pepper-hot (solid)',
			'fa-brands fa-perbyte (brands)',
			'fa-solid fa-percent (solid)',
			'fa-brands fa-periscope (brands)',
			'fa-solid fa-person (solid)',
			'fa-solid fa-person-arrow-down-to-line (solid)',
			'fa-solid fa-person-arrow-up-from-line (solid)',
			'fa-solid fa-person-biking (solid)',
			'fa-solid fa-person-booth (solid)',
			'fa-solid fa-person-breastfeeding (solid)',
			'fa-solid fa-person-burst (solid)',
			'fa-solid fa-person-cane (solid)',
			'fa-solid fa-person-chalkboard (solid)',
			'fa-solid fa-person-circle-check (solid)',
			'fa-solid fa-person-circle-exclamation (solid)',
			'fa-solid fa-person-circle-minus (solid)',
			'fa-solid fa-person-circle-plus (solid)',
			'fa-solid fa-person-circle-question (solid)',
			'fa-solid fa-person-circle-xmark (solid)',
			'fa-solid fa-person-digging (solid)',
			'fa-solid fa-person-dots-from-line (solid)',
			'fa-solid fa-person-dress (solid)',
			'fa-solid fa-person-dress-burst (solid)',
			'fa-solid fa-person-drowning (solid)',
			'fa-solid fa-person-falling (solid)',
			'fa-solid fa-person-falling-burst (solid)',
			'fa-solid fa-person-half-dress (solid)',
			'fa-solid fa-person-harassing (solid)',
			'fa-solid fa-person-hiking (solid)',
			'fa-solid fa-person-military-pointing (solid)',
			'fa-solid fa-person-military-rifle (solid)',
			'fa-solid fa-person-military-to-person (solid)',
			'fa-solid fa-person-praying (solid)',
			'fa-solid fa-person-pregnant (solid)',
			'fa-solid fa-person-rays (solid)',
			'fa-solid fa-person-rifle (solid)',
			'fa-solid fa-person-running (solid)',
			'fa-solid fa-person-shelter (solid)',
			'fa-solid fa-person-skating (solid)',
			'fa-solid fa-person-skiing (solid)',
			'fa-solid fa-person-skiing-nordic (solid)',
			'fa-solid fa-person-snowboarding (solid)',
			'fa-solid fa-person-swimming (solid)',
			'fa-solid fa-person-through-window (solid)',
			'fa-solid fa-person-walking (solid)',
			'fa-solid fa-person-walking-arrow-loop-left (solid)',
			'fa-solid fa-person-walking-arrow-right (solid)',
			'fa-solid fa-person-walking-dashed-line-arrow-right (solid)',
			'fa-solid fa-person-walking-luggage (solid)',
			'fa-solid fa-person-walking-with-cane (solid)',
			'fa-solid fa-peseta-sign (solid)',
			'fa-solid fa-peso-sign (solid)',
			'fa-brands fa-phabricator (brands)',
			'fa-brands fa-phoenix-framework (brands)',
			'fa-brands fa-phoenix-squadron (brands)',
			'fa-solid fa-phone (solid)',
			'fa-solid fa-phone-flip (solid)',
			'fa-solid fa-phone-slash (solid)',
			'fa-solid fa-phone-volume (solid)',
			'fa-solid fa-photo-film (solid)',
			'fa-brands fa-php (brands)',
			'fa-brands fa-pied-piper (brands)',
			'fa-brands fa-pied-piper-alt (brands)',
			'fa-brands fa-pied-piper-hat (brands)',
			'fa-brands fa-pied-piper-pp (brands)',
			'fa-solid fa-piggy-bank (solid)',
			'fa-solid fa-pills (solid)',
			'fa-brands fa-pinterest (brands)',
			'fa-brands fa-pinterest-p (brands)',
			'fa-brands fa-pix (brands)',
			'fa-brands fa-pixiv (brands)',
			'fa-solid fa-pizza-slice (solid)',
			'fa-solid fa-place-of-worship (solid)',
			'fa-solid fa-plane (solid)',
			'fa-solid fa-plane-arrival (solid)',
			'fa-solid fa-plane-circle-check (solid)',
			'fa-solid fa-plane-circle-exclamation (solid)',
			'fa-solid fa-plane-circle-xmark (solid)',
			'fa-solid fa-plane-departure (solid)',
			'fa-solid fa-plane-lock (solid)',
			'fa-solid fa-plane-slash (solid)',
			'fa-solid fa-plane-up (solid)',
			'fa-solid fa-plant-wilt (solid)',
			'fa-solid fa-plate-wheat (solid)',
			'fa-solid fa-play (solid)',
			'fa-brands fa-playstation (brands)',
			'fa-solid fa-plug (solid)',
			'fa-solid fa-plug-circle-bolt (solid)',
			'fa-solid fa-plug-circle-check (solid)',
			'fa-solid fa-plug-circle-exclamation (solid)',
			'fa-solid fa-plug-circle-minus (solid)',
			'fa-solid fa-plug-circle-plus (solid)',
			'fa-solid fa-plug-circle-xmark (solid)',
			'fa-solid fa-plus (solid)',
			'fa-solid fa-plus-minus (solid)',
			'fa-solid fa-podcast (solid)',
			'fa-solid fa-poo (solid)',
			'fa-solid fa-poo-storm (solid)',
			'fa-solid fa-poop (solid)',
			'fa-solid fa-power-off (solid)',
			'fa-solid fa-prescription (solid)',
			'fa-solid fa-prescription-bottle (solid)',
			'fa-solid fa-prescription-bottle-medical (solid)',
			'fa-solid fa-print (solid)',
			'fa-brands fa-product-hunt (brands)',
			'fa-solid fa-pump-medical (solid)',
			'fa-solid fa-pump-soap (solid)',
			'fa-brands fa-pushed (brands)',
			'fa-solid fa-puzzle-piece (solid)',
			'fa-brands fa-python (brands)',
			'fa-solid fa-q (solid)',
			'fa-brands fa-qq (brands)',
			'fa-solid fa-qrcode (solid)',
			'fa-solid fa-question (solid)',
			'fa-brands fa-quinscape (brands)',
			'fa-brands fa-quora (brands)',
			'fa-solid fa-quote-left (solid)',
			'fa-solid fa-quote-right (solid)',
			'fa-solid fa-r (solid)',
			'fa-brands fa-r-project (brands)',
			'fa-solid fa-radiation (solid)',
			'fa-solid fa-radio (solid)',
			'fa-solid fa-rainbow (solid)',
			'fa-solid fa-ranking-star (solid)',
			'fa-brands fa-raspberry-pi (brands)',
			'fa-brands fa-ravelry (brands)',
			'fa-brands fa-react (brands)',
			'fa-brands fa-reacteurope (brands)',
			'fa-brands fa-readme (brands)',
			'fa-brands fa-rebel (brands)',
			'fa-solid fa-receipt (solid)',
			'fa-solid fa-record-vinyl (solid)',
			'fa-solid fa-rectangle-ad (solid)',
			'fa-solid fa-rectangle-list (solid)',
			'fa-regular fa-rectangle-list (regular)',
			'fa-solid fa-rectangle-xmark (solid)',
			'fa-regular fa-rectangle-xmark (regular)',
			'fa-solid fa-recycle (solid)',
			'fa-brands fa-red-river (brands)',
			'fa-brands fa-reddit (brands)',
			'fa-brands fa-reddit-alien (brands)',
			'fa-brands fa-redhat (brands)',
			'fa-solid fa-registered (solid)',
			'fa-regular fa-registered (regular)',
			'fa-brands fa-renren (brands)',
			'fa-solid fa-repeat (solid)',
			'fa-solid fa-reply (solid)',
			'fa-solid fa-reply-all (solid)',
			'fa-brands fa-replyd (brands)',
			'fa-solid fa-republican (solid)',
			'fa-brands fa-researchgate (brands)',
			'fa-brands fa-resolving (brands)',
			'fa-solid fa-restroom (solid)',
			'fa-solid fa-retweet (solid)',
			'fa-brands fa-rev (brands)',
			'fa-solid fa-ribbon (solid)',
			'fa-solid fa-right-from-bracket (solid)',
			'fa-solid fa-right-left (solid)',
			'fa-solid fa-right-long (solid)',
			'fa-solid fa-right-to-bracket (solid)',
			'fa-solid fa-ring (solid)',
			'fa-solid fa-road (solid)',
			'fa-solid fa-road-barrier (solid)',
			'fa-solid fa-road-bridge (solid)',
			'fa-solid fa-road-circle-check (solid)',
			'fa-solid fa-road-circle-exclamation (solid)',
			'fa-solid fa-road-circle-xmark (solid)',
			'fa-solid fa-road-lock (solid)',
			'fa-solid fa-road-spikes (solid)',
			'fa-solid fa-robot (solid)',
			'fa-solid fa-rocket (solid)',
			'fa-brands fa-rocketchat (brands)',
			'fa-brands fa-rockrms (brands)',
			'fa-solid fa-rotate (solid)',
			'fa-solid fa-rotate-left (solid)',
			'fa-solid fa-rotate-right (solid)',
			'fa-solid fa-route (solid)',
			'fa-solid fa-rss (solid)',
			'fa-solid fa-ruble-sign (solid)',
			'fa-solid fa-rug (solid)',
			'fa-solid fa-ruler (solid)',
			'fa-solid fa-ruler-combined (solid)',
			'fa-solid fa-ruler-horizontal (solid)',
			'fa-solid fa-ruler-vertical (solid)',
			'fa-solid fa-rupee-sign (solid)',
			'fa-solid fa-rupiah-sign (solid)',
			'fa-brands fa-rust (brands)',
			'fa-solid fa-s (solid)',
			'fa-solid fa-sack-dollar (solid)',
			'fa-solid fa-sack-xmark (solid)',
			'fa-brands fa-safari (brands)',
			'fa-solid fa-sailboat (solid)',
			'fa-brands fa-salesforce (brands)',
			'fa-brands fa-sass (brands)',
			'fa-solid fa-satellite (solid)',
			'fa-solid fa-satellite-dish (solid)',
			'fa-solid fa-scale-balanced (solid)',
			'fa-solid fa-scale-unbalanced (solid)',
			'fa-solid fa-scale-unbalanced-flip (solid)',
			'fa-brands fa-schlix (brands)',
			'fa-solid fa-school (solid)',
			'fa-solid fa-school-circle-check (solid)',
			'fa-solid fa-school-circle-exclamation (solid)',
			'fa-solid fa-school-circle-xmark (solid)',
			'fa-solid fa-school-flag (solid)',
			'fa-solid fa-school-lock (solid)',
			'fa-solid fa-scissors (solid)',
			'fa-brands fa-screenpal (brands)',
			'fa-solid fa-screwdriver (solid)',
			'fa-solid fa-screwdriver-wrench (solid)',
			'fa-brands fa-scribd (brands)',
			'fa-solid fa-scroll (solid)',
			'fa-solid fa-scroll-torah (solid)',
			'fa-solid fa-sd-card (solid)',
			'fa-brands fa-searchengin (brands)',
			'fa-solid fa-section (solid)',
			'fa-solid fa-seedling (solid)',
			'fa-brands fa-sellcast (brands)',
			'fa-brands fa-sellsy (brands)',
			'fa-solid fa-server (solid)',
			'fa-brands fa-servicestack (brands)',
			'fa-solid fa-shapes (solid)',
			'fa-solid fa-share (solid)',
			'fa-solid fa-share-from-square (solid)',
			'fa-regular fa-share-from-square (regular)',
			'fa-solid fa-share-nodes (solid)',
			'fa-solid fa-sheet-plastic (solid)',
			'fa-solid fa-shekel-sign (solid)',
			'fa-solid fa-shield (solid)',
			'fa-solid fa-shield-cat (solid)',
			'fa-solid fa-shield-dog (solid)',
			'fa-solid fa-shield-halved (solid)',
			'fa-solid fa-shield-heart (solid)',
			'fa-solid fa-shield-virus (solid)',
			'fa-solid fa-ship (solid)',
			'fa-solid fa-shirt (solid)',
			'fa-brands fa-shirtsinbulk (brands)',
			'fa-solid fa-shoe-prints (solid)',
			'fa-brands fa-shoelace (brands)',
			'fa-solid fa-shop (solid)',
			'fa-solid fa-shop-lock (solid)',
			'fa-solid fa-shop-slash (solid)',
			'fa-brands fa-shopify (brands)',
			'fa-brands fa-shopware (brands)',
			'fa-solid fa-shower (solid)',
			'fa-solid fa-shrimp (solid)',
			'fa-solid fa-shuffle (solid)',
			'fa-solid fa-shuttle-space (solid)',
			'fa-solid fa-sign-hanging (solid)',
			'fa-solid fa-signal (solid)',
			'fa-brands fa-signal-messenger (brands)',
			'fa-solid fa-signature (solid)',
			'fa-solid fa-signs-post (solid)',
			'fa-solid fa-sim-card (solid)',
			'fa-brands fa-simplybuilt (brands)',
			'fa-solid fa-sink (solid)',
			'fa-brands fa-sistrix (brands)',
			'fa-solid fa-sitemap (solid)',
			'fa-brands fa-sith (brands)',
			'fa-brands fa-sitrox (brands)',
			'fa-brands fa-sketch (brands)',
			'fa-solid fa-skull (solid)',
			'fa-solid fa-skull-crossbones (solid)',
			'fa-brands fa-skyatlas (brands)',
			'fa-brands fa-skype (brands)',
			'fa-brands fa-slack (brands)',
			'fa-solid fa-slash (solid)',
			'fa-solid fa-sleigh (solid)',
			'fa-solid fa-sliders (solid)',
			'fa-brands fa-slideshare (brands)',
			'fa-solid fa-smog (solid)',
			'fa-solid fa-smoking (solid)',
			'fa-brands fa-snapchat (brands)',
			'fa-solid fa-snowflake (solid)',
			'fa-regular fa-snowflake (regular)',
			'fa-solid fa-snowman (solid)',
			'fa-solid fa-snowplow (solid)',
			'fa-solid fa-soap (solid)',
			'fa-solid fa-socks (solid)',
			'fa-solid fa-solar-panel (solid)',
			'fa-solid fa-sort (solid)',
			'fa-solid fa-sort-down (solid)',
			'fa-solid fa-sort-up (solid)',
			'fa-brands fa-soundcloud (brands)',
			'fa-brands fa-sourcetree (brands)',
			'fa-solid fa-spa (solid)',
			'fa-brands fa-space-awesome (brands)',
			'fa-solid fa-spaghetti-monster-flying (solid)',
			'fa-brands fa-speakap (brands)',
			'fa-brands fa-speaker-deck (brands)',
			'fa-solid fa-spell-check (solid)',
			'fa-solid fa-spider (solid)',
			'fa-solid fa-spinner (solid)',
			'fa-solid fa-splotch (solid)',
			'fa-solid fa-spoon (solid)',
			'fa-brands fa-spotify (brands)',
			'fa-solid fa-spray-can (solid)',
			'fa-solid fa-spray-can-sparkles (solid)',
			'fa-solid fa-square (solid)',
			'fa-regular fa-square (regular)',
			'fa-solid fa-square-arrow-up-right (solid)',
			'fa-brands fa-square-behance (brands)',
			'fa-solid fa-square-caret-down (solid)',
			'fa-regular fa-square-caret-down (regular)',
			'fa-solid fa-square-caret-left (solid)',
			'fa-regular fa-square-caret-left (regular)',
			'fa-solid fa-square-caret-right (solid)',
			'fa-regular fa-square-caret-right (regular)',
			'fa-solid fa-square-caret-up (solid)',
			'fa-regular fa-square-caret-up (regular)',
			'fa-solid fa-square-check (solid)',
			'fa-regular fa-square-check (regular)',
			'fa-brands fa-square-dribbble (brands)',
			'fa-solid fa-square-envelope (solid)',
			'fa-brands fa-square-facebook (brands)',
			'fa-brands fa-square-font-awesome (brands)',
			'fa-brands fa-square-font-awesome-stroke (brands)',
			'fa-solid fa-square-full (solid)',
			'fa-regular fa-square-full (regular)',
			'fa-brands fa-square-git (brands)',
			'fa-brands fa-square-github (brands)',
			'fa-brands fa-square-gitlab (brands)',
			'fa-brands fa-square-google-plus (brands)',
			'fa-solid fa-square-h (solid)',
			'fa-brands fa-square-hacker-news (brands)',
			'fa-brands fa-square-instagram (brands)',
			'fa-brands fa-square-js (brands)',
			'fa-brands fa-square-lastfm (brands)',
			'fa-brands fa-square-letterboxd (brands)',
			'fa-solid fa-square-minus (solid)',
			'fa-regular fa-square-minus (regular)',
			'fa-solid fa-square-nfi (solid)',
			'fa-brands fa-square-odnoklassniki (brands)',
			'fa-solid fa-square-parking (solid)',
			'fa-solid fa-square-pen (solid)',
			'fa-solid fa-square-person-confined (solid)',
			'fa-solid fa-square-phone (solid)',
			'fa-solid fa-square-phone-flip (solid)',
			'fa-brands fa-square-pied-piper (brands)',
			'fa-brands fa-square-pinterest (brands)',
			'fa-solid fa-square-plus (solid)',
			'fa-regular fa-square-plus (regular)',
			'fa-solid fa-square-poll-horizontal (solid)',
			'fa-solid fa-square-poll-vertical (solid)',
			'fa-brands fa-square-reddit (brands)',
			'fa-solid fa-square-root-variable (solid)',
			'fa-solid fa-square-rss (solid)',
			'fa-solid fa-square-share-nodes (solid)',
			'fa-brands fa-square-snapchat (brands)',
			'fa-brands fa-square-steam (brands)',
			'fa-brands fa-square-threads (brands)',
			'fa-brands fa-square-tumblr (brands)',
			'fa-brands fa-square-twitter (brands)',
			'fa-solid fa-square-up-right (solid)',
			'fa-brands fa-square-viadeo (brands)',
			'fa-brands fa-square-vimeo (brands)',
			'fa-solid fa-square-virus (solid)',
			'fa-brands fa-square-whatsapp (brands)',
			'fa-brands fa-square-x-twitter (brands)',
			'fa-brands fa-square-xing (brands)',
			'fa-solid fa-square-xmark (solid)',
			'fa-brands fa-square-youtube (brands)',
			'fa-brands fa-squarespace (brands)',
			'fa-brands fa-stack-exchange (brands)',
			'fa-brands fa-stack-overflow (brands)',
			'fa-brands fa-stackpath (brands)',
			'fa-solid fa-staff-snake (solid)',
			'fa-solid fa-stairs (solid)',
			'fa-solid fa-stamp (solid)',
			'fa-solid fa-stapler (solid)',
			'fa-solid fa-star (solid)',
			'fa-regular fa-star (regular)',
			'fa-solid fa-star-and-crescent (solid)',
			'fa-solid fa-star-half (solid)',
			'fa-regular fa-star-half (regular)',
			'fa-solid fa-star-half-stroke (solid)',
			'fa-regular fa-star-half-stroke (regular)',
			'fa-solid fa-star-of-david (solid)',
			'fa-solid fa-star-of-life (solid)',
			'fa-brands fa-staylinked (brands)',
			'fa-brands fa-steam (brands)',
			'fa-brands fa-steam-symbol (brands)',
			'fa-solid fa-sterling-sign (solid)',
			'fa-solid fa-stethoscope (solid)',
			'fa-brands fa-sticker-mule (brands)',
			'fa-solid fa-stop (solid)',
			'fa-solid fa-stopwatch (solid)',
			'fa-solid fa-stopwatch-20 (solid)',
			'fa-solid fa-store (solid)',
			'fa-solid fa-store-slash (solid)',
			'fa-brands fa-strava (brands)',
			'fa-solid fa-street-view (solid)',
			'fa-solid fa-strikethrough (solid)',
			'fa-brands fa-stripe (brands)',
			'fa-brands fa-stripe-s (brands)',
			'fa-solid fa-stroopwafel (solid)',
			'fa-brands fa-stubber (brands)',
			'fa-brands fa-studiovinari (brands)',
			'fa-brands fa-stumbleupon (brands)',
			'fa-brands fa-stumbleupon-circle (brands)',
			'fa-solid fa-subscript (solid)',
			'fa-solid fa-suitcase (solid)',
			'fa-solid fa-suitcase-medical (solid)',
			'fa-solid fa-suitcase-rolling (solid)',
			'fa-solid fa-sun (solid)',
			'fa-regular fa-sun (regular)',
			'fa-solid fa-sun-plant-wilt (solid)',
			'fa-brands fa-superpowers (brands)',
			'fa-solid fa-superscript (solid)',
			'fa-brands fa-supple (brands)',
			'fa-brands fa-suse (brands)',
			'fa-solid fa-swatchbook (solid)',
			'fa-brands fa-swift (brands)',
			'fa-brands fa-symfony (brands)',
			'fa-solid fa-synagogue (solid)',
			'fa-solid fa-syringe (solid)',
			'fa-solid fa-t (solid)',
			'fa-solid fa-table (solid)',
			'fa-solid fa-table-cells (solid)',
			'fa-solid fa-table-cells-large (solid)',
			'fa-solid fa-table-columns (solid)',
			'fa-solid fa-table-list (solid)',
			'fa-solid fa-table-tennis-paddle-ball (solid)',
			'fa-solid fa-tablet (solid)',
			'fa-solid fa-tablet-button (solid)',
			'fa-solid fa-tablet-screen-button (solid)',
			'fa-solid fa-tablets (solid)',
			'fa-solid fa-tachograph-digital (solid)',
			'fa-solid fa-tag (solid)',
			'fa-solid fa-tags (solid)',
			'fa-solid fa-tape (solid)',
			'fa-solid fa-tarp (solid)',
			'fa-solid fa-tarp-droplet (solid)',
			'fa-solid fa-taxi (solid)',
			'fa-brands fa-teamspeak (brands)',
			'fa-solid fa-teeth (solid)',
			'fa-solid fa-teeth-open (solid)',
			'fa-brands fa-telegram (brands)',
			'fa-solid fa-temperature-arrow-down (solid)',
			'fa-solid fa-temperature-arrow-up (solid)',
			'fa-solid fa-temperature-empty (solid)',
			'fa-solid fa-temperature-full (solid)',
			'fa-solid fa-temperature-half (solid)',
			'fa-solid fa-temperature-high (solid)',
			'fa-solid fa-temperature-low (solid)',
			'fa-solid fa-temperature-quarter (solid)',
			'fa-solid fa-temperature-three-quarters (solid)',
			'fa-brands fa-tencent-weibo (brands)',
			'fa-solid fa-tenge-sign (solid)',
			'fa-solid fa-tent (solid)',
			'fa-solid fa-tent-arrow-down-to-line (solid)',
			'fa-solid fa-tent-arrow-left-right (solid)',
			'fa-solid fa-tent-arrow-turn-left (solid)',
			'fa-solid fa-tent-arrows-down (solid)',
			'fa-solid fa-tents (solid)',
			'fa-solid fa-terminal (solid)',
			'fa-solid fa-text-height (solid)',
			'fa-solid fa-text-slash (solid)',
			'fa-solid fa-text-width (solid)',
			'fa-brands fa-the-red-yeti (brands)',
			'fa-brands fa-themeco (brands)',
			'fa-brands fa-themeisle (brands)',
			'fa-solid fa-thermometer (solid)',
			'fa-brands fa-think-peaks (brands)',
			'fa-brands fa-threads (brands)',
			'fa-solid fa-thumbs-down (solid)',
			'fa-regular fa-thumbs-down (regular)',
			'fa-solid fa-thumbs-up (solid)',
			'fa-regular fa-thumbs-up (regular)',
			'fa-solid fa-thumbtack (solid)',
			'fa-solid fa-ticket (solid)',
			'fa-solid fa-ticket-simple (solid)',
			'fa-brands fa-tiktok (brands)',
			'fa-solid fa-timeline (solid)',
			'fa-solid fa-toggle-off (solid)',
			'fa-solid fa-toggle-on (solid)',
			'fa-solid fa-toilet (solid)',
			'fa-solid fa-toilet-paper (solid)',
			'fa-solid fa-toilet-paper-slash (solid)',
			'fa-solid fa-toilet-portable (solid)',
			'fa-solid fa-toilets-portable (solid)',
			'fa-solid fa-toolbox (solid)',
			'fa-solid fa-tooth (solid)',
			'fa-solid fa-torii-gate (solid)',
			'fa-solid fa-tornado (solid)',
			'fa-solid fa-tower-broadcast (solid)',
			'fa-solid fa-tower-cell (solid)',
			'fa-solid fa-tower-observation (solid)',
			'fa-solid fa-tractor (solid)',
			'fa-brands fa-trade-federation (brands)',
			'fa-solid fa-trademark (solid)',
			'fa-solid fa-traffic-light (solid)',
			'fa-solid fa-trailer (solid)',
			'fa-solid fa-train (solid)',
			'fa-solid fa-train-subway (solid)',
			'fa-solid fa-train-tram (solid)',
			'fa-solid fa-transgender (solid)',
			'fa-solid fa-trash (solid)',
			'fa-solid fa-trash-arrow-up (solid)',
			'fa-solid fa-trash-can (solid)',
			'fa-regular fa-trash-can (regular)',
			'fa-solid fa-trash-can-arrow-up (solid)',
			'fa-solid fa-tree (solid)',
			'fa-solid fa-tree-city (solid)',
			'fa-brands fa-trello (brands)',
			'fa-solid fa-triangle-exclamation (solid)',
			'fa-solid fa-trophy (solid)',
			'fa-solid fa-trowel (solid)',
			'fa-solid fa-trowel-bricks (solid)',
			'fa-solid fa-truck (solid)',
			'fa-solid fa-truck-arrow-right (solid)',
			'fa-solid fa-truck-droplet (solid)',
			'fa-solid fa-truck-fast (solid)',
			'fa-solid fa-truck-field (solid)',
			'fa-solid fa-truck-field-un (solid)',
			'fa-solid fa-truck-front (solid)',
			'fa-solid fa-truck-medical (solid)',
			'fa-solid fa-truck-monster (solid)',
			'fa-solid fa-truck-moving (solid)',
			'fa-solid fa-truck-pickup (solid)',
			'fa-solid fa-truck-plane (solid)',
			'fa-solid fa-truck-ramp-box (solid)',
			'fa-solid fa-tty (solid)',
			'fa-brands fa-tumblr (brands)',
			'fa-solid fa-turkish-lira-sign (solid)',
			'fa-solid fa-turn-down (solid)',
			'fa-solid fa-turn-up (solid)',
			'fa-solid fa-tv (solid)',
			'fa-brands fa-twitch (brands)',
			'fa-brands fa-twitter (brands)',
			'fa-brands fa-typo3 (brands)',
			'fa-solid fa-u (solid)',
			'fa-brands fa-uber (brands)',
			'fa-brands fa-ubuntu (brands)',
			'fa-brands fa-uikit (brands)',
			'fa-brands fa-umbraco (brands)',
			'fa-solid fa-umbrella (solid)',
			'fa-solid fa-umbrella-beach (solid)',
			'fa-brands fa-uncharted (brands)',
			'fa-solid fa-underline (solid)',
			'fa-brands fa-uniregistry (brands)',
			'fa-brands fa-unity (brands)',
			'fa-solid fa-universal-access (solid)',
			'fa-solid fa-unlock (solid)',
			'fa-solid fa-unlock-keyhole (solid)',
			'fa-brands fa-unsplash (brands)',
			'fa-brands fa-untappd (brands)',
			'fa-solid fa-up-down (solid)',
			'fa-solid fa-up-down-left-right (solid)',
			'fa-solid fa-up-long (solid)',
			'fa-solid fa-up-right-and-down-left-from-center (solid)',
			'fa-solid fa-up-right-from-square (solid)',
			'fa-solid fa-upload (solid)',
			'fa-brands fa-ups (brands)',
			'fa-brands fa-upwork (brands)',
			'fa-brands fa-usb (brands)',
			'fa-solid fa-user (solid)',
			'fa-regular fa-user (regular)',
			'fa-solid fa-user-astronaut (solid)',
			'fa-solid fa-user-check (solid)',
			'fa-solid fa-user-clock (solid)',
			'fa-solid fa-user-doctor (solid)',
			'fa-solid fa-user-gear (solid)',
			'fa-solid fa-user-graduate (solid)',
			'fa-solid fa-user-group (solid)',
			'fa-solid fa-user-injured (solid)',
			'fa-solid fa-user-large (solid)',
			'fa-solid fa-user-large-slash (solid)',
			'fa-solid fa-user-lock (solid)',
			'fa-solid fa-user-minus (solid)',
			'fa-solid fa-user-ninja (solid)',
			'fa-solid fa-user-nurse (solid)',
			'fa-solid fa-user-pen (solid)',
			'fa-solid fa-user-plus (solid)',
			'fa-solid fa-user-secret (solid)',
			'fa-solid fa-user-shield (solid)',
			'fa-solid fa-user-slash (solid)',
			'fa-solid fa-user-tag (solid)',
			'fa-solid fa-user-tie (solid)',
			'fa-solid fa-user-xmark (solid)',
			'fa-solid fa-users (solid)',
			'fa-solid fa-users-between-lines (solid)',
			'fa-solid fa-users-gear (solid)',
			'fa-solid fa-users-line (solid)',
			'fa-solid fa-users-rays (solid)',
			'fa-solid fa-users-rectangle (solid)',
			'fa-solid fa-users-slash (solid)',
			'fa-solid fa-users-viewfinder (solid)',
			'fa-brands fa-usps (brands)',
			'fa-brands fa-ussunnah (brands)',
			'fa-solid fa-utensils (solid)',
			'fa-solid fa-v (solid)',
			'fa-brands fa-vaadin (brands)',
			'fa-solid fa-van-shuttle (solid)',
			'fa-solid fa-vault (solid)',
			'fa-solid fa-vector-square (solid)',
			'fa-solid fa-venus (solid)',
			'fa-solid fa-venus-double (solid)',
			'fa-solid fa-venus-mars (solid)',
			'fa-solid fa-vest (solid)',
			'fa-solid fa-vest-patches (solid)',
			'fa-brands fa-viacoin (brands)',
			'fa-brands fa-viadeo (brands)',
			'fa-solid fa-vial (solid)',
			'fa-solid fa-vial-circle-check (solid)',
			'fa-solid fa-vial-virus (solid)',
			'fa-solid fa-vials (solid)',
			'fa-brands fa-viber (brands)',
			'fa-solid fa-video (solid)',
			'fa-solid fa-video-slash (solid)',
			'fa-solid fa-vihara (solid)',
			'fa-brands fa-vimeo (brands)',
			'fa-brands fa-vimeo-v (brands)',
			'fa-brands fa-vine (brands)',
			'fa-solid fa-virus (solid)',
			'fa-solid fa-virus-covid (solid)',
			'fa-solid fa-virus-covid-slash (solid)',
			'fa-solid fa-virus-slash (solid)',
			'fa-solid fa-viruses (solid)',
			'fa-brands fa-vk (brands)',
			'fa-brands fa-vnv (brands)',
			'fa-solid fa-voicemail (solid)',
			'fa-solid fa-volcano (solid)',
			'fa-solid fa-volleyball (solid)',
			'fa-solid fa-volume-high (solid)',
			'fa-solid fa-volume-low (solid)',
			'fa-solid fa-volume-off (solid)',
			'fa-solid fa-volume-xmark (solid)',
			'fa-solid fa-vr-cardboard (solid)',
			'fa-brands fa-vuejs (brands)',
			'fa-solid fa-w (solid)',
			'fa-solid fa-walkie-talkie (solid)',
			'fa-solid fa-wallet (solid)',
			'fa-solid fa-wand-magic (solid)',
			'fa-solid fa-wand-magic-sparkles (solid)',
			'fa-solid fa-wand-sparkles (solid)',
			'fa-solid fa-warehouse (solid)',
			'fa-brands fa-watchman-monitoring (brands)',
			'fa-solid fa-water (solid)',
			'fa-solid fa-water-ladder (solid)',
			'fa-solid fa-wave-square (solid)',
			'fa-brands fa-waze (brands)',
			'fa-brands fa-webflow (brands)',
			'fa-brands fa-weebly (brands)',
			'fa-brands fa-weibo (brands)',
			'fa-solid fa-weight-hanging (solid)',
			'fa-solid fa-weight-scale (solid)',
			'fa-brands fa-weixin (brands)',
			'fa-brands fa-whatsapp (brands)',
			'fa-solid fa-wheat-awn (solid)',
			'fa-solid fa-wheat-awn-circle-exclamation (solid)',
			'fa-solid fa-wheelchair (solid)',
			'fa-solid fa-wheelchair-move (solid)',
			'fa-solid fa-whiskey-glass (solid)',
			'fa-brands fa-whmcs (brands)',
			'fa-solid fa-wifi (solid)',
			'fa-brands fa-wikipedia-w (brands)',
			'fa-solid fa-wind (solid)',
			'fa-solid fa-window-maximize (solid)',
			'fa-regular fa-window-maximize (regular)',
			'fa-solid fa-window-minimize (solid)',
			'fa-regular fa-window-minimize (regular)',
			'fa-solid fa-window-restore (solid)',
			'fa-regular fa-window-restore (regular)',
			'fa-brands fa-windows (brands)',
			'fa-solid fa-wine-bottle (solid)',
			'fa-solid fa-wine-glass (solid)',
			'fa-solid fa-wine-glass-empty (solid)',
			'fa-brands fa-wirsindhandwerk (brands)',
			'fa-brands fa-wix (brands)',
			'fa-brands fa-wizards-of-the-coast (brands)',
			'fa-brands fa-wodu (brands)',
			'fa-brands fa-wolf-pack-battalion (brands)',
			'fa-solid fa-won-sign (solid)',
			'fa-brands fa-wordpress (brands)',
			'fa-brands fa-wordpress-simple (brands)',
			'fa-solid fa-worm (solid)',
			'fa-brands fa-wpbeginner (brands)',
			'fa-brands fa-wpexplorer (brands)',
			'fa-brands fa-wpforms (brands)',
			'fa-brands fa-wpressr (brands)',
			'fa-solid fa-wrench (solid)',
			'fa-solid fa-x (solid)',
			'fa-solid fa-x-ray (solid)',
			'fa-brands fa-x-twitter (brands)',
			'fa-brands fa-xbox (brands)',
			'fa-brands fa-xing (brands)',
			'fa-solid fa-xmark (solid)',
			'fa-solid fa-xmarks-lines (solid)',
			'fa-solid fa-y (solid)',
			'fa-brands fa-y-combinator (brands)',
			'fa-brands fa-yahoo (brands)',
			'fa-brands fa-yammer (brands)',
			'fa-brands fa-yandex (brands)',
			'fa-brands fa-yandex-international (brands)',
			'fa-brands fa-yarn (brands)',
			'fa-brands fa-yelp (brands)',
			'fa-solid fa-yen-sign (solid)',
			'fa-solid fa-yin-yang (solid)',
			'fa-brands fa-yoast (brands)',
			'fa-brands fa-youtube (brands)',
			'fa-solid fa-z (solid)',
			'fa-brands fa-zhihu (brands)'
		);
	}
}
