<?php
/**
 * Flex @package Helix3 Framework
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * Icons changed to a new FontAwesome 6
*/

defined('_JEXEC') or die;

class Helix3FeatureSocial {

	private $helix3;
	public $position;
	public $load_pos;

	public function __construct( $helix3 ){
		$this->helix3 = $helix3;
		$this->position = $this->helix3->getParam('social_position');
		$this->load_pos = $this->helix3->getParam('social_load_pos');
	}

	public function renderFeature() {

		$facebook 	= $this->helix3->getParam('facebook');
		$twitter  	= $this->helix3->getParam('twitter');
		//$googleplus = $this->helix3->getParam('googleplus');
		$instagram  = $this->helix3->getParam('instagram');
		$pinterest 	= $this->helix3->getParam('pinterest');
		$youtube 	= $this->helix3->getParam('youtube');
		$linkedin 	= $this->helix3->getParam('linkedin');
		$dribbble 	= $this->helix3->getParam('dribbble');
		$behance 	= $this->helix3->getParam('behance');
		$flickr 	= $this->helix3->getParam('flickr');
		$vk 		= $this->helix3->getParam('vk');
		$skype 		= $this->helix3->getParam('skype');
		$whatsapp 	= $this->helix3->getParam('whatsapp');
		$custom 	= $this->helix3->getParam('custom');

		if( $this->helix3->getParam('show_social_icons') && ( $facebook || $twitter || $instagram || $pinterest || $youtube || $linkedin || $dribbble || $behance || $flickr || $vk || $skype || $whatsapp ) ) {
			$html  = '<ul class="social-icons">';

			if( $facebook ) {
				$html .= '<li><a target="_blank" href="'. $facebook .'" aria-label="facebook"><i class="fa-brands fa-facebook-f" aria-hidden="true"></i></a></li>';
			}
			if( $twitter ) {
				$html .= '<li><a target="_blank" href="'. $twitter .'" aria-label="twitter"><i class="fa-brands fa-x-twitter" aria-hidden="true"></i></a></li>';
			}
          	if( $instagram ) {
				$html .= '<li ><a target="_blank" href="'. $instagram .'" aria-label="Instagram"><i class="fa-brands fa-instagram" aria-hidden="true"></i></a></li>';
			}
			if( $pinterest ) {
				$html .= '<li><a target="_blank" href="'. $pinterest .'" aria-label="Pinterest"><i class="fa-brands fa-pinterest" aria-hidden="true"></i></a></li>';
			}
			if( $youtube ) {
				$html .= '<li><a target="_blank" href="'. $youtube .'" aria-label="Youtube"><i class="fa-brands fa-youtube" aria-hidden="true"></i></a></li>';
			}
			if( $linkedin ) {
				$html .= '<li><a target="_blank" href="'. $linkedin .'" aria-label="LinkedIn"><i class="fa-brands fa-linkedin" aria-hidden="true"></i></a></li>';
			}
			if( $dribbble ) {
				$html .= '<li><a target="_blank" href="'. $dribbble .'" aria-label="Dribbble"><i class="fa-brands fa-dribbble" aria-hidden="true"></i></a></li>';
			}
			if( $behance ) {
				$html .= '<li><a target="_blank" href="'. $behance .'" aria-label="Behance"><i class="fa-brands fa-behance" aria-hidden="true"></i></a></li>';
			}
			if( $flickr ) {
				$html .= '<li><a target="_blank" href="'. $flickr .'" aria-label="Flickr"><i class="fa-brands fa-flickr" aria-hidden="true"></i></a></li>';
			}
			if( $vk ) {
				$html .= '<li><a target="_blank" href="'. $vk .'" aria-label="VK"><i class="fa-brands fa-vk" aria-hidden="true"></i></a></li>';
			}
			if( $skype ) {
				$html .= '<li><a href="skype:'. $skype .'?chat" aria-label="Skype"><i class="fa-brands fa-skype" aria-hidden="true"></i></a></li>';
			}
			if( $whatsapp ) {
				$html .= '<li><a href="whatsapp://send?abid='. $whatsapp .'&text=Hi" aria-label="WhatsApp"><i class="fa-brands fa-whatsapp" aria-hidden="true"></i></a></li>';
			}
			if( $custom ) {
				$explt_custom = explode(' ', $custom);
				$html .= '<li><a target="_blank" href="'. $explt_custom[1] .'"><i class="fab '. $explt_custom[0] .'"></i></a></li>';
			}

			$html .= '</ul>';

			return $html;
		}
	}
}