<?php
/**
 * Modify user form view
 *
 * Flex @package Helix Framework
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

defined('_JEXEC') or die;

use Joomla\CMS\Router\Route;
use Joomla\CMS\HTML\HTMLHelper;

// Implement Joomla's form validation
vmJsApi::vmValidator();
vmJsApi::css('vmpanels'); // VM_THEMEURL
?>

<?php
$url = vmURI::getCurrentUrlBy('request');
$cancelUrl = Route::_($url.'&task=cancel');
?>

<h1 class="mt-3 mb-4"><?php echo $this->page_title ?></h1>
<?php echo '<hr class="border border-bottom-0 border-dark-subtle border-opacity-50 mt-4 clearfix" /><div class="row w-100 mt-4 mb-3">'. shopFunctionsF::getLoginForm (TRUE, FALSE) .'</div>'; ?>

<?php if($this->userDetails->virtuemart_user_id==0) {
	echo '<hr class="border border-bottom-0 border-dark-subtle border-opacity-50 mt-4 clearfix" /><h3 class="w-100 mt-4 mb-3">'. vmText::_('COM_VIRTUEMART_YOUR_ACCOUNT_REG') .'</h3>';
}

?>
<form method="post" id="adminForm" name="userForm" action="<?php echo $url ?>" class="form-validate edit-shopper-form">
<?php if($this->userDetails->user_is_vendor){ ?>
    <div style="margin:10px 0 0;" class="buttonBar-right">
	<button class="btn sppb-btn-primary" type="submit" onclick="javascript:return myValidator(userForm, true);" ><?php echo $this->button_lbl ?></button><button class="btn sppb-btn-dark" type="reset" onclick="window.location.href='<?php echo $cancelUrl ?>'" ><?php echo vmText::_('COM_VIRTUEMART_CANCEL'); ?></button></div>
    <?php } ?>
<?php // Loading Templates in Tabs
if($this->userDetails->virtuemart_user_id!=0) {
    $tabarray = array();

    $tabarray['shopper'] = 'COM_VIRTUEMART_SHOPPER_FORM_LBL';

	if(!empty($this->manage_link)) {
		echo '<div class="btn sppb-btn-default">' . $this->manage_link . '</div>';
	}

	if(!empty($this->add_product_link)) {
		echo '<div class="btn sppb-btn-default">' . $this->add_product_link . '</div>';
	}
	

	if($this->userDetails->user_is_vendor){
		//echo '<hr />';
		$tabarray['vendor'] = 'COM_VIRTUEMART_VENDOR';
	}

    //$tabarray['user'] = 'COM_VIRTUEMART_USER_FORM_TAB_GENERALINFO';
    if (!empty($this->shipto)) {
	    $tabarray['shipto'] = 'COM_VIRTUEMART_USER_FORM_ADD_SHIPTO_LBL';
    }
    if (($_ordcnt = count($this->orderlist)) > 0) {
	    $tabarray['orderlist'] = 'COM_VIRTUEMART_YOUR_ORDERS';
    }

    shopFunctionsF::buildTabs ( $this, $tabarray);

 } else {
    echo $this->loadTemplate ( 'shopper' );
	echo $this->captcha;
	// captcha addition
	/*if(VmConfig::get ('reg_captcha')){
		JHTML::_('behavior.framework');
		JPluginHelper::importPlugin('captcha');
		$dispatcher = JDispatcher::getInstance(); $dispatcher->trigger('onInit','dynamic_recaptcha_1');
		?>
		<div id="dynamic_recaptcha_1"></div>
		<?php
	}*/
 }

// end of captcha addition
?>
<input type="hidden" name="option" value="com_virtuemart" />
<input type="hidden" name="controller" value="user" />
<?php echo HTMLHelper::_( 'form.token' ); ?>
</form>

