<?php
/**
 * Flex @package Helix3 Framework
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Layout\FileLayout;

//helper & model
$helix3_path = JPATH_PLUGINS.'/system/helix3/core/helix3.php';
if (file_exists($helix3_path))
{
    require_once($helix3_path);
    $helix3 = Helix3::getInstance();
}

$template       = Factory::getApplication()->getTemplate();
$themepath      = JPATH_THEMES . '/' . $template;

$rows_file      = $themepath . '/html/layouts/helix3/frontend/rows.php';
$lyt_thm_path   = $themepath . '/html/layouts/helix3/';

//$helix3 = helix3::getInstance();

$layout_path  = (file_exists($rows_file)) ? $lyt_thm_path : JPATH_ROOT .'/plugins/system/helix3/layouts';

//$getLayout = new FileLayout('frontend.rows', $layout_path );

$data = $displayData;

$output ='';

$output .= '<' . $data['sematic'] . ' id="' . $data['id'] . '"' . $data['row_class'] . '>';

if ($data['componentArea']){
    if (!$data['pagebuilder']){
        if (!$data['fluidrow']){
			$output .= '<div class="container">';
		} 
		else {
			$output .= '<div class="container-fluid">';
		}
    } else {
		if (!$data['fluidrow']){
			if ($helix3->countModules('left') || $helix3->countModules('right')) {
				// When SPPB is inside Article with "left" or "right" modules
				$output .= '<div class="container has-left-right-modules">';
			}
		} 
		else {
			if ($helix3->countModules('left') || $helix3->countModules('right')) {
				// When SPPB is inside Article with "left" or "right" modules
				$output .= '<div class="container-fluid has-left-right-modules">';
			}
		}
	}
}
else{
    if (!$data['fluidrow']){
        $output .= '<div class="container">';
    } 
}

$getLayout = new FileLayout('frontend.rows', $layout_path );

$output .= $getLayout->render($data);

if ($data['componentArea']){
    if (!$data['pagebuilder']){
		if (!$data['fluidrow']){
			$output .= '</div>';
		} else {
			$output .= '</div>';
		}
	} else if ($helix3->countModules('left') || $helix3->countModules('right')) {
		// When SPPB is inside Article with "left" or "right" modules
		$output .= '</div>';	
	}
}

else{
    if (!$data['fluidrow']){
        $output .= '</div>';
    }
}

$output .= '</' . $data['sematic'] . '>';


echo $output;

