<?php
/**
 * Flex @package VM ajax cart
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;

//Add js and css files
$doc = Factory::getDocument();
$doc->addScript( Uri::root(true) . '/templates/flex/js/vm-cart.js' );

if ((int) $data->totalProduct == 0) {
	$basket = 'total_products empty_basket';
} else {
	$basket = 'total_products items-added';
}
if ($data->totalProduct>1) $data->totalProductTxt = $data->totalProduct;
else if ($data->totalProduct == 1) $data->totalProductTxt = vmText::_('COM_VIRTUEMART_CART_ONE_PRODUCT');
else $data->totalProductTxt = vmText::_('COM_VIRTUEMART_EMPTY_CART');

$data->cart_show = '<a style="padding-top:9px;padding-bottom:12px;" class="btn btn-primary sppb-btn-3d border-0 text-shadow rounded-1" href="'.$data->cart_show_link.'" rel="nofollow" ><i class="fa-solid fa-cart-shopping"></i>'.$data->linkName.'</a>';
?>
  
<!-- Virtuemart Ajax Cart -->
<div class="vmCartModule <?php echo $params->get('moduleclass_sfx'); ?> d-flex float-start px-0 mx-0" id="vmCartModule<?php echo $params->get('moduleid_sfx'); ?>" >
     <div id="cart-menu">
        <a id="cd-menu-trigger" href="#0" class="cd-cart">
        <i class="pe pe-7s-cart"></i>
            <?php if ((int) $data->totalProduct == 0) { ?>
                <div class="<?php echo $basket; ?>">0</div>
            <?php } else { ?>
            	<div class="total_products <?php echo $basket; ?>">
				   <?php //echo $data->totalProductTxt; ?>
				   <?php echo $data->totalProduct; ?>
				</div>
            <?php } ?>
        </a>
    </div>
	<nav id="cd-lateral-nav">
		<div class="cd-navigation">
          <h5 class="py-2 centered"><?php echo vmText::_('VM_RECENTLY_ADDED_ITEMS') ?></h5>
			<hr class="border border-top-0 border-dark border-opacity-50 d-block w-100 clearfix" />
			<?php if ($show_product_list) { ?>
				<div id="hiddencontainer" class="hiddencontainer d-none">
					<div class="vmcontainer">
						<div class="product_row">
							<div class="quantity"></div>
							<div class="image cart-image pull-left float-start"></div>                
							<div class="cart-item">
							   <div class="product_name"></div>
								<?php if ($show_price and $currencyDisplay->_priceConfig['salesPrice'][0]) { ?>
									<div class="subtotal_with_tax"></div>  
								<?php } ?>
								<div class="customProductData"></div>
							  </div>
						   <hr class="border border-top-0 border-dark border-opacity-25 d-block w-100 clearfix mt-2 pt-0" />
						</div>
					</div>
				</div>
				<div class="vm_cart_products">
					<div class="vmcontainer">
						
						<?php if(empty($data->products)){ ?>
							<div class="empty_cart"><h3><?php echo vmText::_('VM_EMPTY_CART'); ?></h3>
							<i class="pe pe-7s-cart">
							<span class="fas fa-solid fa-ban"></span>
							</i>
							</div>
						<?php } else { ?>
							<?php foreach ($data->products as $i=>$product){ ?>  
								 <div class="cd-single-item">   
									<div class="quantity"><?php echo $product['quantity']; ?></div>
									<div class="image cart-image pull-left float-start">
									<?php
										if (VmConfig::get('oncheckout_show_images')) {
										echo !empty($cart->products[$i]->images[0]) ? $cart->products[$i]->images[0]->displayMediaThumb ('', FALSE) : '';
										} ?>
									</div>
									<div class="cart-item">
										<div class="product_name"><?php echo $product['product_name'] ?></div>                
										<?php if ($show_price and $currencyDisplay->_priceConfig['salesPrice'][0]) { ?>
										  <div class="subtotal_with_tax"><?php echo $product['subtotal_with_tax'] ?></div>
										<?php } ?>
										<?php if ( !empty($product['customProductData']) ) { ?>
											<div class="customProductData"><?php echo $product['customProductData'] ?></div>
										<?php } ?>
									</div>
									 <?php //if (count($data->products) > 1) { ?>
										<hr class="border border-top-0 border-dark border-opacity-25 d-block w-100 clearfix mt-2  pt-0" />
									 <?php //} ?>
								</div>
							<?php } ?>
						<?php } ?>
					</div>    
				</div>
			<?php } ?>
                <?php if ($data->totalProduct and $show_price and $currencyDisplay->_priceConfig['salesPrice'][0]) { ?>
				<div class="total border border-success border-opacity-25 mb-0 py-2 rounded-1">
                <?php echo $data->billTotal; ?>
				</div>
                <?php } ?>
            <div class="show_cart d-block clearfix">
                <?php if ($data->totalProduct) echo $data->cart_show; ?>
            </div>
		</div><?php // END div class="cd-navigation"; ?>
	</nav>
<?php
$view = vRequest::getCmd('view');
if($view!='cart' and $view!='user'){
	?><div class="payments-signin-button" ></div><?php
}
?>
<noscript>
<?php echo vmText::_('MOD_VIRTUEMART_CART_AJAX_CART_PLZ_JAVASCRIPT') ?>
</noscript>
</div>
