<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

SpAddonsConfig::addonConfig([
	'type'       => 'content',
	'addon_name' => 'animated_number',
	'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER'),
	'desc'       => Text::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_DESC'),
	'category'   => 'Content',
	'settings' => [
		'content' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT'),
			'fields' => [
				'number' => [
					'type'        => 'slider',
					'title'       => Text::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_NUMBER'),
					'std'         => 1389,
				],

				'duration' => [
					'type'        => 'slider',
					'title'       => Text::_('COM_SPPAGEBUILDER_GLOBAL_ANIMATION_DURATION'),
					'std'         => 1000,
				],

				'number_before_after_text' => [
					'type'        => 'text',
					'title'       => Text::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_PREFIX'),
					'desc'        => Text::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_BEF_AFT_TEXT_DESC'),
					'placeholder' => '+,K,$',
					'std'         => '$',
					'inline'	  => true,
				],

				'number_position' => [
					'type'   => 'select',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_POSITION'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_POSITION_DESC'),
					'values' => [
						'top'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_TOP'),
						'right'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_RIGHT'),
						'bottom' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BOTTOM'),
						'left'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_LEFT'),
					],
					'inline'	  => true,
				],

				'number_before_after_text_position' => [
					'type'   => 'radio',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_PREFIX_POSITION'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_BEF_AFT_TEXT_POS_DESC'),
					'values' => [
						'left'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BEFORE'),
						'right' => Text::_('COM_SPPAGEBUILDER_GLOBAL_AFTER'),
					],
					'std'   => 'left',
				],

				'use_number_format' => [
					'type'   => 'checkbox',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_USE_FORMAT'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_USE_NUMBER_FORMAT'),
					'std'   => 0,
				],

				'alignment' => [
					'type'              => 'alignment',
					'title'  			=> Text::_('COM_SPPAGEBUILDER_GLOBAL_ALIGNMENT'),
					'responsive'        => true,
					'available_options' => ['left', 'center', 'right'],
					'std'				=> ['xl' => 'center', 'lg' => '', 'md' => '', 'sm' => '', 'xs' => ''],
				],
			],
		],

		'number' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_NUMBER'),
			'fields' => [
				'number_typography' => [
					'type'     => 'typography',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
					'fallbacks' => [
						'font' => 'number_font_family',
						'size' => 'font_size',
						'line_height' => 'line_height',
						'weight' => 'number_font_wight',
					],
				],

				'color' => [
					'type'   => 'color',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_NUMBER_COLOR'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_ANIMATED_NUMBER_NUMBER_COLOR_DESC'),
					'inline' => true
				],
				
				'background' => [
					'type'   => 'color',
					'title'  => Text::_('FLEX_GLOBAL_BACKGROUND'),
					'inline' => true
				],
				
				'border_color' => [
					'type'   => 'color',
					'title'  => Text::_('FLEX_GLOBAL_BORDER_COLOR'),
					//'std'    => 'RGBA(110, 110, 110, 0.3)',
					//'inline' => true
				],
				
				'border_width' => [
					'type'   => 'slider',
					'title'  => Text::_('FLEX_GLOBAL_BORDER_WIDTH_SIZE'),
					//'std'    => 1,
					'max'    => 500,
				],
				
				'border_radius' => [
					'type'   => 'slider',
					'title'  => Text::_('FLEX_GLOBAL_BORDER_RADIUS'),
					'std'    => 4,
					'max'    => 500,
				],
				'number_class' => [
					'type'   => 'text',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
					//'std'    => 'padding',
				],
			]
		],

		'title' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TITLE'),
			'fields' => [
				'counter_title' => [
					'type'  => 'text',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TITLE'),
					'std'   => 'Animated Number',
				],
				
				'heading_selector' => [
                    'type' => 'headings',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS'),
                    'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_DESC'),
                    'std' => 'h3',
                ],

				'title_margin' => [
					'type'       => 'margin',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN'),
					'responsive' => true,
				],

				'title_typography' => [
					'type'     => 'typography',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
					'fallbacks' => [
						'font' => 'title_font_family',
						'size' => 'title_font_size',
						'line_height' => 'title_line_height',
						'weight' => 'title_fontstyle.weight',
						'italic' => 'title_fontstyle.italic',
						'underline' => 'title_fontstyle.underline',
						'uppercase' => 'title_fontstyle.uppercase',
					],
				],

				'title_color' => [
					'type'   => 'color',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR')
				],
			],
		],
	],
]);
