<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

class SppagebuilderAddonBootstrap_modal extends SppagebuilderAddons{

	public function render() {
		
		$settings = $this->addon->settings;
		// Include template's params
		$tpl_params 	= Factory::getApplication()->getTemplate(true)->params;
		$has_lazyload = $tpl_params->get('lazyload', 1);
		
		$class = (isset($settings->class) && $settings->class) ? $settings->class . ' ' : '';
		
		//Options
		$modal_selector = (isset($settings->modal_selector) && $settings->modal_selector) ? $settings->modal_selector : '';
		$button_text = (isset($settings->button_text) && $settings->button_text) ? $settings->button_text : '';
		
		$button_class = (isset($settings->button_type) && $settings->button_type) ? ' sppb-btn-' . $settings->button_type : ' sppb-btn-default';
		$button_class .= (isset($settings->button_size) && $settings->button_size) ? ' sppb-btn-' . $settings->button_size : '';
		$button_class .= (isset($settings->button_shape) && $settings->button_shape) ? ' sppb-btn-' . $settings->button_shape : ' sppb-btn-rounded';
		$button_class .= (isset($settings->button_appearance) && $settings->button_appearance) ? ' sppb-btn-' . $settings->button_appearance : '';
		
		//Pixeden Icons
		$button_peicon = (isset($settings->button_peicon) && $settings->button_peicon) ? $settings->button_peicon : '';
		$button_icon = (isset($settings->button_icon) && $settings->button_icon) ? $settings->button_icon : '';
		$button_block = (isset($settings->button_block) && $settings->button_block) ? $settings->button_block : '';

		$selector_image = (isset($settings->selector_image) && $settings->selector_image) ? $settings->selector_image : '';
		$selector_image_src = isset($selector_image->src) ? $selector_image->src : $selector_image;
		
		$alignment = (isset($settings->alignment) && $settings->alignment) ? $settings->alignment : ' sppb-text-center';
		
		$button_icon_position = (isset($settings->button_icon_position) && $settings->button_icon_position) ? $settings->button_icon_position: 'left';
		
		$modal_unique_id = 'sppb-modal-' . $this->addon->id;
		$modal_content_type = (isset($settings->modal_content_type) && $settings->modal_content_type) ? $settings->modal_content_type : 'text';
		$modal_window_title = (isset($settings->modal_window_title) && $settings->modal_window_title) ? $settings->modal_window_title : '';
		$modal_window_size = (isset($settings->modal_window_size) && $settings->modal_window_size) ? $settings->modal_window_size : '';
		$modal_content_text = (isset($settings->modal_content_text) && $settings->modal_content_text) ? $settings->modal_content_text : '';
		
		$modal_content_image = (isset($settings->modal_content_image) && $settings->modal_content_image) ? $settings->modal_content_image : '';
		$modal_content_image_src = isset($modal_content_image->src) ? $modal_content_image->src : $modal_content_image;
		
		
		$modal_content_video_url = (isset($settings->modal_content_video_url) && $settings->modal_content_video_url) ? $settings->modal_content_video_url : '';

		if($button_icon_position == 'left') {
			if ($button_peicon != '') {
				$button_text = ($button_peicon) ? '<i style="margin-left:-5px;" class="pe ' . $button_peicon . ' me-2"></i> ' . $button_text : $button_text;
			}else{
				$button_text = ($button_icon) ? '<i style="margin-left:-3px;" class="fa ' . $button_icon . ' me-2"></i> ' . $button_text : $button_text;
			}
		} else {
			if ($button_peicon != '') {
				$button_text = ($button_peicon) ? $button_text . ' <i style="margin-right:-5px;" class="pe ' . $button_peicon . ' ms-2 me-n1"></i>' : $button_text;
			}else{
				$button_text = ($button_icon) ? $button_text . ' <i style="margin-right:-3px;" class="fa ' . $button_icon . ' ms-2 me-n1"></i>' : $button_text;
			}
		}

	$modal_window_title = (isset($modal_window_title) && $modal_window_title) ? $modal_window_title : '';
	
	if($modal_window_title != '') {
		$alt_text = $modal_window_title;
	} else {
		$alt_text = 'modal image';
	}
	
	// Alignment
	$css_align = '';
		
	if ($button_block != 'sppb-btn-block') {
		$css_align .= ' '. $alignment;
	} else {
		$css_align .= ' sppb-btn-block centered';
	}

	$output = '';

	$output .= '<div class="' . $class . $alignment . ' mobile-centered">';

	if($modal_selector=='image') {
		if($selector_image_src) {
			$output .= '<a class="sppb-modal-selector modal-selector-image" href="#" data-toggle="sppb-modal">';
			// Image
			if(strpos($selector_image_src, 'http://') !== false || strpos($selector_image_src, 'https://') !== false){
				/* Lazyload for images with absolute URL */
				if($has_lazyload) {
					$output .= '<img class="lazyload sppb-img-responsive" src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==" data-src="'. $selector_image_src .'" alt="'. $alt_text .'">';
				} else {
					$output .= '<img src="' . $selector_image_src . '" alt="'. $alt_text .'" title="'.$alt_text.'">';	
				}
			} else {
				/* Lazyload for images for relative URL (local image) */
				if($has_lazyload) {
					$output .= '<img class="lazyload sppb-img-responsive' . $class . '" src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==" data-src="'. Uri::root() . $selector_image_src .'" alt="'. $alt_text .'">';
				} else {
					$output .= '<img src="' . $selector_image_src . '" alt="'. $alt_text .'" title="'.$alt_text.'">';	
				}
			}
		$output .= '</a>';
		}
		
	} else {
		$output .= '<button class="sppb-btn' . $button_class . $css_align .' sppb-modal-selector" data-toggle="sppb-modal">'. $button_text .'</button>';
	}

	$output .= '</div>';

	$output .= '<div class="sppb-modal sppb-fade '. $class .'" tabindex="-1" role="dialog" aria-hidden="true">';
	$output .= '<div class="sppb-modal-dialog ' . $modal_window_size . '">';
	$output .= '<div class="sppb-modal-content">';

	if($modal_window_title != '') {
		$output .= '<div class="sppb-modal-header">';
	}
	$output .= '<button type="button" class="sppb-close" data-dismiss="sppb-modal"><span aria-hidden="true">&times;</span></button>';
	if($modal_window_title != '') {
		$output .= '<h4 class="sppb-modal-title">' . $modal_window_title . '</h4>';
		$output .= '</div>';
	}

	$output .= '<div class="sppb-modal-body">';

	if($modal_content_text) $output .= '<div class="sppb-modal-text">'. $modal_content_text .'</div>';
	if($modal_content_image_src) {
		$output .= '<div class="sppb-modal-image mt-3">';

		// Image
		if(strpos($modal_content_image_src, 'http://') !== false || strpos($modal_content_image_src, 'https://') !== false){
			/* Lazyload for images with absolute URL */
			if($has_lazyload) {
				$output .= '<img class="lazyload sppb-img-responsive" src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==" data-src="'. $modal_content_image_src .'" alt="'. $alt_text .'" data-expand="-5">';
			} else {
				$output .= '<img class="sppb-img-responsive" src="'. $modal_content_image_src .'" alt="'.$alt_text.'">';
			}
		} else {
			/* Lazyload for images for relative URL (local image) */
			if($has_lazyload) {
				$output .= '<img class="lazyload sppb-img-responsive' . $class . '" src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==" data-src="'. Uri::root() . $modal_content_image_src .'" alt="'. $alt_text .'" data-expand="-5">';
			} else {
				$output .= '<img class="sppb-img-responsive" src="'. $modal_content_image_src .'" alt="'.$alt_text.'">';	
			}
		}
		$output .= '</div>';
	}

	//Video
	if($modal_content_video_url) {

		$video = parse_url($modal_content_video_url);
		
		switch($video['host']) {
			case 'youtu.be':
				$id = trim($video['path'],'/');
				$src = '//www.youtube.com/embed/' . $id;
			break;
			
			case 'www.youtube.com':
			case 'youtube.com':
				parse_str($video['query'], $query);
				$id = $query['v'];
				$src = '//www.youtube.com/embed/' . $id;
			break;
			
			case 'vimeo.com':
			case 'www.vimeo.com':
				$id = trim($video['path'],'/');
				$src = "//player.vimeo.com/video/{$id}";
		}

		$output .= '<div class="sppb-modal-video mt-3 sppb-embed-responsive sppb-embed-responsive-16by9">';
		$output .= '<iframe class="sppb-embed-responsive-item" src="' . $src . '" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>';
		$output .= '</div>';
	}

	$output .= '</div>';
	
	$output .= '</div>';
	$output .= '</div>';
	$output .= '</div>';

	return $output;
	}

	public function scripts() {
		$app = Factory::getApplication();	
		$tmplPath = Uri::base(true) . '/templates/'.$app->getTemplate();
		return array($tmplPath.'/sppagebuilder/addons/bootstrap_modal/assets/js/bootstrap-modal.js');
	}

	public function stylesheets() {
		$app = Factory::getApplication();	
		$tmplPath = Uri::base(true) . '/templates/'.$app->getTemplate();
		return array($tmplPath.'/sppagebuilder/addons/bootstrap_modal/assets/css/bootstrap-modal.css');
	}

}
