<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Component\ComponentHelper;

$params   = ComponentHelper::getParams('com_sppagebuilder');
$gmap_api = $params->get('gmap_api', '');

SpAddonsConfig::addonConfig([
	'type'       => 'content',
	'addon_name' => 'gmap',
	'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP'),
	'desc'       => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_DESC'),
	'settings' => [
		'map' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT'),
			'fields' => [
				'message' => [ // todo: not working
					'type'    => empty($gmap_api) ? 'alert' : 'hidden',
					'message' => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_APIKEY_MISSING'),
				],

				'map' => [
					'type'  => 'gmap',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_LOCATION'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_LOCATION_DESC'),
					'std'   => '48.86269,2.29483',
					'inline' => true,
				],

				'type' => [
					'type'   => 'select',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPE'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_TYPE_DESC'),
					'values' => [
						'ROADMAP'   => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_TYPE_ROADMAP'),
						'SATELLITE' => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_TYPE_SATELLITE'),
						'HYBRID'    => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_TYPE_HYBRID'),
						'TERRAIN'   => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_TYPE_TERRAIN'),
					],
					'std'     => 'ROADMAP',
					'inline'  => true,
				],

				'height' => [
					'type'        => 'slider',
					'title'       => Text::_('COM_SPPAGEBUILDER_GLOBAL_HEIGHT'),
					'desc'        => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_HEIGHT_DESC'),
					'std'         => ['xl' => 300],
					'max'         => 2000,
					'responsive'  => true,
				],
			],
		],

		'map_options' => [
			'title' => Text::_('COM_SPPAGEBUILDER_OPTIONS'),
			'fields' => [
				'infowindow' => [
					'type'  => 'textarea',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_INFOWINDOW'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_INFOWINDOW_DESC'),
				],

				'zoom' => [
					'type'    => 'slider',
					'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_ZOOM'),
					'desc'    => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_ZOOM_DESC'),
					'std'     => 13,
					'max'     => 25,
				],

				'mousescroll' => [
					'type'   => 'radio',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_MOUSE_SCROLL'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_DISABLE_MOUSE_SCROLL_DESC'),
					'values' => [
						'false' => Text::_('JNO'),
						'true'  => Text::_('JYES'),
					],
					'std'     => 'true',
				],

				'show_controllers' => [
					'type'   => 'radio',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_DISABLE_SHOW_CONTROLLERS'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_DISABLE_SHOW_CONTROLLERS_DESC'),
					'values' => [
						'false' => Text::_('JNO'),
						'true'  => Text::_('JYES'),
					],
					'std'     => 'false',
				],
				
				// UPDATE for FLEX	
				'street_view_control' => [
					'type'   => 'radio',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_STREET_VIEW_CONTROL'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_STREET_VIEW_CONTROL_DESC'),
					'values' => [
						'false' => Text::_('JNO'),
						'true'  => Text::_('JYES'),
					],
					'std'     => 'false',
					'depends' => [['map', '!=', '']],
				],
				
				'map_type_control' => [
					'type'   => 'radio',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_MAP_TYPE_CONTROL'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_MAP_TYPE_CONTROL_DESC'),
					'values' => [
						'false' => Text::_('JNO'),
						'true'  => Text::_('JYES'),
					],
					'std'     => 'false',
					'depends' => [['map', '!=', '']],
				],
				
				'fullscreen_control' => [
					'type'   => 'radio',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_FULLSCREEN_CONTROL'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_FULLSCREEN_CONTROL_DESC'),
					'values' => [
						'false' => Text::_('JNO'),
						'true'  => Text::_('JYES'),
					],
					'std'     => 'false',
					'depends' => [['map', '!=', '']],
				],
				
				'show_transit' => [
					'type'   => 'radio',
					'title'=>Text::_('FLEX_GMAP_SHOW_TRANSIT'),
					'desc'=>Text::_('FLEX_GMAP_SHOW_TRANSIT_DESC'),
					'values' => [
						0 => Text::_('JNO'),
						1 => Text::_('JYES'),
					],
					'std' => 0,
					'depends' => [['map', '!=', '']],
				],
				
				'show_poi' => [
					'type'   => 'radio',
					'title'=>Text::_('FLEX_GMAP_SHOW_POI'),
					'desc'=>Text::_('FLEX_GMAP_SHOW_POI_DESC'),
					'values' => [
						0 => Text::_('JNO'),
						1 => Text::_('JYES'),
					],
					'std' => 0,
					'depends' => [['map', '!=', '']],
				],
				
				// Separator
				'separator2' => [
					'type'=>'separator',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_COLOR_SETTINGS'),
				],
				
				'water_color' => [
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_WATER_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_WATER_COLOR_DESC'),
					'depends' => [['map', '!=', '']],
				],
				
				'highway_stroke_color' => [
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_HW_STROKE_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_HW_STROKE_COLOR_DESC'),
					'depends' => [['map', '!=', '']],
				],
				
				'highway_fill_color' => [
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_HW_FILL_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_HW_FILL_COLOR_DESC'),
					'depends' => [['map', '!=', '']],
				],
				
				'local_stroke_color' => [
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_LOCAL_STROKE_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_LOCAL_STROKE_COLOR_DESC'),
					'depends' => [['map', '!=', '']],
				],
				
				'local_fill_color' => [
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_LOCAL_FILL_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_LOCAL_FILL_COLOR_DESC'),
					'depends' => [['map', '!=', '']],
				],
				
				'poi_fill_color' => [
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_POI_FILL_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_POI_FILL_COLOR_DESC'),
					'depends' => [['map', '!=', '']],
				],
				
				'administrative_color' => [
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_ADMINISTRATIVE_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_ADMINISTRATIVE_COLOR_DESC'),
					'depends' => [['map', '!=', '']],
				],
				
				'landscape_color' => [
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_LANDSCAPE_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_LANDSCAPE_COLOR_DESC'),
					'depends' => [['map', '!=', '']],
				],
	
				'road_text_color' => [
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_ROAD_TEXT_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_ROAD_TEXT_COLOR_DESC'),
					'depends' => [['map', '!=', '']],
				],
				
				'road_arterial_fill_color' => [
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_ROAD_ARTERIAL_FILL_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_ROAD_ARTERIAL_FILL_COLOR_DESC'),
					'depends' => [['map', '!=', '']],
				],
				
				'road_arterial_stroke_color' => [
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_ROAD_ARTERIAL_STROKE_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_ROAD_ARTERIAL_STROKE_COLOR_DESC'),
					'depends' => [['map', '!=', '']],
				],
				
				'class' => [
					'type' => 'text',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
					'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
				],
				
			],
		],

		/*
		'multiple_maps' => [
			'title' => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_LOCATION'),
			'fields' => [
				'multi_location' => [
					'type'   => 'checkbox',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_MULTI_LOCATION'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_MULTI_LOCATION_DESC'),
					'values' => [
						1 => Text::_('YES'),
						0 => Text::_('NO'),
					],
					'std' => 0,
					'is_header' => 1
				],

				'multi_location_items' => [
					'type'	=> 'repeatable',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_MULTI_LOCATION_ITEMS'),
					'attr'  => [
						'location_item' => [
							'type'  => 'gmap',
							'title' => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_LOCATION'),
							'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_LOCATION_DESC'),
							'std'   => '22.3435442,91.765449',
						],

						'location_popup_text' => [
							'type'  => 'textarea',
							'title' => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_INFOWINDOW'),
							'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_GMAP_INFOWINDOW_DESC'),
							'std'   => 'Chittagong',
						],
					],
					'depends' => [['multi_location', '=', 1]],
				],
			],
		],
		*/

		'title' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TITLE'),
			'fields' => [
				'title' => [
					'type'  => 'text',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_DESC'),
				],

				'heading_selector' => [
					'type'   => 'headings',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_DESC'),
					'std'   => 'h3',
				],

				'title_typography' => [
					'type'      => 'typography',
					'title'     => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
					'fallbacks' => [
						'font'           => 'title_font_family',
						'size'           => 'title_fontsize',
						'line_height'    => 'title_lineheight',
						'letter_spacing' => 'title_letterspace',
						'uppercase'      => 'title_font_style.uppercase',
						'italic'         => 'title_font_style.italic',
						'underline'      => 'title_font_style.underline',
						'weight'         => 'title_font_style.weight',
					],
				],

				'title_text_color' => [
					'type'   => 'color',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
				],

				'title_margin_separator' => [
					'type' => 'separator',
				],

				'title_margin_top' => [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_TOP'),
					'max'        => 400,
					'responsive' => true,
				],

				'title_margin_bottom' => [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_BOTTOM'),
					'max'        => 400,
					'responsive' => true,
				],
			],
		],
	],
]);
