<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2023 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

SpAddonsConfig::addonConfig([
    'type' => 'content',
    'addon_name' => 'sp_latest_posts',
	'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_LATEST_POSTS'),
	'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_LATEST_POSTS_DESC'),
    'category' => 'Flex',
    'settings' => [
        'source' => [
            'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT'),
            'fields' => [

				'category' => [
                    'type' => 'category',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_LATEST_POSTS_SELECT_CATEGORY'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_LATEST_POSTS_SELECT_CATEGORY_DESC'),
                    'multiple' => true,
                ],
				
				'include_subcat' => [
                    'type' => 'checkbox',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_INCLUDE_SUBCATEGORIES'),
                    'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_INCLUDE_SUBCATEGORIES_DESC'),
                    'values' => [
                        1 => Text::_('COM_SPPAGEBUILDER_YES'),
                        0 => Text::_('COM_SPPAGEBUILDER_NO'),
                    ],
                    'std' => 1,
                ],
				
				'ordering_separator' => [
                    'type' => 'separator',
                ],
				
                'ordering' => [
                    'type' => 'select',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_ARTICLES_ORDERING'),
                    'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_ARTICLES_ORDERING_DESC'),
                    'values' => [
                        'latest' => Text::_('COM_SPPAGEBUILDER_ADDON_ARTICLES_ORDERING_LATEST'),
                        'oldest' => Text::_('COM_SPPAGEBUILDER_ADDON_ARTICLES_ORDERING_OLDEST'),
                        'hits' => Text::_('COM_SPPAGEBUILDER_ADDON_ARTICLES_ORDERING_POPULAR'),
                        'featured' => Text::_('COM_SPPAGEBUILDER_ADDON_ARTICLES_ORDERING_FEATURED'),
                        'alphabet_asc' => Text::_('COM_SPPAGEBUILDER_ADDON_ARTICLES_ORDERING_ALPHABET_ASC'),
                        'alphabet_desc' => Text::_('COM_SPPAGEBUILDER_ADDON_ARTICLES_ORDERING_ALPHABET_DESC'),
                        'random' => Text::_('COM_SPPAGEBUILDER_ADDON_ARTICLES_ORDERING_RANDOM'),
                    ],
                    'std' => 'latest',
                ],

				 'style' => [
                    'type' => 'select',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_TYPE'),
					 'values' => [
						'default'=>Text::_('Default'),
						'blog'=>Text::_('Blog'),
						'flex'=>Text::_('Flex'),
                    ],
                    'std' => 'flex',
                ],
				
				'masonry_separator' => [
                    'type' => 'separator',
                ],
				
				// Enable Masonry effect (only on 2, 3, 4, 6 columns with)
				'enable_masonry' => [
                    'type' => 'checkbox',
					'title'=>Text::_('FLEX_ADDON_ENABLE_MASONRY'),
					'desc'=>Text::_('FLEX_ADDON_ENABLE_MASONRY_DESC'),
                    'values' => [
						1 => Text::_('JYES'),
						0 => Text::_('JNO'),
                    ],
                    'std' => 0,
					'depends' => [['column_no', '!=', '1']],
                ],
				
				'class_separator' => [
                    'type' => 'separator',
                ],
				
				'class' => [
                    'type' => 'text',
						'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
						'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
                    'std' => '',
                ],
            ],
        ],

        'options' => [
            'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_OPTIONS'),
            'fields' => [
                'item_limit' => [
                    'type' => 'slider',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_LATEST_POSTS_LIMIT'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_LATEST_POSTS_LIMIT_DESC'),
                    'min' => 1,
                    'std' => 6,
                ],

				'column_no' => [
                    'type' => 'slider',
					'title'=>Text::_('FLEX_LATEST_POSTS_COLUMN_NO'),
					'desc'=>Text::_('FLEX_LATEST_POSTS_COLUMN_NO_DESC'),
                    'min' => 1,
                    'max' => 6,
                    //'std' => ['xl' => 3],
					'std' => 3,
                ],
				
				// Show Intro image
				'show_image' => [
                    'type' => 'checkbox',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_LATEST_POSTS_IMG'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_LATEST_POSTS_IMG_DESC'),
                    'values' => [
						1 => Text::_('JYES'),
						0 => Text::_('JNO'),
                    ],
                    'std' => 1,
                ],
				
				 'image_alignment' => [
                    'type' => 'select',
					'title'=>Text::_('FLEX_LATEST_POSTS_IMAGE_ALIGNMENT'),
					'desc'=>Text::_('FLEX_LATEST_POSTS_IMAGE_ALIGNMENT_DESC'),
					 'values' => [
						'left'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_LEFT'),
						'right'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_RIGHT'),
                    ],
                    'std' => 'left',
					'depends' => [['column_no', '=', '1']],
                ],

				// Show Introtext
                'show_intro_text' => [
                    'type' => 'checkbox',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_LATEST_POSTS_INTROTEXT_LIMIT'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_LATEST_POSTS_INTROTEXT_LIMIT_DESC'),
                    'std' => '1',
                ],
				
				 'intro_text_limit' => [
                    'type' => 'slider',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_LATEST_POSTS_INTROTEXT_LIMIT'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_LATEST_POSTS_INTROTEXT_LIMIT_DESC'),
                    'std' => 100,
					'depends' => [['show_intro_text', '=', '1']],
                ],
			

				// Show Author
                'show_author' => [
                    'type' => 'checkbox',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_LATEST_POSTS_AUTHOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_LATEST_POSTS_AUTHOR_DESC'),
                    'values' => [
                        1 => Text::_('JYES'),
                        0 => Text::_('JNO'),
                    ],
                    'std' => 1,
                ],
				
				// Show Category link
                'show_category' => [
                    'type' => 'checkbox',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_LATEST_POSTS_CATEGORY'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_LATEST_POSTS_CATEGORY_DESC'),
                    'values' => [
                        1 => Text::_('JYES'),
                        0 => Text::_('JNO'),
                    ],
                    'std' => 1,
                ],
				
				// Show Date
                'show_date' => [
                    'type' => 'checkbox',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_LATEST_POSTS_DATE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_LATEST_POSTS_DATE_DESC'),
                    'values' => [
						1 => Text::_('JYES'),
						0 => Text::_('JNO'),
                    ],
                    'std' => 1,
                ],
				
				'date_format' => [
                    'type' => 'select',
					'title'=>Text::_('FLEX_GLOBAL_DATE_FORMAT'),
					'desc'=>Text::_('FLEX_GLOBAL_DATE_FORMAT_DESC'),
                    'values' => [
						'DATE_FORMAT_LC1'=>Text::_('DATE_FORMAT_LC1: Tuesday, 07 October 2023 (l, d F Y)'),
						'DATE_FORMAT_LC2'=>Text::_('DATE_FORMAT_LC2: Tuesday, 07 October 2023 14:15 (l, d F Y H:i)'),
						'DATE_FORMAT_LC3'=>Text::_('DATE_FORMAT_LC3: 07 October 2023 (d F Y)'),
						'DATE_FORMAT_LC4'=>Text::_('DATE_FORMAT_LC4: 2023-10-07 (Y-m-d)'),
						'DATE_FORMAT_JS1'=>Text::_('DATE_FORMAT_JS1: 23-10-07 (y-m-d)'),
                    ],
                    'std'=>'DATE_FORMAT_LC1',
					'depends' => [['show_date', '=', '1']],
                ],
				
				// Readmore button
                'show_readmore' => [
                    'type' => 'checkbox',
					'title'=>Text::_('FLEX_ADDON_READMORE'),
					'desc'=>Text::_('FLEX_ADDON_READMORE_DESC'),
						1 => Text::_('JYES'),
						0 => Text::_('JNO'),
                    ],
                    'std' => 0,
                ],
			
				'readmore_button' => [
                    'type' => 'text',
					'title'=>Text::_('FLEX_ADDON_READMORE_BUTTON_TEXT'),
					'desc'=>Text::_('FLEX_ADDON_READMORE_BUTTON_TEXT_DESC'),
                    'std' => Text::_('JGLOBAL_READ_MORE'),
                    'inline' => true,
                    'depends' => [['show_readmore', '=', '1']],
                ],

                'readmore_button_position' => [
                    'type' => 'select',
 					'title'=>Text::_('FLEX_ADDON_READMORE_BUTTON_POSITION'),
					'values' => [
						'left'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_LEFT'),
						'right'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_RIGHT'),
                    ],
                    'std' => 'left',
                    'std' => Text::_('JGLOBAL_READ_MORE'),
                    'inline' => true,
                    'depends' => [['show_readmore', '=', '1']],
                ],
				
				'button_type' => [
                    'type' => 'select',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_STYLE'),
                    'desc' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_STYLE_DESC'),
                    'values' => [
                        'default' => Text::_('COM_SPPAGEBUILDER_GLOBAL_DEFAULT'),
						'flex'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_FLEX'),
						'dark'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_DARK'),
						'light'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_LIGHT'),
                        'primary' => Text::_('COM_SPPAGEBUILDER_GLOBAL_PRIMARY'),
                        'secondary' => Text::_('COM_SPPAGEBUILDER_GLOBAL_SECONDARY'),
                        'success' => Text::_('COM_SPPAGEBUILDER_GLOBAL_SUCCESS'),
                        'info' => Text::_('COM_SPPAGEBUILDER_GLOBAL_INFO'),
                        'warning' => Text::_('COM_SPPAGEBUILDER_GLOBAL_WARNING'),
                        'danger' => Text::_('COM_SPPAGEBUILDER_GLOBAL_DANGER'),
                        'link' => Text::_('COM_SPPAGEBUILDER_GLOBAL_LINK'),
                        'custom' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CUSTOM'),
                    ],
                    'std' => 'default',
                    'inline' => true,
                    'depends' => [
                        ['show_readmore', '=', '1'],
                    ],
                ],
			
			    'button_appearance' => [
                    'type' => 'select',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE'),
                    'desc' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_DESC'),
                    'values' => [
                        '' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_FLAT'),
                        'gradient' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_GRADIENT'),
                        'outline' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_OUTLINE'),
						'3d' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_3D'),
                    ],
                    'std' => '',
                    'inline' => true,
                    'depends' => [
                        ['show_readmore', '=', '1'],
                    ],
                ],
			
				'button_size' => [
                    'type' => 'select',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE'),
                    'desc' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_DESC'),
                    'values' => [
                        '' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_DEFAULT'),
                        'lg' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_LARGE'),
                        'xlg' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_XLARGE'),
                        'sm' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_SMALL'),
                        'xs' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_EXTRA_SAMLL'),
                    ],
                    'std' => '',
                    'depends' => [
                        ['show_readmore', '=', '1'],
                    ],
                ],
			
				'button_shape' => [
                    'type' => 'select',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_DESC'),
                    'values' => [
						'rounded'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_ROUNDED'),
						'square'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_SQUARE'),
						'round'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_ROUND'),
                    ],
                    'std' => '',
                    'depends' => [
                        ['show_readmore', '=', '1'],
                    ],
                ],
				
				'button_block' => [
                    'type' => 'select',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BLOCK'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BLOCK_DESC'),
                    'values' => [
                        '' => Text::_('JNO'),
                        'sppb-btn-block' => Text::_('JYES'),
                    ],
                    'depends' => [
                        ['show_readmore', '=', '1'],
                    ],
                ],
		
        ],

        'title' => [
            'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TITLE'),
            'fields' => [
                'title' => [
                    'type' => 'text',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE'),
                    'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_DESC'),
                ],

                'heading_selector' => [
                    'type' => 'headings',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS'),
                    'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_DESC'),
                    'std' => 'h3',
                ],

                'title_typography' => [
                    'type' => 'typography',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
                    'fallbacks' => [
                        'font' => 'font_family',
                        'size' => 'title_fontsize',
                        'line_height' => 'title_lineheight',
                        'letter_spacing' => 'title_letterspace',
                        'uppercase' => 'title_font_style.uppercase',
                        'italic' => 'title_font_style.italic',
                        'underline' => 'title_font_style.underline',
                        'weight' => 'title_font_style.weight',
                    ],
                ],

                'title_text_color' => [
                    'type' => 'color',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
                ],

                'title_margin_separator' => [
                    'type' => 'separator',
                ],

                'title_margin_top' => [
                    'type' => 'slider',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_TOP'),
                    'max' => 400,
                    'responsive' => true,
                ],

                'title_margin_bottom' => [
                    'type' => 'slider',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_BOTTOM'),
                    'max' => 400,
                    'responsive' => true,
                ],
            ],
        ],
    ],
]);
