<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

class SppagebuilderAddonLightbox extends SppagebuilderAddons{

	public function render() {
		
		$settings = $this->addon->settings;
		
		$class = (isset($settings->class) && $settings->class) ? $settings->class : '';
		$title = (isset($settings->title) && $settings->title) ? $settings->title : '';
		$heading_selector = (isset($settings->heading_selector) && $settings->heading_selector) ? $settings->heading_selector : 'h3';

		//Options
		$width = (isset($settings->width) && $settings->width) ? $settings->width : 220;
		//$height = (isset($settings->height) && $settings->height) ? $settings->height : 200;
		$spacing = (isset($settings->spacing) && $settings->spacing) ? $settings->spacing : 12;
		
		$output  = '<div class="sppb-addon sppb-addon-lightbox ' . $class . '">';
		$output .= ($title) ? '<'.$heading_selector.' class="sppb-addon-title">' . $title . '</'.$heading_selector.'>' : '';
		$output .= '<div class="sppb-addon-content">';
		$output .= '<ul id="grid-'.$this->addon->id.'" class="sppb-lightbox clearfix">';
		
		foreach ($settings->sp_lightbox_item as $key => $value) {
			
			$class != '' ? $thumb_class = ' class="'.$class.'"' : $thumb_class = '';
			$class == 'small' ? $small = ' small' : $small = '';
			
			//$value->show_caption != 0 ? $caption = $value->title : $caption = '';
			$title = (isset($value->title) && $value->title) ? $value->title : '';
			$thumb = (isset($value->thumb) && $value->thumb) ? $value->thumb : '';
			$thumb_src = isset($thumb->src) ? $thumb->src : $thumb;
			$full = (isset($value->full) && $value->full) ? $value->full : '';
			$full_src = isset($full->src) ? $full->src : $full;
			$caption = (isset($value->show_caption) && $value->show_caption) ? $caption = $title : '';

			if($thumb_src) {
				//$output .= ($spacing != 0) ? '<li class="shuffle_sizer'. $small .'" style="margin-bottom:' . $spacing . 'px;">' : '<li class="shuffle_sizer">';
				$output .= ($spacing != 0) ? '<li class="shuffle_sizer'. $small .'">' : '<li class="shuffle_sizer">';
				//$output .= '';
		
				if($full_src) {
					$output .= '<div class="overlay"><a href="'. $full_src .'" data-imagelightbox="gallery-'. $this->addon->id .'">';
					
					if (($class == 'simple') || ($class == 'small')) {
						$output .= '';
					} else {
						$output .= '<i class="ap-plus-1"></i>';
					}
					$output .= '';
				}
				
				// Thumbnail image
				$output .= '<img'. $thumb_class .' src="'. $thumb_src . '" width="' . $width . '" alt="' . $caption . '" />';
		
				if($full_src) {
					$output .= '</a></div>';
				}
				$output .= '</li>';
			}		
		}
		$output .= '</ul>';
		$output	.= '</div>';
		$output .= '</div>';

		return $output;
	}
	
	public function stylesheets() {
		$app = Factory::getApplication();
		$tmplPath = Uri::base(true) . '/templates/'.$app->getTemplate();
		return array($tmplPath.'/sppagebuilder/addons/lightbox/assets/css/imagelightbox.css');
	}
	

	public function scripts() {
		$app = Factory::getApplication();
		$tmplPath = Uri::base(true) . '/templates/'.$app->getTemplate();
		
		return array(
			$tmplPath.'/sppagebuilder/addons/lightbox/assets/js/imagelightbox.min.js'
		);
	}
	public function css() {
		
		$settings = $this->addon->settings;
		$addon_id = '#sppb-addon-' . $this->addon->id;
		$cssHelper = new CSSHelper($addon_id);
		
		$gutter = (isset($settings->spacing) && $settings->spacing) ? $settings->spacing : 12;
		$width = (isset($settings->width) && $settings->width) ? $settings->width : 220;
		
		
		$css = '';
		$imageStyle = '';
		
		$imageStyle = $cssHelper->generateStyle(
			'li.shuffle_sizer',
			$settings,
			[
				'width' => 'width'
			]
		);
		
		if ($settings->spacing == 0) {
			$css .='#grid-'.$this->addon->id.' li.shuffle_sizer {width:'.$width.'px;margin:0;}';
		} else {
			$css .='#grid-'.$this->addon->id.' li.shuffle_sizer {width:'.$width.'px;margin-bottom:'.$gutter.'px;}';
		}
		$css .= $imageStyle;
		//$css = preg_replace(array('/([\s])\1+/', '/[\n\t]+/m'), '', $css); // Removes whitespace
		return $css;
	}
	public function js() {
		
		$settings = $this->addon->settings;
		$gutter = (isset($settings->spacing) && $settings->spacing) ? ',gutter:' . $settings->spacing : '';
		
		if ($settings->spacing == 0) {
			$gutterCSS = ',gutter:0';
		} else {
			$gutterCSS = $gutter;
		}
		$width = (isset($settings->width) && $settings->width) ? $settings->width : 220;
		
		// Removes arrows when there is ONLY one item (image)
		if (count($settings->sp_lightbox_item) == 1) {
			$hide_arrows = 'd-none ';
		} else {
			$hide_arrows = '';
		}
		
		// Masonry version (from June 2022):
		$js ='
		jQuery(function($){$("#grid-'.$this->addon->id.'").imagesLoaded(function(){$("#grid-'.$this->addon->id.'").masonry({
		  isFitWidth:true,
		  itemSelector:\'.shuffle_sizer\',
		  columnWidth:'. $width .'
		  '. $gutterCSS .'
		})}),
		$(function(){var b=function(){$(\'<div class="imagelightbox-loading"><div></div></div>\').appendTo("body")},c=function(){$(".imagelightbox-loading").remove()},d=function(){$(\'<div id="imagelightbox-overlay"></div>\').appendTo("body")},e=function(){$("#imagelightbox-overlay").remove()},f=function(a){$(\'<button type="button" id="imagelightbox-close" title="Close"></button>\').appendTo("body").on("click touchend",function(){return $(this).remove(),a.quitImageLightbox(),!1})},g=function(){$("#imagelightbox-close").remove()},h=function(){var a=$(\'a[href="\'+$("#imagelightbox").attr("src")+\'"] img\').attr("alt");a.length>0&&$(\'<div id="imagelightbox-caption">\'+a+"</div>").appendTo("body")},i=function(){$("#imagelightbox-caption").remove()},j=function(b,c){var a=$(\'<button type="button" class="'. $hide_arrows .'imagelightbox-arrow imagelightbox-arrow-left"><i class="ap-left-2"></i></button><button type="button" class="'. $hide_arrows .'imagelightbox-arrow imagelightbox-arrow-right"><i class="ap-right-2"></i></button>\');a.appendTo("body"),a.on("click touchend",function(d){d.preventDefault();var e=$(this),f=$(c+\'[href="\'+$("#imagelightbox").attr("src")+\'"]\'),a=f.index(c);return e.hasClass("imagelightbox-arrow-left")?(a-=1,$(c).eq(a).length||(a=$(c).length)):(a+=1,$(c).eq(a).length||(a=0)),b.switchImageLightbox(a),!1})},k=function(){$(".imagelightbox-arrow").remove()},a=\'a[data-imagelightbox="gallery-'.$this->addon->id.'"]\',l=$(a).imageLightbox({animationSpeed:300,onStart:function(){d(),f(l),j(l,a)},onEnd:function(){e(),i(),g(),k(),c()},onLoadStart:function(){i(),b()},onLoadEnd:function(){h(),c(),$(".imagelightbox-arrow").css("display","block")}})})});
		';
		$js = preg_replace(array('/([\s])\1+/', '/[\n\t]+/m'), '', $js); // Removes whitespace
		return $js;
	}

}
