<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Uri\Uri;

class SppagebuilderAddonTestimonial extends SppagebuilderAddons {

	public function render() {
		$settings = $this->addon->settings;
		$class = (isset($settings->class) && $settings->class) ? $settings->class : '';
		$class .= (isset($settings->alignment) && $settings->alignment) ? $settings->alignment : 'sppb-text-left';
		$style = (isset($settings->style) && $settings->style) ? $settings->style : '';
		$show_avatar = (isset($settings->show_avatar) && $settings->show_avatar) ? $settings->show_avatar : 1;
		$avatar_position = (isset($settings->alignment) && $settings->alignment) ? $avatar_position = $settings->alignment : $avatar_position = 'left';
		
		$title = (isset($settings->title) && $settings->title) ? $settings->title : '';
		$heading_selector = (isset($settings->heading_selector) && $settings->heading_selector) ? $settings->heading_selector : 'h3';
		$show_quote = (isset($settings->show_quote)) ? $settings->show_quote : 1;
		$designation_position = (isset($settings->designation_position)) ? $settings->designation_position : 'bottom';

		//Options
		$review = (isset($settings->review) && $settings->review) ? $settings->review : '';
		$name = (isset($settings->name) && $settings->name) ? $settings->name : '';
		$company = (isset($settings->company) && $settings->company) ? $settings->company : '';
		
		$avatar = (isset($settings->avatar) && $settings->avatar) ? $settings->avatar : '';
		$avatar_src = isset($avatar->src) ? $avatar->src : $avatar;
		$avatar_width = (isset($settings->avatar_width) && $settings->avatar_width) ? $settings->avatar_width : '';
		$avatar_shape = (isset($settings->avatar_shape) && $settings->avatar_shape) ? $settings->avatar_shape : 'sppb-avatar-round';
		
		// Lazy load image
		$placeholder = $avatar_src == '' ? false : $this->get_image_placeholder($avatar_src);
		$avatar_img = '';

		if (strpos($avatar_src, "http://") !== false || strpos($avatar_src, "https://") !== false) {
			$avatar_img = $avatar_src;
		} else {
			if ($avatar_src) {
				$avatar_img = Uri::base() . $avatar_src;
			}
		}
		
		$show_footer_link = (isset($settings->show_footer_link) && $settings->show_footer_link) ? $settings->show_footer_link : '';
		
		list($link, $link_target) = AddonHelper::parseLink($settings, 'url', ['url' => 'link', 'new_tab' => 'link_target']);
		
		//Rating
		$client_rating_enable = (isset($settings->client_rating_enable)) ? $settings->client_rating_enable : '';
		$client_rating = (isset($settings->client_rating)) ? $settings->client_rating : '';
		
		$link != '' ? $active_link = '' : $active_link = ' inactive';
		$link_strip = preg_replace("/^(http:\/\/|https:\/\/)/", "", $link);

		// Output
		$output  = '';
		$output  = '<div class="sppb-addon sppb-addon-testimonial ' . $class . '">';
		$output .= ($title) ? '<'.$heading_selector.' class="sppb-addon-title">' . $title . '</'.$heading_selector.'>' : '';
		$output .= '<div class="sppb-addon-content">';

		if($style == 'flex') {
			
			$output .= '<div class="sppb-media flex">';
		
			if ($avatar_position != 'center') {

				if ($avatar_img) {

					$output .= $link ? '<a '. $link_target .' class="float-'. $avatar_position .'"  href="'. $link .'">' : '<span class="float-'. $avatar_position .'">';
					$output .= $avatar_img ? '<img'. ($avatar_shape == "sppb-avatar-circle" ? ' style="height:'. $avatar_width .'px;object-fit:cover;"' : '') .' src="' . ($placeholder ? $placeholder : $avatar_img) . '" class="'. $avatar_shape .' sppb-addon-testimonial-avatar sppb-media-object' . ($placeholder ? ' sppb-element-lazy' : '') . '" alt="'. $name .'" ' . ($placeholder ? 'data-large="'. $avatar_img .'"' : '') . ' ' . ($avatar_width ? 'width="'. $avatar_width .'"' : '') . ' loading="lazy">' : '';
					$output .= $link ? '</a>' : '</span>';

				} else {
						
					$output .= $link ? '<a '. $link_target .' class="pull-'. $avatar_position .'"  href="'. $link .'" data-toggle="tooltip" data-placement="top" title="'. $link_strip .'">' : '<span class="float-'. $avatar_position .'">';
					$output .= '<i style="width:' . $avatar_width . 'px;height:' . ( $avatar_width + 5 ) . 'px;line-height:' . ( $avatar_width + 3 ) . 'px;font-size:' . ( $avatar_width / 1.8 ) . 'px;" class="fa-solid fa-user pull-'.$avatar_position.'"></i>';	
					$output .= $link ? '</a>' : '</span>';

				}

			} else {
				if ($avatar_img) {

					$output .= $link ? '<a ' . $link_target . ' class="d-table pull-center" '. ($avatar_width ? 'style="width:' . $avatar_width . 'px"' : '') .' href="' . $link . '">' : '';
					//$output .= ($avatar_width ? 'style="width:' . $avatar_width . 'px"' : '');
					$output .= $avatar_img ? '<img src="' . ($placeholder ? $placeholder : $avatar_img) . '" class="' . $avatar_shape . ' sppb-addon-testimonial-avatar sppb-media-object d-table pull-center ' . ($placeholder ? ' sppb-element-lazy' : '') . '" alt="' . $name . '" ' . ($placeholder ? 'data-large="' . $avatar_img . '"' : '') . ' ' . ($avatar_width ? 'width="' . $avatar_width . '"' : '') . ' loading="lazy">' : '';
					$output .= $link ? '</a>' : '';
					
				} else {
					$output .= $link ? '<a ' . $link_target . ' class="d-table mx-auto" '. ($avatar_width ? 'style="width:' . $avatar_width . 'px"' : '') .' href="' . $link . '">' : '';
					$output .= '<i style="width:' . $avatar_width . 'px;height:' . ( $avatar_width + 1 ) . 'px;line-height:' . ( $avatar_width - 2 ) . 'px;font-size:' . ( $avatar_width / 1.8 ) . 'px;" class="fa-solid fa-user pull-center mx-auto d-table"></i>';
					$output .= $link ? '</a>' : '';	
				}
				//$output .= '<div class="div-pull-center clearfix"></div>';
			}

			$output .= '<div style="text-align:'.$avatar_position.'" class="sppb-media-body">';
			if($show_quote){
				$output .= '<i class="fa-solid fa-quote-left'. $active_link .'"></i>';
			}
			$output .= $review;
			if($show_quote){
				$output .= '<i class="fa-solid fa-quote-right'. $active_link .'"></i>';
			}
			if ($avatar_position != 'center') {
				$output .= '<footer class="pull-'.$avatar_position.'"><strong><em>'. $name .'</em></strong> <cite>'. $company .'</cite></footer>';

			} else {
				$output .= '<footer class="pull-center"><strong class="pull-center">'. $name .'</strong> <cite>'. $company .'</cite>';
				$output .= '</footer>';	
			}

			// Link bellow
			if($show_footer_link){
				$output .= $link ? '<div class="d-block w-100 clearfix mt-3 mb-2 pe-va"></div><a ' . $link_target . ' href="'. $link .'"><em style="vertical-align:top;" class="client-url mt-5 pe-va">'.$link_strip.'</em></a>' : '';
			}
			// Rating
			if($client_rating_enable){
				$output .= '<div class="sppb-addon-testimonial-rating">';
				if ($client_rating == 1) {
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
				} elseif ($client_rating == 2) {
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
				} elseif ($client_rating == 3) {
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
				} elseif ($client_rating == 4) {
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
				} elseif ($client_rating == 5) {
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
				}
				$output .= '</div>';
			}

			$output .= '</div>';
			$output .= '</div>';

	
		} else {
	
			$output .= '<div class="sppb-media default">';

			if ($avatar_position != 'center') {

				if ($avatar_img) {
					
					$output .= '<div class="sppb-addon-testimonial-footer">';
					$output .= $link ? '<a '. $link_target .' class="float-'. $avatar_position .'"  href="'. $link .'">' : '';
					$output .= $avatar_img ? '<img'. ($avatar_shape == "sppb-avatar-circle" ? ' style="height:'. $avatar_width .'px;object-fit:cover;"' : '') .' src="' . ($placeholder ? $placeholder : $avatar_img) . '" class="'. $avatar_shape .' sppb-addon-testimonial-avatar sppb-media-object float-'.$avatar_position.'' . ($placeholder ? ' sppb-element-lazy' : '') . '" alt="'. $name .'" ' . ($placeholder ? 'data-large="'. $avatar_img .'"' : '') . ' ' . ($avatar_width ? 'width="'. $avatar_width .'"' : '') . ' loading="lazy">' : '';
					$output .= $link ? '</a>' : '';
					$output .= '</div>';
					
				} else {
					if ($link) {
					$output .= '<a '. $link_target .' class="pull-'. $avatar_position .'" href="'. $link .'">';
					$output .= '<i style="width:' . $avatar_width . 'px;height:' . ( $avatar_width + 1 ) . 'px;line-height:' . ( $avatar_width - 2 ) . 'px;font-size:' . ( $avatar_width / 1.8 ) . 'px;" class="fa-solid fa-user"></i>';
					$output .= '</a>';	
					} else {
						$output .= '<i style="width:' . $avatar_width . 'px;height:' . ( $avatar_width + 1 ) . 'px;line-height:' . ( $avatar_width - 2 ) . 'px;font-size:' . ( $avatar_width / 1.8 ) . 'px;" class="fa-solid fa-user pull-'.$avatar_position.'"></i>';
					}
				}

			} else {
				
				if ($avatar_img) {

					$output .= '<div class="sppb-addon-testimonial-footer pull-center">';
					$output .= $link ? '<a '. $link_target .' class="pull-center"  href="'. $link .'">' : '';
					$output .= $avatar_img ? '<img'. ($avatar_shape == "sppb-avatar-circle" ? ' style="height:'. $avatar_width .'px;object-fit:cover;"' : '') .' src="' . ($placeholder ? $placeholder : $avatar_img) . '" class="'. $avatar_shape .' sppb-addon-testimonial-avatar sppb-media-object pull-center ' . ($placeholder ? ' sppb-element-lazy' : '') . '" alt="'. $name .'" ' . ($placeholder ? 'data-large="'. $avatar_img .'"' : '') . ' ' . ($avatar_width ? 'width="'. $avatar_width .'"' : '') . ' loading="lazy">' : '';
					$output .= $link ? '</a>' : '';
					$output .= '</div>';
					
				} else {
					
					$output .= '<div class="sppb-addon-testimonial-footer pull-center">';
					$output .= $link ? '<a '. $link_target .' class="pull-center"  href="'. $link .'">' : '';
					$output .= '<i style="width:' . $avatar_width . 'px;height:' . ( $avatar_width + 1 ) . 'px;line-height:' . ( $avatar_width - 2 ) . 'px;font-size:' . ( $avatar_width / 1.8 ) . 'px;" class="fa-solid fa-user pull-center"></i>';
					$output .= $link ? '</a>' : '';
					$output .= '</div>';
				}
				
			}
			if ($avatar_position != 'center') {
				$output .= '<div style="text-align:'. $avatar_position .'" class="sppb-media-body">';
			} else {
				$output .= '<div class="sppb-media-body centered">';
			}

			$output .= $review;

			if ($avatar_position != 'center') {
				$output .= '<footer><strong>'.$name.'</strong> <cite>'.$company.'</cite></footer>';
			} else {
				$output .= '<footer><strong>'.$name.'</strong> <cite>'.$company.'</cite>';
				
				$output .= '</footer>';
			}

			// Link bellow
			if($show_footer_link){
				$output .= $link ? '<div class="d-block clearfix mt-1 mb-1"><a ' . $link_target . ' href="'. $link .'"><em style="vertical-align:top;" class="client-url">'.$link_strip.'</em></a><i class="pe pe-7s-link"></i></div>' : '';
			}
			// Rating
			if($client_rating_enable){
				$output .= '<div class="sppb-addon-testimonial-rating">';
				if($client_rating == 1){
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
				} elseif($client_rating == 2){
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
				} elseif($client_rating == 3){
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
				} elseif($client_rating == 4){
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-regular fa-star" aria-hidden="true"></i>';
				} elseif($client_rating == 5){
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
					$output .= '<i class="fa-solid fa-star" aria-hidden="true"></i>';
				}
				$output .= '</div>';
			}

			$output .= '</div>';
			$output .= '</div>';
	}
	 
		$output .= '</div>';
		$output .= '</div>';
	
		return $output;

	}

	public function css() {
		
		$settings = $this->addon->settings;
		$addon_id = '#sppb-addon-' . $this->addon->id;
		$cssHelper = new CSSHelper($addon_id);

		$css = '';
		$style = '';
		$style_sm = '';
		$style_xs = '';
		$style .= (isset($settings->review_color) && $settings->review_color) ? "color: " . $settings->review_color . ";" : "";
		$style .= (isset($settings->review_size) && $settings->review_size) ? "font-size: " . $settings->review_size . "px;" : "";
		$style_sm .= (isset($settings->review_size_sm) && $settings->review_size_sm) ? "font-size: " . $settings->review_size_sm . "px;" : "";
		$style_xs .= (isset($settings->review_size_xs) && $settings->review_size_xs) ? "font-size: " . $settings->review_size_xs . "px;" : "";

		$style .= (isset($settings->review_line_height) && $settings->review_line_height) ? "line-height: " . $settings->review_line_height . "px;" : "";
		$style_sm .= (isset($settings->review_line_height_sm) && $settings->review_line_height_sm) ? "line-height: " . $settings->review_line_height_sm . "px;" : "";
		$style_xs .= (isset($settings->review_line_height_xs) && $settings->review_line_height_xs) ? "line-height: " . $settings->review_line_height_xs . "px;" : "";
		
		$css .= $cssHelper->generateStyle('.sppb-addon-testimonial-footer img.sppb-media-object', $settings, ['avatar_width' => ['width'], 'avatar_margin' => 'margin'], ['avatar_margin' => false], ['avatar_margin' => 'spacing']);
		
		$css .= $cssHelper->generateStyle('.sppb-media .sppb-addon-testimonial-avatar', $settings, ['avatar_width' => ['width'], 'avatar_margin' => 'margin'], ['avatar_margin' => false], ['avatar_margin' => 'spacing']);
		
		if($style){
			$css .= '#sppb-addon-' . $this->addon->id . ' .sppb-media-body{ ' . $style . ' }';
		}

		if($style_sm){
			$css .= '@media (min-width: 768px) and (max-width: 991px) {#sppb-addon-' . $this->addon->id . ' .sppb-media-body{ ' . $style_sm . ' }}';
		}

		if($style_xs){
			$css .= '@media (max-width: 767px) {#sppb-addon-' . $this->addon->id . ' .sppb-media-body{ ' . $style_xs . ' }}';
		}

		$icon_style = '';
		$icon_style_sm = '';
		$icon_style_xs = '';

		$icon_style_sm .= (isset($settings->icon_size_sm) && $settings->icon_size_sm) ? "font-size: " . $settings->icon_size_sm . "px;" : "";
		$icon_style_xs .= (isset($settings->icon_size_xs) && $settings->icon_size_xs) ? "font-size: " . $settings->icon_size_xs . "px;" : "";
		
		$iconStyle          = $cssHelper->generateStyle('.sppb-addon-testimonial .fa-quote-left, .sppb-addon-testimonial .fa-quote-right', $settings, ['icon_color' => 'color', 'icon_size' => 'font-size'], ['icon_color' => false]);
		$ratingStyle        = $cssHelper->generateStyle('.sppb-addon-testimonial-rating i', $settings, ['client_rating_fontsize' => 'font-size', 'client_rating_margin' => 'margin'], ['client_rating_margin' => false], ['client_rating_margin' => 'spacing']);
		$clientRatingStyle  = $cssHelper->generateStyle('.sppb-addon-testimonial-rating i.fa-star', $settings, ['client_rating_color' => 'color'], false);
		$clientUnratedStyle = $cssHelper->generateStyle('.sppb-addon-testimonial-rating i.fa-star-o', $settings, ['client_unrated_color' => 'color'], false);
		
		$css .= $iconStyle;
		$css .= $ratingStyle;
		$css .= $clientRatingStyle;
		$css .= $clientUnratedStyle;


		return $css;
	}

	
	public static function getTemplate()
	{
		$lodash = new Lodash('#sppb-addon-{{ data.id }}');
		$output = '
			<#
				let avatar_position = data.avatar_position || "left"
				let avatar = ""
				if (typeof data.avatar !== "undefined" && typeof data.avatar.src !== "undefined") {
					avatar = data.avatar
				} else {
					avatar = {src: data.avatar}
				}
				let avatar_shape = data.avatar_shape || "sppb-avatar-round";

	
				if(!data.alignment){
					data.alignment = "left";
				} else {
					data.alignment = data.alignment;
				}


				const urlObj = _.isObject(data.url) ? data.url : window.getSiteUrl(data?.link || "", data?.link_target || "");
				const {url, menu, page, type, new_tab, nofollow, noopener, noreferrer} = urlObj;
				const target = new_tab ? "_blank" : "";

				let relValue="";
				relValue += nofollow ? "nofollow" : "";
				relValue += noreferrer ? " noreferrer" : "";
				relValue += noopener ? " noopener" : "";
			
				let newUrl = "";
				if(type === "url" || !type) newUrl = url;
				if(type === "menu") newUrl = menu;
				if(type === "page") newUrl = page ? `index.php?option=com_sppagebuilder&view=page&id=${page}` : "";
				
				let reviewer_link = newUrl;
				let link_target = (new_tab)? "target=\'"+ target +"\'": "";
				let relfollow = (relValue)? relValue: "";

				if(!data.designation_position){
					data.designation_position = "bottom";
				}
			#>

		<style type="text/css">';

		$output .= '<# if (data.avatar_dis_block) { #>';
		$output .= '#sppb-addon-{{ data.id }} .sppb-addon-testimonial-content-wrap > span, #sppb-addon-{{ data.id }} .sppb-addon-testimonial-content-wrap { display:block; }';
		$output .= '<# } #>';

		$output .= '<# if (data.show_quote) { #>';
		$output .= $lodash->unit('font-size', '.sppb-addon-testimonial .fa-quote-left, .sppb-addon-testimonial .fa-quote-right', 'data.icon_size', 'px');
		$output .= $lodash->color('color', '.sppb-addon-testimonial .fa-quote-left, .sppb-addon-testimonial .fa-quote-right', 'data.icon_color');
		$output .= '<# } #>';
		$output .= '<# if (data.client_rating_enable) { #>';
		$output .= $lodash->unit('font-size', '.sppb-addon-testimonial-rating i', 'data.client_rating_fontsize', 'px');
		$output .= $lodash->spacing('margin', '.sppb-addon-testimonial-rating i', 'data.client_rating_margin');
		$output .= '<# } #>';
		$output .= $lodash->color('color', '.sppb-addon-testimonial-rating i.fa-solid', 'data.client_rating_color');
		$output .= $lodash->color('color', '.sppb-addon-testimonial-rating i.fa-regular', 'data.client_unrated_color');

		$output .= $lodash->alignment('text-align', '.sppb-addon-testimonial', 'data.alignment');
		
		//$output .= $lodash->alignment('float', '.sppb-addon-testimonial .avatar_img', 'data.alignment');
		$output .= $lodash->alignment('float', '.sppb-addon-testimonial .avatar_img, .sppb-addon-testimonial .sppb-media-object, .sppb-addon-testimonial .fa-user', 'data.alignment');
		
		//$output .= $lodash->flexAlignment('.sppb-addon-testimonial .avatar_img', 'data.alignment');
		//$output .= $lodash->alignment('float', '.sppb-addon-testimonial-avatar', 'data.alignment');
		//$output .= $lodash->flexAlignment('.sppb-addon-testimonial-content-wrap', 'data.alignment');

		// Review
		$reviewTypographyFallbacks = [
			'font'        => 'data.review_font_family',
			'size'        => 'data.review_size',
			'line_height' => 'data.review_line_height',
			'weight'      => 'data.review_fontweight',
		];

		$output .= $lodash->typography('.sppb-addon-testimonial-review', 'data.review_typography', $reviewTypographyFallbacks);
		// Name
		$nameTypographyFallbacks = [
			'font'        => 'data.name_font_family',
			'size'        => 'data.name_font_size',
			'line_height' => 'data.name_line_height',
			'uppercase'   => 'data.name_font_style?.uppercase',
			'italic'      => 'data.name_font_style?.italic',
			'underline'   => 'data.name_font_style?.underline',
			'weight'      => 'data.name_font_style?.weight',
		];

		$output .= $lodash->typography('.sppb-addon-testimonial-footer .sppb-addon-testimonial-client', 'data.name_typography', $nameTypographyFallbacks);
		// Designation
		$designationTypographyFallbacks = [
			'font'        => 'data.company_font_family',
			'size'        => 'data.company_font_size',
			'line_height' => 'data.company_line_height',
			'uppercase'   => 'data.company_font_style?.uppercase',
			'italic'      => 'data.company_font_style?.italic',
			'underline'   => 'data.company_font_style?.underline',
			'weight'      => 'data.company_font_style?.weight',
		];
		$output .= $lodash->typography('.sppb-addon-testimonial-footer .sppb-addon-testimonial-client-url', 'data.designation_typography', $designationTypographyFallbacks);
		// Title
		$titleTypographyFallbacks = [
			'font'           => 'data.title_font_family',
			'size'           => 'data.title_fontsize',
			'line_height'    => 'data.title_lineheight',
			'letter_spacing' => 'data.title_letterspace',
			'uppercase'      => 'data.title_font_style?.uppercase',
			'italic'         => 'data.title_font_style?.italic',
			'underline'      => 'data.title_font_style?.underline',
			'weight'         => 'data.title_font_style?.weight',
		];

		$output .= $lodash->typography('.sppb-addon-testimonial .sppb-addon-title', 'data.title_typography', $titleTypographyFallbacks);
		$output .= $lodash->color('color', '.sppb-addon-testimonial-review', 'data.review_color');
		$output .= $lodash->color('color', '.sppb-addon-testimonial-footer .sppb-addon-testimonial-client', 'data.name_color');
		$output .= $lodash->color('color', '.sppb-addon-testimonial-footer .sppb-addon-testimonial-client-url', 'data.company_color');
		$output .= $lodash->spacing('margin', '.sppb-addon-testimonial-review', 'data.review_margin');
		$output .= $lodash->spacing('margin', '.sppb-addon-testimonial-footer .sppb-addon-testimonial-client', 'data.name_margin');
		$output .= $lodash->spacing('margin', '.sppb-addon-testimonial-footer .sppb-addon-testimonial-client-url', 'data.client_rating_margin');
		$output .= $lodash->spacing('margin', '.sppb-media img.sppb-media-object', 'data.avatar_margin');
		//$output .= $lodash->unit('height', '.sppb-addon-testimonial-content-wrap img', 'data.avatar_width', 'px');
		$output .= $lodash->unit('width', '.sppb-media img.sppb-media-object', 'data.avatar_width', 'px');

		$output .= '
			</style>

			<div class="sppb-addon sppb-addon-testimonial {{ data.class }}">
				<# if( !_.isEmpty( data.title ) ){ #><{{ data.heading_selector }} class="sppb-addon-title sp-inline-editable-element" data-id={{data.id}} data-fieldName="title" contenteditable="true">{{ data.title }}</{{ data.heading_selector }}><# } #>
				<div class="sppb-addon-content">
		
					
				<# if(data.style == "flex") { #>
					 <div class="sppb-media flex">
							<# if (reviewer_link) { #>
								<a {{ link_target }} class="avatar_img mx-3" rel=\'{{ relfollow }}\' href=\'{{ reviewer_link }}\'>
							<# } #>
								<# if (avatar.src && avatar.src.indexOf("https://") == -1 && avatar.src.indexOf("http://") == -1) { #>
									<img class="{{ avatar_shape }} sppb-addon-testimonial-avatar sppb-media-object" src=\'{{ pagebuilder_base + avatar.src }}\' width="{{ data.avatar_width }}" alt="{{ data.name }}">
								<# } else if(avatar.src){ #>
									<img class="{{ avatar_shape }} sppb-addon-testimonial-avatar sppb-media-object" src=\'{{ avatar.src }}\' width="{{ data.avatar_width }}" alt="{{ data.name }}">
								<# } else { #>
									<i style="width:{{ data.avatar_width }}px;height:{{ data.avatar_width * 1.05 }}px;line-height:{{ data.avatar_width * 1.05 }}px;font-size:{{ data.avatar_width / 1.8}}px;" class="fa-solid fa-user mx-3"></i>
								<# } #>
							<# if (reviewer_link) { #>
								</a>
							<# } #>
							
							<div style="text-align:{{data.alignment}}" class="sppb-media-body">
								<# if(data.show_quote){ #><i class="fa-solid fa-quote-left"></i><# } #>
								
							<div id="addon-review-{{data.id}}" class="d-inline sp-editable-content" data-id={{data.id}} data-fieldName="review">{{{ data.review }}}</div>
					
								<# if(data.show_quote){ #><i class="fa-solid fa-quote-right"></i><# } #>
							
								<footer class="float-{{data.alignment}}"><strong><em>{{ data.name }}</em></strong> <cite>{{ data.company }}</cite></footer>
								
								
								<# if(data.show_footer_link == 1){ #>
								<div class="d-block clearfix mt-1 mb-1"><a {{ link_target }} rel=\'{{ relfollow }}\' href=\'{{ reviewer_link }}\'><em style="vertical-align:top;" class="client-url">{{ reviewer_link }}</em></a></div>
								<# } #>
			
								<# if(data.client_rating_enable){ #>
									<div class="sppb-addon-testimonial-rating">
									<# if(data.client_rating == 1){ #>
										<i class="fa-solid fa-star" aria-hidden="true"></i>
										<i class="fa-regular fa-star" aria-hidden="true"></i>
										<i class="fa-regular fa-star" aria-hidden="true"></i>
										<i class="fa-regular fa-star" aria-hidden="true"></i>
										<i class="fa-regular fa-star" aria-hidden="true"></i>
									<# } else if(data.client_rating == 2){ #>
										<i class="fa-solid fa-star" aria-hidden="true"></i>
										<i class="fa-solid fa-star" aria-hidden="true"></i>
										<i class="fa-regular fa-star" aria-hidden="true"></i>
										<i class="fa-regular fa-star" aria-hidden="true"></i>
										<i class="fa-regular fa-star" aria-hidden="true"></i>
									<# } else if(data.client_rating == 3){ #>
										<i class="fa-solid fa-star" aria-hidden="true"></i>
										<i class="fa-solid fa-star" aria-hidden="true"></i>
										<i class="fa-solid fa-star" aria-hidden="true"></i>
										<i class="fa-regular fa-star" aria-hidden="true"></i>
										<i class="fa-regular fa-star" aria-hidden="true"></i>
									<# } else if(data.client_rating == 4){ #>
										<i class="fa-solid fa-star" aria-hidden="true"></i>
										<i class="fa-solid fa-star" aria-hidden="true"></i>
										<i class="fa-solid fa-star" aria-hidden="true"></i>
										<i class="fa-solid fa-star" aria-hidden="true"></i>
										<i class="fa-regular fa-star" aria-hidden="true"></i>
									<# } else if(data.client_rating == 5){ #>
										<i class="fa-solid fa-star" aria-hidden="true"></i>
										<i class="fa-solid fa-star" aria-hidden="true"></i>
										<i class="fa-solid fa-star" aria-hidden="true"></i>
										<i class="fa-solid fa-star" aria-hidden="true"></i>
										<i class="fa-solid fa-star" aria-hidden="true"></i>
									<# } #>
									</div>
								<# } #>
						
						</div> <!-- End of sppb-media-body DIV -->
					</div> <!-- End of Flex style DIV -->
				<# } #>

					<# if(data.style !== "flex") { #>
					
						<div class="sppb-media default">
						
								<# if (reviewer_link) { #>
									<a {{ link_target }} class="avatar_img mx-3" rel=\'{{ relfollow }}\' href=\'{{ reviewer_link }}\'>
								<# } #>
								<div class="sppb-addon-testimonial-footer">
									<# if (avatar.src && avatar.src.indexOf("https://") == -1 && avatar.src.indexOf("http://") == -1) { #>
										<img<# if (avatar_shape == "sppb-avatar-circle") { #> style="height:{{ data.avatar_width }}px;object-fit:cover;"<# } #> class="{{ avatar_shape }} sppb-addon-testimonial-avatar sppb-media-object" src=\'{{ pagebuilder_base + avatar.src }}\' width="{{ data.avatar_width }}" alt="{{ data.name }}">
									<# } else if(avatar.src){ #>
										<span class="float-{{data.alignment}}"><img<# if (avatar_shape == "sppb-avatar-circle") { #> style="height:{{ data.avatar_width }}px;object-fit:cover;"<# } #> class="{{ avatar_shape }} sppb-addon-testimonial-avatar sppb-media-object" src=\'{{ avatar.src }}\' width="{{ data.avatar_width }}" alt="{{ data.name }}"></span>
									<# } else { #>
										<i style="width:{{ data.avatar_width }}px;height:{{ data.avatar_width * 1.05 }}px;line-height:{{ data.avatar_width * 1.05 }}px;font-size:{{ data.avatar_width / 1.8}}px;" class="pull-{{data.alignment}} fa-solid fa-user mx-3"></i>
									<# } #>
								</div>
								<# if (reviewer_link) { #>
									</a>
								<# } #>
								
								<div style="text-align:{{data.alignment}}" class="sppb-media-body">

								<div id="addon-review-{{data.id}}" class="d-inline sp-editable-content" data-id={{data.id}} data-fieldName="review">
								{{{ data.review }}}
								</div>
								
								<footer class="float-{{data.alignment}} w-100"><strong><em>{{ data.name }}</em></strong> <cite>{{ data.company }}</cite></footer>
								
								<# if(data.show_footer_link == 1){ #>
								<div class="d-block clearfix mt-1 mb-1"><a {{ link_target }} rel=\'{{ relfollow }}\' href=\'{{ reviewer_link }}\'><em style="vertical-align:top;" class="client-url">{{ reviewer_link }}</em></a><# if (reviewer_link) { #><i class="pe pe-7s-link"></i><# } #></div>
								<# } #>
								
									<# if(data.client_rating_enable){ #>
										<div class="sppb-addon-testimonial-rating clearfix">
										<# if(data.client_rating == 1){ #>
											<i class="fa-solid fa-star" aria-hidden="true"></i>
											<i class="fa-regular fa-star" aria-hidden="true"></i>
											<i class="fa-regular fa-star" aria-hidden="true"></i>
											<i class="fa-regular fa-star" aria-hidden="true"></i>
											<i class="fa-regular fa-star" aria-hidden="true"></i>
										<# } else if(data.client_rating == 2){ #>
											<i class="fa-solid fa-star" aria-hidden="true"></i>
											<i class="fa-solid fa-star" aria-hidden="true"></i>
											<i class="fa-regular fa-star" aria-hidden="true"></i>
											<i class="fa-regular fa-star" aria-hidden="true"></i>
											<i class="fa-regular fa-star" aria-hidden="true"></i>
										<# } else if(data.client_rating == 3){ #>
											<i class="fa-solid fa-star" aria-hidden="true"></i>
											<i class="fa-solid fa-star" aria-hidden="true"></i>
											<i class="fa-solid fa-star" aria-hidden="true"></i>
											<i class="fa-regular fa-star" aria-hidden="true"></i>
											<i class="fa-regular fa-star" aria-hidden="true"></i>
										<# } else if(data.client_rating == 4){ #>
											<i class="fa-solid fa-star" aria-hidden="true"></i>
											<i class="fa-solid fa-star" aria-hidden="true"></i>
											<i class="fa-solid fa-star" aria-hidden="true"></i>
											<i class="fa-solid fa-star" aria-hidden="true"></i>
											<i class="fa-regular fa-star" aria-hidden="true"></i>
										<# } else if(data.client_rating == 5){ #>
											<i class="fa-solid fa-star" aria-hidden="true"></i>
											<i class="fa-solid fa-star" aria-hidden="true"></i>
											<i class="fa-solid fa-star" aria-hidden="true"></i>
											<i class="fa-solid fa-star" aria-hidden="true"></i>
											<i class="fa-solid fa-star" aria-hidden="true"></i>
										<# } #>
										</div>
									<# } #>

							</div> <!-- End of sppb-media-body DIV -->
						</div> <!-- End of Default style DIV -->
					<# } #>
				</div>
			</div>
			';

		return $output;
	}
}
