<?php
/**
 * @package Case-Themes
 */

if ( post_password_required() ) {
    return;
} 
$post_related = floka()->get_theme_opt( 'post_related', false );
?>

<div id="comments" class="comments-area">

    <?php
    if ( have_comments() ) : ?>
        <div class="comment-list-wrap">

            <h2 class="comments-title">
                <?php
                $comment_count = get_comments_number();
                if ( 1 === intval($comment_count) ) {
                    echo esc_html__( 'Comments', 'floka' );
                } else {
                    echo esc_html__('Comments', 'floka');
                }
                ?>
            </h2>

            <?php the_comments_navigation(); ?>

            <ul class="comment-list">
                <?php
                wp_list_comments( array(
                    'style'      => 'ul',
                    'short_ping' => true,
                    'callback'   => 'floka_comment_list',
                    'max_depth'  => 3
                ) );
                ?>
            </ul>

            <?php the_comments_navigation(); ?>
        </div>
        <?php if ( ! comments_open() ) : ?>
            <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'floka' ); ?></p>
            <?php
        endif;

    endif;

    $args = array(
        'id_form'           => 'commentform',
        'id_submit'         => 'submit',
        'class_submit'         => 'btn',
        'title_reply'       => esc_attr__( 'Add comment:', 'floka'),
        'title_reply_to'    => esc_attr__( 'Add comment To:', 'floka') . '%s',
        'cancel_reply_link' => esc_attr__( 'Cancel Comment', 'floka'),
        'submit_button'     => '<button name="%1$s" type="submit" id="%2$s" class="%3$s" /><span class="pxl--btn-icon"><span class="pxl-icon--plus"></span></span><span class="pxl--btn-text">Make Comment 
        </span></button>',
        'comment_notes_before' => '',
        'fields' => apply_filters( 'comment_form_default_fields', array(

            'author_firstname' =>
            '<div class="row"><div class="comment-form-author col-lg-6 col-md-6 col-sm-6">'.
            '<input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) .
            '" size="30" placeholder="'.esc_attr__('Name*', 'floka').'"/></div>',

            'email' =>
            '<div class="comment-form-email col-lg-6 col-md-6 col-sm-6">'.
            '<input id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) .
            '" size="30" placeholder="'.esc_attr__('Email Address*', 'floka').'"/></div></div>',
        )
    ),
        'comment_field' =>  '<div class="comment-form-comment"><textarea id="comment" name="comment" cols="45" rows="8" placeholder="'.esc_attr__('Comment Here', 'floka').'" aria-required="true">' .
        '</textarea></div>',
    );
    comment_form($args); ?>
</div>
<?php if ($post_related) :?>
    <?php floka()->blog->get_related_post();  ?>
<?php endif; ?>
