<?php
$title = $settings['title'] ?? '';
$number = $settings['number'] ?? '';
$desc = $settings['desc'] ?? '';
$image_id = $settings['image']['id'] ?? '';
$img_size = $settings['img_size'] ?? '600x600';
$thumbnail = floka_get_thumbnail($image_id, $img_size);
?>
<div class="pxl-book--call pxl-book--call1 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
	<div class="pxl-item--holder">
		<a <?php floka_render_link_attributes($settings['link']); ?>></a>
		<?php if (!empty($settings['image'])) : ?>
			<div class="pxl-item--image">
				<?php pxl_print_html($thumbnail); ?>
			</div>
		<?php endif; ?>
		<div class="pxl-item--content">
			<?php if (!empty($title)) : ?>
				<h3 class="pxl-item--title">
					<?php pxl_print_html($title); ?>
				</h3>
			<?php endif; ?>

			<?php if (!empty($desc)) : ?>
				<div class="pxl-item--desc">
					<?php pxl_print_html($desc); ?>
				</div>
			<?php endif; ?>

		</div>
	</div>


</div>