<?php
$image_id = $settings['image']['id'] ?? '';
$img_size = $settings['img_size'] ?? '680px676';
$thumbnail = floka_get_thumbnail($image_id, $img_size);
$title = $settings['title'] ?? '';
$desc = $widget->parse_text_editor( $settings['desc'] );
$text_button = $settings['text_button'] ?? '';
$show_button = $settings['show_button'] ?? '';
$show_button_icon = $settings['show_button_icon'] ?? '';
$show_button_video = $settings['show_button_video'] ?? '';
?>


<div class="pxl-feature--card pxl-feature--card1">
	<div class="pxl-item--holder">
		<div class="pxl-item--inner">
			<?php if (!empty($thumbnail)) : ?>
				<div class="pxl-image--feature pxl-image-scale-parallax">
					<?php pxl_print_html($thumbnail); ?>
					<?php if ($show_button_video) : ?>
						<a class="btn-video pxl-action-popup" <?php floka_render_link_attributes($settings['video_link']); ?>>
							<i class="fas fa-play"></i>
						</a>
					<?php endif; ?>
					<?php if ($show_button_icon) : ?>
						<a class="btn-icon" <?php floka_render_link_attributes($settings['link']); ?>>
							<span class="pxl-icon--plus"></span>
						</a>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			<div class="pxl-item--content">
				<?php if (!empty($title)) : ?>
					<h3 class="pxl-item--title">
						<?php pxl_print_html($title); ?>
					</h3>
				<?php endif; ?>

				<?php if (!empty($desc)) : ?>
					<div class="pxl-item--desc">
						<?php pxl_print_html($desc); ?>
					</div>
				<?php endif; ?>

			</div>
		</div>
		<?php if ($show_button) : ?>
			<a <?php floka_render_link_attributes($settings['link']); ?> class="pxl-item--button">
				<?php pxl_print_html($text_button); ?>
				<span class="pxl-icon--plus"></span>
			</a>
		<?php endif; ?>
	</div>


</div>