<?php
$html_id = pxl_get_element_id($settings);

$editor_subtitle = $widget->get_settings_for_display( 'sub_title', '' );
if( !empty($editor_subtitle) ) {
	$editor_subtitle = $widget->parse_text_editor( $editor_subtitle );
}

$editor_title = $widget->get_settings_for_display( 'title', '' );
if( $settings['source_type'] == 'text' && !empty($editor_title) ) {
	$editor_title = $widget->parse_text_editor( $editor_title );
}

$sg_post_title = floka()->get_theme_opt('sg_post_title', 'default');
$sg_post_title_text = floka()->get_theme_opt('sg_post_title_text');

$sg_product_ptitle = floka()->get_theme_opt('sg_product_ptitle', 'default');
$sg_product_ptitle_text = floka()->get_theme_opt('sg_product_ptitle_text');

$sg_service_title = floka()->get_theme_opt('sg_service_title', 'default');
$sg_service_title_text = floka()->get_theme_opt('sg_service_title_text');

$sg_portfolio_title = floka()->get_theme_opt('sg_portfolio_title', 'default');
$sg_portfolio_title_text = floka()->get_theme_opt('sg_portfolio_title_text');
?>

<div id="pxl-<?php echo esc_attr($html_id) ?>" class="pxl-heading <?php if(!empty($settings['highlight_text_image']['id'])) { echo 'highlight-text-image'; } ?>">
	<div class="pxl-heading--inner">
		<?php if(!empty($settings['sub_title'])) : ?>
			<div class="pxl-item--subtitle <?php echo esc_attr($settings['pxl_animate_sub']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay_sub']); ?>ms">
				<span class="pxl-item--subtext <?php echo esc_attr($settings['sub_title_style_color']); ?>">
					<?php echo wp_kses_post($editor_subtitle); ?>
				</span>
			</div>
		<?php endif; ?>

		<<?php echo esc_attr($settings['title_tag']); ?> class="pxl-item--title <?php if ($settings['title_style_color'] === 'text-gradient-2') { echo 'text-gradient'; } ?> <?php echo esc_attr($settings['h_title_style'].' '.$settings['highlight_style'].' '.$settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">

		<span class="pxl-heading--text <?php echo pxl_print_html($settings['title_style_color']); ?>">

			<?php if(is_singular('post') && $sg_post_title == 'custom_text' && !empty($sg_post_title_text) && $settings['source_type'] == 'title') { ?>
				<?php echo pxl_print_html($sg_post_title_text); ?>
				
			<?php } elseif(is_singular('portfolio') && $sg_portfolio_title == 'custom_text' && !empty($sg_portfolio_title_text) && $settings['source_type'] == 'title') { ?>
				<?php echo pxl_print_html($sg_portfolio_title_text); ?>
				
			<?php } elseif(is_singular('service') && $sg_service_title == 'custom_text' && !empty($sg_service_title_text) && $settings['source_type'] == 'title') { ?>
				<?php echo pxl_print_html($sg_service_title_text); ?>

			<?php } elseif(is_singular('product') && $sg_product_ptitle == 'custom_text' && !empty($sg_product_ptitle_text) && $settings['source_type'] == 'title') { ?>
				<?php echo pxl_print_html($sg_product_ptitle_text); ?>
				
			<?php } else { ?>
				<?php if($settings['source_type'] == 'text' && !empty($editor_title)) {
					if($settings['h_title_style'] == 'style-outline') { ?>
						<span class="pxl-text-line-backdrop">
							<span><?php echo wp_kses_post($editor_title); ?></span>

						</span>
					<?php } else {
						echo wp_kses_post($editor_title);
					}
				} elseif($settings['source_type'] == 'title') {
					$titles = floka()->page->get_title();
					if(!empty($_GET['blog_title'])) {
						$blog_title = $_GET['blog_title'];
						$custom_title = explode('_', $blog_title);
						foreach ($custom_title as $index => $value) {
							$arr_str_b[$index] = $value;
						}
						$str = implode(' ', $arr_str_b);
						echo wp_kses_post($str);
					} else {
						pxl_print_html($titles['title']);
					}
				}?>	
			<?php } ?>	

		</span>
		</<?php echo esc_attr($settings['title_tag']); ?>>
		
	</div>
</div>