<?php 
$image_size = !empty($settings['img_size']) ? $settings['img_size'] : '450x450';
?>
<div class="pxl--physics pxl--physics2">
    <?php foreach ($settings['texts'] as $key => $value):
        $title = isset($value['title']) ? $value['title'] : '';
        $text = isset($value['text']) ? $value['text'] : '';
        $image = isset($value['image']) ? $value['image'] : '';
        $image_id = $value['image']['id'] ?? '';
        if( !empty($value['text_ed']) ) {
            $editor_content = $widget->parse_text_editor( $value['text_ed'] );
        }
        ?>
        <div class="pxl--item-physics elementor-repeater-item-<?php echo esc_attr($value['_id']); ?>">
            <?php if (!empty($title) || !empty($editor_content)): ?>
            <div class="pxl-item--content <?php echo pxl_print_html($value['style_content']); ?>">
                <?php if (!empty($title)): ?>
                    <h4 class="pxl-item--title">
                        <?php pxl_print_html($title); ?>
                    </h4>
                <?php endif; ?>

                <?php if (!empty($editor_content)): ?>
                    <div class="pxl-item--text">
                        <?php echo wp_kses_post($editor_content); ?>        
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <?php if (!empty($image_id)): ?>
            <div class="pxl-item--image">
                <?php echo floka_get_thumbnail($image_id, $image_size); ?>
            </div>
        <?php endif; ?>
    </div>
<?php endforeach; ?>
</div>