<?php

$html_id = pxl_get_element_id($settings);
$tax = ['category'];
$select_post_by = $widget->get_setting('select_post_by', '');
$source = $post_ids = [];
if($select_post_by === 'post_selected'){
    $post_ids = $widget->get_setting('source_'.$settings['post_type'].'_post_ids', '');
}else{
    $source  = $widget->get_setting('source_'.$settings['post_type'], '');
}
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
extract(pxl_get_posts_of_grid(
    'service', 
    ['source' => $source, 'orderby' => $orderby, 'order' => $order, 'limit' => $limit, 'post_ids' => $post_ids],
    $tax
));

$pxl_animate = $widget->get_setting('pxl_animate', '');
$pxl_animate_delay = $widget->get_setting('pxl_animate_delay', '');
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = (int)$widget->get_setting('col_md', '');
if($col_md == 'custom') {
    $col_md = $widget->get_setting('col_md_custom', '');
}
$col_lg = (int)$widget->get_setting('col_lg', '');
if($col_lg == 'custom') {
    $col_lg = $widget->get_setting('col_lg_custom', '');
}
$col_xl = (int)$widget->get_setting('col_xl', '');
if($col_xl == 'custom') {
    $col_xl = $widget->get_setting('col_xl_custom', '');
}
$col_xxl = (int)$widget->get_setting('col_xxl', '');
if($col_xxl == 'custom') {
    $col_xxl = $widget->get_setting('col_xxl_custom', '');
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);
$speed = $widget->get_setting('speed', 500);

$show_category = $widget->get_setting('show_category');
$show_excerpt = $widget->get_setting('show_excerpt');
$show_button = $widget->get_setting('show_button');
$button_text = $widget->get_setting('button_text','Read More');
$img_size = $widget->get_setting('img_size');

?>

<?php if (is_array($posts)): ?>
    <div class="pxl-post-reveal pxl-post-reveal1 <?php echo esc_attr($pxl_animate); ?>" data-wow-delay="<?php echo esc_attr($pxl_animate_delay); ?>ms">
        <div class="pxl-reveal-inner">
            <div class="pxl-reveal-wrapper">
                <div class="pxl-item--reveal">
                    <?php
                    $active = intval($settings['active']);
                    $images_size = !empty($img_size) ? $img_size : '600x600';
                    $num_words = $settings['num_words'] ? $settings['num_words'] : '11';
                    foreach ($posts as $key => $post):
                        $is_active = ($key + 1) == $active ? 'active' : '';
                        $img_id       = get_post_thumbnail_id( $post->ID );
                        $excerpt_post = get_the_excerpt($post->ID);
                        ?>
                        <div class="pxl-post--inner <?php echo pxl_print_html($is_active); ?>">
                            <div class="pxl-item--holder">
                                <div class="pxl-post--featured">
                                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                        <?php echo floka_get_thumbnail($img_id, $images_size); ?>
                                    </a>
                                </div>

                                <div class="pxl-item--content">
                                    <?php if($show_category == 'true'): ?>
                                        <div class="pxl-item--category">
                                            <?php the_terms( $post->ID, 'service-category', '', ' ' ); ?>
                                        </div>
                                    <?php endif; ?>

                                    <?php if($show_excerpt == 'true') : ?>
                                        <div class="pxl-item--excerpt">
                                            <?php echo wp_trim_words( $excerpt_post, $num_words, $more = null ); ?> 
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <?php if($show_button == 'true') : ?>
                                <a class="btn btn-readmore d-flex" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                    <span class="pxl-btn--text">
                                        <?php echo esc_attr($button_text); ?>
                                    </span>
                                    <span class="pxl-icon--plus"></span>
                                </a>
                            <?php endif; ?>
                        </div>

                    <?php endforeach; ?>
                </div>

                <div class="pxl-column--categories">
                    <?php  foreach ($posts as $key => $categories):
                        $is_active = ($key + 1) == $active ? 'active' : '';
                        ?>
                        <?php if($show_category == 'true'): ?>
                            <div class="pxl-item--category <?php echo pxl_print_html($is_active); ?>">
                                <?php 
                                echo implode(', ', wp_list_pluck( get_the_terms( $categories->ID, 'service-category' ), 'name' ));
                                ?>

                            </div>
                        <?php endif; ?>
                    <?php  endforeach; ?>
                </div>
            </div> 

            <?php if($pagination !== false): ?>
                <div class="pxl-swiper-dots-wrap">
                    <div class="pxl-swiper-dots style-1"></div>
                </div>
            <?php endif; ?>

            <?php if($arrows !== false): ?>
                <div class="pxl-swiper-arrow-wrap <?php echo pxl_print_html($settings['style_arrows']); ?>">
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="caseicon-angle-arrow-left rtl-icon"></i></div>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="caseicon-angle-arrow-right rtl-icon"></i></div>
                </div>
            <?php endif; ?>

        </div>
    </div>
    <?php endif; ?>