<?php
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', 500);
$drap = $widget->get_setting('drap', false);  
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]); 

$pxl_g_id = uniqid(); ?>
<?php if(isset($settings['process']) && !empty($settings['process']) && count($settings['process'])): 
$image_size = !empty($settings['img_size']) ? $settings['img_size'] : '500x500'; ?>
<div id="pxl-process-carousel-<?php echo esc_attr($pxl_g_id); ?>" class="pxl-swiper-slider pxl-process-carousel pxl-process-carousel2" <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_attr('DRAG', 'floka'); ?>"<?php endif; ?>>
    <div class="pxl-carousel-inner">
        <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
            <div class="pxl-swiper-wrapper">
                <?php foreach ($settings['process'] as $key => $value):
                    $image = isset($value['image']) ? $value['image'] : '';
                    $decorative = isset($value['decorative']) ? $value['decorative'] : '';
                    ?>

                    <div class="pxl-swiper-slide elementor-repeater-item-<?php echo esc_attr($value['_id']); ?> <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                        <?php if(!empty($image['id'])) { 
                            $img = pxl_get_image_by_size( array(
                                'attach_id'  => $image['id'],
                                'thumb_size' => $image_size,
                                'class' => 'no-lazyload',
                            ));
                            $thumbnail = $img['thumbnail'];

                            $icon_key = $widget->get_repeater_setting_key( 'decorative_icon', 'icons', $key );
                            $widget->add_render_attribute( $icon_key, [
                                'class' => $value['decorative_icon'],
                                'aria-hidden' => 'true',
                            ] ); ?>
                            <div class="pxl-item--image">
                                <a <?php floka_render_link_attributes($value['item_link']); ?>>
                                    <span class="pxl--image">
                                        <?php echo wp_kses_post($thumbnail); ?>
                                    </span>
                                </a>
                                <div class="pxl-icon-bg">
                                    <?php if ( $is_new ):
                                        \Elementor\Icons_Manager::render_icon( $value['decorative_icon'], [ 'aria-hidden' => 'true' ] );
                                    elseif(!empty($value['decorative_icon'])): ?>
                                        <i class="<?php echo esc_attr( $value['decorative_icon'] ); ?>" aria-hidden="true"></i>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php } ?>

                        <div class="pxl-item--inner ">
                            <div class="pxl-item--number">
                                <div class="pxl--number">
                                    <?php echo pxl_print_html($key + 1); ?>
                                </div>
                            </div>

                            <h3 class="pxl-item--title">
                                <a <?php floka_render_link_attributes($value['item_link']); ?>>
                                    <?php echo pxl_print_html($value['title']); ?>
                                </a>
                            </h3>

                            <div class="pxl-item--description">
                                <?php echo pxl_print_html($value['description']); ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <?php if($pagination !== false): ?>
            <div class="pxl-swiper-dots style-1"></div>
        <?php endif; ?>

        <?php if($arrows !== false): ?>
            <div class="pxl-swiper-arrow-wrap style-2">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="caseicon-angle-arrow-left rtl-icon"></i></div>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="caseicon-angle-arrow-right rtl-icon"></i></div>
            </div>
        <?php endif; ?>

    </div>
</div>
<?php endif; ?>
