<?php 
$is_cases = (isset($settings['cases']) && !empty($settings['cases']) && count($settings['cases'])) || false;

$col_xxl = ($settings['col_xxl'] == '5') ? 'pxl5' : 12 / (int)$settings['col_xxl'];
$col_xl = ($settings['col_xl'] == '5') ? 'pxl5' : 12 / (int)$settings['col_xl'];
$col_lg = 12 / (int)$settings['col_lg'];
$col_md = 12 / (int)$settings['col_md'];
$col_sm = 12 / (int)$settings['col_sm'];
$col_xs = 12 / (int)$settings['col_xs'];

$grid_item = "col-xxl-{$col_xxl} col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
?>

<?php if($is_cases) : ?>
    <div class="pxl-showcase pxl-showcase2">
        <div class="pxl-item--container">
            <div class="pxl-item--inner row">
                <?php foreach($settings['cases'] as $key => $case) : ?>
                    <?php 
                    $sub_title = $widget->parse_text_editor( $case['sub_title']);
                    $image = floka_get_thumbnail($case['image']['id']);    
                    $link = floka_get_link($case['link']);
                    $link2 = floka_get_link($case['link2']);
                    ?>
                    <div class="pxl-item--single <?php echo esc_attr($grid_item); ?> <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                        <div class="pxl-inner--content">
                            <div class="pxl-item--showcase <?php if ($case['is_coming_soon'] == 'yes') { echo pxl_print_html('coming-soon');} ?>">
                                <div class="pxl-item--image">
                                    <?php pxl_print_html($image); ?>
                                </div>
                                <div class="pxl-btn-group">
                                    <a class="pxl-item--btn btn pxl-item--btn1" <?php echo pxl_print_html($link); ?>>
                                        <span class="pxl-btn--text">
                                            <?php echo esc_attr($settings['button_text']); ?>
                                        </span>
                                    </a>
                                    <a class="pxl-item--btn btn pxl-item--btn2" <?php echo pxl_print_html($link2); ?>>
                                        <span class="pxl-btn--text">
                                            <?php echo esc_attr($settings['button_text2']); ?>
                                        </span>
                                    </a>
                                </div>

                                <?php pxl_print_html(floka_render_icon($settings['pxl_icon'])); ?>
                            </div>
                            <div class="pxl-item--sub_title">
                             <?php echo wp_kses_post($sub_title); ?> 
                         </div>
                         <h6 class="pxl-item--title">
                             <?php echo esc_attr($case['title']); ?> 
                         </h6>
                     </div>
                 </div>
             <?php endforeach; ?>
         </div>
     </div>
 </div>
 <?php endif; ?>