<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');

$col_xl = 12 / intval($col_xl);
$col_lg = 12 / intval($col_lg);
$col_md = 12 / intval($col_md);
$col_sm = 12 / intval($col_sm);
$col_xs = 12 / intval($col_xs);

$grid_sizer = "col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
$item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
$image_size = !empty($settings['img_size']) ? $settings['img_size'] : '450x450';
$pxl_animate = $widget->get_setting('pxl_animate', '');
$pxl_animate_delay = $widget->get_setting('pxl_animate_delay', '');
?>
<?php if(isset($settings['team']) && !empty($settings['team']) && count($settings['team'])): ?>
<div class="pxl-grid pxl-team pxl-team-grid pxl-team-grid1">
    <div class="pxl-grid-inner row" data-gutter="15">
        <div class="grid-sizer <?php echo esc_attr($grid_sizer); ?>"></div>
        <?php foreach ($settings['team'] as $key => $value):
            $title = isset($value['title']) ? $value['title'] : '';
            $position = isset($value['position']) ? $value['position'] : '';
            $social = isset($value['social']) ? $value['social'] : '';
            $image = isset($value['image']) ? $value['image'] : '';
            $image_id = $value['image']['id'] ?? '';
            ?>

            <div class="<?php echo esc_attr($item_class); ?> <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="<?php echo esc_attr($pxl_animate_delay); ?>">
                <div class="pxl-item--inner elementor-repeater-item-<?php echo esc_attr($value['_id']); ?>">
                        <div class="pxl-item--image el-parallax-wrap">
                            <a class="el-parallax-item" <?php floka_render_link_attributes($value['item_link']); ?>>
                                <?php echo floka_get_thumbnail($image_id, $image_size); ?>
                            </a>
                        </div>
                    <div class="pxl--content">
                        <?php if (!empty($title)) : ?>
                            <h3 class="pxl-item--title">
                                <?php echo pxl_print_html($title); ?>
                            </h3>
                        <?php endif; ?>

                        <?php if (!empty($position)) : ?>
                            <div class="pxl-item--position">
                                <?php echo pxl_print_html($position); ?>
                            </div>
                        <?php endif; ?>

                        <?php if(!empty($social)): ?>
                            <div class="pxl-item--social">
                             <?php  $team_social = json_decode($social, true);
                             foreach ($team_social as $value): ?>
                                <a href="<?php echo esc_url($value['url']); ?>" target="_blank"><i class="<?php echo esc_attr($value['icon']); ?>"></i></a>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
    <div class="grid-sizer <?php echo esc_attr($grid_sizer); ?>"></div>
</div>
</div>
<?php endif; ?>
