<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
if ( ! empty( $settings['link']['url'] ) ) {
    $widget->add_render_attribute( 'button', 'href', $settings['link']['url'] );

    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'button', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
    }
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', '500');
$drap = $widget->get_setting('drap', false);  
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];

$opts_thumb = [
    'slide_direction'               => 'horizontal',
    'slides_to_show'                => '1', 
    'slide_mode'                    => 'slide',
    'loop'                          => true,
];

$widget->add_render_attribute( 'thumb', [
    'class'         => 'pxl-swiper-thumbs',
    'data-settings' => wp_json_encode($opts_thumb)
]);

$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    <div class="pxl-swiper-slider pxl-testimonial-carousel pxl-testimonial-carousel4" <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_html('DRAG', 'floka'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'thumb' )); ?>>
                <div class="pxl-swiper-wrapper">
                  <?php foreach ($settings['testimonial'] as $key => $value):
                    $img_size_t = !empty($settings['img_size']) ? $settings['img_size'] : '922x974';
                    $image_thumbs = isset($value['image_thumbs']) ? $value['image_thumbs'] : '';
                    $thumbnail_t = floka_get_thumbnail($image_thumbs['id'], $img_size_t);
                    ?>
                    <div class="pxl-swiper-slide">
                        <?php if(!empty($image_thumbs['id'])) { ?>
                            <div class="pxl-item--image-t ">
                                <?php pxl_print_html($thumbnail_t); ?>
                            </div>
                        <?php } ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
            <div class="pxl-swiper-wrapper">
                <?php foreach ($settings['testimonial'] as $key => $value):
                    $title = isset($value['title']) ? $value['title'] : '';
                    $position = isset($value['position']) ? $value['position'] : '';
                    $desc = isset($value['desc']) ? $value['desc'] : '';
                    $star = isset($value['star']) ? $value['star'] : '';
                    $outlined_star =  '5' - $star;
                    $img_size = !empty($settings['img_size']) ? $settings['img_size'] : '500x500';
                    $image = isset($value['image']) ? $value['image'] : '';
                    $thumbnail = floka_get_thumbnail($image['id'], $img_size);

                    ?>
                    <div class="pxl-swiper-slide">
                        <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                          <div class="pxl-item--star pxl-rating--<?php echo esc_attr($star); ?>-star">
                            <?php for ($i = 0; $i < $star; $i++) : ?>
                                <i class="fas fa-star"></i>
                            <?php endfor; ?>
                            <?php for ($i = 0; $i < $outlined_star; $i++) : ?>
                                <i class="far fa-star"></i>
                            <?php endfor; ?>
                        </div>

                        <div class="pxl-item--desc el-empty"><?php echo pxl_print_html($desc); ?></div>
                        <div class="pxl-item--holder">

                            <div class="pxl-item--meta">
                                <h3 class="pxl-item--title el-empty"><?php echo pxl_print_html($title); ?></h3>
                                <div class="pxl-item--position el-empty"><?php echo pxl_print_html($position); ?></div>
                            </div>
                            <?php if(!empty($image['id'])) { ?>
                                <div class="pxl-item--image ">
                                    <?php pxl_print_html($thumbnail); ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>


</div>


</div>
<?php endif; ?>
