<?php
$img_size = '';
if(!empty($settings['img_size'])) {
    $img_size = $settings['img_size'];
} else {
    $img_size = 'full';
}
?>
<div class="pxl-video-player pxl-video-player1 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-video--inner">
        <?php if( $settings['image_type'] != 'none' && !empty( $settings['image']['url'] ) ) :
            $img  = pxl_get_image_by_size( array(
                'attach_id'  => $settings['image']['id'],
                'thumb_size' => $img_size,
            ) );
            $thumbnail = $img['thumbnail'];
            ?>
            <div class="pxl-video--holder">
                <?php if ($settings['image_type'] == 'img') { ?>
                    <?php if ( ! empty( $settings['image']['url'] ) ) { echo wp_kses_post($thumbnail); } ?>
                <?php } else { ?>
                    <div class="pxl-video--image bg-image" style="background-image: url(<?php echo esc_url($settings['image']['url']); ?>);"></div>
                <?php } ?>
            </div>
        <?php endif; ?>
        <?php if(!empty($settings['video_link']) && $settings['image_type'] != 'video') : ?>
            <div class="btn-video-wrap <?php echo esc_attr($settings['btn_video_position']); ?>">
                <a class="btn-video pxl-action-popup" href="<?php echo esc_url($settings['video_link']); ?>">
                    <i class="fas fa-play"></i>
                    <?php if(!empty($settings['title'])) : ?>
                        <h2 class="pxl-item--title el-empty"><?php echo pxl_print_html($settings['title']); ?></h2>
                    <?php endif; ?>
                </a>
            </div>
        <?php endif; ?>
        <?php if(!empty($settings['video_link']) && $settings['image_type'] == 'video') : ?>
            <div class="localvideo-bg">
                <video autoplay="" muted="" loop="">
                    <source src="<?php echo esc_url($settings['video_link']); ?>" type="video/mp4">
                    </video>
                </div>
            <?php endif; ?>
        </div>
    </div>