<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_accordion',
        'title' => esc_html__('Case Accordion', 'floka' ),
        'icon' => 'eicon-accordion',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'floka-accordion'
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'floka' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_accordion/layout1.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'active',
                            'label' => esc_html__('Active', 'floka' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'separator' => 'after',
                            'default' => '1',
                        ),
                        array(
                            'name' => 'accordion',
                            'label' => esc_html__('Accordion', 'floka' ),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__('Title', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'desc',
                                    'label' => esc_html__('Content', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                                    'rows' => 10,
                                ),

                                array(
                                    'name' => 'text_button',
                                    'label' => esc_html__('Text Button', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'rows' => 10,
                                ),
                                array(
                                    'name' => 'link',
                                    'label' => esc_html__('Link', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'default' => [
                                        'url' => '#',
                                    ],
                                ),

                                array(
                                    'name' => 'image',
                                    'label' => esc_html__('Choose Image', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                ),

                            ),
                            'title_field' => '{{{ title }}}',
                            'separator' => 'after',
                        ),


                        array(
                            'name' => 'max_width_widget',
                            'label' => esc_html__('Widget Max Width', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px','custom' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1920,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-accordion' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_general',
                    'label' => esc_html__('General', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name'  => 'margin-item',
                            'label' => esc_html__('Margin','floka'),
                            'type'  => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-accordion .pxl--item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),

                        array(
                            'name'  => 'box_shadow',
                            'label' => esc_html__('Box Shadow','floka'),
                            'type'  => \Elementor\Group_Control_Box_Shadow::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-accordion .pxl--item',
                        ),

                        array(
                            'name'  => 'general_tab_controls',
                            'control_type'  => 'tab',
                            'tabs'  => [
                                [
                                    'name'  => 'general_tab_normal',
                                    'label' => esc_html__('Normal','floka'),
                                    'type'  => 'tab',
                                    'controls'  => [
                                        array(
                                            'name' => 'background_box',
                                            'label' => esc_html__('Background Color', 'floka' ),
                                            'type' => \Elementor\Controls_Manager::COLOR,
                                            'selectors' => [
                                            '{{WRAPPER}} .pxl-accordion .pxl--item' => 'background: {{VALUE}};',
                                        ],
                                    ),

                                        array(
                                            'name'  => 'border_radius_item',
                                            'label' => esc_html__('Border Radius','floka'),
                                            'type'  => \Elementor\Controls_Manager::DIMENSIONS,
                                            'size_units' => [ 'px' ],
                                            'control_type' => 'responsive',
                                            'selectors' => [
                                            '{{WRAPPER}} .pxl-accordion .pxl--item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                        ],
                                    ),

                                        array(
                                            'name'  => 'border_item',
                                            'label' => esc_html__('Border','floka'),
                                            'type'  => \Elementor\Group_Control_Border::get_type(),
                                            'control_type' => 'group',
                                            'selector'     => '{{WRAPPER}} .pxl-accordion .pxl--item',
                                        ),


                                        array(
                                            'name'  => 'heading_icon',
                                            'label' => esc_html__('ICONS','floka'),
                                            'type'  => \Elementor\Controls_Manager::HEADING,
                                            'separator' => 'before',
                                        ),

                                        array(
                                            'name' => 'color_icon',
                                            'label' => esc_html__('Color', 'floka' ),
                                            'type' => \Elementor\Controls_Manager::COLOR,
                                            'selectors' => [
                                            '{{WRAPPER}} .pxl-accordion .pxl--item .pxl-icon--plus::before,
                                            {{WRAPPER}} .pxl-accordion .pxl--item .pxl-icon--plus::after' => 'background: {{VALUE}};',
                                        ],
                                    ),
                                        array(
                                            'name' => 'background_icon',
                                            'label' => esc_html__('Background', 'floka' ),
                                            'type' => \Elementor\Controls_Manager::COLOR,
                                            'selectors' => [
                                            '{{WRAPPER}} .pxl-accordion .pxl--item .pxl-icon--plus' => 'background: {{VALUE}};',
                                        ],
                                    ),

                                    ],
                                ],
                                [
                                    'name'  => 'general_tab_active',
                                    'label' => esc_html__('Active','floka'),
                                    'type'  => 'tab',
                                    'controls'  => [
                                        array(
                                            'name' => 'background_box_active',
                                            'label' => esc_html__('Background Color', 'floka' ),
                                            'type' => \Elementor\Controls_Manager::COLOR,
                                            'selectors' => [
                                            '{{WRAPPER}} .pxl-accordion .pxl--item.active' => 'background: {{VALUE}};',
                                        ],
                                    ),

                                        array(
                                            'name'  => 'border_radius_item_active',
                                            'label' => esc_html__('Border Radius','floka'),
                                            'type'  => \Elementor\Controls_Manager::DIMENSIONS,
                                            'size_units' => [ 'px' ],
                                            'control_type' => 'responsive',
                                            'selectors' => [
                                            '{{WRAPPER}} .pxl-accordion .pxl--item.active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                        ],
                                    ),

                                        array(
                                            'name'  => 'border_item_active',
                                            'label' => esc_html__('Border','floka'),
                                            'type'  => \Elementor\Group_Control_Border::get_type(),
                                            'control_type' => 'group',
                                            'selector'     => '{{WRAPPER}} .pxl-accordion .pxl--item.active',
                                        ),

                                        array(
                                            'name'  => 'heading_icon_active',
                                            'label' => esc_html__('ICONS','floka'),
                                            'type'  => \Elementor\Controls_Manager::HEADING,
                                            'separator' => 'before',
                                        ),
                                        array(
                                            'name' => 'color_icon_active',
                                            'label' => esc_html__('Color', 'floka' ),
                                            'type' => \Elementor\Controls_Manager::COLOR,
                                            'selectors' => [
                                            '{{WRAPPER}} .pxl-accordion .pxl--item.active .pxl-icon--plus::before,
                                            {{WRAPPER}} .pxl-accordion .pxl--item.active .pxl-icon--plus::after' => 'background: {{VALUE}};',
                                        ],
                                    ),

                                        array(
                                            'name' => 'background_icon_active',
                                            'label' => esc_html__('Background', 'floka' ),
                                            'type' => \Elementor\Controls_Manager::COLOR,
                                            'selectors' => [
                                            '{{WRAPPER}} .pxl-accordion .pxl--item.active .pxl-icon--plus' => 'background: {{VALUE}};',
                                        ],
                                    ),
                                    ],
                                ],

                            ],
                        ),

),
),



array(
    'name' => 'section_style_title',
    'label' => esc_html__('Title', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'title_tag',
            'label' => esc_html__('HTML Tag', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'h1' => 'H1',
                'h2' => 'H2',
                'h3' => 'H3',
                'h4' => 'H4',
                'h5' => 'H5',
                'h6' => 'H6',
                'div' => 'div',
                'span' => 'span',
                'p' => 'p',
            ],
            'default' => 'h5',
        ),
        array(
            'name' => 'title_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-accordion .pxl-accordion--title' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'title_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-accordion .pxl-accordion--title',
        ),

    ),
),
array(
    'name' => 'section_style_content',
    'label' => esc_html__('Content', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'content_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-accordion .pxl-accordion--content' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'desc_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-accordion .pxl-accordion--content',
        ),
    ),
),

array(
    'name' => 'section_style_button',
    'label' => esc_html__('Button', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'btn_text_effect',
            'label' => esc_html__('Text Effect', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => '',
            'options' => [
                '' => esc_html__('Default', 'floka' ),
                'btn-text-nina' => esc_html__('Nina', 'floka' ),
                'btn-text-nanuk' => esc_html__('Nanuk', 'floka' ),
                'btn-text-parallax' => esc_html__('Parallax', 'floka' ),
                'btn-spotlight-scale' => esc_html__('Spotlight', 'floka' ),
                'btn-icon--shake' => esc_html__('Shake', 'floka' ),
            ],
        ),
    )
),
floka_widget_animation_settings(),
),
),
),
floka_get_class_widget_path()
);