<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_history',
        'title' => esc_html__('Case History', 'floka' ),
        'icon' => 'eicon-history',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'floka'),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => array(
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'floka'),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_history/layout1.jpg',
                                ],
                            ),
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'active',
                            'label' => esc_html__('Active', 'floka' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'separator' => 'after',
                            'default' => '1',
                        ),
                        array(
                            'name'  => 'history',
                            'label' => esc_html__('History','floka'),
                            'type'  => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'number', 
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label' => esc_html__( 'Number', 'floka' ),
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'desc', 
                                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                                    'label' => esc_html__( 'Description', 'floka' ),
                                    'label_block' => true,
                                    'rows' => 3,
                                ),
                                array(
                                    'name' => 'image',
                                    'label' => esc_html__('Choose Image', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                ),
                                array(
                                    'name' => 'link',
                                    'label' => esc_html__('Link', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'default' => [
                                        'url' => '#',
                                    ],
                                ),

                            ),
                        ),

                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size - Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme. Alternatively enter size in pixels Example: 200x100 - Width x Height.',
                        ),

                        array(
                          'name' => 'align',
                          'label' => esc_html__( 'Alignment', 'floka' ),
                          'type' => \Elementor\Controls_Manager::CHOOSE,
                          'control_type' => 'responsive',
                          'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'floka' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'floka' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'floka' ),
                                    'icon' => 'eicon-text-align-right',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-feature--card ' => 'text-align: {{VALUE}};',
                            ],
                        ),
                    ),
                ),
                floka_widget_animation_settings(),
            ),
        ),
    ),
floka_get_class_widget_path()
);