<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_link',
        'title' => esc_html__('Case Links', 'floka'),
        'icon' => 'eicon-editor-link',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                       array(
                        'name' => 'wg_title',
                        'label' => esc_html__('Title', 'floka' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                    ),
                       array(
                        'name' => 'link',
                        'label' => esc_html__('Link', 'floka'),
                        'type' => \Elementor\Controls_Manager::REPEATER,
                        'controls' => array(
                            array(
                                'name' => 'text',
                                'label' => esc_html__('Text', 'floka'),
                                'type' => \Elementor\Controls_Manager::TEXTAREA,
                                'label_block' => true,
                                'description' => 'Create Highlight text with shortcode: [highlight text="Text"]',
                            ),
                            array(
                                'name' => 'link',
                                'label' => esc_html__('Link', 'floka'),
                                'type' => \Elementor\Controls_Manager::URL,
                                'label_block' => true,
                            ),
                            array(
                                'name' => 'pxl_icon',
                                'label' => esc_html__('Icon', 'floka' ),
                                'type' => \Elementor\Controls_Manager::ICONS,
                                'fa4compatibility' => 'icon',
                            ),
                        ),
                        'title_field' => '{{{ text }}}',
                    ),


                       array(
                        'name' => 'display_type_wr',
                        'label' => esc_html__('Display Content', 'floka' ),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'options' => [
                            '' => 'Vertical',
                            'wr-horizontal' => 'Horizontal',
                        ],
                        'default' => '',
                    ),
                       array(
                        'name' => 'display_type_gap_wr',
                        'label' => esc_html__('Gap', 'floka' ),
                        'type' => \Elementor\Controls_Manager::SLIDER,
                        'control_type' => 'responsive',
                        'size_units' => [ 'px','custom'],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-link-wrap' => 'gap: {{SIZE}}{{UNIT}};',
                        ],
                        'condition' => [
                            'display_type_wr'  => 'wr-horizontal',
                        ],
                    ),
                       array(
                        'name' => 'flex_wrap',
                        'label' => esc_html__( 'Flex Wrap', 'floka' ),
                        'type' => \Elementor\Controls_Manager::CHOOSE,
                        'control_type' => 'responsive',
                        'options' => [
                            'nowrap' => [
                                'title' => esc_html__( 'No Wrap', 'floka' ),
                                'icon' => 'eicon-nowrap',
                            ],
                            'wrap' => [
                                'title' => esc_html__( 'Wrap', 'floka' ),
                                'icon' => 'eicon-wrap',
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-link' => 'flex-wrap: {{VALUE}};',
                        ],
                        'condition' => [
                            'display_type'  => 'horizontal',
                        ],
                    ),

                       array(
                          'name' => 'align',
                          'label' => esc_html__( 'Alignment', 'floka' ),
                          'type' => \Elementor\Controls_Manager::CHOOSE,
                          'control_type' => 'responsive',
                          'options' => [
                            'left' => [
                                'title' => esc_html__( 'Left', 'floka' ),
                                'icon' => 'eicon-text-align-left',
                            ],
                            'center' => [
                                'title' => esc_html__( 'Center', 'floka' ),
                                'icon' => 'eicon-text-align-center',
                            ],
                            'right' => [
                                'title' => esc_html__( 'Right', 'floka' ),
                                'icon' => 'eicon-text-align-right',
                            ],
                            'justify' => [
                                'title' => esc_html__( 'Justified', 'floka' ),
                                'icon' => 'eicon-text-align-justify',
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-link,{{WRAPPER}} .pxl-link-wrap' => 'text-align: {{VALUE}}; justify-content: {{VALUE}};',
                        ],
                    ),
                       array(
                        'name' => 'l_width',
                        'label' => esc_html__('Max Width', 'floka' ),
                        'type' => \Elementor\Controls_Manager::SLIDER,
                        'control_type' => 'responsive',
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 3000,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-link' => 'max-width: {{SIZE}}{{UNIT}};',
                        ],
                    ),

                   ),
),


array(
    'name' => 'section_style_general',
    'label' => esc_html__('General', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'display_type',
            'label' => esc_html__('Display Content', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '' => 'Vertical',
                'horizontal' => 'Horizontal',
            ],
            'default' => '',
        ),
        array(
            'name' => 'display_gap_content_vtc',
            'label' => esc_html__('Gap', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px','custom'],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-link .pxl-item--link a' => 'margin-bottom: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'display_type'  => 'vertical',
            ],
        ),

        array(
            'name' => 'display_type_gap',
            'label' => esc_html__('Gap', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px','custom'],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-link' => 'gap: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'display_type'  => 'horizontal',
            ],
        ),
        array(
            'name' => 'margin_item',
            'label' => esc_html__('Margin', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'selectors' => [
                '{{WRAPPER}} .pxl-link li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'padding_item_link',
            'label' => esc_html__('Padding', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'selectors' => [
                '{{WRAPPER}} .pxl-link li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),
    ),
),



array(
    'name' => 'section_style_title',
    'label' => esc_html__('Title', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'title_style',
            'label' => esc_html__('Style', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '' => 'Default',
                'style-divider' => 'Divider',
            ],
            'default' => '',
        ),

        array(
            'name' => 'title_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-widget-title' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'title_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-widget-title',
        ),

        
    ),
),
array(
    'name' => 'section_style_link',
    'label' => esc_html__('Link', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(

        array(
            'name' => 'style',
            'label' => esc_html__('Style', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'style-default' => 'Default',
                'style-hover-divider' => 'Hover Divider 1',
                'style-hover-divider2' => 'Hover Divider 2',
            ],
            'default' => 'style-default',
        ),
        
        array(
            'name' => 'link_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-link a' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'link_color_hover',
            'label' => esc_html__('Color Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-link a:hover' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'color_divider',
            'label' => esc_html__('Color Divider', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-link a span:before, {{WRAPPER}} .pxl-link a span:after' => 'background-color: {{VALUE}};',
            ],
            'condition' => [
                'style' => ['style-hover-divider','style-hover-divider2'],
            ],
        ),
        array(
            'name' => 'weight_divider',
            'label' => esc_html__('Weight Divider', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 10000,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-link a span:before, {{WRAPPER}} .pxl-link a span:after' => 'height: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'style' => ['style-hover-divider','style-hover-divider2'],
            ],
        ),
        array(
            'name' => 'link_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-link a',
        ),

        array(
            'name'         => 'link_style_outline',
            'label' => esc_html__( 'Text Stroke', 'floka' ),
            'type'         => \Elementor\Group_Control_Text_Stroke::get_type(),
            'control_type' => 'group',
            'selector'     => '{{WRAPPER}} .pxl-link a',
       ),
        
        array(
            'name'  => 'heading_highlight',
            'label' => esc_html__('HIGHLIGHT','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),

        array(
            'name' => 'highlight_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-link .pxl-title--highlight' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'highlight_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-link .pxl-title--highlight',
        ),


        array(
            'name' => 'border_items',
            'label' => esc_html__('Border Items', 'floka' ),
            'type' => \Elementor\Group_Control_Border::get_type(),
            'control_type'  => 'group',
            'selector'     => '{{WRAPPER}} .pxl-link .pxl-item--link',
        ),
        
        array(
            'name' => 'align_items',
            'label' => esc_html__('Align Items', 'floka' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'control_type' => 'responsive',
            'options' => [
                'flex-start' => [
                    'title' => esc_html__( 'Flex Start', 'floka' ),
                    'icon' => 'eicon-v-align-top',
                ],
                'Center' => [
                    'title' => esc_html__( 'Center', 'floka' ),
                    'icon' => 'fas fa-arrows-alt-v',
                ],
                'flex-end' => [
                    'title' => esc_html__( 'Flex End', 'floka' ),
                    'icon' => 'eicon-v-align-bottom',
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-link li a' => 'align-items: {{VALUE}};',
            ],
        ),

    ),
),
array(
    'name' => 'section_style_icon',
    'label' => esc_html__('Icon', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'condition' => [
        'style!' => ['style-round-box'],
    ],
    'controls' => array_merge(
        floka_widget_color_type([
            'prefix' => 'icon',
            'selectors_class' => '.pxl-link a .pxl-link--icon i',
        ]),
        floka_widget_bgcolor_type([
            'prefix' => 'bg_icon',
            'selectors_class' => '.pxl-link a .pxl-link--icon',
        ]),
        array(
            array(
                'name'  => 'heading_icon_hover',
                'label' => esc_html__('Icon Hover','floka'),
                'type'  => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ),

            array(
                'name' => 'icon_color_hv',
                'label' => esc_html__('Color Hover', 'floka' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-link a .pxl-link--icon:hover i' => 'color: {{VALUE}};',
                ],
            ),

            array(
                'name' => 'bg_icon_color_hv',
                'label' => esc_html__('Background Hover', 'floka' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-link a .pxl-link--icon:hover' => 'background: {{VALUE}};',
                ],
                'separator' => 'after',
            ),

            array(
                'name' => 'icon_position',
                'label' => esc_html__('Icon Position', 'floka' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => 'Before',
                    'icon-after' => 'After',
                ],
                'default' => '',
            ),

            array(
                'name' => 'icon_font_size',
                'label' => esc_html__('Font Size', 'floka' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'control_type' => 'responsive',
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-link a .pxl-link--icon' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .pxl-link a .pxl-link--icon svg' => 'height: {{SIZE}}{{UNIT}};min-width: {{SIZE}}{{UNIT}};',
                ],
            ),
            array(
                'name' => 'icon_width',
                'label' => esc_html__('Box Width', 'floka' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'control_type' => 'responsive',
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-link a .pxl-link--icon' => 'min-width: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
                ],
            ),
            array(
                'name' => 'icon_box_width',
                'label' => esc_html__('Box Height', 'floka' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'control_type' => 'responsive',
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-link a .pxl-link--icon' => 'height: {{SIZE}}{{UNIT}};justify-content: center; align-items: center;',
                ],
            ),

            array(
                'name' => 'border_items_icon',
                'label' => esc_html__('Border Icon', 'floka' ),
                'type' => \Elementor\Group_Control_Border::get_type(),
                'control_type'  => 'group',
                'selector'     => '{{WRAPPER}} .pxl-link a .pxl-link--icon',
            ),

            array(
                'name' => 'icon_border_radius',
                'label' => esc_html__('Box Border Radius', 'floka' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-link a .pxl-link--icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ),
            array(
                'name'         => 'icon_box_shadow',
                'label' => esc_html__( 'Icon Shadow', 'floka' ),
                'type'         => \Elementor\Group_Control_Text_Shadow::get_type(),
                'control_type' => 'group',
                'selector'     => '{{WRAPPER}} .pxl-link a .pxl-link--icon',
            ),
        )
),
),
floka_widget_animation_settings(),
),
),
),
floka_get_class_widget_path()
);