<?php
$pt_supports = ['portfolio','service'];
pxl_add_custom_widget(
    array(
        'name' => 'pxl_post_accordion',
        'title' => esc_html__('Case Post Accordion', 'floka' ),
        'icon' => 'eicon-accordion',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'floka-accordion'
        ),
        'params' => array(
            'sections' => array(

                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'floka' ),
                    'tab'      => 'layout',
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'post_type',
                                'label'    => esc_html__( 'Select Post Type', 'floka' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => floka_get_post_type_options($pt_supports),
                                'default'  => 'post'
                            ) 
                        ),
                        floka_get_post_accordion_layout($pt_supports),
                    ),
                ),
                array(
                    'name' => 'section_source',
                    'label' => esc_html__('Source', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array_merge(
                        array(
                            array(
                                'name' => 'active',
                                'label' => esc_html__('Active', 'floka' ),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'separator' => 'after',
                                'default' => '1',
                            ),
                            array(
                                'name'     => 'select_post_by',
                                'label'    => esc_html__( 'Select posts by', 'floka' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => [
                                    'term_selected' => esc_html__( 'Terms selected', 'floka' ),
                                    'post_selected' => esc_html__( 'Posts selected ', 'floka' ),
                                ],
                                'default'  => 'term_selected'
                            ) 
                        ),
                        floka_get_term_by_post_type($pt_supports, ['custom_condition' => ['select_post_by' => 'term_selected']]),
                        floka_get_ids_by_post_type($pt_supports, ['custom_condition' => ['select_post_by' => 'post_selected']]),
                        array(
                            array(
                                'name' => 'orderby',
                                'label' => esc_html__('Order By', 'floka' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'date',
                                'options' => [
                                    'date' => esc_html__('Date', 'floka' ),
                                    'ID' => esc_html__('ID', 'floka' ),
                                    'author' => esc_html__('Author', 'floka' ),
                                    'title' => esc_html__('Title', 'floka' ),
                                    'rand' => esc_html__('Random', 'floka' ),
                                ],
                            ),
                            array(
                                'name' => 'order',
                                'label' => esc_html__('Sort Order', 'floka' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'desc',
                                'options' => [
                                    'desc' => esc_html__('Descending', 'floka' ),
                                    'asc' => esc_html__('Ascending', 'floka' ),
                                ],
                            ),
                            array(
                                'name' => 'limit',
                                'label' => esc_html__('Total items', 'floka' ),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => '4',
                                'control_type' => 'responsive',

                            ),
                        )
                    ),
                ),
                array(
                    'name' => 'section_display',
                    'label' => esc_html__('Display', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).',
                        ),

                        array(
                            'name' => 'show_category',
                            'label' => esc_html__('Show Category', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                        ),

                        array(
                            'name' => 'show_excerpt',
                            'label' => esc_html__('Show Excerpt', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                        ),
                        array(
                            'name' => 'button_more',
                            'label' => esc_html__('Button More', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('See More','floka'),
                            'condition' => [
                                'layout'    => '2',
                            ],
                        ),

                        array(
                            'name' => 'num_words',
                            'label' => esc_html__('Number of Words', 'floka' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 12,
                            'separator' => 'after',
                            'control_type'  => 'responsive',
                        ),
                    ),
                ),


                floka_widget_animation_settings(),
            ),
),
),
floka_get_class_widget_path()
);