<?php
$pt_supports = ['post','service','portfolio'];
pxl_add_custom_widget(
    array(
        'name' => 'pxl_post_carousel',
        'title' => esc_html__('Case Post Carousel', 'floka' ),
        'icon' => 'eicon-posts-carousel',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'swiper',
            'pxl-swiper',
            'floka-effect',
            'swiper-material',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'floka' ),
                    'tab'      => 'layout',
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'post_type',
                                'label'    => esc_html__( 'Select Post Type', 'floka' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => floka_get_post_type_options($pt_supports),
                                'default'  => 'post'
                            ) 
                        ),
                        floka_get_post_carousel_layout($pt_supports),
                    ),
                ),
                array(
                    'name' => 'section_source',
                    'label' => esc_html__('Source', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'select_post_by',
                                'label'    => esc_html__( 'Select posts by', 'floka' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => [
                                    'term_selected' => esc_html__( 'Terms selected', 'floka' ),
                                    'post_selected' => esc_html__( 'Posts selected ', 'floka' ),
                                ],
                                'default'  => 'term_selected'
                            ) 
                        ),
                        floka_get_term_by_post_type($pt_supports, ['custom_condition' => ['select_post_by' => 'term_selected']]),
                        floka_get_ids_by_post_type($pt_supports, ['custom_condition' => ['select_post_by' => 'post_selected']]),
                        array(
                            array(
                                'name' => 'orderby',
                                'label' => esc_html__('Order By', 'floka' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'date',
                                'options' => [
                                    'date' => esc_html__('Date', 'floka' ),
                                    'ID' => esc_html__('ID', 'floka' ),
                                    'author' => esc_html__('Author', 'floka' ),
                                    'title' => esc_html__('Title', 'floka' ),
                                    'rand' => esc_html__('Random', 'floka' ),
                                ],
                            ),
                            array(
                                'name' => 'order',
                                'label' => esc_html__('Sort Order', 'floka' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'desc',
                                'options' => [
                                    'desc' => esc_html__('Descending', 'floka' ),
                                    'asc' => esc_html__('Ascending', 'floka' ),
                                ],
                            ),
                            array(
                                'name' => 'limit',
                                'label' => esc_html__('Total items', 'floka' ),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => '6',
                                'control_type' => 'responsive',

                            ),
                        )
                    ),
                ),
                array(
                    'name' => 'section_carousel',
                    'label' => esc_html__('Carousel', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'active',
                            'label' => esc_html__('Active', 'floka' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'separator' => 'after',
                            'default' => '1',
                        ),
                        array(
                            'name' => 'pxl_animate',
                            'label' => esc_html__('Floka Animate', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => floka_widget_animate_v2(),
                            'default' => '',
                        ),
                        array(
                            'name' => 'pxl_animate_delay',
                            'label' => esc_html__('Animate Delay', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '0',
                            'description' => 'Enter number. Default 0ms',
                        ),
                        array(
                            'name' => 'col_xs',
                            'label' => esc_html__('Columns XS Devices', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_sm',
                            'label' => esc_html__('Columns SM Devices', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '2',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_md',
                            'label' => esc_html__('Columns MD Devices', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '2',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                                'custom' => 'custom',
                            ],
                        ),

                        array(
                            'name' => 'col_md_custom',
                            'label' => esc_html__('Columns MD Custom', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'description' => 'Enter number.',
                            'condition' => [
                                'col_md' => 'custom',
                            ],
                        ),


                        array(
                            'name' => 'col_lg',
                            'label' => esc_html__('Columns LG Devices', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                                'custom' => 'custom',
                            ],
                        ),

                        array(
                            'name' => 'col_lg_custom',
                            'label' => esc_html__('Columns LG Custom', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'description' => 'Enter number.',
                            'condition' => [
                                'col_lg' => 'custom',
                            ],
                        ),

                        array(
                            'name' => 'col_xl',
                            'label' => esc_html__('Columns XL Devices', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                                'custom' => 'custom',
                            ],
                        ),

                        array(
                            'name' => 'col_xl_custom',
                            'label' => esc_html__('Columns XL Custom', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'description' => 'Enter number.',
                            'condition' => [
                                'col_xl' => 'custom',
                            ],
                        ),

                        array(
                            'name' => 'col_xxl',
                            'label' => esc_html__('Columns XXL Devices', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                                'custom' => 'custom',
                            ],
                        ),

                        array(
                            'name' => 'col_xxl_custom',
                            'label' => esc_html__('Columns XXL Custom', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'description' => 'Enter number.',
                            'condition' => [
                                'col_xxl' => 'custom',
                            ],
                        ),

                        array(
                            'name' => 'slides_to_scroll',
                            'label' => esc_html__('Slides to scroll', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                            ],
                        ),

                        array(
                            'name' => 'filter',
                            'label' => esc_html__('Filter on Masonry', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'false',
                            'options' => [
                                'true' => esc_html__('Enable', 'floka' ),
                                'false' => esc_html__('Disable', 'floka' ),
                            ],
                            'condition' => [
                                'select_post_by' => 'term_selected',
                            ],
                        ),
                        array(
                            'name' => 'filter_type',
                            'label' => esc_html__('Filter Type', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'df',
                            'options' => [
                                'df' => esc_html__('Default', 'floka' ),
                                'style-2' => esc_html__('Style 2', 'floka' ),
                            ],
                            'condition' => [
                                'filter' => 'true',
                            ]
                        ),
                        array(
                            'name'      => 'filter_default_title',
                            'label'     => esc_html__('Filter Default Title', 'floka' ),
                            'type'      => \Elementor\Controls_Manager::TEXT,
                            'default'   => esc_html__('All', 'floka' ),
                            'condition' => [
                                'filter'         => 'true',
                            ],
                        ),
                        array(
                            'name' => 'arrows',
                            'label' => esc_html__('Show Arrows', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),

                        array(
                            'name' => 'style_arrows',
                            'label' => esc_html__('Style Arrows', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'style-1',
                            'options' => [
                                'style-1' => 'Style 1',
                                'style-2' => 'Style 2',
                                'style-3' => 'Style 3',
                            ],
                            'condition' => [
                                'arrows'    => 'true',
                            ],
                        ),

                        array(
                            'name' => 'pagination',
                            'label' => esc_html__('Show Pagination', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                        array(
                            'name' => 'pagination_type',
                            'label' => esc_html__('Pagination Type', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'bullets',
                            'options' => [
                                'bullets' => 'Bullets',
                                'fraction' => 'Fraction',
                                'progressbar' => 'Progressbar',
                            ],
                            'condition' => [
                                'pagination' => 'true'
                            ]
                        ),

                        array(
                            'name' => 'pause_on_hover',
                            'label' => esc_html__('Pause on Hover', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                        array(
                            'name' => 'autoplay',
                            'label' => esc_html__('Autoplay', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                        array(
                            'name' => 'autoplay_speed',
                            'label' => esc_html__('Autoplay Delay', 'floka'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 5000,
                            'condition' => [
                                'autoplay' => 'true'
                            ]
                        ),
                        array(
                            'name' => 'infinite',
                            'label' => esc_html__('Infinite Loop', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                        array(
                            'name' => 'speed',
                            'label' => esc_html__('Animation Speed', 'floka'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 500,
                        ),
                        array(
                            'name' => 'drap',
                            'label' => esc_html__('Show Scroll Drap', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                        array(
                            'name' => 'item_spacer',
                            'label' => esc_html__('Item Spacer', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-swiper-slider .pxl-swiper-container .pxl-swiper-slide' => 'padding: 0 {{SIZE}}px;',
                                '{{WRAPPER}} .pxl-swiper-slider .pxl-swiper-container' => 'margin: 0 -{{SIZE}}px;',
                            ],
                        ),

                    ),
),
array(
    'name' => 'section_display',
    'label' => esc_html__('Display', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
    'controls' => array(
        array(
            'name' => 'img_size',
            'label' => esc_html__('Image Size', 'floka' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                        ]
                    ],
                ],
            ],
        ),
        array(
            'name' => 'show_date',
            'label' => esc_html__('Show Date', 'floka' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'true',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2']]
                        ]
                    ],
                ],
            ],
        ),



        array(
            'name' => 'show_category',
            'label' => esc_html__('Show Category', 'floka' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'true',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-2']]
                        ]
                    ],
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1','portfolio-2']]
                        ]
                    ],
                ],
            ]
        ),

        array(
            'name' => 'show_number_count',
            'label' => esc_html__('Show Number Count', 'floka' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'true',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-3']]
                        ]
                    ],
                ],
            ]
        ),

        array(
            'name' => 'show_button',
            'label' => esc_html__('Show Button', 'floka' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'true',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2']]
                        ]
                    ],
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1','portfolio-2','portfolio-3']]
                        ]
                    ],
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2','service-3']]
                        ]
                    ],
                ],
            ]
        ),
        array(
            'name' => 'show_excerpt',
            'label' => esc_html__('Show Excerpt', 'floka' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'true',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']],
                        ]
                    ],
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2']]
                        ]
                    ],
                ],
            ]
        ),
        array(
            'name' => 'num_words',
            'label' => esc_html__('Number of Words', 'floka' ),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'default' => 12,
            'separator' => 'after',
            'control_type'  => 'responsive',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']],
                            ['name' => 'show_excerpt', 'operator' => '==', 'value' => 'true']
                        ]
                    ],
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2']]
                        ]
                    ],
                ],
            ]
        ),
    ),
),

array(
    'name' => 'section_style_general',
    'label' => esc_html__('General', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name'  => 'heading_image',
            'label' => esc_html__('IMAGE','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
        ),

        array(
            'name' => 'img_effect',
            'label' => esc_html__('Image Effect', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '' => 'None',
                'pxl-image-tilt' => 'Tilt',
                'pxl-image-scale-parallax' => 'Parallax Scale',
                'pxl-image-distortion' => 'Distortion',
            ],
            'default' => '',
            'description'   => 'Not Apply to layout 5!'

        ),
        
        array(
            'name' => 'displacement_img',
            'label' => esc_html__('Displacement Image', 'floka'),
            'type' => 'media',
            'default' => [
                'url' => content_url('/uploads/2025/01/displacement-4.webp'),
                'id' => 9031,
            ],
            'condition' => [
                'img_effect' => 'pxl-image-distortion',
            ]
        ),
        array(
            'name' => 'max_tilt',
            'label' => esc_html__('Max Tilt', 'floka' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
                'img_effect' => 'pxl-image-tilt',
            ],
            'default' => '10',
            'description' => esc_html__('Enter number.', 'floka' ),
        ),
        array(
            'name' => 'speed_tilt',
            'label' => esc_html__('Speed Tilt', 'floka' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
                'img_effect' => 'pxl-image-tilt',
            ],
            'default' => '400',
            'description' => esc_html__('Enter number.', 'floka' ),
        ),
        array(
            'name' => 'perspective_tilt',
            'label' => esc_html__('Perspective Tilt', 'floka' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
                'img_effect' => 'pxl-image-tilt',
            ],
            'default' => '1000',
            'description' => esc_html__('Enter number.', 'floka' ),
        ),

        array(
            'name'  => 'heading_author',
            'label' => esc_html__('AUTHOR','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                 [
                    'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                        ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2']],
                    ]
                ],
            ],
        ],
    ),
        array(
            'name' => 'author_name_color' ,
            'label' => esc_html__('Author Name Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-user--name' => 'color: {{VALUE}};',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                 [
                    'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                        ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2']],
                    ]
                ],
            ],
        ],
    ),

        array(
            'name' => 'author_name_typography',
            'label' => esc_html__('Author Name Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-user--name',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                 [
                    'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                        ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2']],
                    ]
                ],
            ],
        ],
    ),

        array(
            'name' => 'author_position_color' ,
            'label' => esc_html__('Author Position Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-user--position' => 'color: {{VALUE}};',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                 [
                    'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                        ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2']],
                    ]
                ],
            ],
        ],
    ),

        array(
            'name' => 'author_position_typography',
            'label' => esc_html__('Author Position Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-user--position',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                 [
                    'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                        ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2']],
                    ]
                ],
            ],
        ],
    ),

        array(
            'name' => 'border_color_author',
            'label' => esc_html__('Border Color Author', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-item--author' => 'border-bottom-color: {{VALUE}};',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2']],
                        ]
                    ],
                ],
            ]
        ),

        array(
            'name'  => 'line_color_port3',
            'label' => esc_html__('Line Color','floka'),
            'type'  => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide'  => 'border-right-color:{{VALUE}};',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-3']],
                        ]
                    ],
                ],
            ],
        ),


        array(
            'name'          => 'tab_iconbox_featured',
            'control_type'  => 'tab',
            'tabs'          => [
                [
                    'name'  => 'iconbox_featured_normal',
                    'label' => esc_html__('Normal','floka'),
                    'type'  => 'tab',
                    'controls'  => 
                    [
                        array(
                            'name'  => 'heading_number_count',
                            'label' => esc_html__('NUMBER COUNT','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'conditions' => [
                            'relation' => 'or',
                            'terms' => [
                            [
                            'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-3']],
                            ]
                            ],
                            ],
                        ],
                        'condition' => [
                        'show_number_count'     => 'true',
                    ],
                ),
                        array(
                            'name'  => 'color_number_count',
                            'label' => esc_html__('Color','floka'),
                            'type'  => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}}.pxl-post-blog .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--featured .count '  => 'color:{{VALUE}};',
                        ],
                        'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                        [
                        'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                        ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-3']],
                        ]
                        ],
                        ],
                    ],
                    'condition' => [
                    'show_number_count'     => 'true',
                ],
            ),

                        array(
                            'name' => 'typography_number_count',
                            'label' => esc_html__('Typography', 'floka' ),
                            'type' => \Elementor\Group_Control_Background::get_type(),
                            'control_type'  => 'group',
                            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--featured .count',
                            'conditions' => [
                            'relation' => 'or',
                            'terms' => [
                            [
                            'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-3']],
                            ]
                            ],
                            ],
                        ],
                        'condition' => [
                        'show_number_count'     => 'true',
                    ],
                ),


                        array(
                            'name' => 'background_item',
                            'label' => esc_html__('Background', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}}.pxl-post-blog .pxl-item--content' => 'background: {{VALUE}};',
                        ],
                        'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                        [
                        'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                        ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']],
                        ]
                        ],
                        ],
                    ],
                ),



                        array(
                            'name' => 'background_item_service',
                            'label' => esc_html__('Background', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}}.pxl-post-blog .pxl-post--inner' => 'background: {{VALUE}};',
                        ],
                        'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                        [
                        'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                        ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1']],
                        ]
                        ],
                        ],
                    ]
                ),

                        array(
                            'name' => 'background_item_service2',
                            'label' => esc_html__('Background', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}}.pxl-post-blog .pxl-post--holder' => 'background: {{VALUE}};',
                        ],
                        'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                        [
                        'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                        ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-2']],
                        ]
                        ],
                        [
                        'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                        ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1']],
                        ]
                        ],
                        ],
                    ]
                ),

                        array(
                            'name' => 'background_item_service3',
                            'label' => esc_html__('Background', 'floka' ),
                            'type' => \Elementor\Group_Control_Background::get_type(),
                            'control_type'  => 'group',
                            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-post--inner::before',
                            'conditions' => [
                            'relation' => 'or',
                            'terms' => [
                            [
                            'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-3']],
                            ]
                            ],
                            [
                            'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-2']],
                            ]
                            ],
                            ],
                        ]
                    ),
                        array(
                            'name' => 'padding_item',
                            'label' => esc_html__('Padding', 'floka' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'selectors' => [
                            '{{WRAPPER}}.pxl-post-blog .pxl-item--content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                        [
                        'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                        ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                        ]
                        ],
                        ],
                    ],
                ),

                        array(
                            'name' => 'padding_item_service',
                            'label' => esc_html__('Padding', 'floka' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'selectors' => [
                            '{{WRAPPER}}.pxl-post-blog .pxl-post--holder' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                        [
                        'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                        ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2']]
                        ]
                        ],
                        ],
                    ],
                ),

                        array(
                            'name' => 'margin_item_service',
                            'label' => esc_html__('Margin', 'floka' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'selectors' => [
                            '{{WRAPPER}}.pxl-post-blog .pxl-post--holder' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                        [
                        'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                        ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-2']]
                        ]
                        ],
                        ],
                    ],
                ),

                        array(
                            'name' => 'border_radius_item',
                            'label' => esc_html__('Border Radius', 'floka' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'selectors' => [
                            '{{WRAPPER}}.pxl-post-blog .pxl-post--inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                        [
                        'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                        ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                        ]
                        ],
                        [
                        'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                        ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-3']]
                        ]
                        ],
                        ],
                    ],
                ),


                        array(
                            'name' => 'border_radius_item_service2',
                            'label' => esc_html__('Border Radius', 'floka' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'selectors' => [
                            '{{WRAPPER}}.pxl-post-blog .pxl-post--holder' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                        [
                        'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                        ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-2']]
                        ]
                        ],
                        ],
                    ],
                ),

                        array(
                            'name'  => 'box_shadow_item',
                            'label' => esc_html__('Box Shadow','floka'),
                            'type'  => \Elementor\Group_Control_Box_Shadow::get_type(),
                            'control_type'  => 'group',
                            'selector'  => '{{WRAPPER}}.pxl-post-blog .pxl-post--inner',
                            'conditions' => [
                            'relation' => 'or',
                            'terms' => [
                            [
                            'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                            ]
                            ],
                            [
                            'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-3']]
                            ]
                            ],
                            [
                            'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-2']]
                            ]
                            ],
                            ],
                        ],
                    ),

                        array(
                            'name'  => 'box_shadow_item_service2',
                            'label' => esc_html__('Box Shadow','floka'),
                            'type'  => \Elementor\Group_Control_Box_Shadow::get_type(),
                            'control_type'  => 'group',
                            'selector'  => '{{WRAPPER}}.pxl-post-blog .pxl-post--holder',
                            'conditions' => [
                            'relation' => 'or',
                            'terms' => [
                            [
                            'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-2']]
                            ]
                            ],
                            ],
                        ],
                    ),

                        array(
                            'name'  => 'heading_icon_box',
                            'label' => esc_html__('ICON BOX','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                            'conditions' => [
                            'relation' => 'or',
                            'terms' => [
                            [
                            'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2','service-3']],
                            ]
                            ],
                            ],
                        ],
                    ),

                        array(
                            'name'         => 'featured_iconbox_box_fs',
                            'label'        => esc_html__('Size Box', 'floka' ),
                            'type'         => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units'   => [ 'px', 'custom' ],
                            'range'        => [
                            'px' => [
                            'min' => 0,
                            'max' => 300,
                            ],
                        ],
                        'selectors' => [
                        '{{WRAPPER}}.pxl-post-blog .pxl-post--icon' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                    ],
                    'conditions' => [
                    'relation' => 'or',
                    'terms'    => [
                    [
                    'terms' => [
                    ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                    ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2','service-3']],
                    ]
                    ],
                    ],
                ],
            ),

                        array(
                            'name' => 'featured_iconbox_icon_fs',
                            'label' => esc_html__('Size Icon', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', 'custom' ],
                            'range' => [
                            'px' => [
                            'min' => 0,
                            'max' => 300,
                            ],
                        ],
                        'selectors' => [
                        '{{WRAPPER}}.pxl-post-blog .pxl-post--icon img' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}}.pxl-post-blog .pxl-post--icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                    ],
                    'conditions' => [
                    'relation' => 'or',
                    'terms'    => [
                    [
                    'terms' => [
                    ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                    ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2','service-3']],
                    ]
                    ],
                    ],
                ],
            ),

                        array(
                            'name' => 'iconbox_border',
                            'label' => esc_html__('Border', 'floka' ),
                            'type' => \Elementor\Group_Control_Border::get_type(),
                            'control_type'  => 'group',
                            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-post--icon',
                            'conditions' => [
                            'relation' => 'or',
                            'terms'    => [
                            [
                            'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2']],
                            ]
                            ],
                            ],
                        ],
                    ),

                        array(
                            'name' => 'iconbox_border_service3',
                            'label' => esc_html__('Border', 'floka' ),
                            'type' => \Elementor\Group_Control_Border::get_type(),
                            'control_type'  => 'group',
                            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-post--icon::before',
                            'conditions' => [
                            'relation' => 'or',
                            'terms'    => [
                            [
                            'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-3']],
                            ]
                            ],
                            ],
                        ],
                    ),

                        array(
                            'name' => 'iconbox_border_bg',
                            'label' => esc_html__('Background Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}}.pxl-post-blog .pxl-post--icon' => 'background: {{VALUE}};',
                        ],
                        'conditions' => [
                        'relation' => 'or',
                        'terms'    => [
                        [
                        'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                        ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2']],
                        ]
                        ],
                        ],
                    ],

                ),

                        array(
                            'name' => 'iconbox_border_bg_service3',
                            'label' => esc_html__('Background Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}}.pxl-post-blog .pxl-post--icon::after' => 'background: {{VALUE}};',
                        ],
                        'conditions' => [
                        'relation' => 'or',
                        'terms'    => [
                        [
                        'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                        ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-3']],
                        ]
                        ],
                        ],
                    ],

                ),
                    ],
                ],
                [
                    'name'  => 'iconbox_featured_hover',
                    'label' => esc_html__('Hover','floka'),
                    'type'  => 'tab',
                    'controls'  => [
                     array(
                        'name' => 'background_item_service2_hv',
                        'label' => esc_html__('Background', 'floka' ),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                        '{{WRAPPER}}.pxl-post-blog .pxl-post--holder:before' => 'background: {{VALUE}};',
                    ],
                    'conditions' => [
                    'relation' => 'or',
                    'terms' => [

                    [
                    'terms' => [
                    ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                    ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1']],
                    ]
                    ],
                    ],
                ]
            ),

                     array(
                        'name' => 'background_hover_item_service3',
                        'label' => esc_html__('Background', 'floka' ),
                        'type' => \Elementor\Group_Control_Background::get_type(),
                        'control_type'  => 'group',
                        'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-post--inner::after',
                        'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                        [
                        'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                        ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-3']],
                        ]
                        ],
                        [
                        'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                        ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-2']],
                        ]
                        ],
                        ],
                    ],
                    'separator' => 'after',
                ),

                     array(
                        'name'  => 'heading_icon_box_hv',
                        'label' => esc_html__('ICON BOX','floka'),
                        'type'  => \Elementor\Controls_Manager::HEADING,
                        'separator' => 'before',
                        'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                        [
                        'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                        ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2','service-3']],
                        ]
                        ],
                        ],
                    ],
                ),

                     array(
                        'name' => 'iconbox_border_hv',
                        'label' => esc_html__('Border', 'floka' ),
                        'type' => \Elementor\Group_Control_Border::get_type(),
                        'control_type'  => 'group',
                        'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-post--inner:hover .pxl-post--icon',
                        'conditions' => [
                        'relation' => 'or',
                        'terms'    => [
                        [
                        'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                        ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2']],
                        ]
                        ],
                        ],
                    ],
                ),

                     array(
                        'name' => 'iconbox_border_bg_hv',
                        'label' => esc_html__('Background Color', 'floka' ),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                        '{{WRAPPER}}.pxl-post-blog .pxl-post--inner:hover .pxl-post--icon' => 'background: {{VALUE}};',
                    ],
                    'conditions' => [
                    'relation' => 'or',
                    'terms'    => [
                    [
                    'terms' => [
                    ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                    ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2']],
                    ]
                    ],
                    ],
                ],
            ),

                     array(
                        'name'  => 'box_shadow_item_hv',
                        'label' => esc_html__('Box Shadow','floka'),
                        'type'  => \Elementor\Group_Control_Box_Shadow::get_type(),
                        'control_type'  => 'group',
                        'selector'  => '{{WRAPPER}}.pxl-post-blog .pxl-post--inner:hover',
                        'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                        [
                        'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                        ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-2']]
                        ]
                        ],
                        ],
                    ],
                ),
                 ],
             ],
         ],
     ),

),
),
array(
    'name' => 'section_style_category',
    'label' => esc_html__('Category', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'conditions' => [
        'relation' => 'or',
        'terms' => [
            [
                'terms' => [
                    ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                    ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1','portfolio-2','portfolio-3']],
                ]
            ],
        ],
    ],
    'controls' => array(
        array(
            'name' => 'categories_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-item--category a' => 'color: {{VALUE}} !important;',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1','portfolio-2','portfolio-3']],
                        ]
                    ],
                ],
            ],
        ),
        array(
            'name' => 'categories_color_hv',
            'label' => esc_html__('Color Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--inner:hover .pxl-item--category a' => 'color: {{VALUE}} !important;',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1','portfolio-2','portfolio-3']],
                        ]
                    ],
                ],
            ],
        ),

        array(
            'name' => 'categories_bg_color',
            'label' => esc_html__('Background Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-item--category' => 'background: {{VALUE}} !important;',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1','portfolio-2','portfolio-3']],
                        ]
                    ],
                ],
            ],
        ),

        array(
            'name' => 'categories_bg_color_hv',
            'label' => esc_html__('Background Color Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--inner:hover .pxl-item--category' => 'background: {{VALUE}} !important;',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1','portfolio-2','portfolio-3']],
                        ]
                    ],
                ],
            ],
        ),


        array(
            'name' => 'category_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-item--category a',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1','portfolio-2']],
                        ]
                    ],
                ],
            ]
        ),

        array(
            'name' => 'category_typography_port3',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .pxl-item--title',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-3']],
                        ]
                    ],
                ],
            ]
        ),
    ),
),

array(
    'name' => 'section_style_title',
    'label' => esc_html__('Title', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'title_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--title' => 'color: {{VALUE}} !important;',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']],
                        ]
                    ],
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2','service-3']],
                        ]
                    ],
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1','portfolio-2']],
                        ]
                    ],
                ],
            ]
        ),

        array(
            'name' => 'title_color_port3',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide.swiper-slide-active .pxl-item--inner .pxl-item--holder .pxl-item--title a,
                {{WRAPPER}}.pxl-post-blog .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .pxl-post--title > span' => 'color: {{VALUE}} !important;',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-3']],
                        ]
                    ],
                ],
            ]
        ),
        array(
            'name' => 'title_color_port3_hv',
            'label' => esc_html__('Color Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide.swiper-slide-active .pxl-item--inner .pxl-item--holder .pxl-item--title a:hover,
                {{WRAPPER}}.pxl-post-blog .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .pxl-post--title:hover > span' => 'color: {{VALUE}} !important;',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-3']],
                        ]
                    ],
                ],
            ]
        ),
        array(
            'name' => 'title_color_hv',
            'label' => esc_html__('Color Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--inner:hover .pxl-post--title' => 'color: {{VALUE}} !important;',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1','portfolio-2']],
                        ]
                    ],
                ],
            ]
        ),

        array(
            'name' => 'title_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-post--title',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']],
                        ]
                    ],
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2','service-3']],
                        ]
                    ],
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1','portfolio-2']],
                        ]
                    ],
                ],
            ]
        ),

        array(
            'name' => 'title_typography_port3',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .pxl-item--title a',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-3']],
                        ]
                    ],
                ],
            ]
        ),

        array(
            'name'  => 'heading_date',
            'label' => esc_html__('DATE','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                 [
                    'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                        ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']],
                    ]
                ],
            ],
        ],
    ),

        array(
            'name'  => 'date_color',
            'label' => esc_html__('Color','floka'),
            'type'  => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--date,{{WRAPPER}}.pxl-post-blog .pxl-item--date' => 'color: {{VALUE}};',
                '{{WRAPPER}}.pxl-post-blog .pxl-post--date svg path' => 'fill: {{VALUE}};',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                 [
                    'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                        ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']],
                    ]
                ],
            ],
        ],
    ),
        array(
            'name'  => 'date_bg_color',
            'label' => esc_html__('Background Color','floka'),
            'type'  => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--date' => 'background-color: {{VALUE}};',
                '{{WRAPPER}}.pxl-post-blog .pxl-post--date svg path' => 'fill: {{VALUE}};',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                 [
                    'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                        ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']],
                    ]
                ],
            ],
        ],
    ),

        array(
            'name' => 'date_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-post--date',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                 [
                    'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                        ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']],
                    ]
                ],
            ],
        ]
    ),

        array(
            'name' => 'date_border_radius',
            'label' => esc_html__( 'Border Radius', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'responsive' => true,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--date' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']],
                        ]
                    ],
                ],
            ],
        ),

        array(
            'name' => 'date_border',
            'label' => esc_html__('Border', 'floka' ),
            'type' => \Elementor\Group_Control_Border::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-post--date',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']],
                        ]
                    ],
                ],
            ]
        ),

        array(
            'name' => 'size_box_date',
            'label' => esc_html__('Size Box', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--date' => 'width: {{SIZE}}px; height: {{SIZE}}px;',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                 [
                    'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                        ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']],
                    ]
                ],
            ],
        ],
    ),



    ),
),

array(
    'name' => 'section_style_excerpt',
    'label' => esc_html__('Exceprt', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'conditions' => [
        'relation' => 'or',
        'terms' => [
            [
                'terms' => [
                    ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                    ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']],
                ]
            ],
            [
                'terms' => [
                    ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                    ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2']],
                ]
            ],
            [
                'terms' => [
                    ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                    ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-3']],
                ]
            ],
        ],
    ],
    'controls' => array(
        array(
            'name' => 'excerpt_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-item--excerpt' => 'color: {{VALUE}};',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']],
                        ]
                    ],
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2']],
                        ]
                    ],

                ],
            ]

        ),
        array(
            'name' => 'excerpt_color_port3',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .pxl-item--content' => 'color: {{VALUE}};',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-3']],
                        ]
                    ],
                ],
            ]

        ),
        
        array(
            'name' => 'excerpt_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-item--excerpt',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']],
                        ]
                    ],
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2']],
                        ]
                    ],
                ],
            ],
        ),

        array(
            'name' => 'excerpt_typography_port3',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .pxl-item--content',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-3']],
                        ],
                    ],
                ],
            ],
        ),
    ),
),

array(
    'name' => 'section_style_button',
    'label' => esc_html__('Button', 'floka'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'conditions' => [
        'relation' => 'or',
        'terms' => [
            [
                'terms' => [
                    ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                    ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2']],
                ]
            ],
            [
                'terms' => [
                    ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                    ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2','service-3']],
                ]
            ],
            [
                'terms' => [
                    ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                    ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-2','portfolio-3']],
                ]
            ],
        ],
    ],
    'controls' => array(
        array(
            'name' => 'button_color',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--button a' => 'color: {{VALUE}};',
                '{{WRAPPER}}.pxl-post-blog .pxl-post--button a svg path' => 'fill: {{VALUE}};',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2']],
                        ]
                    ],
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2','service-3']],
                        ]
                    ],
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-2']],
                        ]
                    ],
                ],
            ],
        ),


        array(
            'name' => 'button_color_port3',
            'label' => esc_html__('Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .pxl-item--readmore .btn' => 'color: {{VALUE}};',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-3']],
                        ]
                    ],
                ],
            ],
        ),

        array(
            'name' => 'button_color_hv',
            'label' => esc_html__('Color Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--button a:hover' => 'color: {{VALUE}};',
                '{{WRAPPER}}.pxl-post-blog .pxl-post--button a:before:hover' => 'background: {{VALUE}};',
                '{{WRAPPER}}.pxl-post-blog .pxl-post--button a:hover svg path' => 'fill: {{VALUE}};',

            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                 [
                    'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                        ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2']],
                    ]
                ],
                [
                    'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                        ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2','service-3']],
                    ]
                ],
                [
                    'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                        ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-2']],
                    ]
                ],
            ],
        ],
    ),

        array(
            'name' => 'button_color_port3_hv',
            'label' => esc_html__('Color Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .pxl-item--readmore .btn:hover' => 'color: {{VALUE}};',
            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-3']],
                        ]
                    ],
                ],
            ],
        ),

        array(
            'name' => 'button_bg_color',
            'label' => esc_html__('Background', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--button a' => 'background: {{VALUE}};',

            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2','service-3']],
                        ]
                    ],
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-2']],
                        ]
                    ],
                ],
            ],
        ),

        array(
            'name' => 'button_bg_color_port3',
            'label' => esc_html__('Background', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .pxl-item--readmore .btn' => 'background: {{VALUE}};',

            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-3']],
                        ]
                    ],
                ],
            ],
        ),

        array(
            'name' => 'button_bg_color_hv',
            'label' => esc_html__('Background Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--button a:hover' => 'background: {{VALUE}};',

            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2','service-3']],
                        ]
                    ],
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-2']],
                        ]
                    ],
                ],
            ],
            'condition' => [
                'btn_text_effect!'  => 'btn-spotlight-scale',
            ],
        ),

        array(
            'name' => 'button_bg_color_port3_hv',
            'label' => esc_html__('Background Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .pxl-item--readmore .btn:hover' => 'background: {{VALUE}};',

            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-3']],
                        ]
                    ],
                ],
            ],
            'condition' => [
                'btn_text_effect!'  => 'btn-spotlight-scale',
            ],
        ),

        array(
            'name' => 'button_bg_color_hv_spotlight',
            'label' => esc_html__('Background Hover', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-post-blog .pxl-post--button a .item-spotlight' => 'background: {{VALUE}};',

            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2','service-3']],
                        ]
                    ],
                ],
            ],
            'condition' => [
                'btn_text_effect'  => 'btn-spotlight-scale',
            ],
        ),

        array(
            'name' => 'button_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-post--button a',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                 [
                    'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                        ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1','post-2']],
                    ]
                ],
                [
                    'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                        ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2','service-3']],
                    ]
                ],
            ],
        ],
    ),

        array(
            'name' => 'button_typography_port3',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}}.pxl-post-blog .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .pxl-item--readmore .btn',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                 [
                    'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                        ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-3']],
                    ],
                ],
            ],
        ],
    ),

        array(
            'name' => 'btn_text_effect',
            'label' => esc_html__('Text Effect', 'floka' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => '',
            'options' => [
                '' => esc_html__('Default', 'floka' ),
                'btn-text-nina' => esc_html__('Nina', 'floka' ),
                'btn-text-nanuk' => esc_html__('Nanuk', 'floka' ),
                'btn-text-parallax' => esc_html__('Parallax', 'floka' ),
                'btn-spotlight-scale' => esc_html__('Spotlight', 'floka' ),

            ],
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                 [
                    'terms' => [
                        ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                        ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-2','service-3']],
                    ]
                ],
            ],
        ],
    ),

    ),
),

),
),
),
floka_get_class_widget_path()
);