<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_pricing',
        'title' => esc_html__('Case Pricing', 'floka'),
        'icon' => 'eicon-price-table',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'floka' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_pricing/layout1.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'title',
                            'label' => esc_html__('Title', 'floka'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),

                        array(
                            'name' => 'desc',
                            'label' => esc_html__('Description', 'floka'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),

                        array(
                            'name' => 'price',
                            'label' => esc_html__('Price', 'floka'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                        ),
                        array(
                            'name' => 'billing_cycle',
                            'label' => esc_html__('Billing Cycle', 'floka'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                        ),
                        array(
                            'name' => 'btn_text',
                            'label' => esc_html__('Button Text', 'floka'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'btn_link',
                            'label' => esc_html__('Button Link', 'floka'),
                            'type' => \Elementor\Controls_Manager::URL,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'feature',
                            'label' => esc_html__('Feature', 'floka'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'feature_text',
                                    'label' => esc_html__('Text', 'floka'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'feature_active',
                                    'label' => esc_html__('Features', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'options' => [
                                        'yes' => 'Available',
                                        'no' => 'No',
                                    ],
                                    'default' => 'yes',
                                ),
                            ),
                            'title_field' => '{{{ feature_text }}}',
                        ),
                    ),
                ),
array(
    'name' => 'section_style_general',
    'label' => esc_html__('General', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'border_radius',
            'label' => esc_html__('Border Radius', 'floka' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px','custom' ],
            'selectors' => [
                '{{WRAPPER}} .pxl-pricing .pxl-item--inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'control_type' => 'responsive',
        ),
        array(
            'name'  => 'border_group',
            'label' => esc_html__('Border','floka'),
            'type'  => \Elementor\Group_Control_Border::get_type(),
            'control_type'  => 'group',
            'selector'  => '{{WRAPPER}} .pxl-pricing .pxl-item--inner',
        ),
    ),
),   
array(
    'name' => 'section_style_content',
    'label' => esc_html__('Content', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(

        array(
            'name' => 'border_color_bottom_content',
            'label' => esc_html__( 'Border Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--inner' => 'border-bottom-color: {{VALUE}};',
            ],
        ),

        array(
            'name'  => 'heading_desc',
            'label' => esc_html__('DESCRIPTION','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
        ),
        array(
            'name' => 'desc_color',
            'label' => esc_html__( 'Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--inner .pxl-item--desc' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'desc_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--inner .pxl-item--desc',
        ),



        array(
            'name'  => 'heading_price',
            'label' => esc_html__('PRICING','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ),
        array(
            'name'  => 'heading_price_price',
            'label' => esc_html__('Price','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
        ),
        array(
            'name' => 'price_color',
            'label' => esc_html__( 'Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--inner .pxl-item--price .pxl--price' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'price_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--inner .pxl-item--price .pxl--price',
        ),
        array(
            'name'  => 'heading_billing_cycle',
            'label' => esc_html__('Billing Cycle','floka'),
            'type'  => \Elementor\Controls_Manager::HEADING,
        ),
        array(
            'name' => 'billing_cycle_color',
            'label' => esc_html__( 'Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--inner .pxl-item--price .pxl--billing-cycle' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'billing_cycle_typography',
            'label' => esc_html__('Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--inner .pxl-item--price .pxl--billing-cycle',
        ),
    ),
),


array(
    'name' => 'section_style_feature',
    'label' => esc_html__('Feature', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name'  => 'tab_feature_controls',
            'control_type'  => 'tab',
            'tabs'  => [
                [
                    'name'  => 'feature_normal',
                    'label' => esc_html__('Available','floka'),
                    'type'  => 'tab',
                    'controls'  => [
                        array(
                            'name' => 'feature_color',
                            'label' => esc_html__('Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--content .pxl-pricing--feature li' => 'color: {{VALUE}};',
                        ],
                    ),
                        array(
                            'name' => 'feature_typography',
                            'label' => esc_html__('Typography', 'floka' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--content .pxl-pricing--feature li',
                        ),
                        array(
                            'name' => 'feature_space',
                            'label' => esc_html__('Spacing', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', 'custom' ],
                            'range' => [
                            'px' => [
                            'min' => 0,
                            'max' => 1000,
                            ],
                        ],
                        'selectors' => [
                        '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--content .pxl-pricing--feature li' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ),
                    ],
                ],
                [
                    'name'  => 'tab_available',
                    'label' => esc_html__('Not Available','floka'),
                    'type'  => 'tab',
                    'controls'  => [
                        array(
                            'name' => 'feature_color_not_available',
                            'label' => esc_html__('Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--content .pxl-pricing--feature li.not-feature-item' => 'color: {{VALUE}};',
                        ],
                    ),
                        array(
                            'name' => 'feature_typography_not_available',
                            'label' => esc_html__('Typography', 'floka' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--content .pxl-pricing--feature li.not-feature-item',
                        ),
                    ],
                ],
            ],
        ),
        

    ),
),
array(
    'name' => 'section_style_button',
    'label' => esc_html__('Button', 'floka' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name'  => 'tab_button_controls',
            'control_type'  => 'tab',
            'tabs'  => [
                [
                    'name'  => 'tab_normal',
                    'label' => esc_html__('Normal','floka'),
                    'type'  => 'tab',
                    'controls'  => [
                        array(
                            'name' => 'button_color',
                            'label' => esc_html__('Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--content .pxl-pricing--button a' => 'color: {{VALUE}};',
                        ],
                    ),
                        array(
                            'name' => 'button_bg_color',
                            'label' => esc_html__('Background Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--content .pxl-pricing--button a' => 'background-color: {{VALUE}};',
                        ],
                    ),
                        array(
                            'name' => 'border_button',
                            'label' => esc_html__('Border', 'floka' ),
                            'type' => \Elementor\Group_Control_Border::get_type(),
                            'control_type'  => 'group',
                            'selector' =>  '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--content .pxl-pricing--button a',
                        ),
                        array(
                            'name' => 'button_padding',
                            'label' => esc_html__('Padding', 'floka' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px','custom' ],
                            'selectors' => [
                            '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--content .pxl-pricing--button a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'control_type' => 'responsive',
                    ),
                        array(
                            'name' => 'btn_border_radius',
                            'label' => esc_html__('Border Radius', 'floka' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px','custom' ],
                            'selectors' => [
                            '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--content .pxl-pricing--button a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'control_type' => 'responsive',
                    ),
                    ],
                ],
                [
                    'name'  => 'tab_hover',
                    'label' => esc_html__('Hover','floka'),
                    'type'  => 'tab',
                    'controls'  => [
                        array(
                            'name' => 'button_color_hover',
                            'label' => esc_html__('Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--content .pxl-pricing--button a:hover' => 'color: {{VALUE}};',
                        ],
                    ),
                        array(
                            'name' => 'button_bg_color_hover',
                            'label' => esc_html__('Background Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                            '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--content .pxl-pricing--button a:hover' => 'background-color: {{VALUE}};',
                        ],
                    ),
                        array(
                            'name' => 'border_button_hover',
                            'label' => esc_html__('Border', 'floka' ),
                            'type' => \Elementor\Group_Control_Border::get_type(),
                            'control_type'  => 'group',
                            'selector' =>  '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--content .pxl-pricing--button a:hover',
                        ),
                        array(
                            'name' => 'button_padding_hover',
                            'label' => esc_html__('Padding', 'floka' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px','custom' ],
                            'selectors' => [
                            '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--content .pxl-pricing--button a:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'control_type' => 'responsive',
                    ),
                        array(
                            'name' => 'btn_border_radius_hover',
                            'label' => esc_html__('Border Radius', 'floka' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px','custom' ],
                            'selectors' => [
                            '{{WRAPPER}} .pxl-pricing .pxl-item--inner .pxl-pricing--content .pxl-pricing--button a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'control_type' => 'responsive',
                    ),
                    ],
                ],
            ],
        ),


),
),
floka_widget_animation_settings(),
),
),
),
floka_get_class_widget_path()
);