<?php
$slides_to_show = range( 1, 10 );
$slides_to_show = array_combine( $slides_to_show, $slides_to_show );
pxl_add_custom_widget(
    array(
        'name' => 'pxl_process_carousel',
        'title' => esc_html__('Case Process Carousel', 'floka'),
        'icon' => 'eicon-carousel',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'swiper',
            'pxl-swiper',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'floka' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_process_carousel/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'floka' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_process_carousel/layout2.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_content',
                    'label' => esc_html__('Content', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'process',
                            'label' => esc_html__('Content', 'floka'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'image',
                                    'label' => esc_html__('Image', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                ),
                                
                                array(
                                    'name'  => 'title',
                                    'label' => esc_html__('Title','floka'),
                                    'type'  => \Elementor\Controls_Manager::TEXT,
                                    'label_block'   => true,
                                ),
                                
                                array(
                                    'name'  => 'description',
                                    'label' => esc_html__('Description','floka'),
                                    'type'  => \Elementor\Controls_Manager::TEXTAREA,
                                    'label_block'   => true,
                                ),

                                array(
                                    'name' => 'decorative_icon',
                                    'label' => esc_html__('Decorative', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::ICONS,
                                    'fa4compatibility' => 'icon',
                                ),
                                array(
                                    'name' => 'item_link',
                                    'label' => esc_html__('Link Details', 'floka'),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'label_block' => true,
                                ),
                                array(
                                    'name'  => 'item_margin_top',
                                    'label' => esc_html__( 'Margin Top', 'floka' ),
                                    'type' => \Elementor\Controls_Manager::SLIDER,
                                    'control_type' => 'responsive',
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl-process-carousel {{CURRENT_ITEM}}' => 'margin-top: {{SIZE}}{{UNIT}};',
                                    ],
                                ),

                            ),'title_field' => '{{{ title }}}',
                        ),
                    ),
                ),

                array(
                    'name' => 'section_carousel_settings',
                    'label' => esc_html__('Carousel Settings', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).',
                        ),
                        array(
                            'name' => 'col_xs',
                            'label' => esc_html__('Columns XS Devices', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_sm',
                            'label' => esc_html__('Columns SM Devices', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '2',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_md',
                            'label' => esc_html__('Columns MD Devices', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '2',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_lg',
                            'label' => esc_html__('Columns LG Devices', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                                '7' => '7',
                                '8' => '8',
                            ],
                        ),
                        array(
                            'name' => 'col_xl',
                            'label' => esc_html__('Columns XL Devices', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                                '7' => '7',
                                '8' => '8',
                            ],
                        ),
                        array(
                            'name' => 'col_xxl',
                            'label' => esc_html__('Columns XXL Devices', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '4',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                                '7' => '7',
                                '8' => '8',
                            ],
                        ),

                        array(
                            'name' => 'slides_to_scroll',
                            'label' => esc_html__('Slides to scroll', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                                '7' => '7',
                                '8' => '8',
                            ],
                        ),
                        array(
                            'name' => 'arrows',
                            'label' => esc_html__('Show Arrows', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                        array(
                            'name' => 'pagination',
                            'label' => esc_html__('Show Pagination', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                        array(
                            'name' => 'pagination_type',
                            'label' => esc_html__('Pagination Type', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'bullets',
                            'options' => [
                                'bullets' => 'Bullets',
                                'fraction' => 'Fraction',
                                'progressbar' => 'Progressbar',
                            ],
                            'condition' => [
                                'pagination' => 'true'
                            ]
                        ),
                        array(
                            'name' => 'pause_on_hover',
                            'label' => esc_html__('Pause on Hover', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                        array(
                            'name' => 'autoplay',
                            'label' => esc_html__('Autoplay', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                        array(
                            'name' => 'autoplay_speed',
                            'label' => esc_html__('Autoplay Delay', 'floka'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 5000,
                            'condition' => [
                                'autoplay' => 'true'
                            ]
                        ),
                        array(
                            'name' => 'infinite',
                            'label' => esc_html__('Infinite Loop', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                        array(
                            'name' => 'speed',
                            'label' => esc_html__('Animation Speed', 'floka'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 500,
                        ),
                        array(
                            'name' => 'drap',
                            'label' => esc_html__('Show Scroll Drap', 'floka'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                        array(
                            'name' => 'item_spacer',
                            'label' => esc_html__('Item Spacer', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-swiper-slider .pxl-swiper-container .pxl-swiper-slide' => 'padding: 0 {{SIZE}}px;',
                                '{{WRAPPER}} .pxl-swiper-slider .pxl-swiper-container' => 'margin: 0 -{{SIZE}}px;',
                            ],
                        ),
                    ),
),

array(
    'name'  => 'section_carousel_style',
    'label' => esc_html__('General','floka'),
    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
    'controls'  => array(
     array(
        'name' => 'heading_img',
        'label' => esc_html__('IMAGE', 'floka' ),
        'type' => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
    ),

     array(
        'name' => 'border_img_color',
        'label' => esc_html__('Border Color', 'floka' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .pxl-process-carousel .pxl-item--image a .pxl--image' => 'border-color: {{VALUE}};',
        ],
    ),

     array(
        'name' => 'border_img_color_hv',
        'label' => esc_html__('Border Color Hover', 'floka' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .pxl-process-carousel .pxl-swiper-slide:hover .pxl-item--image a .pxl--image' => 'border-color: {{VALUE}};',
        ],
    ),

     array(
        'name' => 'heading_decorative',
        'label' => esc_html__('DECORATIVE', 'floka' ),
        'type' => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
    ),

     array(
        'name' => 'border_decorative_color',
        'label' => esc_html__('Color', 'floka' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .pxl-process-carousel .pxl-swiper-slide .pxl-icon-bg svg path' => 'fill: {{VALUE}};',
        ],
    ),

     array(
        'name' => 'border_decorative_color_hv',
        'label' => esc_html__('Color Hover', 'floka' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .pxl-process-carousel .pxl-swiper-slide:hover .pxl-icon-bg svg path' => 'fill: {{VALUE}};',
        ],
    ),

     array(
        'name' => 'heading_number',
        'label' => esc_html__('NUMBER', 'floka' ),
        'type' => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
    ),

     array(
        'name' => 'number_color',
        'label' => esc_html__('Color', 'floka' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .pxl-process-carousel .pxl--number' => 'color: {{VALUE}};',
        ],
    ),

     array(
        'name' => 'number_bg_color',
        'label' => esc_html__('Background Color', 'floka' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .pxl-process-carousel .pxl--number' => 'background: {{VALUE}};',
        ], 
    ),

     array(
        'name' => 'number_line',
        'label' => esc_html__('Line Color', 'floka' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .pxl-process-carousel .pxl-item--number::after' => 'background: {{VALUE}};',
        ],
        'condition' => [
            'layout'   => '1',
        ],
    ),
 ),
),

array(
    'name'  => 'section_carousel_title',
    'label' => esc_html__('Title','floka'),
    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
    'controls'  => array(
        array(
            'name' => 'title_color',
            'label' => esc_html__('Title Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-process-carousel .pxl-item--title' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'title_typography',
            'label' => esc_html__('Title Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-process-carousel .pxl-item--title',
        ),
        array(
            'name' => 'title_space_top',
            'label' => esc_html__('Space Top', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px','custom' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-process-carousel .pxl-item--title' => 'margin-top: {{SIZE}}{{UNIT}};',
            ],
        ),


    ),
),

array(
    'name'  => 'section_carousel_description',
    'label' => esc_html__('Description','floka'),
    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
    'controls'  => array(
        array(
            'name' => 'description_color',
            'label' => esc_html__('Description Color', 'floka' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-process-carousel .pxl-item--description' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'description_typography',
            'label' => esc_html__('Description Typography', 'floka' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-process-carousel .pxl-item--description',
        ),
        array(
            'name' => 'description_space_top',
            'label' => esc_html__('Space Top', 'floka' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px','custom' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-process-carousel .pxl-item--description' => 'margin-top: {{SIZE}}{{UNIT}};',
            ],
        ),


    ),
),

floka_widget_animation_settings(),
),
),
),
floka_get_class_widget_path()
);