<?php
$pt_supports = ['portfolio','service'];
pxl_add_custom_widget(
    array(
        'name' => 'pxl_tab_scroll',
        'title' => esc_html__('Case Tab Scroll', 'floka' ),
        'icon' => 'eicon-slider-vertical',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'pxl-tabs--scroll',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'floka' ),
                    'tab'      => 'layout',
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'post_type',
                                'label'    => esc_html__( 'Select Post Type', 'floka' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => floka_get_post_type_options($pt_supports),
                                'default'  => 'post'
                            ) 
                        ),
                        floka_get_post_tab_scroll_layout($pt_supports),
                    ),
                ),
                array(
                    'name' => 'section_source',
                    'label' => esc_html__('Source', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'select_post_by',
                                'label'    => esc_html__( 'Select posts by', 'floka' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => [
                                    'term_selected' => esc_html__( 'Terms selected', 'floka' ),
                                    'post_selected' => esc_html__( 'Posts selected ', 'floka' ),
                                ],
                                'default'  => 'term_selected'
                            ) 
                        ),
                        floka_get_term_by_post_type($pt_supports, ['custom_condition' => ['select_post_by' => 'term_selected']]),
                        floka_get_ids_by_post_type($pt_supports, ['custom_condition' => ['select_post_by' => 'post_selected']]),
                        array(
                            array(
                                'name' => 'orderby',
                                'label' => esc_html__('Order By', 'floka' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'date',
                                'options' => [
                                    'date' => esc_html__('Date', 'floka' ),
                                    'ID' => esc_html__('ID', 'floka' ),
                                    'author' => esc_html__('Author', 'floka' ),
                                    'title' => esc_html__('Title', 'floka' ),
                                    'rand' => esc_html__('Random', 'floka' ),
                                ],
                            ),
                            array(
                                'name' => 'order',
                                'label' => esc_html__('Sort Order', 'floka' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'desc',
                                'options' => [
                                    'desc' => esc_html__('Descending', 'floka' ),
                                    'asc' => esc_html__('Ascending', 'floka' ),
                                ],
                            ),
                            array(
                                'name' => 'limit',
                                'label' => esc_html__('Total items', 'floka' ),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => '6',
                                'control_type' => 'responsive',

                            ),
                        )
                    ),
                ),

                array(
                    'name' => 'tab_scroll',
                    'label' => esc_html__('Display', 'floka' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'floka' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 419x279 (Width x Height)).',
                        ),
                        array(
                            'name' => 'show_category',
                            'label' => esc_html__('Show Category', 'floka' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                        ),
                    ),
                ),

                array(
                    'name' => 'section_style',
                    'label' => esc_html__('Style', 'floka'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name'  => 'heading_title',
                            'label' => esc_html__('Title','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ),
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__( 'Title Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-tabs--scroll .pxl-post--title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name'         => 'title_typography',
                            'label' => esc_html__( 'Title Typography', 'floka' ),
                            'type'         => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-tabs--scroll .pxl-post--title',
                        ),


                        array(
                            'name'  => 'heading_categories',
                            'label' => esc_html__('Categories','floka'),
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ),
                        array(
                            'name' => 'categories_color',
                            'label' => esc_html__( 'Color', 'floka' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-tabs--scroll .pxl-item--category' => 'color: {{VALUE}};',
                            ],
                        ),

                        array(
                            'name'         => 'categories_typography',
                            'label' => esc_html__( 'Typography', 'floka' ),
                            'type'         => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-tabs--scroll .pxl-item--category',
                        ),

                        array(
                            'name'         => 'categories_border',
                            'label' => esc_html__( 'Border', 'floka' ),
                            'type'         => \Elementor\Group_Control_Border::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-tabs--scroll .pxl-item--category a',
                        ),



                    ),
                ),
                floka_widget_animation_settings(),
            ),
),
),
floka_get_class_widget_path()
);