( function( $ ) {
    "use strict";
    
    let circleInstances = [];
    
    function initCircleText($scope) {
        let elements = $scope.find('.pxl-circle-text-item');
        if(!elements.length) return;
        
        circleInstances.forEach(instance => {
            if (instance && typeof instance.destroy === 'function') {
                instance.destroy();
            }
        });
        circleInstances = [];
        
        setTimeout(function() {
            elements.each(function() {
                let circletext = new CircleType(this);
                circletext.forceHeight(true) 
                         .forceWidth(true);
                
                circleInstances.push(circletext);
            });
        }, 300);
    }
    
    function initScrollAnimation($scope) {
        gsap.registerPlugin(ScrollTrigger);
        setTimeout(function() {
            document.querySelectorAll('.spin-scroll').forEach(wrapper => {
              const textCircle = $('.pxl-circle-text-item,.pxl-img-spin'); 
              if (!textCircle) return;
              gsap.to(textCircle, {
                rotate: 360,
                ease: "none",
                scrollTrigger: {
                  trigger: wrapper, 
                  start: "top bottom",
                  end: "bottom top",
                  scrub: true,
              }
          });
          });
        }, 300);
    }
    
    var pxl_circilar_text_handler = function( $scope ) {
        initCircleText($scope);
        
        initScrollAnimation($scope);
        
        $scope.find('.pxl-anchor-button').off('click.circleText').on('click.circleText', function(e) {
            e.preventDefault();
            
            initCircleText($scope);
            
            if (typeof ScrollTrigger !== 'undefined') {
                ScrollTrigger.refresh();
            }
            
        });
        
        $(document).off('click.circleTextGlobal', '.pxl-anchor-button').on('click.circleTextGlobal', '.pxl-anchor-button', function(e) {
            e.preventDefault();
            
            let $currentScope = $(this).closest('[data-element_type="pxl_circle_text.default"]');
            if (!$currentScope.length) {
                $currentScope = $(document);
            }
            
            initCircleText($currentScope);
            
            if (typeof ScrollTrigger !== 'undefined') {
                ScrollTrigger.refresh();
            }
            
        });
    };
    
    $( window ).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_circle_text.default', function( $scope ) {
            pxl_circilar_text_handler($scope);
        });
    } );
} )( jQuery );