<?php
$active = intval($settings['active']);
$accordion = $widget->get_settings('accordion');
$wg_id = pxl_get_element_id($settings);
if(!empty($accordion)) : ?>
    <div class="pxl-accordion pxl-accordion1">
        <?php foreach ($accordion as $key => $value):
            $is_active = ($key + 1) == $active;
            $pxl_id = isset($value['_id']) ? $value['_id'] : '';
            $title = isset($value['title']) ? $value['title'] : '';
            $desc = isset($value['desc']) ? $value['desc'] : ''; 
            $image_id = $value['image']['id'] ?? '';
            $img_size = $settings['img_size'] ?? '480x308';
            ?>
            <div class="pxl--item <?php echo esc_attr($is_active ? 'active' : ''); ?> <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" >

                    <<?php pxl_print_html($settings['title_tag']); ?> class="pxl-accordion--title" data-target="<?php echo esc_attr('#'.$wg_id.'-'.$pxl_id); ?>" >
                        <span class="pxl-title--text"><?php echo wp_kses_post($title); ?></span>
                        <div class="pxl-icon--plus"></div>
                    </<?php pxl_print_html($settings['title_tag']); ?>>


                    <div id="<?php echo esc_attr($wg_id.'-'.$pxl_id); ?>" class="pxl-accordion--content" <?php if($is_active){ ?>style="display: block;"<?php } ?>>


                        <div class="pxl--content">
                            <?php if (!empty($image_id)) : ?>
                                <div class="pxl-item--image">
                                    <?php echo floka_get_thumbnail($image_id, $img_size); ?>
                                </div>
                            <?php endif; ?>
                            <div class="pxl-desc--content">
                                <div class="pxl-item--desc">
                                    <?php echo wp_kses_post(nl2br($desc)); ?> 
                                </div>
                                <a class="pxl-button btn" <?php floka_render_link_attributes($value['link']); ?>>
                                    <span class="pxl--btn-icon">
                                        <span class="pxl-icon--plus"></span>
                                    </span>
                                    <span class="pxl--btn-text" data-text="<?php echo esc_attr($value['text_button']); ?>">
                                        <?php if($settings['btn_text_effect'] == 'btn-text-nina' || $settings['btn_text_effect'] == 'btn-text-nanuk') {
                                            $chars = preg_split('//u', $value['text_button'], -1, PREG_SPLIT_NO_EMPTY);

                                            foreach ($chars as $value) {
                                                if($value == ' ') {
                                                    echo '<span class="spacer">&nbsp;</span>';
                                                } else {
                                                    echo '<span>' . htmlspecialchars($value) . '</span>';
                                                }
                                            }
                                        } else {
                                            echo pxl_print_html($value['text_button']);
                                        }
                                        ?>
                                    </span>
                                </a>
                            </div>
                        </div>
                </div>
                

            </div>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>