<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', 500);
$drap = $widget->get_setting('drap', false);
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
if(isset($settings['box']) && !empty($settings['box']) && count($settings['box'])): ?>
    <div class="pxl-swiper-slider pxl-box-carousel pxl-box-carousel1 " <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_attr('DRAG', 'floka'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">

            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['box'] as $key => $value):
                        $img_size = isset($value['img_size']) ? $value['img_size'] : '900x900';
                        $image = floka_get_thumbnail($value['image']['id'],$img_size);  
                        $title = isset($value['title']) ? $value['title'] : '';
                        $desc = isset($value['desc']) ? $value['desc'] : '';
                        $button_readmore = !empty($value['button_readmore']) ? $value['button_readmore'] : 'Readmore';
                        $link = floka_get_link($value['item_link']);
                        ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                                <div class="pxl-item--image">
                                    <a <?php pxl_print_html($link);?>></a>
                                    <?php pxl_print_html($image); ?>
                                </div>
                                <div class="pxl-item--content">
                                    <?php if (!empty($title)) : ?>
                                        <h6 class="pxl-item--title"><?php echo pxl_print_html($title); ?></h6>
                                    <?php endif; ?>
                                    <div class="pxl-item--desc">
                                        <?php echo pxl_print_html($desc); ?>
                                    </div>
                                    <a class="btn btn-readmore" <?php pxl_print_html($link); ?>>
                                        <span class="pxl--btn-icon">
                                            <svg width="11" height="11" viewBox="0 0 11 11" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M10.2812 4.59375C10.3906 4.59375 10.5 4.70312 10.5 4.8125V5.6875C10.5 5.82422 10.3906 5.90625 10.2812 5.90625H5.90625V10.2812C5.90625 10.418 5.79688 10.5 5.6875 10.5H4.8125C4.67578 10.5 4.59375 10.418 4.59375 10.2812V5.90625H0.21875C0.0820312 5.90625 0 5.82422 0 5.6875V4.8125C0 4.70312 0.0820312 4.59375 0.21875 4.59375H4.59375V0.21875C4.59375 0.109375 4.67578 0 4.8125 0H5.6875C5.79688 0 5.90625 0.109375 5.90625 0.21875V4.59375H10.2812Z" fill="white"/>
                                            </svg>

                                        </span>
                                        <span class="pxl--btn-text">
                                            <?php pxl_print_html($button_readmore); ?>
                                        </span>
                                    </a>
                                </div>

                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php if($pagination !== false): ?>
            <div class="pxl-swiper-dots-wrap">
                <div class="pxl-swiper-dots style-1"></div>
            </div>
        <?php endif; ?>

        <?php if($arrows !== false): ?>
            <div class="pxl-swiper-arrow-wrap style-2">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="caseicon-angle-arrow-left rtl-icon"></i></div>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="caseicon-angle-arrow-right rtl-icon"></i></div>
            </div>
        <?php endif; ?>

    </div>
    <?php endif; ?>