<?php 
$img_size_circle = $settings['img_size_circle'] ?? 'full';
$image_id = $settings['circle_img']['id'] ?? '';
?>

<div class="pxl-circle-text-wrapper <?php echo pxl_print_html($settings['spin_text']); ?>">
  
  <a class="pxl-pabsolute-full" <?php floka_render_link_attributes($settings['link']); ?>>
  </a>
  <?php if(!empty($settings['circle_text'])) : ?>
    <div class="pxl-circle-text-item">
      <?php echo esc_html($settings['circle_text']);?>
    </div>
  <?php endif; ?>

  <?php if(!empty($image_id)) : ?>
    <div class="pxl-img-spin">
      <?php pxl_print_html(floka_get_thumbnail($image_id,$img_size_circle)); ?>
    </div>
  <?php endif; ?>
  <span class="pxl-circle-text-icon">
    <?php if(isset($settings['_icon'])) : ?>
      <?php \Elementor\Icons_Manager::render_icon( $settings['_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
    <?php elseif(isset($settings['text'])): ?>
      <?php pxl_print_html($settings['text']) ?>
    <?php elseif(isset($settings['img'])): ?>
      <?php 
      $get_img = pxl_get_image_by_size([
        'attach_id'  => $settings['img']['id'],
        'thumb_size' => 'full',
      ]);
      $img = $get_img ? $get_img['thumbnail'] : '<img src="' . $settings['img']['url'] . '">';
      pxl_print_html($img);
      ?>
    <?php endif; ?>
  </span>
</div>