<?php
$html_id = pxl_get_element_id($settings);
$tax = ['portfolio-category'];
$select_post_by = $widget->get_setting('select_post_by', '');
$source = $post_ids = [];
if($select_post_by === 'post_selected'){
    $post_ids = $widget->get_setting('source_'.$settings['post_type'].'_post_ids', '');
}else{
    $source  = $widget->get_setting('source_'.$settings['post_type'], '');
}
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
extract(pxl_get_posts_of_grid(
    'portfolio', 
    ['source' => $source, 'orderby' => $orderby, 'order' => $order, 'limit' => $limit, 'post_ids' => $post_ids],
    $tax
));

$pxl_animate = $widget->get_setting('pxl_animate', '');
$pxl_animate_delay = $widget->get_setting('pxl_animate_delay', '');
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = (int)$widget->get_setting('col_md', '');
if($col_md == 'custom') {
    $col_md = $widget->get_setting('col_md_custom', '');
}
$col_lg = (int)$widget->get_setting('col_lg', '');
if($col_lg == 'custom') {
    $col_lg = $widget->get_setting('col_lg_custom', '');
}
$col_xl = (int)$widget->get_setting('col_xl', '');
if($col_xl == 'custom') {
    $col_xl = $widget->get_setting('col_xl_custom', '');
}
$col_xxl = (int)$widget->get_setting('col_xxl', '');
if($col_xxl == 'custom') {
    $col_xxl = $widget->get_setting('col_xxl_custom', '');
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);
$speed = $widget->get_setting('speed', 500);

$img_size = $widget->get_setting('img_size');
$show_author = $widget->get_setting('show_author');
$show_date = $widget->get_setting('show_date');
$show_category = $widget->get_setting('show_category');
$show_excerpt = $widget->get_setting('show_excerpt');
$show_button = $widget->get_setting('show_button');
$img_effect = $widget->get_setting('img_effect');
$button_text = $widget->get_setting('button_text','Read More');

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_percolumnfill'           => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => $col_xl,
    'slides_to_show_xxl'            => $col_xxl,  
    'slides_to_show_lg'             => $col_lg, 
    'slides_to_show_md'             => $col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,  
    'slides_gutter'                 => 30, 
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];

$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]); ?>

<?php if (is_array($posts)): ?>
    <div class="pxl-swiper-slider pxl-portfolio-carousel pxl-portfolio-carousel1" <?php if($settings['drap'] !== false) : ?>data-cursor-drap="<?php echo esc_attr('DRAG', 'floka'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php
                    $images_size = !empty($img_size) ? $img_size : '700x550';

                    foreach ($posts as $key => $post):
                        $img_id       = get_post_thumbnail_id( $post->ID );
                        $author = get_user_by('ID', get_post_field('post_author', $post->ID));
                        $author_name = $author->display_name; 
                        $portfolio_icon_type = get_post_meta($post->ID, 'portfolio_icon_type', true);
                        $portfolio_icon_font = get_post_meta($post->ID, 'portfolio_icon_font', true);
                        $portfolio_icon_img = get_post_meta($post->ID, 'portfolio_icon_img', true);
                        ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                                <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                                $img_id = get_post_thumbnail_id($post->ID);
                                $img          = pxl_get_image_by_size( array(
                                    'attach_id'  => $img_id,
                                    'thumb_size' => $images_size
                                ) );
                                $thumbnail    = $img['thumbnail'];
                                ?>
                                <div class="pxl-post--featured <?php if(!empty($img_effect)) { echo esc_attr($img_effect); } ?>" 
                                    <?php if($img_effect == 'pxl-image-tilt') : ?>data-maxtilt="<?php echo esc_attr($settings['max_tilt']); ?>" data-speedtilt="<?php echo esc_attr($settings['speed_tilt']); ?>" data-perspectivetilt="<?php echo esc_attr($settings['perspective_tilt']); ?>"<?php endif; ?> 
                                    <?php if($img_effect=='pxl-image-distortion') : ?> data-displacement="<?php echo esc_attr($displacement_url); ?>" <?php endif; ?>>
                                    <?php echo wp_kses_post($thumbnail); ?>
                                    <a class="pxl-post--link" href="<?php echo esc_url(get_permalink( $post->ID ));?>"></a>


                                    <?php if($portfolio_icon_type == 'icon' && !empty($portfolio_icon_font)) : ?>
                                        <div class="pxl-post--icon pxl-fl-middle">
                                            <i class="<?php echo esc_attr($portfolio_icon_font); ?>"></i>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($portfolio_icon_type == 'image' && !empty($portfolio_icon_img)) : 
                                        $icon_img = pxl_get_image_by_size( array(
                                            'attach_id'  => $portfolio_icon_img['id'],
                                            'thumb_size' => 'full',
                                        ));
                                        $icon_thumbnail = $icon_img['thumbnail'];
                                        ?>
                                        <div class="pxl-post--icon pxl-fl-middle">
                                            <?php echo wp_kses_post($icon_thumbnail); ?>
                                        </div>
                                    <?php endif; ?>

                                    <?php if($show_button == 'true') : ?>
                                        <div class="pxl-post--button">
                                            <a class="btn-readmore d-flex" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                                <svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M8.2778 3.63859C8.25294 3.41485 8.45182 3.21598 8.70041 3.21598H14.4677C14.7163 3.21598 14.8904 3.39 14.8904 3.63859V9.40593C14.8904 9.65452 14.6915 9.85339 14.4677 9.82853L14.0949 9.85339C13.8711 9.82853 13.6971 9.65452 13.6723 9.43079V5.25444L4.35004 14.5766C4.17603 14.7507 3.92744 14.7507 3.75342 14.5766L3.50483 14.3281C3.35567 14.1789 3.33082 13.9054 3.50483 13.7314L12.827 4.40922L8.67555 4.43408C8.45182 4.40922 8.2778 4.23521 8.25294 4.01148L8.2778 3.63859Z" fill="currentColor"/>
                                                </svg>

                                            </a>
                                        </div>
                                    <?php endif; ?>

                                    <?php if($show_category == 'true'): ?>
                                        <div class="pxl-item--category">
                                            <?php the_terms( $post->ID, 'portfolio-category', '', ', ' ); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                            <div class="pxl-item--author">

                                <div class="pxl-user--name">
                                    <?php echo esc_html($author_name);?>
                                </div>

                                    <div class="pxl-item--position">
                                        <?php echo get_the_date('Y', $post->ID); ?>
                                    </div>
                            </div>

                        </div>
                    </div>
                <?php endforeach; ?>
            </div> 
        </div>

        <?php if($pagination !== false): ?>
            <div class="pxl-swiper-dots-wrap">
                <div class="pxl-swiper-dots style-1"></div>
            </div>
        <?php endif; ?>

        <?php if($arrows !== false): ?>
            <div class="pxl-swiper-arrow-wrap <?php echo pxl_print_html($settings['style_arrows']); ?>">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="caseicon-angle-arrow-left rtl-icon"></i></div>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="caseicon-angle-arrow-right rtl-icon"></i></div>
            </div>
        <?php endif; ?>

    </div>
</div>
<?php endif; ?>