<?php

$html_id = pxl_get_element_id($settings);
$tax = ['category'];
$select_post_by = $widget->get_setting('select_post_by', '');
$source = $post_ids = [];
if($select_post_by === 'post_selected'){
    $post_ids = $widget->get_setting('source_'.$settings['post_type'].'_post_ids', '');
}else{
    $source  = $widget->get_setting('source_'.$settings['post_type'], '');
}
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
extract(pxl_get_posts_of_grid(
    'service', 
    ['source' => $source, 'orderby' => $orderby, 'order' => $order, 'limit' => $limit, 'post_ids' => $post_ids],
    $tax
));

$pxl_animate = $widget->get_setting('pxl_animate', '');
$pxl_animate_delay = $widget->get_setting('pxl_animate_delay', '');

$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);
$speed = $widget->get_setting('speed', 500);

$img_size = $widget->get_setting('img_size');
$show_author = $widget->get_setting('show_author');
$show_category = $widget->get_setting('show_category');
?>

<?php if (is_array($posts)): ?>
    <div class="pxl-tabs--scroll pxl-scroll-service1">
        <div class="tabs-content-stacked">
            <?php
            $images_size = !empty($img_size) ? $img_size : '668x400';

            foreach ($posts as $key => $post):
                $img_id       = get_post_thumbnail_id( $post->ID );
                $excerpt_post = get_the_excerpt($post->ID);
                $number       = $key + 1;
                $service_multi_text = get_post_meta($post->ID, 'service_multi_text', true);
                ?>
                <div class="pxl-post--inner pxl-stacked--scroll <?php echo esc_attr($pxl_animate); ?>" data-wow-delay="<?php echo esc_attr($pxl_animate_delay); ?>ms">

                    <div class="pxl-item--content">
                        <div class="pxl-number--post">
                            <?php if ($number <= 9) {
                                echo pxl_print_html('0'.$number); 
                            }else{
                                echo pxl_print_html($number); 
                            } ?>
                        </div>
                        <div class="pxl-item--category">
                            <?php the_terms( $post->ID, 'service-category', '', ' ' ); ?>
                        </div>

                        <h3 class="pxl-post--title">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo pxl_print_html(get_the_title($post->ID)); ?></a>
                        </h3>
                    </div>

                    <div class="pxl-post--featured">
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                            <?php echo floka_get_thumbnail($img_id, $images_size); ?>
                        </a>
                        <ul class="pxl-box--multitext">
                            <?php foreach ($service_multi_text as $text): 

                                $parts = explode('|', $text);
                                if (count($parts) == 2) {
                                    $text = esc_html($parts[0]);
                                    $link = esc_html($parts[1]);
                                    echo '<li class="box-multi"><a href="' . $link . '" target="_blank">' . $text . '</a></li>';
                                }
                                else {
                                    echo '<li class="box-multi">' . esc_html($text) . '</li>';
                                }
                                ?>

                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            <?php endforeach; ?>
        </div> 
    </div>
<?php endif; ?>
