<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', 500);
$drap = $widget->get_setting('drap', false);
$image_size = !empty($settings['img_size']) ? $settings['img_size'] : '450x450';
$pxl_animate = $widget->get_setting('pxl_animate', '');
$pxl_animate_delay = $widget->get_setting('pxl_animate_delay', '');
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
if(isset($settings['team']) && !empty($settings['team']) && count($settings['team'])): ?>
    <div class="pxl-swiper-slider pxl-team pxl-team-carousel pxl-team-carousel1 " <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_attr('DRAG', 'floka'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">

            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['team'] as $key => $value):
                        $title = isset($value['title']) ? $value['title'] : '';
                        $position = isset($value['position']) ? $value['position'] : '';
                        $social = isset($value['social']) ? $value['social'] : '';
                        $image = isset($value['image']) ? $value['image'] : '';
                        $image_id = $value['image']['id'] ?? '';
                        ?>

                        <div class="pxl-swiper-slide">
                            <div class="pxl-item--inner elementor-repeater-item-<?php echo esc_attr($value['_id']); ?>">
                                <div class="pxl-item--image el-parallax-wrap">
                                    <a class="el-parallax-item" <?php floka_render_link_attributes($value['item_link']); ?>>
                                        <?php echo floka_get_thumbnail($image_id, $image_size); ?>
                                    </a>
                                </div>
                                <div class="pxl--content">
                                    <?php if (!empty($title)) : ?>
                                        <h3 class="pxl-item--title">
                                            <?php echo pxl_print_html($title); ?>
                                        </h3>
                                    <?php endif; ?>

                                    <?php if (!empty($position)) : ?>
                                        <div class="pxl-item--position">
                                            <?php echo pxl_print_html($position); ?>
                                        </div>
                                    <?php endif; ?>

                                    <?php if(!empty($social)): ?>
                                        <div class="pxl-item--social">
                                           <?php  $team_social = json_decode($social, true);
                                           foreach ($team_social as $value): ?>
                                            <a href="<?php echo esc_url($value['url']); ?>" target="_blank"><i class="<?php echo esc_attr($value['icon']); ?>"></i></a>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    <?php if($pagination !== false): ?>
        <div class="pxl-swiper-dots-wrap">
            <div class="pxl-swiper-dots style-1"></div>
        </div>
    <?php endif; ?>

    <?php if($arrows !== false): ?>
        <div class="pxl-swiper-arrow-wrap style-2">
            <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="caseicon-angle-arrow-left rtl-icon"></i></div>
            <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="caseicon-angle-arrow-right rtl-icon"></i></div>
        </div>
    <?php endif; ?>

</div>
<?php endif; ?>